/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.OID;

public class ApcSNMPv3User {
    private String theName;
    private ApcSNMPv1User.AccessType theAccessType;
    AuthProtocol auth;
    String authPass;
    PrivProtocol priv;
    String privPass;

    public ApcSNMPv3User(String string, AuthProtocol authProtocol, String string2, PrivProtocol privProtocol, String string3, ApcSNMPv1User.AccessType accessType) {
        this.theName = string;
        this.auth = authProtocol;
        this.authPass = string2;
        this.priv = privProtocol;
        this.privPass = string3;
        this.theAccessType = accessType;
    }

    public String getName() {
        return this.theName;
    }

    public AuthProtocol getAuthProt() {
        return this.auth;
    }

    public OID getAuthOID() {
        return this.getSecurityOID(this.auth.toString());
    }

    public String getAuthPass() {
        return this.authPass;
    }

    public PrivProtocol getPrivProt() {
        return this.priv;
    }

    public OID getPrivOID() {
        return this.getSecurityOID(this.priv.toString());
    }

    public String getPrivPass() {
        return this.privPass;
    }

    public ApcSNMPv1User.AccessType getAccessType() {
        return this.theAccessType;
    }

    private OID getSecurityOID(String string) {
        if (string.toUpperCase().equals("SHA1")) {
            return AuthSHA.ID;
        }
        if (string.toUpperCase().equals("SHA256")) {
            return AuthHMAC192SHA256.ID;
        }
        if (string.toUpperCase().equals("SHA512")) {
            return AuthHMAC384SHA512.ID;
        }
        if (string.toUpperCase().equals("MD5")) {
            return AuthMD5.ID;
        }
        if (string.toUpperCase().equals("AES128")) {
            return PrivAES128.ID;
        }
        if (string.toUpperCase().equals("AES192")) {
            return PrivAES192.ID;
        }
        if (string.toUpperCase().equals("AES256")) {
            return PrivAES256.ID;
        }
        if (string.toUpperCase().equals("AES192EX")) {
            return PrivAES192With3DESKeyExtension.ID;
        }
        if (string.toUpperCase().equals("AES256EX")) {
            return PrivAES256With3DESKeyExtension.ID;
        }
        if (string.toUpperCase().equals("DES")) {
            return PrivDES.ID;
        }
        return null;
    }

    public static enum AuthProtocol {
        NONE,
        SHA1,
        MD5,
        SHA256,
        SHA512;

    }

    public static enum PrivProtocol {
        NONE,
        AES128,
        AES192,
        AES192EX,
        AES256,
        AES256EX,
        DES;

    }
}

