/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.utils.ApcBaseAgent;
import com.apcc.pcns.snmp.utils.ApcSNMPData;
import com.apcc.pcns.snmp.utils.ApcSNMPTrapNMS;
import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.UsmUser;
import org.snmp4j.security.UsmUserEntry;
import org.snmp4j.security.UsmUserTable;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public abstract class ApcTrapGenerator {
    private static final Logger logger = LogManager.getLogger(ApcTrapGenerator.class);
    private static final String mtrapArgString = ".1.3.6.1.4.1.318.2.3.3";
    long start = System.currentTimeMillis();

    public static boolean sendSnmpTraps(OID oID, String string, Vector<ApcSNMPTrapNMS> vector, ApcBaseAgent apcBaseAgent, ConfigurationManager configurationManager) {
        boolean bl = true;
        try {
            logger.info("sendSnmpTraps() - start, message: {}", (Object)string);
            if (vector != null && !vector.isEmpty()) {
                if (string == null) {
                    string = "";
                }
                for (ApcSNMPTrapNMS apcSNMPTrapNMS : vector) {
                    if (!apcSNMPTrapNMS.isEnabled().booleanValue()) continue;
                    logger.info("sendSnmpTraps() - send trap to {} at {}:{}", (Object)apcSNMPTrapNMS.getProfile(), (Object)apcSNMPTrapNMS.getNMSip(), (Object)apcSNMPTrapNMS.getNMSport());
                    try {
                        if (apcSNMPTrapNMS.type.equals((Object)ApcSNMPTrapNMS.SNMPType.V1)) {
                            ApcTrapGenerator.sendSnmpV1Trap(oID, string, apcSNMPTrapNMS, apcBaseAgent, configurationManager);
                            continue;
                        }
                        if (apcSNMPTrapNMS.getV3User().getAccessType() == ApcSNMPv1User.AccessType.DISABLED) continue;
                        ApcTrapGenerator.sendSnmpV3Trap(oID, string, apcSNMPTrapNMS, apcBaseAgent, configurationManager);
                    }
                    catch (MessageException messageException) {
                        if (messageException.getSnmp4jErrorStatus() == 1405) {
                            logger.error("sendSnmpTraps() - Error sending SNMPv3 trap to {} due to encryption errors. If using long encryption keys, this may require installing the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy.  Currently using JRE: {}", (Object)apcSNMPTrapNMS.getNMSip(), (Object)System.getProperty("java.home"));
                        } else {
                            logger.error("sendSnmpTraps() - Error sending trap to {} due to {}", (Object)apcSNMPTrapNMS.getNMSip(), (Object)messageException);
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        logger.error("sendSnmpTraps() - Error sending trap: {}", (Throwable)exception);
                        bl = false;
                    }
                }
            } else {
                logger.debug("sendSnmpTraps() - No SNMP Trap reveicers configured");
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
            logger.error("sendSnmpTraps() - Error in Sending Trap: {}", (Throwable)exception);
        }
        return bl;
    }

    public static void sendSnmpV1Trap(OID oID, String string, ApcSNMPTrapNMS apcSNMPTrapNMS, ApcBaseAgent apcBaseAgent, ConfigurationManager configurationManager) throws IOException {
        logger.debug("sendSnmpV1Trap() - start, message: {}", (Object)string);
        CommunityTarget communityTarget = new CommunityTarget();
        communityTarget.setCommunity(new OctetString(apcSNMPTrapNMS.getProfile()));
        communityTarget.setVersion(0);
        communityTarget.setAddress((Address)new UdpAddress(apcSNMPTrapNMS.getNMSip() + "/" + apcSNMPTrapNMS.getNMSport()));
        communityTarget.setRetries(2);
        communityTarget.setTimeout(5000L);
        PDUv1 pDUv1 = new PDUv1();
        pDUv1.setType(-92);
        pDUv1.setGenericTrap(6);
        pDUv1.setEnterprise(ApcSNMPData.apcOID);
        pDUv1.setSpecificTrap(oID.last());
        IpAddress ipAddress = null;
        try {
            String string2 = configurationManager.getString("Networking", "localHostAddress");
            ipAddress = new IpAddress(string2);
        }
        catch (ConversionException conversionException) {
            ipAddress = new IpAddress(InetAddress.getLocalHost().toString());
        }
        pDUv1.setAgentAddress(ipAddress);
        long l = (System.currentTimeMillis() - ApcBaseAgent.start) / 10L;
        pDUv1.setTimestamp(l);
        pDUv1.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(l)));
        pDUv1.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)oID));
        pDUv1.add(new VariableBinding(new OID(mtrapArgString), (Variable)new OctetString(string)));
        Snmp snmp = apcBaseAgent.getSession();
        logger.debug("sendSnmpV1Trap() - Sending V1 Trap to {} on Port {}", (Object)apcSNMPTrapNMS.getNMSip(), (Object)apcSNMPTrapNMS.getNMSport());
        snmp.send((PDU)pDUv1, (Target)communityTarget);
    }

    public static void sendSnmpV3Trap(OID oID, String string, ApcSNMPTrapNMS apcSNMPTrapNMS, ApcBaseAgent apcBaseAgent, ConfigurationManager configurationManager) throws IOException {
        logger.debug("sendSnmpV3Trap() - start, message: {}", (Object)string);
        logger.debug("sendSnmpV3Trap() -  EngineID: {}", (Object)apcBaseAgent.getEngineID());
        Address address = GenericAddress.parse((String)("udp:" + apcSNMPTrapNMS.getNMSip() + "/" + apcSNMPTrapNMS.getNMSport()));
        Snmp snmp = apcBaseAgent.getSession();
        UsmUserTable usmUserTable = snmp.getUSM().getUserTable();
        UsmUserEntry usmUserEntry = usmUserTable.getUser(new OctetString(apcSNMPTrapNMS.getProfile()));
        UsmUser usmUser = null;
        if (usmUserEntry != null) {
            usmUser = usmUserEntry.getUsmUser();
        }
        OctetString octetString = new OctetString(apcSNMPTrapNMS.getProfile());
        OctetString octetString2 = null;
        if (apcSNMPTrapNMS.getV3User().getAuthPass() != null) {
            octetString2 = new OctetString(apcSNMPTrapNMS.getV3User().getAuthPass());
        }
        OctetString octetString3 = null;
        if (apcSNMPTrapNMS.getV3User().getPrivPass() != null) {
            octetString3 = new OctetString(apcSNMPTrapNMS.getV3User().getPrivPass());
        }
        UsmUser usmUser2 = new UsmUser(octetString, apcSNMPTrapNMS.getV3User().getAuthOID(), octetString2, apcSNMPTrapNMS.getV3User().getPrivOID(), octetString3);
        boolean bl = false;
        if (!usmUser2.equals((Object)usmUser)) {
            snmp.getUSM().addUser(new OctetString(apcSNMPTrapNMS.getProfile()), usmUser2);
            bl = true;
        }
        UserTarget userTarget = new UserTarget();
        userTarget.setAddress(address);
        userTarget.setRetries(1);
        userTarget.setTimeout(11500L);
        userTarget.setVersion(3);
        if (apcSNMPTrapNMS.getV3User().getAuthOID() != null && apcSNMPTrapNMS.getV3User().getPrivOID() != null) {
            userTarget.setSecurityLevel(3);
        } else if (apcSNMPTrapNMS.getV3User().getAuthOID() != null) {
            userTarget.setSecurityLevel(2);
        } else {
            userTarget.setSecurityLevel(1);
        }
        userTarget.setSecurityName(new OctetString(apcSNMPTrapNMS.getProfile()));
        ScopedPDU scopedPDU = new ScopedPDU();
        scopedPDU.setType(-89);
        long l = (System.currentTimeMillis() - ApcBaseAgent.start) / 10L;
        scopedPDU.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(l)));
        scopedPDU.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)oID));
        IpAddress ipAddress = null;
        try {
            String string2 = configurationManager.getString("Networking", "localHostAddress");
            ipAddress = new IpAddress(string2);
        }
        catch (ConversionException conversionException) {
            ipAddress = new IpAddress(InetAddress.getLocalHost().toString());
        }
        scopedPDU.add(new VariableBinding(SnmpConstants.snmpTrapAddress, (Variable)ipAddress));
        scopedPDU.add(new VariableBinding(new OID(mtrapArgString), (Variable)new OctetString(string)));
        logger.debug("sendSnmpV3Trap() - Sending V3 Trap to {} on Port {}", (Object)apcSNMPTrapNMS.getNMSip(), (Object)apcSNMPTrapNMS.getNMSport());
        snmp.send((PDU)scopedPDU, (Target)userTarget);
        if (bl) {
            snmp.getUSM().removeAllUsers(new OctetString(apcSNMPTrapNMS.getProfile()));
            if (usmUser != null) {
                snmp.getUSM().addUser(new OctetString(apcSNMPTrapNMS.getProfile()), usmUser);
            }
        }
    }
}

