/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.snmp.utils;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.errorservice.ApplicationErrorHandler;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.smi.OctetString;

public class ExtendedCommandProcessor
extends CommandProcessor {
    private static Logger logger = LogManager.getLogger(ExtendedCommandProcessor.class);
    private HashSet<String> Users = new HashSet();
    private HashSet<String> FailedUsers = new HashSet();
    private ApplicationErrorHandler applicationErrorHandler;

    public ExtendedCommandProcessor(OctetString octetString, ApplicationErrorHandler applicationErrorHandler) {
        super(octetString);
        this.applicationErrorHandler = applicationErrorHandler;
    }

    public void processPdu(CommandResponderEvent commandResponderEvent) {
        super.processPdu(commandResponderEvent);
        logger.debug("got Request from:" + String.valueOf(commandResponderEvent.getSecurityName()) + commandResponderEvent.toString());
        String string = new String(commandResponderEvent.getSecurityName(), StandardCharsets.UTF_8);
        String string2 = commandResponderEvent.getPeerAddress().toString();
        int n = string2.indexOf("/");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if (!commandResponderEvent.isProcessed()) {
            logger.debug("Failed Connection");
            if (!this.FailedUsers.contains(string + string2)) {
                this.FailedUsers.add(string + string2);
                String string3 = "";
                ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                MessageFormat messageFormat = new MessageFormat("");
                messageFormat.setLocale(Locale.getDefault());
                String string4 = Utils.getResourceString(resourceBundleWrapper, "SNMP.AuthFailure");
                messageFormat.applyPattern(string4);
                Object[] objectArray = new Object[]{string, string2, "V1"};
                string3 = messageFormat.format(objectArray);
                this.applicationErrorHandler.put(string3);
            }
        } else {
            logger.debug("Successfull Connection");
            if (!this.Users.contains(string + string2)) {
                this.Users.add(string + string2);
                String string5 = "";
                ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
                MessageFormat messageFormat = new MessageFormat("");
                messageFormat.setLocale(Locale.getDefault());
                String string6 = Utils.getResourceString(resourceBundleWrapper, "SNMP.NewLogin");
                messageFormat.applyPattern(string6);
                String string7 = "V1";
                if (commandResponderEvent.getSecurityModel() == 3) {
                    string7 = "V3";
                }
                Object[] objectArray = new Object[]{string, string2, string7};
                string5 = messageFormat.format(objectArray);
                this.applicationErrorHandler.put(string5);
            }
        }
    }
}

