/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import com.apcc.pcns.sshservice.GenericConnection;
import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.util.RetryCommand;
import com.apcc.pcns.util.RetryException;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.RemoteException;
import javax.naming.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GenericSSHConnection
implements GenericConnection {
    private static final Logger logger = LogManager.getLogger(GenericSSHConnection.class);
    protected static final int SUCCESS_STATUS = 0;
    protected static final int EMPTY_RESULT = 1;
    protected SshSession sshSession;

    public GenericSSHConnection(SshSession sshSession) {
        this.sshSession = sshSession;
    }

    protected SshSession.CmdResult executeCommandWithRetry(int n, String string, int n2) throws RemoteException {
        return this.executeCommandWithRetry(n, string, n2, true);
    }

    protected SshSession.CmdResult executeCommandWithRetry(int n, String string, int n2, boolean bl) throws RemoteException {
        logger.debug("executeCommandWithRetry() - start, command: {}, timeout: {}", (Object)string, (Object)n2);
        try {
            RetryCommand<SshSession.CmdResult> retryCommand = new RetryCommand<SshSession.CmdResult>(n);
            SshSession.CmdResult cmdResult = retryCommand.execute(() -> this.executeCmd(string, n2, bl));
            if (cmdResult != null && !StringUtils.isEmpty((CharSequence)cmdResult.error)) {
                logger.debug("executeCommandWithRetry() - command returned with error output, could be expected, Output: {}", (Object)cmdResult.error);
            }
            return cmdResult;
        }
        catch (RetryException retryException) {
            throw new RemoteException("Failed to execute command", retryException.getCause());
        }
    }

    protected SshSession.CmdResult executeCmd(String string, int n) {
        return this.executeCmd(string, n, true);
    }

    protected SshSession.CmdResult executeCmd(String string, int n, boolean bl) {
        logger.trace("executeCmd() - start");
        if (!this.isConnected()) {
            IllegalStateException illegalStateException = new IllegalStateException("No active SSH connection available.");
            throw new RetryException("Command execution failed", illegalStateException);
        }
        try {
            return this.sshSession.executeCommand(string, n, bl);
        }
        catch (IllegalArgumentException | IllegalStateException | ConnectException exception) {
            logger.debug("executeCmd() - command execution failed with error {}", (Throwable)exception);
            throw new RetryException("Command execution failed", exception);
        }
    }

    @Override
    public boolean isConnected() {
        if (this.sshSession == null) {
            return false;
        }
        return this.sshSession.hasActiveConnection();
    }

    @Override
    public void connect() throws RemoteException {
        logger.debug("connect() - start");
        if (this.sshSession == null) {
            logger.error("connect() - SSH session is null");
            throw new IllegalStateException("No SSH session available");
        }
        try {
            this.sshSession.startConnection();
        }
        catch (IOException | IllegalStateException | AuthenticationException exception) {
            logger.debug("connect() - starting SSH connection failed with error {}", (Throwable)exception);
            throw new RemoteException("Failed to start connection", exception);
        }
        logger.debug("connect() - end");
    }

    @Override
    public void disconnect() throws RemoteException {
        logger.debug("disconnect() - start");
        if (this.sshSession == null) {
            logger.debug("disconnect() - session null, already disconnected");
            return;
        }
        if (this.sshSession.hasActiveConnection()) {
            try {
                if (this.sshSession.hasActiveSession()) {
                    this.sshSession.closeShellSession();
                }
                this.sshSession.closeConnection();
                logger.debug("disconnect() - session disconnected");
            }
            catch (IOException | IllegalStateException exception) {
                logger.debug("disconnect() - disconnect failed with error {}", (Throwable)exception);
                this.sshSession = null;
                throw new RemoteException("Failed to disconnect", exception);
            }
        }
        this.sshSession = null;
        logger.debug("disconnect() - end");
    }

    protected boolean isResultOk(int n, String string, SshSession.CmdResult cmdResult) {
        logger.debug("isResultOk() - start");
        if (cmdResult == null) {
            logger.error("isResultOk() - command result is null");
            return false;
        }
        if (cmdResult.exitStatus > n || !StringUtils.isBlank((CharSequence)cmdResult.error)) {
            logger.error("isResultOk() - unexpected result received: (exit status {}) {}", (Object)cmdResult.exitStatus, (Object)cmdResult.error);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)cmdResult.output)) {
            logger.error("isResultOk() - unexpected empty output received: (exit status {})", (Object)cmdResult.exitStatus);
            return false;
        }
        if (!cmdResult.output.toLowerCase().contains(string.toLowerCase())) {
            logger.error("isResultOk() - unexpected command output received: {}", (Object)cmdResult.output);
            return false;
        }
        logger.debug("isResultOk() - end, result as expected: {} (exit status {})", (Object)cmdResult.output, (Object)cmdResult.exitStatus);
        return true;
    }

    protected boolean isResultOk(int n, SshSession.CmdResult cmdResult) {
        logger.debug("isResultOk() - start");
        if (cmdResult == null) {
            logger.error("isResultOk() - command result is null");
            return false;
        }
        if (cmdResult.exitStatus > n || !StringUtils.isBlank((CharSequence)cmdResult.error)) {
            logger.error("isResultOk() - unexpected result received: (exit status {}) {}", (Object)cmdResult.exitStatus, (Object)cmdResult.error);
            return false;
        }
        logger.debug("isResultOk() - result as expected: {} (exit status {})", (Object)cmdResult.output, (Object)cmdResult.exitStatus);
        return true;
    }
}

