/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.shutdowner.formatters.RunSSHActionFormatter;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.SSHActionConfigurator;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.sshservice.LatchRelease;
import com.apcc.pcns.sshservice.SSHActionSupplier;
import com.apcc.pcns.sshservice.SshService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHActionManager
implements Runnable {
    @Generated
    private final Object $lock = new Object[0];
    public static final int RUNTIME_GRACE = 10;
    private static final Logger logger = LogManager.getLogger(SSHActionManager.class);
    private SSHActionConfigurator sshActionHelper;
    private Map<SSHActionTrigger, Set<String>> actionsAlreadyRun;
    private BlockingQueue<SSHActionSupplier> runQueue;
    private SshService sessionFactory;
    private ServiceManager services;
    private OperatingSystemEventLogger osLogger;
    private boolean enabled = true;

    public SSHActionManager(IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        logger.debug("SSHActionManager() - start");
        this.services = serviceManager;
        this.osLogger = serviceManager.getOperatingSystemEventLogger();
        this.actionsAlreadyRun = new HashMap<SSHActionTrigger, Set<String>>();
        for (SSHActionTrigger sSHActionTrigger : SSHActionTrigger.values()) {
            this.actionsAlreadyRun.put(sSHActionTrigger, new HashSet());
        }
        this.runQueue = new LinkedBlockingQueue<SSHActionSupplier>();
        this.sshActionHelper = new SSHActionConfigurator(serviceManager.getConfigurationManager(), serviceManager.getAuthHelper(), serviceManager.getAdvancedSetupHelper());
        this.sessionFactory = serviceManager.getSshService();
        logger.debug("SSHActionManager() - end");
    }

    public void runSSHActions(Integer n, SSHActionTrigger sSHActionTrigger) {
        try {
            logger.debug("runSSHActions() - running SSH actions for group: {} at stage: {}", (Object)n, (Object)sSHActionTrigger.getIniSetting());
            List<SSHSettings> list = this.getSSHActionsForExecution(n, sSHActionTrigger);
            logger.debug("runSSHActions() - {} ssh actions found", (Object)list.size());
            CountDownLatch countDownLatch = new CountDownLatch(list.size());
            for (SSHSettings sSHSettings : list) {
                logger.info("runSSHActions() - queueing: {} for group: {} at stage: {}", (Object)sSHSettings.getName(), (Object)n, (Object)sSHActionTrigger.getIniSetting());
                this.runQueue.put(new SSHActionSupplier(sSHSettings, countDownLatch, this.sessionFactory.getSshSession()));
            }
            logger.debug("runSSHActions() - waiting for all SSH actions tasks to be completed");
            countDownLatch.await();
            logger.info("runSSHActions() - all actions for group: {} at stage: {} are complete", (Object)n, (Object)sSHActionTrigger.getIniSetting());
        }
        catch (InterruptedException interruptedException) {
            logger.warn("runSSHActions() - InterruptedException: ", (Throwable)interruptedException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn("runSSHActions() - IllegalArgumentException: ", (Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            logger.error("runSSHActions() - Exception: ", (Throwable)exception);
        }
    }

    public List<SSHSettings> getSSHActionsForExecution(Integer n, SSHActionTrigger sSHActionTrigger) {
        boolean bl = true;
        logger.debug("getSSHActionsForExecution() - start");
        List<SSHSettings> list = this.sshActionHelper.readAll(bl);
        ArrayList<SSHSettings> arrayList = new ArrayList<SSHSettings>();
        if (n != null) {
            logger.debug("getSSHActionsForExecution() - getting SSH settings for advanced configuration");
            UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(n);
            Map<String, Boolean> map = uPSSetup.getSSHSettings();
            for (SSHSettings sSHSettings : list) {
                boolean bl2;
                boolean bl3 = sSHSettings.isEnabled();
                boolean bl4 = sSHSettings.getTrigger() == sSHActionTrigger;
                boolean bl5 = bl2 = Boolean.TRUE == map.get(sSHSettings.getSection());
                if (!bl3 || !bl4 || !bl2) continue;
                arrayList.add(sSHSettings);
            }
        } else {
            logger.debug("getSSHActionsForExecution() - getting SSH settings for non-advanced configuration");
            for (SSHSettings sSHSettings : list) {
                boolean bl6;
                boolean bl7 = sSHSettings.isEnabled();
                boolean bl8 = bl6 = sSHSettings.getTrigger() == sSHActionTrigger;
                if (!bl7 || !bl6) continue;
                arrayList.add(sSHSettings);
            }
        }
        logger.debug("getSSHActionsForExecution() - end, list contains: {} items", (Object)arrayList.size());
        return arrayList;
    }

    private void sendSSHActionEvent(String string, String string2) {
        try {
            Object[] objectArray = new Object[]{StringEscapeUtils.escapeHtml4((String)string)};
            RunSSHActionFormatter runSSHActionFormatter = new RunSSHActionFormatter("com.apcc.m11.components.shutdowner.i18n.ShutdownFormatters", string2, objectArray);
            this.services.getApplicationErrorHandler().put(runSSHActionFormatter.format(null));
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error((Object)throwable);
        }
    }

    public synchronized void clearActionLocks(SSHActionTrigger sSHActionTrigger) {
        logger.debug("clearActionLocks() - start, trigger {}", (Object)sSHActionTrigger);
        this.actionsAlreadyRun.get((Object)sSHActionTrigger).clear();
    }

    private synchronized void flagAsRun(SSHActionTrigger sSHActionTrigger, String string) {
        logger.debug("flagAsRun() - start, stage: {}, section: {}", (Object)sSHActionTrigger, (Object)string);
        this.actionsAlreadyRun.get((Object)sSHActionTrigger).add(string);
    }

    private synchronized boolean hasAlreadyRun(SSHActionTrigger sSHActionTrigger, String string) {
        logger.debug("hasAlreadyRun() - start, stage: {}, section: {}", (Object)sSHActionTrigger, (Object)string);
        return this.actionsAlreadyRun.get((Object)sSHActionTrigger).contains(string);
    }

    @Override
    public void run() {
        logger.debug("run() - start");
        while (this.isEnabled()) {
            try {
                SSHActionSupplier sSHActionSupplier = null;
                try {
                    sSHActionSupplier = this.runQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (sSHActionSupplier == null) continue;
                SSHSettings sSHSettings = sSHActionSupplier.getAction();
                if (this.hasAlreadyRun(sSHSettings.getTrigger(), sSHSettings.getSection())) {
                    logger.info("run() - skipping {} as it has already run", (Object)sSHSettings.getName());
                    this.sendSSHActionEvent(sSHSettings.getName(), "RunSSHAction_AlreadyRun");
                    sSHActionSupplier.releaseLatch(LatchRelease.SKIPPED);
                    continue;
                }
                logger.info("run() - starting execution of {}", (Object)sSHSettings.getName());
                this.flagAsRun(sSHSettings.getTrigger(), sSHSettings.getSection());
                this.sendSSHActionEvent(sSHSettings.getName(), "RunSSHAction_Starting");
                LatchRelease latchRelease = LatchRelease.COMPLETE;
                try {
                    logger.debug("run() - Async execution of task: {}. Expected runtime: {}", (Object)sSHSettings.getName(), (Object)sSHSettings.getRuntime());
                    latchRelease = CompletableFuture.supplyAsync(sSHActionSupplier).get(10L + (long)sSHSettings.getRuntime(), TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException exception) {
                    logger.warn("run() - execution failure for {}", (Object)sSHSettings.getName());
                    latchRelease = LatchRelease.COMPLETE;
                }
                catch (TimeoutException timeoutException) {
                    logger.debug("run() - execution timeout for {}", (Object)sSHSettings.getName());
                    latchRelease = LatchRelease.TIMEOUT;
                }
                switch (latchRelease) {
                    case ERROR: {
                        logger.warn("run() - execution failure for {}", (Object)sSHSettings.getName());
                        this.osLogger.warn("OsLogger.SSHAction.Error", "108", sSHSettings.getName());
                        this.sendSSHActionEvent(sSHSettings.getName(), "RunSSHAction_Done");
                        break;
                    }
                    case COMPLETE: {
                        logger.info("run() - execution complete for {}", (Object)sSHSettings.getName());
                        this.sendSSHActionEvent(sSHSettings.getName(), "RunSSHAction_Done");
                        break;
                    }
                    case TIMEOUT: {
                        logger.info("run() - execution duration exceeded for {}", (Object)sSHSettings.getName());
                        this.osLogger.warn("OsLogger.SSHAction.Timeout", "109", sSHSettings.getName());
                        this.sendSSHActionEvent(sSHSettings.getName(), "RunSSHAction_DurationTimeout");
                        break;
                    }
                    default: {
                        logger.warn("Unhandled SSH action result.");
                    }
                }
                sSHActionSupplier.releaseLatch(latchRelease);
            }
            catch (Exception exception) {
                logger.warn((Object)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public void setEnabled(boolean bl) {
        Object object = this.$lock;
        synchronized (object) {
            this.enabled = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public boolean isEnabled() {
        Object object = this.$lock;
        synchronized (object) {
            return this.enabled;
        }
    }
}

