/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.pcns.sshservice.LatchRelease;
import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.util.CountdownTimer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import javax.naming.AuthenticationException;
import lombok.NonNull;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.MultiResult;
import net.sf.expectit.Result;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.Matchers;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHActionSupplier
implements Supplier<LatchRelease> {
    private static final Logger logger = LogManager.getLogger(SSHActionSupplier.class);
    public static final String LINUX_USER_PROMPT = "\\$\\s";
    public static final String LINUX_ROOT_PROMPT = "#\\s";
    public static final String WINDOWS_RPDU_PROMPT = "\\w>";
    private SSHSettings action;
    private CountDownLatch latch;
    private SshSession sshSession;

    public SSHActionSupplier(@NonNull SSHSettings sSHSettings, @NonNull CountDownLatch countDownLatch, @NonNull SshSession sshSession) {
        if (sSHSettings == null) {
            throw new IllegalArgumentException("action is marked non-null but is null");
        }
        if (countDownLatch == null) {
            throw new IllegalArgumentException("latch is marked non-null but is null");
        }
        if (sshSession == null) {
            throw new IllegalArgumentException("sshSession is marked non-null but is null");
        }
        logger.debug("SSHActionRunner() - start");
        this.action = sSHSettings;
        this.latch = countDownLatch;
        this.sshSession = sshSession;
    }

    public SSHSettings getAction() {
        return this.action;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public void releaseLatch(LatchRelease latchRelease) {
        switch (latchRelease) {
            case SKIPPED: {
                logger.debug("releaseLatch() - releasing latch on '{}', task has already run.", (Object)this.action.getName());
                break;
            }
            case COMPLETE: {
                logger.debug("releaseLatch() - releasing latch on '{}', task has completed.", (Object)this.action.getName());
                break;
            }
            case TIMEOUT: {
                logger.debug("releaseLatch() - releasing latch on '{}', task has taken more time than configured.", (Object)this.action.getName());
                break;
            }
            default: {
                logger.debug("releaseLatch() - releasing latch on '{}', due to {}", (Object)this.action.getName(), (Object)latchRelease);
            }
        }
        this.latch.countDown();
        logger.debug("releaseLatch() - latches pending: {}", (Object)this.latch.getCount());
    }

    private LatchRelease lineByLine() {
        logger.debug("lineByLine() - start");
        LatchRelease latchRelease = LatchRelease.COMPLETE;
        try {
            this.sshSession.setConnectionConfig(this.action.getSSHConnectionConfig());
            this.sshSession.startConnection();
            List<String> list = Files.readAllLines(Paths.get(this.action.getCommandFilePath(), new String[0]));
            SshSession.ShellStreams shellStreams = this.sshSession.startShell();
            Expect expect = new ExpectBuilder().withInfiniteTimeout().withInputs(new InputStream[]{shellStreams.shellInput}).withOutput(shellStreams.shellOutput).build();
            Matcher<MultiResult> matcher = this.getPromptMatcher();
            Result result = expect.withTimeout(30L, TimeUnit.SECONDS).expect(matcher);
            logger.debug("lineByLine() - SSH Action Output:");
            logger.debug(result.getInput());
            if (result.isSuccessful()) {
                for (String string : list) {
                    if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
                    expect.sendLine(string);
                    result = expect.expect(matcher);
                    logger.debug(result.getInput());
                }
            } else {
                logger.error("lineByLine() - failed to detect remote command prompt.  Aborting SSH Action: {}", (Object)this.action.getName());
                latchRelease = LatchRelease.ERROR;
            }
            expect.close();
            this.sshSession.closeConnection();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | AuthenticationException exception) {
            logger.error("lineByLine() - SSH Action: {} failed with error: {}", (Object)this.action.getName(), (Object)exception);
            latchRelease = LatchRelease.ERROR;
        }
        logger.debug("lineByLine() - end");
        return latchRelease;
    }

    protected Matcher<MultiResult> getPromptMatcher() {
        logger.debug("getPromptMatcher() - start");
        String string = this.action.getCustomPrompt();
        Matcher matcher = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                Matcher matcher2 = Matchers.regexp((String)string);
                logger.debug("getPromptMatcher() - adding custom prompt from config to prompt matchers: {}", (Object)string);
                matcher = Matchers.anyOf((Matcher[])new Matcher[]{matcher2, Matchers.regexp((String)LINUX_ROOT_PROMPT), Matchers.regexp((String)LINUX_USER_PROMPT), Matchers.regexp((String)WINDOWS_RPDU_PROMPT)});
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.error("getPromptMatcher() - found custom prompt regular expression in config but failed to compile, error: {}", (Throwable)patternSyntaxException);
            }
        }
        if (matcher == null) {
            logger.debug("getPromptMatcher() - using default prompt matchers only");
            matcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.regexp((String)LINUX_ROOT_PROMPT), Matchers.regexp((String)LINUX_USER_PROMPT), Matchers.regexp((String)WINDOWS_RPDU_PROMPT)});
        }
        logger.debug("getPromptMatcher() - end");
        return matcher;
    }

    @Override
    public LatchRelease get() {
        LatchRelease latchRelease = LatchRelease.COMPLETE;
        try {
            if (this.action.isEnabled()) {
                logger.info("run() - executing SSH Action: {}", (Object)this.action.getName());
                logger.debug("run() - waiting for the SSH Action Delay: {}", (Object)this.action.getDelay());
                CountdownTimer countdownTimer = new CountdownTimer(this.action.getDelay(), TimeUnit.SECONDS);
                countdownTimer.sleep();
                logger.debug("run() - starting SSH Action duration timer: {}", (Object)this.action.getDuration());
                countdownTimer = new CountdownTimer(this.action.getDuration(), TimeUnit.SECONDS);
                latchRelease = this.lineByLine();
                boolean bl = false;
                if (countdownTimer.hasElapsed()) {
                    logger.debug("run() - Duration has elapsed.  Setting result to TIMEOUT");
                    bl = true;
                } else {
                    logger.debug("run() - waiting any remainder on the duration.");
                    countdownTimer.sleep();
                    logger.debug("run() - duration clock elapsed.");
                }
                if (bl && latchRelease != LatchRelease.ERROR) {
                    latchRelease = LatchRelease.TIMEOUT;
                }
            }
        }
        catch (Exception exception) {
            logger.error("run() - error running ssh Action: {}", (Throwable)exception);
            latchRelease = LatchRelease.ERROR;
        }
        logger.debug("run() - end, result: {}", (Object)latchRelease);
        return latchRelease;
    }
}

