/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public abstract class SSHCommand {
    private String command;
    private int wait;
    private TimeUnit waitUnit;

    public SSHCommand(@NonNull String string, int n, @NonNull TimeUnit timeUnit) {
        if (string == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit is marked non-null but is null");
        }
        this.command = string;
        this.wait = n;
        this.waitUnit = timeUnit;
    }

    public int getWait() {
        return (int)TimeUnit.SECONDS.convert(this.wait, this.waitUnit);
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public TimeUnit getWaitUnit() {
        return this.waitUnit;
    }
}

