/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import javax.naming.AuthenticationException;

public interface SshSession {
    public void setConnectionConfig(SshConnectionConfig var1) throws IllegalArgumentException, IOException;

    public void setHost(String var1) throws IllegalArgumentException;

    public void setUsername(String var1) throws IllegalArgumentException;

    public void setPassword(String var1) throws IllegalArgumentException;

    public void setSshKey(String var1) throws IllegalArgumentException, IOException;

    public void setSshKey(String var1, String var2) throws IllegalArgumentException, IOException;

    public void setTimeout(int var1) throws IllegalArgumentException;

    public void setPort(int var1);

    public void startConnection() throws IOException, ConnectException, IllegalStateException, AuthenticationException;

    public ShellStreams startShell() throws IllegalStateException, ConnectException;

    public boolean hasActiveConnection();

    public boolean hasActiveSession();

    public CmdResult executeCommand(String var1, int var2) throws IllegalArgumentException, IllegalStateException, ConnectException;

    public CmdResult executeCommand(String var1, int var2, boolean var3) throws IllegalArgumentException, IllegalStateException, ConnectException;

    public void closeShellSession() throws IllegalStateException, ConnectException;

    public void closeConnection() throws IllegalStateException, IOException, ConnectException;

    public void scpUpload(String var1, String var2) throws IOException, IllegalStateException;

    public static class ShellStreams {
        public InputStream shellInput;
        public OutputStream shellOutput;
    }

    public static class CmdResult {
        public String output;
        public String error;
        public int exitStatus;
    }

    public static class SshConnectionConfig {
        public String host;
        public String username;
        public String password;
        public String sshKeyLocation;
        public String keyPassphrase;
        public int timeout;
        public Integer port;
        public Integer keepAlivePeriod;
    }
}

