/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.sshservice;

import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.util.CountdownTimer;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import net.schmizz.keepalive.KeepAliveProvider;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.IOUtils;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SshSessionImpl
implements SshSession {
    private static final Logger logger = LogManager.getLogger(SshSessionImpl.class);
    private SSHClient client;
    private Session shellSession;
    private String host;
    private String username;
    private String password;
    private Integer port;
    private KeyProvider sshKeyProv;
    private int sessionTimeout;
    private int readyToConnectScore = 0;
    public static final int KEEP_ALIVE_INTERVAL = 15;
    private int keepAliveInterval = 15;

    public SshSessionImpl() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    SSHClient makeClient() {
        DefaultConfig defaultConfig = new DefaultConfig();
        defaultConfig.setKeepAliveProvider(KeepAliveProvider.KEEP_ALIVE);
        return new SSHClient((Config)defaultConfig);
    }

    @Override
    public void setConnectionConfig(SshSession.SshConnectionConfig sshConnectionConfig) throws IllegalArgumentException, IOException {
        if (sshConnectionConfig == null) {
            throw new IllegalArgumentException("Config object cannot be null.");
        }
        this.setHost(sshConnectionConfig.host);
        this.setUsername(sshConnectionConfig.username);
        this.port = sshConnectionConfig.port;
        if (sshConnectionConfig.keepAlivePeriod != null) {
            this.keepAliveInterval = sshConnectionConfig.keepAlivePeriod;
        }
        if (this.client == null) {
            this.client = this.makeClient();
        }
        if (!StringUtils.isBlank((CharSequence)sshConnectionConfig.password)) {
            this.setPassword(sshConnectionConfig.password);
        } else if (!StringUtils.isBlank((CharSequence)sshConnectionConfig.sshKeyLocation)) {
            this.password = null;
            if (!StringUtils.isBlank((CharSequence)sshConnectionConfig.keyPassphrase)) {
                this.setSshKey(sshConnectionConfig.sshKeyLocation, sshConnectionConfig.keyPassphrase);
            } else {
                this.setSshKey(sshConnectionConfig.sshKeyLocation);
            }
        } else {
            throw new IllegalArgumentException("Missing authentication details, password and sshKeyLocation cannot be both blank.");
        }
        this.setTimeout(sshConnectionConfig.timeout);
    }

    @Override
    public void setHost(String string) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Host parameter is missing.");
        }
        this.host = string;
        ++this.readyToConnectScore;
    }

    @Override
    public void setUsername(String string) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Username parameter is missing.");
        }
        this.username = string;
        ++this.readyToConnectScore;
    }

    @Override
    public void setPassword(String string) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Password parameter is missing.");
        }
        this.password = string;
        ++this.readyToConnectScore;
    }

    @Override
    public void setSshKey(String string) throws IllegalArgumentException, IOException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Ssh key location parameter is missing.");
        }
        if (this.client == null) {
            this.client = this.makeClient();
        }
        this.sshKeyProv = this.client.loadKeys(string);
        ++this.readyToConnectScore;
    }

    @Override
    public void setSshKey(String string, String string2) throws IllegalArgumentException, IOException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Ssh key location parameter is missing.");
        }
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new IllegalArgumentException("Passphrase parameter is missing.");
        }
        if (this.client == null) {
            this.client = this.makeClient();
        }
        this.sshKeyProv = this.client.loadKeys(string, string2);
        ++this.readyToConnectScore;
    }

    @Override
    public void setTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout parameter cannot be negative.");
        }
        this.sessionTimeout = n;
    }

    @Override
    public void startConnection() throws IOException, ConnectException, IllegalStateException, AuthenticationException {
        if (this.canConnect()) {
            this.client.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            this.client.setTimeout(this.sessionTimeout);
            logger.debug("Connecting to host {} now", (Object)this.host);
            if (this.port == null) {
                this.client.connect(this.host);
            } else {
                this.client.connect(this.host, this.port.intValue());
            }
            this.client.getConnection().getKeepAlive().setKeepAliveInterval(this.keepAliveInterval);
            try {
                if (this.password != null) {
                    logger.debug("Authenticating with host {} now, using password.", (Object)this.host);
                    this.client.authPassword(this.username, this.password);
                }
                logger.debug("Authenticating with host {} now, using key.", (Object)this.host);
                this.client.authPublickey(this.username, new KeyProvider[]{this.sshKeyProv});
            }
            catch (UserAuthException userAuthException) {
                logger.error("SSH authentication failed with error {}", (Object)userAuthException.getMessage());
                AuthenticationException authenticationException = new AuthenticationException("Failed to connect session due authentication failure");
                throw authenticationException;
            }
        } else {
            throw new IllegalStateException("Session not correctly configured.");
        }
    }

    @Override
    public SshSession.ShellStreams startShell() throws IllegalStateException, ConnectException {
        SshSession.ShellStreams shellStreams = null;
        if (this.canStartSession()) {
            try {
                this.shellSession = this.client.startSession();
                this.shellSession.allocateDefaultPTY();
                this.shellSession.startShell();
                shellStreams = new SshSession.ShellStreams();
                shellStreams.shellInput = this.shellSession.getInputStream();
                shellStreams.shellOutput = this.shellSession.getOutputStream();
            }
            catch (ConnectionException | TransportException throwable) {
                logger.error("Starting shell session failed with error {}", (Object)throwable.getMessage());
                ConnectException connectException = new ConnectException("Failed to start session");
                throw connectException;
            }
        }
        return shellStreams;
    }

    @Override
    public SshSession.CmdResult executeCommand(String string, int n) throws IllegalArgumentException, IllegalStateException, ConnectException {
        return this.executeCommand(string, n, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SshSession.CmdResult executeCommand(String string, int n, boolean bl) throws IllegalArgumentException, IllegalStateException, ConnectException {
        logger.trace("Executing command with wait: {} and readStreams: {}", (Object)n, (Object)bl);
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Command parameter is missing.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Wait parameter cannot be negative.");
        }
        if (!this.canStartSession()) throw new IllegalStateException("Can't create a session.");
        Session session = null;
        SshSession.CmdResult cmdResult = null;
        try {
            this.client.setTimeout((int)TimeUnit.SECONDS.toMillis(n));
            this.client.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(n));
            session = this.client.startSession();
            if (session == null || !session.isOpen() || session.isEOF()) {
                logger.error("executeCommand() - failed to open session (session is null: {})", (Object)(session == null ? 1 : 0));
                throw new ConnectionException("No valid session available");
            }
            logger.trace("executeCommand() - session started and open: {}", (Object)session.isOpen());
            try {
                Session.Command command = session.exec(string);
                cmdResult = new SshSession.CmdResult();
                if (command == null) {
                    logger.error("executeCommand() - failed to execute command, returned Command object is null");
                    throw new ConnectionException("Command execution failed");
                }
                if (bl) {
                    logger.trace("Reading output streams");
                    InputStream inputStream = command.getInputStream();
                    InputStream inputStream2 = command.getErrorStream();
                    if (inputStream != null) {
                        logger.trace("executeCommand() - reading command InputStream");
                        cmdResult.output = IOUtils.readFully((InputStream)command.getInputStream()).toString();
                    }
                    if (inputStream2 != null) {
                        logger.trace("executeCommand() - reading command ErrorStream");
                        cmdResult.error = IOUtils.readFully((InputStream)command.getErrorStream()).toString();
                    }
                    try {
                        logger.trace("executeCommand() - trying to retrieve exit status");
                        cmdResult.exitStatus = command.getExitStatus();
                        logger.trace("Exit status: {}", (Object)cmdResult.exitStatus);
                    }
                    catch (Exception exception) {
                        logger.error("executeCommand() - failed to retrieve exit status with error: {}", (Throwable)exception);
                    }
                }
                command.join((long)n, TimeUnit.SECONDS);
            }
            catch (ConnectionException | TransportException throwable) {
                logger.debug("Command execution failed with error {}", throwable);
                throw new ConnectException("Failed to execute command");
            }
            catch (IOException iOException) {
                logger.error("Failed to read the output for shell command, error {}", (Throwable)iOException);
                throw new ConnectException("Failed to read shell output");
            }
        }
        catch (ConnectionException | TransportException throwable) {
            try {
                logger.error("Starting session for command execution failed with error {}", throwable);
                if (!(throwable instanceof OpenFailException)) throw new ConnectException("Failed to start session");
                OpenFailException openFailException = (OpenFailException)throwable;
                logger.error("Session failure reason: {}", (Object)openFailException.getReason());
                throw new ConnectException("Failed to start session");
                catch (Exception exception) {
                    logger.error("Starting session for command execution failed with error {}", (Throwable)exception);
                    throw new ConnectException("Failed to start session");
                }
            }
            catch (Throwable throwable2) {
                try {
                    if (session == null) throw throwable2;
                    logger.trace("Closing SSH session");
                    session.close();
                    new CountdownTimer(1L, TimeUnit.SECONDS).sleep();
                    logger.trace("Session closed: {}", (Object)(!session.isOpen() ? 1 : 0));
                    throw throwable2;
                }
                catch (ConnectionException | TransportException throwable3) {
                    logger.error("Closing session failed with error {}", throwable3);
                }
                throw throwable2;
            }
        }
        try {
            if (session == null) return cmdResult;
            logger.trace("Closing SSH session");
            session.close();
            new CountdownTimer(1L, TimeUnit.SECONDS).sleep();
            logger.trace("Session closed: {}", (Object)(!session.isOpen() ? 1 : 0));
            return cmdResult;
        }
        catch (ConnectionException | TransportException throwable) {
            logger.error("Closing session failed with error {}", throwable);
            return cmdResult;
        }
    }

    @Override
    public boolean hasActiveSession() {
        boolean bl = this.shellSession != null && this.shellSession.isOpen();
        logger.trace("hasActiveSession() - {}", (Object)bl);
        return bl;
    }

    @Override
    public boolean hasActiveConnection() {
        boolean bl = this.client.isConnected() && this.client.isAuthenticated();
        logger.trace("hasActiveConnection() - {}", (Object)bl);
        return bl;
    }

    private boolean closeSession() throws IllegalStateException, ConnectException {
        if (this.client == null || !this.client.isConnected()) {
            throw new IllegalStateException("No active client connection available");
        }
        if (this.hasActiveSession()) {
            try {
                this.shellSession.close();
                return true;
            }
            catch (ConnectionException | TransportException throwable) {
                logger.error("Closing session failed with error {}", (Object)throwable.getMessage());
                ConnectException connectException = new ConnectException("Failed to close session");
                throw connectException;
            }
        }
        return false;
    }

    @Override
    public void closeConnection() throws IllegalStateException, IOException, ConnectException {
        this.closeSession();
        this.client.close();
    }

    @Override
    public void closeShellSession() throws IllegalStateException, ConnectException {
        if (!this.closeSession()) {
            logger.debug("Unable to close shell session, no active session found.");
        }
    }

    private boolean canStartSession() {
        if (this.client == null || !this.client.isConnected() || !this.client.isAuthenticated()) {
            throw new IllegalStateException("No active ssh connection available.");
        }
        if (this.hasActiveSession()) {
            throw new IllegalStateException("Another session is already open.");
        }
        return true;
    }

    private boolean canConnect() {
        return this.readyToConnectScore >= 3;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public void scpUpload(String string, String string2) throws IOException, IllegalStateException {
        if (!this.canConnect()) {
            throw new IllegalStateException("Session not correctly configured.");
        }
        this.client.useCompression();
        this.client.newSCPFileTransfer().upload(string, string2);
    }
}

