/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.threadpool;

import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadService {
    private static final Logger logger = LogManager.getLogger(ThreadService.class);
    private static final int POOL_SIZE = 70;
    private ScheduledExecutorService executor;
    private static int maxSize = 0;
    private HashMap<String, Integer> map = new HashMap();

    public ThreadService() {
        this.executor = Executors.newScheduledThreadPool(70);
    }

    public Future<?> submit(Runnable runnable) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.executor;
        this.log(runnable);
        logger.trace("Scheduled:" + scheduledThreadPoolExecutor.getTaskCount() + " Complete:" + scheduledThreadPoolExecutor.getCompletedTaskCount());
        return scheduledThreadPoolExecutor.submit(runnable);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.executor;
        this.log(runnable);
        return scheduledThreadPoolExecutor.scheduleAtFixedRate(runnable, l, l2, timeUnit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, int n, int n2, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.executor;
        this.log(runnable);
        return scheduledThreadPoolExecutor.scheduleWithFixedDelay(runnable, n, n2, timeUnit);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, int n, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.executor;
        this.log(runnable);
        return scheduledThreadPoolExecutor.schedule(runnable, (long)n, timeUnit);
    }

    public void execute(Runnable runnable) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = (ScheduledThreadPoolExecutor)this.executor;
        this.log(runnable);
        scheduledThreadPoolExecutor.execute(runnable);
    }

    private void log(Runnable runnable) {
        Object object;
        Integer n = this.map.get(runnable.getClass().getName());
        if (n == null) {
            n = 1;
        } else {
            object = n;
            n = n + 1;
        }
        this.map.put(runnable.getClass().getName(), n);
        object = (ScheduledThreadPoolExecutor)this.executor;
        logger.trace("==============================");
        logger.trace("Total Tasks Scheduled:" + ((ThreadPoolExecutor)object).getTaskCount());
        logger.trace("Total Tasks Complete:" + ((ThreadPoolExecutor)object).getCompletedTaskCount());
        logger.trace("Total Tasks Active:" + ((ThreadPoolExecutor)object).getActiveCount());
        if (((ThreadPoolExecutor)object).getActiveCount() > maxSize) {
            maxSize = ((ThreadPoolExecutor)object).getActiveCount();
        }
        logger.trace("Maximum:" + maxSize);
        logger.trace("------------------------------");
        for (String string : this.map.keySet()) {
            logger.trace(string + ":" + String.valueOf(this.map.get(string)));
        }
        logger.trace("------------------------------");
    }

    public void shutdownNow() {
        logger.debug("shutdownNow() - Shutting down thread service...");
        this.executor.shutdownNow();
        logger.debug("shutdownNow() - Thread service shutdown complete.");
    }
}

