/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableBody;
import com.apcc.m11.components.webserver.html.table.TableData;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.pcns.trustmanagement.CertificateUtils;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.apcc.pcns.util.DateTimeFormatUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import lombok.NonNull;

public class CertificateHTMLHelper {
    private static final String CSS_HIDDEN = "hidden";
    private static final String UNTRUSTED_CERT_DIALOG_TITLE = "CfgWizard.CertificateManagementPage.DialogTitle";
    private static final String PCNS_CANCEL_BUTTON = "PCNS.CancelButton";
    private static final String PCNS_CLOSE_BUTTON = "PCNS.CloseButton";
    private static final String ACCEPT_CERT_BUTTON = "CfgWizard.CertificateManagementPage.AcceptCert";
    private static final String NO_CERTS = "CfgWizard.CertificateManagementPage.NoCertsToValidate";
    private static final String CERT_READ_FAIL = "CfgWizard.CertificateManagementPage.ReadFail";
    private static final String VERSION = "CfgWizard.CertificateManagementPage.Version";
    private static final String SUBJECT = "CfgWizard.CertificateManagementPage.Subject";
    private static final String ISSUER = "CfgWizard.CertificateManagementPage.Issuer";
    private static final String SERIAL_NUMBER = "CfgWizard.CertificateManagementPage.SerialNumber";
    private static final String VALID_FROM = "CfgWizard.CertificateManagementPage.ValidFrom";
    private static final String VALID_TO = "CfgWizard.CertificateManagementPage.ValidTo";
    private static final String PUBLIC_KEY_FIELD = "CfgWizard.CertificateManagementPage.PublicKeyField";
    private static final String SIGNATURE_ALGORITHM = "CfgWizard.CertificateManagementPage.SignatureAlgorithm";
    private static final String ALIAS_TEXT = "CfgWizard.CertificateManagementPage.Alias";
    private static final String EXPIRY_TEXT = "CfgWizard.CertificateManagementPage.ExpiryDate";
    private static final String CERT_BUTTON_TEXT = "CfgWizard.CertificateManagementPage.ViewCert";
    private static final String CERT_VIEW_INFO = "CfgWizard.CertificateManagementPage.CertViewInfo";
    private UnverifiedCertificateManager certManager;
    private CertificateUtils certUtils;
    private DateTimeFormatUtils dateUtils;
    private ResourceBundleWrapper resources;
    private String noCertsText;
    private String resCertViewDialogTitle;
    private String resCloseButton;
    private String resAcceptButton;
    private String resCancelButton;
    private String resReadFailError;
    private String versionFieldName;
    private String subjectFieldName;
    private String issuerFieldName;
    private String serialNumber;
    private String validFrom;
    private String validTo;
    private String publicKey;
    private String signatureAlgorithm;
    private String aliasHeader;
    private String expiryHeader;
    private String buttonHeader;
    private String infoMessage;

    public CertificateHTMLHelper(@NonNull UnverifiedCertificateManager unverifiedCertificateManager, @NonNull CertificateUtils certificateUtils, @NonNull DateTimeFormatUtils dateTimeFormatUtils, @NonNull ResourceBundleWrapper resourceBundleWrapper) {
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("certManager is marked non-null but is null");
        }
        if (certificateUtils == null) {
            throw new IllegalArgumentException("certUtils is marked non-null but is null");
        }
        if (dateTimeFormatUtils == null) {
            throw new IllegalArgumentException("dateUtils is marked non-null but is null");
        }
        if (resourceBundleWrapper == null) {
            throw new IllegalArgumentException("resources is marked non-null but is null");
        }
        this.certManager = unverifiedCertificateManager;
        this.certUtils = certificateUtils;
        this.dateUtils = dateTimeFormatUtils;
        this.resources = resourceBundleWrapper;
        this.getResources();
    }

    public void addCertificateListContainer(Container container) {
        Division division = new Division();
        division.setId("certListDiv");
        container.add(division);
        this.addCertificateListView(division);
    }

    private void getResources() {
        ResourceBundle resourceBundle = this.resources.getResourceBundle();
        this.noCertsText = resourceBundle.getString(NO_CERTS);
        this.resAcceptButton = resourceBundle.getString(ACCEPT_CERT_BUTTON);
        this.resCloseButton = resourceBundle.getString(PCNS_CLOSE_BUTTON);
        this.resCancelButton = resourceBundle.getString(PCNS_CANCEL_BUTTON);
        this.resCertViewDialogTitle = resourceBundle.getString(UNTRUSTED_CERT_DIALOG_TITLE);
        this.resReadFailError = resourceBundle.getString(CERT_READ_FAIL);
        this.issuerFieldName = resourceBundle.getString(ISSUER);
        this.subjectFieldName = resourceBundle.getString(SUBJECT);
        this.publicKey = resourceBundle.getString(PUBLIC_KEY_FIELD);
        this.serialNumber = resourceBundle.getString(SERIAL_NUMBER);
        this.signatureAlgorithm = resourceBundle.getString(SIGNATURE_ALGORITHM);
        this.validFrom = resourceBundle.getString(VALID_FROM);
        this.validTo = resourceBundle.getString(VALID_TO);
        this.versionFieldName = resourceBundle.getString(VERSION);
        this.aliasHeader = resourceBundle.getString(ALIAS_TEXT);
        this.expiryHeader = resourceBundle.getString(EXPIRY_TEXT);
        this.buttonHeader = resourceBundle.getString(CERT_BUTTON_TEXT);
        this.infoMessage = resourceBundle.getString(CERT_VIEW_INFO);
    }

    private HTML createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.resCertViewDialogTitle);
        span.setId("resCertViewDialogTitle");
        division.add(span);
        span = new Span(this.noCertsText);
        span.setId("noCertsText");
        division.add(span);
        span = new Span(this.resCloseButton);
        span.setId("resCloseButton");
        division.add(span);
        span = new Span(this.resAcceptButton);
        span.setId("resAcceptButton");
        division.add(span);
        span = new Span(this.resCancelButton);
        span.setId("resCancelButton");
        division.add(span);
        span = new Span(this.resReadFailError);
        span.setId("resReadFailError");
        division.add(span);
        return division;
    }

    public void addCertificateListView(Container container) {
        Map<String, List<X509Certificate>> map = this.certManager.getAllCertificateChains();
        UnOrderedList unOrderedList = new UnOrderedList();
        unOrderedList.setId("certList");
        if (map.isEmpty()) {
            unOrderedList.setCssClass(CSS_HIDDEN);
        }
        container.add(unOrderedList);
        ListItem listItem = new ListItem();
        listItem.setId("certItem");
        listItem.setCssClass("ui-widget-content ui-corner-all");
        unOrderedList.add(listItem);
        this.createTableHeaders(listItem);
        for (Map.Entry<String, List<X509Certificate>> entry : map.entrySet()) {
            List<X509Certificate> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            listItem = new ListItem();
            listItem.setId("certItem");
            listItem.setCssClass("ui-widget-content ui-corner-all");
            unOrderedList.add(listItem);
            this.createListViewRow(entry.getKey(), list, listItem);
        }
    }

    public void addEmptyCertPanel(Container container) {
        Map<String, List<X509Certificate>> map = this.certManager.getAllCertificateChains();
        Division division = new Division();
        division.setId("noCertsDiv");
        division.add(new Text(this.noCertsText));
        Object object = "ui-state-highlight ui-corner-all";
        if (!map.isEmpty()) {
            object = (String)object + " hidden";
        }
        division.setCssClass((String)object);
        container.add(division);
    }

    private void createListViewRow(String string, List<X509Certificate> list, Container container) {
        Table table = new Table();
        container.add(table);
        TableBody tableBody = new TableBody();
        table.add(tableBody);
        TableRow tableRow = new TableRow();
        tableBody.add(tableRow);
        TableData tableData = new TableData();
        tableRow.add(tableData);
        Span span = new Span();
        tableData.add(span);
        span.setCssClass("certAlias");
        span.setText(string);
        tableData = new TableData();
        tableRow.add(tableData);
        span = new Span();
        tableData.add(span);
        Date date = this.certUtils.findExpiryDate(list);
        span.setText(this.dateUtils.dateToISOString(date));
        TableData tableData2 = new TableData();
        tableRow.add(tableData2);
        Anchor anchor = new Anchor();
        anchor.setCssClass("viewBtn");
        anchor.setHypertextReference("#");
        anchor.setAttribute("index", string);
        tableData2.add(anchor);
    }

    public void createTableHeaders(Container container) {
        Table table = new Table();
        container.add(table);
        TableBody tableBody = new TableBody();
        table.add(tableBody);
        TableRow tableRow = new TableRow();
        tableBody.add(tableRow);
        TableData tableData = new TableData();
        tableRow.add(tableData);
        Span span = new Span();
        tableData.add(span);
        span.setCssClass("certAlias tableHeader");
        span.setText(this.aliasHeader);
        tableData = new TableData();
        tableRow.add(tableData);
        span = new Span();
        span.setCssClass("tableHeader");
        tableData.add(span);
        span.setText(this.expiryHeader);
        tableData = new TableData();
        tableRow.add(tableData);
        span = new Span();
        span.setCssClass("tableHeader");
        tableData.add(span);
        span.setText(this.buttonHeader);
    }

    public HTML createCertViewDialog() {
        Division division = new Division();
        division.add(this.createResourceStrings());
        Division division2 = new Division();
        division.add(division2);
        division2.setId("certViewDialog");
        division2.setCssClass(CSS_HIDDEN);
        Form form = new Form();
        division2.add(form);
        form.setId("certViewDialogForm");
        Division division3 = FormHelper.createInfoDivision("certInfoDiv", this.infoMessage, null);
        division3.setStyle("display: block;");
        division2.add(division3);
        division2.add(FormHelper.createLabelValueDiv("version", this.versionFieldName, "", null));
        division2.add(FormHelper.createLabelValueDiv("subject", this.subjectFieldName, "", null));
        division2.add(FormHelper.createLabelValueDiv("issuer", this.issuerFieldName, "", null));
        division2.add(FormHelper.createLabelValueDiv("serial", this.serialNumber, "", null));
        division2.add(FormHelper.createLabelValueDiv("validFrom", this.validFrom, "", null));
        division2.add(FormHelper.createLabelValueDiv("validTo", this.validTo, "", null));
        division2.add(FormHelper.createLabelValueDiv("publicKey", this.publicKey, "", null));
        division2.add(FormHelper.createLabelValueDiv("sigAlg", this.signatureAlgorithm, "", null));
        Input input = new Input();
        form.add(input);
        input.setType(CSS_HIDDEN);
        input.setId("alias");
        Input input2 = new Input();
        form.add(input2);
        input2.setType(CSS_HIDDEN);
        input2.setId("index");
        Division division4 = new Division();
        division4.setCssClass("labelvaluediv");
        Span span = new Span("Certificate Chain");
        division4.add(span);
        Division division5 = new Division();
        division5.setId("certTree");
        division4.add(division5);
        division2.add(division4);
        return division;
    }
}

