/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.pcns.trustmanagement.KeyUsage;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import lombok.NonNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class CertificateUtils {
    private static final String VERISIGN_EMAIL_ADDRESS = "E";
    private static final String PKCS_9_EMAIL_ADDRESS = "emailAddress";
    public static final Logger logger = LogManager.getLogger(CertificateUtils.class);

    public Date findExpiryDate(@NonNull List<X509Certificate> list) {
        if (list == null) {
            throw new IllegalArgumentException("certList is marked non-null but is null");
        }
        Optional<Date> optional = list.stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder());
        return optional.orElse(null);
    }

    public boolean verifyCertificateDate(@NonNull List<X509Certificate> list) {
        if (list == null) {
            throw new IllegalArgumentException("certList is marked non-null but is null");
        }
        boolean bl = true;
        try {
            for (X509Certificate x509Certificate : list) {
                x509Certificate.checkValidity();
            }
        }
        catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
            bl = false;
        }
        return bl;
    }

    public boolean findValidity(@NonNull List<X509Certificate> list) {
        if (list == null) {
            throw new IllegalArgumentException("certList is marked non-null but is null");
        }
        return this.verifyCertificateDate(list);
    }

    public List<String> parseRdn(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("distinguishedName is marked non-null but is null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            LdapName ldapName = new LdapName(string);
            arrayList.addAll(ldapName.getRdns().stream().map(Rdn::toString).collect(Collectors.toList()));
        }
        catch (InvalidNameException invalidNameException) {
            logger.debug("parseRdn() - Failed to parse distinguished name: {}", (Object)string, (Object)invalidNameException);
        }
        logger.debug("parseRdn() - Returning: {}", arrayList);
        return arrayList;
    }

    public int getKeySize(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("key is marked non-null but is null");
        }
        BigInteger bigInteger = new BigInteger(publicKey.getEncoded());
        return bigInteger.bitLength();
    }

    public String getCommonName(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate is marked non-null but is null");
        }
        String string = "";
        try {
            X500Name x500Name = new JcaX509CertificateHolder(x509Certificate).getSubject();
            RDN[] rDNArray = x500Name.getRDNs(BCStyle.CN);
            if (rDNArray.length > 0 && rDNArray[0] != null) {
                RDN rDN = rDNArray[0];
                string = IETFUtils.valueToString((ASN1Encodable)rDN.getFirst().getValue());
            }
            logger.debug("getCommonName() - Common Name Found {}", (Object)string);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            logger.debug("getCommonName() - Could not find Common Name");
        }
        return string;
    }

    public String getThumbprint(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate is marked non-null but is null");
        }
        String string = null;
        try {
            string = DigestUtils.sha1Hex((byte[])x509Certificate.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            logger.debug("getThumbprint() - Exception creating certificate thumbprint", (Throwable)certificateEncodingException);
        }
        return string;
    }

    public String getCommonNameOrThumbprint(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate is marked non-null but is null");
        }
        String string = this.getCommonName(x509Certificate);
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.getThumbprint(x509Certificate);
        }
        logger.debug("getCommonNameOrThumbprint() - result: {}", (Object)string);
        return string;
    }

    public String getDistinguishedNameOrThumbprint(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        String string = this.getSubjectName(x509Certificate);
        if (StringUtils.isBlank((CharSequence)string)) {
            string = this.getThumbprint(x509Certificate);
        }
        logger.debug("getDistinguishedNameOrThumbprint() - result: {}", (Object)string);
        return string;
    }

    public String getCertificateAlias(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        String string = this.getSubjectName(x509Certificate);
        String string2 = this.getSerialNumberAsHex(x509Certificate);
        return MessageFormat.format("{0}-{1}", string, string2);
    }

    public String getSerialNumberAsHex(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        return StringUtils.trim((String)bigInteger.toString(16));
    }

    public X509Certificate generateCert(String string) throws CertificateException {
        logger.debug("generateCert() - start");
        X509Certificate x509Certificate = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException certificateException) {
            logger.error("generateCert() - CertificateException: {}", (Throwable)certificateException);
            throw certificateException;
        }
        logger.debug("generateCert() - end");
        return x509Certificate;
    }

    public boolean isSelfSigned(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        boolean bl = false;
        try {
            if (x509Certificate.getIssuerX500Principal().equals(x509Certificate.getSubjectX500Principal())) {
                x509Certificate.verify(x509Certificate.getPublicKey());
                bl = true;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException generalSecurityException) {
            logger.debug("isSelfSigned() - Failed to verify that certificate was self signed: ", (Throwable)generalSecurityException);
        }
        logger.debug("isSelfSigned() - Certificate {} is self signed: {}", (Object)x509Certificate.getSubjectX500Principal().getName(), (Object)bl);
        return bl;
    }

    public boolean isCertificateAuthority(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        boolean bl = false;
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            try {
                bl = blArray[KeyUsage.KEY_CERT_SIGN.getValue()];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.debug("isCertificateAuthority() - Failed to determine if the cert is a certificate authority. Assuming it is not.");
            }
        }
        logger.debug("isCertificateAuthority() - Certificate {} has signing key usage enabled: {}", (Object)x509Certificate.getSubjectX500Principal().getName(), (Object)bl);
        return bl;
    }

    public String getSubjectName(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        return x509Certificate.getSubjectX500Principal().getName("RFC2253", this.getExtensionOidMap());
    }

    public String getIssuerName(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        return x509Certificate.getIssuerX500Principal().getName("RFC2253", this.getExtensionOidMap());
    }

    private Map<String, String> getExtensionOidMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(BCStyle.EmailAddress.getId(), PKCS_9_EMAIL_ADDRESS);
        hashMap.put(BCStyle.E.getId(), VERISIGN_EMAIL_ADDRESS);
        return hashMap;
    }
}

