/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.trustmanagement.CertificateUtils;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CollectVCenterRootCert {
    private static final Logger logger = LogManager.getLogger(CollectVCenterRootCert.class);
    private static final String VALUE = "value";
    private static final String CHAIN = "chain";
    private static final String CERT_CHAIN = "cert_chain";
    private static final String PROTOCOL = "https";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String SESSION_ID_HEADER_KEY = "vmware-api-session-id";
    private static final String SESSION_ID_PATH_67 = "/rest/com/vmware/cis/session";
    private static final String CHAIN_ID_67 = "/rest/vcenter/certificate-management/vcenter/trusted-root-chains";
    private static final String ROOT_CERTIFICATE_PATH_67 = "/rest/vcenter/certificate-management/vcenter/trusted-root-chains/";
    private static final String SESSION_ID_PATH_70 = "/api/session";
    private static final String CHAIN_ID_70 = "/api/vcenter/certificate-management/vcenter/trusted-root-chains";
    private static final String ROOT_CERTIFICATE_PATH_70 = "/api/vcenter/certificate-management/vcenter/trusted-root-chains/";
    private String username = null;
    private String password = null;
    private String hostName = null;
    private ServiceManager serviceManager;
    private TrustStoreManager trustStoreManager;
    private UnverifiedCertificateManager unverifiedCertificateManager;
    private CertificateUtils certUtils = new CertificateUtils();

    public CollectVCenterRootCert(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        this.trustStoreManager = serviceManager.getTrustStoreManager();
        this.unverifiedCertificateManager = serviceManager.getUnverifiedCertificateManager();
    }

    public boolean getRootCert() {
        X509Certificate x509Certificate;
        JSONObject jSONObject;
        logger.debug("getRootCert() - start");
        String string = null;
        List<Object> list = new ArrayList();
        HashMap<String, List<X509Certificate>> hashMap = new HashMap<String, List<X509Certificate>>();
        this.getvCenterDetails();
        try {
            string = this.parseSessionIdFromResponse67(this.getSessionIdResponse(SESSION_ID_PATH_67));
            if (string == null) {
                throw new IllegalArgumentException("Unable to retrieve sessionId");
            }
            list = this.parseChainIds67(this.getChainId(CHAIN_ID_67, string));
            for (String string2 : list) {
                jSONObject = this.getRootCertificate(string, ROOT_CERTIFICATE_PATH_67, string2);
                x509Certificate = this.certUtils.generateCert(this.parseCertificateString67(jSONObject));
                if (x509Certificate == null) continue;
                hashMap.put(string2, List.of(x509Certificate));
            }
        }
        catch (Exception exception) {
            logger.error("getRootCert() - vCenter 6.7 API's failed to obtain root certificate");
        }
        if (!hashMap.isEmpty()) {
            logger.debug("getRootCert() - end, successfully found vCenter root Certificate using 6.7 API's");
            for (String string2 : hashMap.keySet()) {
                this.unverifiedCertificateManager.addCertificateChain(string2, (List)hashMap.get(string2));
            }
            return true;
        }
        try {
            logger.debug("getRootCert() - attempting to retrieve root certificate with 7.0 API's");
            string = this.parseSessionIdFromResponse70(this.getSessionIdResponse(SESSION_ID_PATH_70));
            if (string == null) {
                throw new IllegalArgumentException("Unable to retrieve sessionId");
            }
            list = this.parseChainIds70(this.getChainId(CHAIN_ID_70, string));
            for (String string3 : list) {
                jSONObject = this.getRootCertificate(string, ROOT_CERTIFICATE_PATH_70, string3);
                x509Certificate = this.certUtils.generateCert(this.parseCertificateString70(jSONObject));
                if (x509Certificate == null) continue;
                hashMap.put(string3, List.of(x509Certificate));
            }
        }
        catch (Exception exception) {
            logger.error("getRootCert() - vCenter 7.0 API's failed to obtain root certificate");
        }
        if (!hashMap.isEmpty()) {
            logger.debug("getRootCert() - end, successfully found vCenter root Certificate using 7.0 API's");
            for (String string4 : hashMap.keySet()) {
                this.unverifiedCertificateManager.addCertificateChain(string4, (List)hashMap.get(string4));
            }
            return true;
        }
        logger.debug("getRootCert() - end, failed to retrieve vCenter root Certificate");
        return false;
    }

    protected String getSessionIdResponse(String string) throws MalformedURLException, IOException {
        logger.debug("getSessionId() - start");
        HttpURLConnection httpURLConnection = null;
        String string2 = null;
        try {
            URL uRL = this.buildURL(this.hostName, string);
            httpURLConnection = this.setupHttpConnection(uRL, POST, null);
            String string3 = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
            httpURLConnection.setRequestProperty("Authorization", "Basic " + string3);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200 || httpURLConnection.getResponseCode() == 201) {
                string2 = this.getResponseFromConnection((HttpsURLConnection)httpURLConnection);
            } else {
                logger.error("getSessionId() - Response Message: {}, Code: {}", (Object)httpURLConnection.getResponseMessage(), (Object)httpURLConnection.getResponseCode());
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("getSessionId() - MalformedURLException: {}", (Throwable)malformedURLException);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            logger.error("getSessionId() - IOException: {}", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        logger.debug("getSessionId() - end");
        return string2;
    }

    protected String getChainId(String string, String string2) throws MalformedURLException, IOException {
        logger.debug("getChainId() - start");
        HttpURLConnection httpURLConnection = null;
        String string3 = null;
        try {
            URL uRL = this.buildURL(this.hostName, string);
            httpURLConnection = this.setupHttpConnection(uRL, GET, string2);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                string3 = this.getResponseFromConnection((HttpsURLConnection)httpURLConnection);
            } else {
                logger.error("getChainId() - Response Message: {}, Code: {}", (Object)httpURLConnection.getResponseMessage(), (Object)httpURLConnection.getResponseCode());
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("getChainId() - MalformedURLException: {}", (Throwable)malformedURLException);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            logger.error("getChainId() - IOException: {}", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        logger.debug("getChainId() - end");
        return string3;
    }

    protected JSONObject getRootCertificate(String string, String string2, String string3) throws MalformedURLException, IOException {
        logger.debug("getRootCertificate() - start");
        HttpURLConnection httpURLConnection = null;
        JSONObject jSONObject = null;
        try {
            String string4 = string2.concat(string3);
            URL uRL = this.buildURL(this.hostName, string4);
            httpURLConnection = this.setupHttpConnection(uRL, GET, string);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() == 200) {
                String string5 = this.getResponseFromConnection((HttpsURLConnection)httpURLConnection);
                jSONObject = new JSONObject(string5);
            } else {
                logger.error("getRootCertificate() - Response Message: {}, Code: {}", (Object)httpURLConnection.getResponseMessage(), (Object)httpURLConnection.getResponseCode());
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("getRootCertificate() - MalformedURLException: {}", (Throwable)malformedURLException);
            throw malformedURLException;
        }
        catch (IOException iOException) {
            logger.error("getRootCertificate() - IOException: {}", (Throwable)iOException);
            throw iOException;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        logger.debug("getRootCertificate() - end");
        return jSONObject;
    }

    protected String parseSessionIdFromResponse67(String string) {
        String string2 = null;
        JSONObject jSONObject = new JSONObject(string);
        string2 = jSONObject.getString(VALUE);
        return string2;
    }

    protected String parseSessionIdFromResponse70(String string) {
        String string2 = null;
        string2 = string.replaceAll("\"", "");
        return string2;
    }

    protected List<String> parseChainIds67(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONObject jSONObject = new JSONObject(string);
        JSONArray jSONArray = jSONObject.getJSONArray(VALUE);
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(jSONArray.getJSONObject(i).getString(CHAIN));
        }
        logger.debug("parseChainIds67() - Found chain IDs: {}", arrayList);
        return arrayList;
    }

    protected List<String> parseChainIds70(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            arrayList.add(jSONArray.getJSONObject(i).getString(CHAIN));
        }
        logger.debug("parseChainIds70() - Found chain IDs: {}", arrayList);
        return arrayList;
    }

    protected String parseCertificateString67(JSONObject jSONObject) {
        String string = null;
        JSONObject jSONObject2 = jSONObject.getJSONObject(VALUE);
        JSONObject jSONObject3 = jSONObject2.getJSONObject(CERT_CHAIN);
        JSONArray jSONArray = jSONObject3.getJSONArray(CERT_CHAIN);
        string = jSONArray.getString(0);
        return string;
    }

    protected String parseCertificateString70(JSONObject jSONObject) {
        String string = null;
        JSONObject jSONObject2 = jSONObject.getJSONObject(CERT_CHAIN);
        JSONArray jSONArray = jSONObject2.getJSONArray(CERT_CHAIN);
        string = jSONArray.getString(0);
        return string;
    }

    private void getvCenterDetails() {
        this.username = this.serviceManager.getAuthHelper().getVCenterUser();
        this.password = this.serviceManager.getAuthHelper().getVCenterPassword();
        this.hostName = this.serviceManager.getVirtualConfigurationManager().getServerIP();
    }

    private HttpsURLConnection setupHttpConnection(URL uRL, String string, String string2) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setReadTimeout(10000);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setUseCaches(false);
        httpsURLConnection.setSSLSocketFactory(this.trustStoreManager.makeSSLSocketFactory());
        httpsURLConnection.setRequestMethod(string);
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            httpsURLConnection.addRequestProperty(SESSION_ID_HEADER_KEY, string2);
        }
        return httpsURLConnection;
    }

    private String getResponseFromConnection(HttpsURLConnection httpsURLConnection) throws IOException {
        String string = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        inputStream = httpsURLConnection.getInputStream();
        inputStreamReader = new InputStreamReader(inputStream);
        bufferedReader = new BufferedReader(inputStreamReader);
        string = bufferedReader.readLine();
        inputStream.close();
        bufferedReader.close();
        inputStreamReader.close();
        return string;
    }

    private URL buildURL(String string, String string2) throws MalformedURLException {
        URL uRL = new URL(PROTOCOL, string, string2);
        logger.debug("buildURL() - url: {}", (Object)uRL);
        return uRL;
    }
}

