/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.pcns.trustmanagement.UntrustedCertificateException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SavingTrustManager
implements X509TrustManager {
    private static final Logger logger = LogManager.getLogger(SavingTrustManager.class);
    private X509TrustManager javaTrustManager;
    private X509TrustManager pcnsTrustManager;

    public SavingTrustManager(X509TrustManager x509TrustManager, X509TrustManager x509TrustManager2) {
        this.javaTrustManager = x509TrustManager;
        this.pcnsTrustManager = x509TrustManager2;
    }

    @Override
    public void checkClientTrusted(@NonNull X509Certificate[] x509CertificateArray, @NonNull String string) throws CertificateException {
        if (x509CertificateArray == null) {
            throw new IllegalArgumentException("chain is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("authType is marked non-null but is null");
        }
        if (x509CertificateArray.length == 0 || StringUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException();
        }
        logger.debug("checkClientTrusted() - Checking for client trust...");
        try {
            this.javaTrustManager.checkClientTrusted(x509CertificateArray, string);
            logger.debug("checkClientTrusted() - Certificate chain is trusted...");
        }
        catch (CertificateException certificateException) {
            logger.debug("checkClientTrusted() - Certificate chain is not trusted...", (Throwable)certificateException);
            throw certificateException;
        }
    }

    @Override
    public void checkServerTrusted(@NonNull X509Certificate[] x509CertificateArray, @NonNull String string) throws CertificateException {
        if (x509CertificateArray == null) {
            throw new IllegalArgumentException("chain is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("authType is marked non-null but is null");
        }
        if (x509CertificateArray.length == 0 || StringUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException();
        }
        logger.debug("checkServerTrusted() - Check Server Trusted, Chain: " + Arrays.toString(x509CertificateArray));
        logger.debug("checkServerTrusted() - Check Server Trusted, AuthType: " + string);
        try {
            this.javaTrustManager.checkServerTrusted(x509CertificateArray, string);
            logger.debug("checkServerTrusted() - Trust anchor found in Java cacerts...");
        }
        catch (CertificateException certificateException) {
            logger.debug("checkServerTrusted() - Trust anchor not found in Java cacerts: {}", (Object)certificateException.getMessage());
            logger.trace((Object)certificateException);
            try {
                if (this.pcnsTrustManager.getAcceptedIssuers().length == 0) {
                    logger.debug("checkServerTrusted() - PowerChute keystore has no trust material...");
                    throw new CertificateException("PCNS keystore has no certs");
                }
                this.pcnsTrustManager.checkServerTrusted(x509CertificateArray, string);
                logger.debug("checkServerTrusted() - Trust anchor found in PowerChute trust store...");
            }
            catch (CertificateException certificateException2) {
                logger.debug("checkServerTrusted() - Trust anchor not found in PowerChute trust store: {}", (Object)certificateException2.getMessage());
                logger.trace((Object)certificateException2);
                UntrustedCertificateException untrustedCertificateException = new UntrustedCertificateException(certificateException2);
                untrustedCertificateException.setChain(x509CertificateArray);
                throw untrustedCertificateException;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        logger.debug("getAcceptedIssuers() - start");
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.addAll(Arrays.asList(this.javaTrustManager.getAcceptedIssuers()));
        arrayList.addAll(Arrays.asList(this.pcnsTrustManager.getAcceptedIssuers()));
        X509Certificate[] x509CertificateArray = arrayList.toArray(new X509Certificate[0]);
        logger.debug("getAcceptedIssuers() - end. Issuer count: {}", (Object)x509CertificateArray.length);
        return x509CertificateArray;
    }
}

