/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.m11.components.stdpowersource.ResolvingHostnameVerifier;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.trustmanagement.CertificateUtils;
import com.apcc.pcns.trustmanagement.SavingTrustManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TrustStoreManager {
    public static final String kKeystoreDefault = "PowerChute-keystore";
    private static final String kJettyHome = "jetty.home";
    private static final String kKeystoreDirectory = "/etc/";
    private static final String kKeyStoreType = "JKS";
    private static final String kSecurityProvider = "SUN";
    private static final String kSecurityProviderALT = "IBMJCE";
    private static final String kBouncyCastleSecurityType = "BKS";
    public static final String VXRAIL_CERT_ALIAS = "vxrail";
    private static final Logger logger = LogManager.getLogger(TrustStoreManager.class);
    private File keystoreFile = null;
    private String keystorePath = "PowerChute-keystore";
    private SavingTrustManager theTrustManager = null;
    private AuthHelper authHelper;
    private ConfigurationManager configurationManager;

    public TrustStoreManager() {
        String string = System.getProperty(kJettyHome);
        logger.debug("TrustStoreManager() - Jetty Home defined as: {}", (Object)string);
        this.keystoreFile = string != null ? new File(string + kKeystoreDirectory + this.keystorePath) : new File(this.keystorePath);
        logger.info("TrustStoreManager() - Using Keystore file: " + this.keystoreFile.getAbsolutePath());
        HttpsURLConnection.setDefaultHostnameVerifier(new ResolvingHostnameVerifier());
    }

    public void initKeystore() {
        logger.debug("initKeystore() - start");
        try {
            String string = this.readPowerChuteKeystorePasswordFromINI(this.configurationManager);
            String string2 = this.authHelper.getTrustStorePassword();
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String string3 = string2;
                if (!StringUtils.equals((CharSequence)(string = string.trim()), (CharSequence)string3)) {
                    boolean bl;
                    boolean bl2 = bl = string.length() >= 6;
                    if (!bl) {
                        logger.error("initKeystore() - Keystore password should contain at least 6 characters.");
                    }
                    if (bl && this.updateKeystore(string)) {
                        logger.info("initKeystore() - Keystore password change successful");
                        this.authHelper.setTrustStorePassword(string);
                        this.configurationManager.clearProperty("NetworkManagementCard", "PowerChuteKeystorePassword");
                    } else {
                        logger.error("initKeystore() - Keystore password change failed - using old keystore password");
                        string2 = string3;
                    }
                } else {
                    logger.info("initKeystore() - Keystore password not changed - new password is same as existing password");
                    this.configurationManager.clearProperty("NetworkManagementCard", "KeystorePassword");
                }
            } else if (StringUtils.isNotBlank((CharSequence)string2)) {
                logger.info("initKeystore() - Using keystore password stored in m11.cfg");
            } else {
                this.recreateKeystore();
            }
        }
        catch (Exception exception) {
            logger.warn("initKeystore() - Unable to get keys from storage", (Throwable)exception);
        }
        logger.debug("initKeystore()- end");
    }

    private synchronized void recreateKeystore() {
        logger.debug("recreateKeystore() - start");
        if (this.keystoreFile.exists()) {
            try {
                logger.debug("recreateKeystore() - Deleting keystore file at: {}", (Object)this.keystoreFile.getAbsolutePath());
                Files.delete(this.keystoreFile.toPath());
            }
            catch (IOException iOException) {
                logger.warn("recreateKeystore() - Failed to delete keystore.", (Throwable)iOException);
            }
        }
        this.loadKeystore();
        logger.debug("recreateKeystore() - end");
    }

    private synchronized boolean updateKeystore(String string) {
        logger.debug("updateKeystore() - start");
        boolean bl = false;
        KeyStore keyStore = this.loadKeystore();
        if (keyStore != null) {
            try {
                logger.debug("updateKeystore() - Saving keystore with updated password.");
                this.saveKeystore(keyStore, string);
                bl = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                logger.error("updateKeystore() - Exception:", (Throwable)exception);
            }
        }
        logger.debug("updateKeystore() - end");
        return bl;
    }

    public boolean addCertificateToKeystore(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate is marked non-null but is null");
        }
        return this.addCertificateToKeystore(null, x509Certificate);
    }

    public synchronized boolean addCertificateToKeystore(String string, @NonNull X509Certificate x509Certificate) {
        Object object;
        if (x509Certificate == null) {
            throw new IllegalArgumentException("certificate is marked non-null but is null");
        }
        logger.debug("addCertificateToKeystore() - start.  Alias: {}, Certificate: {}", (Object)string, (Object)x509Certificate);
        boolean bl = false;
        if (StringUtils.isBlank((CharSequence)string)) {
            object = new CertificateUtils();
            string = ((CertificateUtils)object).getCertificateAlias(x509Certificate);
            logger.debug("addCertificateToKeystore() - updating alias to: {}", (Object)string);
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.warn("addCertificateToKeystore() - Can't add a certificate with a blank alias for certificate: {}", (Object)x509Certificate);
            return false;
        }
        try {
            object = this.loadKeystore();
            if (object != null) {
                ((KeyStore)object).setCertificateEntry(string, x509Certificate);
                this.saveKeystore((KeyStore)object, null);
                logger.debug("addCertificateToKeystore() - Saved Certificate to keystore with alias: {}", (Object)string);
                bl = true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            logger.error("addCertificateToKeystore() - KeyStoreException occurred while trying to process certificate: {} {}", (Object)x509Certificate, (Object)keyStoreException);
        }
        catch (IOException iOException) {
            logger.error("addCertificateToKeystore() - IOException occurred while trying to process certificate (Subject Info): {} {}", (Object)x509Certificate, (Object)iOException);
        }
        catch (CertificateException certificateException) {
            logger.error("addCertificateToKeystore() - CertificateException occurred while trying to process certificate (Subject Info): {} {}", (Object)x509Certificate, (Object)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.error("addCertificateToKeystore() - NoSuchAlgorithmException occurred while trying to process certificate (Subject Info): {} {}", (Object)x509Certificate, (Object)noSuchAlgorithmException);
        }
        logger.debug("addCertificateToKeystore() - end. Result: {}", (Object)bl);
        return bl;
    }

    public synchronized SSLSocketFactory makeSSLSocketFactory() {
        logger.debug("makeSSLSocketFactory() - start");
        SSLContext sSLContext = this.makeSSLContext();
        SSLSocketFactory sSLSocketFactory = null;
        sSLSocketFactory = sSLContext.getSocketFactory();
        logger.debug("makeSSLSocketFactory() - end. Result: {}", (Object)sSLSocketFactory);
        return sSLSocketFactory;
    }

    public synchronized SSLContext makeSSLContext() {
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("TLS");
            this.theTrustManager = this.makeSavingTrustManager();
            sSLContext.init(null, new TrustManager[]{this.theTrustManager}, null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            logger.error("makeSSLSocketFactory() - Exception when constructing SSLSocketFactory: ", (Throwable)generalSecurityException);
        }
        return sSLContext;
    }

    /*
     * WARNING - void declaration
     */
    public SavingTrustManager makeSavingTrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        void var5_8;
        logger.debug("makeSavingTrustManager() - start");
        logger.debug("makeSavingTrustManager() - get default trust manager");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        X509TrustManager x509TrustManager = null;
        TrustManager[] object = trustManagerFactory.getTrustManagers();
        int x509TrustManager2 = object.length;
        boolean object2 = false;
        while (var5_8 < x509TrustManager2) {
            TrustManager trustManager = object[var5_8];
            if (trustManager instanceof X509TrustManager) {
                x509TrustManager = (X509TrustManager)trustManager;
                break;
            }
            ++var5_8;
        }
        logger.debug("makeSavingTrustManager() - get PowerChute-keystore trust manager");
        trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = this.loadKeystore();
        trustManagerFactory.init(keyStore);
        X509TrustManager x509TrustManager3 = null;
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            x509TrustManager3 = (X509TrustManager)trustManager;
            break;
        }
        SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager, x509TrustManager3);
        logger.debug("makeSavingTrustManager() - end. Result: {}", (Object)savingTrustManager);
        return savingTrustManager;
    }

    public X509Certificate getCertificateFromKeystore(String string) {
        X509Certificate x509Certificate = null;
        if (string == null) {
            return x509Certificate;
        }
        KeyStore keyStore = this.loadKeystore();
        try {
            if (keyStore != null && keyStore.containsAlias(string)) {
                logger.debug("getCertificateFromKeystore() - alias found in keystore: {}", (Object)string);
                x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            }
        }
        catch (Exception exception) {
            logger.error("getCertificateFromKeystore() - Exception: {}", (Throwable)exception);
        }
        logger.debug("getCertificateFromKeystore() - Found certificate: {} for alias: {}", x509Certificate, (Object)string);
        return x509Certificate;
    }

    public Map<String, X509Certificate> getCertificatesFromKeystoreStartingWith(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix is marked non-null but is null");
        }
        HashMap<String, X509Certificate> hashMap = new HashMap<String, X509Certificate>();
        KeyStore keyStore = this.loadKeystore();
        if (keyStore != null) {
            try {
                for (String string2 : Collections.list(keyStore.aliases())) {
                    if (!StringUtils.startsWith((CharSequence)string2, (CharSequence)string)) continue;
                    logger.debug("getCertificatesFromKeystoreStartingWith() - adding alias: {}", (Object)string2);
                    hashMap.put(string2, (X509Certificate)keyStore.getCertificate(string2));
                }
            }
            catch (KeyStoreException keyStoreException) {
                logger.error("getCertificatesFromKeystoreStartingWith() - Exception: ", (Throwable)keyStoreException);
            }
        }
        Map map = Collections.unmodifiableMap(hashMap);
        logger.debug("getCertificatesFromKeystoreStartingWith() - Found {} certificates with aliases beginning with: {}", (Object)map.size(), (Object)string);
        return map;
    }

    public Optional<X509Certificate> getVxRailCertificate() {
        X509Certificate x509Certificate = this.getCertificateFromKeystore(VXRAIL_CERT_ALIAS);
        Optional<X509Certificate> optional = Optional.ofNullable(x509Certificate);
        logger.debug("getVxRailCertificate() - VxRail Certificate: {}", (Object)x509Certificate);
        return optional;
    }

    public boolean hasVxRailRootCert() {
        boolean bl = this.getVxRailCertificate().isPresent();
        logger.debug("hasVxRailRootCert() - A root certificate for VxRail is present: {}", (Object)bl);
        return bl;
    }

    private synchronized void createKeystore() {
        logger.debug("createKeystore() - start");
        KeyStore keyStore = null;
        boolean bl = false;
        String string = kSecurityProvider;
        String string2 = kKeyStoreType;
        do {
            Object object;
            bl = false;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.keystoreFile);){
                logger.debug("createKeystore() - File: {}, type: {}, provider:{}", (Object)this.keystoreFile, (Object)string2, (Object)string);
                keyStore = KeyStore.getInstance(string2, string);
                keyStore.load(null, null);
                object = this.authHelper.getPowerChuteKeystorePassword();
                keyStore.store(fileOutputStream, ((String)object).toCharArray());
                fileOutputStream.flush();
            }
            catch (KeyStoreException | NoSuchProviderException generalSecurityException) {
                logger.debug((Object)generalSecurityException);
                logger.warn("createKeystore() - No such provider or keystore type, trying alternative");
                if (string.equals(kSecurityProvider)) {
                    string = kSecurityProviderALT;
                    bl = true;
                    continue;
                }
                if (string.equals(kSecurityProviderALT)) {
                    object = new BouncyCastleProvider();
                    string = object.getName();
                    string2 = kBouncyCastleSecurityType;
                    try {
                        Security.addProvider((Provider)object);
                        bl = true;
                    }
                    catch (SecurityException securityException) {
                        logger.error("createKeystore() - No available Security Provider", (Throwable)securityException);
                    }
                    continue;
                }
                logger.error("createKeystore() - No available Security Provider", (Throwable)generalSecurityException);
            }
            catch (Exception exception) {
                logger.error("createKeystore() - tried to fix keystore error:", (Throwable)exception);
            }
        } while (bl);
    }

    private synchronized KeyStore loadKeystore() {
        logger.debug("loadKeystore() - start");
        KeyStore keyStore = null;
        String string = null;
        if (!this.keystoreFile.exists()) {
            logger.info("loadKeystore() - Keystore file not found. Creating a new keystore with a new password");
            string = this.authHelper.getRandomKey();
            this.authHelper.setTrustStorePassword(string);
            this.createKeystore();
        }
        boolean bl = false;
        String string2 = kSecurityProvider;
        String string3 = kKeyStoreType;
        do {
            bl = false;
            try (FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);){
                logger.debug("loadKeystore() - File: {}, type: {}, provider: {}", (Object)this.keystoreFile, (Object)kKeyStoreType, (Object)string2);
                keyStore = KeyStore.getInstance(string3, string2);
                string = this.authHelper.getTrustStorePassword();
                keyStore.load(fileInputStream, string.toCharArray());
            }
            catch (NoSuchAlgorithmException | CertificateException generalSecurityException) {
                logger.error((Object)generalSecurityException);
            }
            catch (KeyStoreException | NoSuchProviderException generalSecurityException) {
                logger.debug((Object)generalSecurityException);
                logger.warn("loadKeystore() - No such provider or keystore type, trying alternative");
                if (string2.equals(kSecurityProvider)) {
                    string2 = kSecurityProviderALT;
                    bl = true;
                    continue;
                }
                if (string2.equals(kSecurityProviderALT)) {
                    BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
                    string2 = bouncyCastleProvider.getName();
                    string3 = kBouncyCastleSecurityType;
                    try {
                        Security.addProvider((Provider)bouncyCastleProvider);
                        bl = true;
                    }
                    catch (SecurityException securityException) {
                        logger.error("loadKeystore() - No available Security Provider", (Throwable)generalSecurityException);
                    }
                    continue;
                }
                logger.error("loadKeystore() - No available Security Provider", (Throwable)generalSecurityException);
            }
            catch (IOException iOException) {
                if (iOException.getCause() instanceof UnrecoverableKeyException) {
                    logger.error("loadKeystore() - Password Error: {}", (Throwable)iOException);
                    continue;
                }
                logger.error((Object)iOException);
            }
        } while (bl);
        logger.debug("loadKeystore() - end: Keystore loaded: {}", (Object)(keyStore != null ? 1 : 0));
        return keyStore;
    }

    private synchronized void saveKeystore(KeyStore keyStore, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        logger.debug("saveKeystore() - start");
        String string2 = this.authHelper.getPowerChuteKeystorePassword();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            string2 = string;
        }
        logger.debug("saveKeystore() - Saving to file: {}", (Object)this.keystoreFile.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.keystoreFile);){
            keyStore.store(fileOutputStream, string2.toCharArray());
            fileOutputStream.flush();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            logger.warn("saveKeystore() - Exception while writing keystore...", (Throwable)exception);
            throw exception;
        }
        logger.debug("saveKeystore() - end");
    }

    private String readPowerChuteKeystorePasswordFromINI(ConfigurationManager configurationManager) {
        logger.debug("readPowerChuteKeystorePasswordFromINI() - start");
        String string = null;
        if (configurationManager != null && configurationManager.containsKey("NetworkManagementCard", "PowerChuteKeystorePassword")) {
            logger.debug("readPowerChuteKeystorePasswordFromINI() - Powerchute keystore password key contained in INI.");
            try {
                string = configurationManager.getString("NetworkManagementCard", "PowerChuteKeystorePassword");
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
        logger.debug("readPowerChuteKeystorePasswordFromINI() - Found keystore password: {}", (Object)StringUtils.isNotBlank(string));
        return string;
    }

    public boolean hasAnyCertificate(@NonNull List<? extends Certificate> list) {
        if (list == null) {
            throw new IllegalArgumentException("certificates is marked non-null but is null");
        }
        logger.debug("hasAnyCertificate() - start.  Checking cert chain: {}", list);
        KeyStore keyStore = this.loadKeystore();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            for (Certificate certificate : list) {
                while (enumeration.hasMoreElements()) {
                    Certificate certificate2;
                    String string = enumeration.nextElement();
                    if (!keyStore.containsAlias(string) || (certificate2 = keyStore.getCertificate(string)) == null || !certificate2.equals(certificate)) continue;
                    logger.debug("hasAnyCertificate() - Found a matching member: {}", (Object)certificate2);
                    return true;
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            logger.debug("hasAnyCertificate() - Error checking for certificates: {}", (Throwable)keyStoreException);
        }
        logger.debug("hasAnyCertificate() - No matching certificate found for chain: {}", list);
        return false;
    }

    @Generated
    public void setAuthHelper(AuthHelper authHelper) {
        this.authHelper = authHelper;
    }

    @Generated
    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

