/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.trustmanagement;

import com.apcc.pcns.trustmanagement.CertificateUtils;
import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UntrustedCertificateException;
import java.math.BigInteger;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnverifiedCertificateManager {
    private static final String IN_VALIDITY_PERIOD = "inValidityPeriod";
    private static final Logger logger = LogManager.getLogger(UnverifiedCertificateManager.class);
    private Map<String, List<X509Certificate>> untrustedCertificatesStore;
    private CertificateUtils certUtils = new CertificateUtils();
    private TrustStoreManager trustStoreManager;

    public UnverifiedCertificateManager() {
        this.untrustedCertificatesStore = new HashMap<String, List<X509Certificate>>();
    }

    public void addCertificateChain(@NonNull String string, @NonNull List<X509Certificate> list) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't set a blank alias");
        }
        if (!this.trustStoreManager.hasAnyCertificate(list)) {
            logger.debug("Setting Untrusted Cert for {}", (Object)string);
            this.untrustedCertificatesStore.put(string, list);
        }
    }

    public boolean addCertificateChainByException(@NonNull String string, @NonNull Throwable throwable) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (throwable == null) {
            throw new IllegalArgumentException("cause is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank alias");
        }
        boolean bl = false;
        HashSet<Throwable> hashSet = new HashSet<Throwable>();
        while (throwable != null && !hashSet.contains(throwable)) {
            hashSet.add(throwable);
            if (throwable instanceof UntrustedCertificateException) {
                UntrustedCertificateException untrustedCertificateException = (UntrustedCertificateException)throwable;
                this.addCertificateChain(string, Arrays.asList(untrustedCertificateException.getChain()));
                bl = true;
                break;
            }
            throwable = throwable.getCause();
        }
        return bl;
    }

    public List<X509Certificate> getCertificateChainByAlias(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank alias");
        }
        List<X509Certificate> list = this.untrustedCertificatesStore.get(string);
        List<X509Certificate> list2 = null;
        if (list != null) {
            list2 = Collections.unmodifiableList(list);
        }
        logger.debug("getCertificateChainByAlias() - Alias: {}, Chain: {}", (Object)string, list2);
        return list2;
    }

    public HashMap<String, HashMap<String, Boolean>> validateCertificateChain(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        List<X509Certificate> list = this.getCertificateChainByAlias(string);
        HashMap<String, HashMap<String, Boolean>> hashMap = new HashMap<String, HashMap<String, Boolean>>();
        list.forEach(x509Certificate -> {
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            String string = this.certUtils.getCommonNameOrThumbprint((X509Certificate)x509Certificate);
            try {
                x509Certificate.checkValidity();
                logger.debug("validateCertificateChain() - certificate {} is valid", (Object)string);
                hashMap2.put(IN_VALIDITY_PERIOD, true);
            }
            catch (CertificateExpiredException | CertificateNotYetValidException certificateException) {
                hashMap2.put(IN_VALIDITY_PERIOD, false);
                logger.debug("validateCertificateChain() - certificate {} is not currently valid", (Object)string);
            }
            hashMap.put(string, hashMap2);
        });
        return hashMap;
    }

    public Map<String, List<X509Certificate>> getAllCertificateChains() {
        Map<String, List<X509Certificate>> map = Collections.unmodifiableMap(this.untrustedCertificatesStore);
        logger.debug("getAllCertificateChains() - Chains: {}", map);
        return map;
    }

    public boolean removeCertificateChainByAlias(@NonNull String string) {
        boolean bl;
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank alias");
        }
        logger.debug("removeCertificateChainByAlias() - Received request to deleted Untrusted Agent Certificate with alias '{}'.", (Object)string);
        List<X509Certificate> list = this.untrustedCertificatesStore.remove(string);
        boolean bl2 = bl = list != null;
        if (bl) {
            logger.debug("removeCertificateChainByAlias() - Successfully deleted Untrusted Agent Certificate with alias '{}'.", (Object)string);
        }
        return bl;
    }

    public void removeAllCertificateChains() {
        logger.debug("removeAllCertificateChains() - Removing all content from unverified cache.");
        this.untrustedCertificatesStore.clear();
    }

    public boolean hasAlias(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank alias");
        }
        boolean bl = this.untrustedCertificatesStore.containsKey(string);
        logger.debug("hasAlias() - Alias: {}, Result: {}", (Object)string, (Object)bl);
        return bl;
    }

    public boolean hasCertificate(@NonNull String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("Can't use a blank alias");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Index must be a positive integer");
        }
        List<X509Certificate> list = this.untrustedCertificatesStore.get(string);
        boolean bl = list != null && list.size() > n;
        logger.debug("hasCertificate() - Alias: {}, Index: {}, Result:{}", (Object)string, (Object)n, (Object)bl);
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = this.untrustedCertificatesStore.isEmpty();
        logger.debug("isEmpty() - {}", (Object)bl);
        return bl;
    }

    public X509Certificate getCertificateByAliasAndIndex(@NonNull String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (!this.hasCertificate(string, n)) {
            throw new IllegalArgumentException("No certificate at given coordinates");
        }
        X509Certificate x509Certificate = null;
        List<X509Certificate> list = this.getCertificateChainByAlias(string);
        if (list != null) {
            x509Certificate = list.get(n);
        }
        logger.debug("getCertificateByAliasAndIndex() - Alias: {}, Index: {}, Certificate: {}", (Object)string, (Object)n, (Object)x509Certificate);
        return x509Certificate;
    }

    public void moveCertToTrustStore(@NonNull String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("alias is marked non-null but is null");
        }
        if (!this.hasCertificate(string, n)) {
            throw new IllegalArgumentException("No certificate at given coordinates");
        }
        logger.debug("moveCertToTrustStore() - Alias: {}, Index:{}", (Object)string, (Object)n);
        X509Certificate x509Certificate = this.getCertificateByAliasAndIndex(string, n);
        if (StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"vxrail")) {
            this.moveVxRailRooCertToTrustStore(x509Certificate);
        } else {
            logger.debug("moveCertToTrustStore() - Move cert to trust store: {}", (Object)x509Certificate);
            this.trustStoreManager.addCertificateToKeystore(x509Certificate);
        }
    }

    public void moveVxRailRooCertToTrustStore(@NonNull X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        if (this.certUtils.isCertificateAuthority(x509Certificate) || this.certUtils.isSelfSigned(x509Certificate)) {
            this.trustStoreManager.addCertificateToKeystore("vxrail", x509Certificate);
        } else {
            this.trustStoreManager.addCertificateToKeystore(x509Certificate);
        }
    }

    public void removeCertificateChainsBySerialNumber(@NonNull BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("serialNumber is marked non-null but is null");
        }
        logger.debug("removeCertificateChainsBySerialNumber() - Serial Number: {}", (Object)bigInteger);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.untrustedCertificatesStore.keySet()) {
            List<X509Certificate> list = this.untrustedCertificatesStore.get(string);
            Optional<X509Certificate> optional = list.stream().filter(x509Certificate -> x509Certificate.getSerialNumber().equals(bigInteger)).findFirst();
            if (!optional.isPresent()) continue;
            arrayList.add(string);
        }
        logger.debug("removeCertificateChainsBySerialNumber() - Found these chains: {}", arrayList);
        for (String string : arrayList) {
            this.untrustedCertificatesStore.remove(string);
        }
        logger.debug("removeCertificateChainsBySerialNumber() - Remaining aliases: {}", this.untrustedCertificatesStore.keySet());
    }

    @Generated
    public void setTrustStoreManager(TrustStoreManager trustStoreManager) {
        this.trustStoreManager = trustStoreManager;
    }
}

