/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;

public class CountdownTimer {
    private long targetTime;
    private long duration;
    private TimeUnit timeUnit;
    private ReentrantReadWriteLock lock;

    public static CountdownTimer seconds(long l) {
        return new CountdownTimer(l, TimeUnit.SECONDS);
    }

    public static CountdownTimer minutes(long l) {
        return new CountdownTimer(l, TimeUnit.MINUTES);
    }

    public CountdownTimer(long l, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("timeUnit is marked non-null but is null");
        }
        this.duration = l;
        this.timeUnit = timeUnit;
        this.lock = new ReentrantReadWriteLock();
        this.reset();
    }

    public CountdownTimer(long l) {
        this(l, TimeUnit.SECONDS);
    }

    public void reset() {
        this.lock.writeLock().lock();
        try {
            this.targetTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(this.duration, this.timeUnit);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean hasElapsed() {
        this.lock.readLock().lock();
        try {
            boolean bl = System.currentTimeMillis() > this.targetTime;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void sleep() {
        while (!this.hasElapsed()) {
            try {
                long l = this.getTimeRemaining();
                long l2 = Math.max(100L, l / 2L);
                TimeUnit.MILLISECONDS.sleep(l2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void interruptableSleep() throws InterruptedException {
        TimeUnit.MILLISECONDS.sleep(this.getTimeRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(@NonNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("monitor is marked non-null but is null");
        }
        Object object2 = object;
        synchronized (object2) {
            while (!this.hasElapsed()) {
                try {
                    long l = this.getTimeRemaining();
                    long l2 = Math.max(500L, l / 2L);
                    object.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptableAwait(@NonNull Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException("monitor is marked non-null but is null");
        }
        Object object2 = object;
        synchronized (object2) {
            while (!this.hasElapsed()) {
                long l = this.getTimeRemaining();
                long l2 = Math.max(500L, l / 2L);
                object.wait(l2);
            }
        }
    }

    private long getTimeRemaining() {
        this.lock.readLock().lock();
        try {
            long l = this.targetTime - System.currentTimeMillis();
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

