/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DateTimeFormatUtils {
    private static final Logger theLogger = LogManager.getLogger(DateTimeFormatUtils.class);
    public static final String DATE_SEPARATOR_SLASH = "/";
    public static final String DATE_SEPARATOR_DASH = "-";
    public static final String DATE_SEPARATOR_DOT = ".";
    private static final String DEFAULT_TABLE_TIME_PATTERN = "HH:mm:ss";
    private static final String DEFAULT_TABLE_DATE_PATTERN = "MM/dd/yyy";
    private static final String DEFAULT_TABLE_YEAR_PATTERN = "yyyy";
    private static final String DEFAULT_TABLE_MONTH_PATTERN = "MM";
    private static final String DEFAULT_TABLE_DAY_PATTERN = "dd";
    private static final String YEAR_TOKEN = "Y";
    private static final String MONTH_TOKEN = "M";
    private static final String DAY_TOKEN = "D";
    private String theDateSeparator = this.getDateSeparator();
    private String theDateFormatPattern = this.getDateFormatPattern();

    protected DateTimeFormatUtils() {
    }

    public String formatTableTime(Date date) {
        String string = "";
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_TABLE_TIME_PATTERN);
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    public String formatTableDate(Date date) {
        String string = "";
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.theDateFormatPattern);
            string = simpleDateFormat.format(date);
        }
        return string;
    }

    public String dateToISOString(@NonNull Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date is marked non-null but is null");
        }
        return DateTimeFormatter.ISO_INSTANT.format(date.toInstant());
    }

    private String getTableDatePatternPart(String string) {
        String string2 = null;
        if (string.startsWith(DAY_TOKEN)) {
            string2 = DEFAULT_TABLE_DAY_PATTERN;
        } else if (string.startsWith(MONTH_TOKEN)) {
            string2 = DEFAULT_TABLE_MONTH_PATTERN;
        } else if (string.startsWith(YEAR_TOKEN)) {
            string2 = DEFAULT_TABLE_YEAR_PATTERN;
        }
        return string2;
    }

    private String getDateSeparator() {
        String string = DATE_SEPARATOR_SLASH;
        String string2 = new SimpleDateFormat().toPattern();
        Matcher matcher = Pattern.compile("[^\\w]").matcher(string2);
        if (matcher.find() && !(string = matcher.group(0)).equals(DATE_SEPARATOR_SLASH) && !string.equals(DATE_SEPARATOR_DASH) && !string.equals(DATE_SEPARATOR_DOT)) {
            string = DATE_SEPARATOR_SLASH;
        }
        theLogger.info("Country=" + Locale.getDefault().getDisplayCountry(Locale.ENGLISH) + " language=" + Locale.getDefault().getDisplayLanguage(Locale.ENGLISH) + " date separator=" + this.theDateSeparator);
        return string;
    }

    private String getDateFormatPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        String[] stringArray = simpleDateFormat.toPattern().split(Pattern.quote(this.theDateSeparator));
        if (stringArray.length >= 3) {
            String string = this.getTableDatePatternPart(stringArray[0].trim().toUpperCase());
            String string2 = this.getTableDatePatternPart(stringArray[1].trim().toUpperCase());
            String string3 = this.getTableDatePatternPart(stringArray[2].trim().toUpperCase());
            if (string == null || string2 == null || string3 == null) {
                stringBuffer.append(DEFAULT_TABLE_DATE_PATTERN);
            } else {
                stringBuffer.append(string);
                stringBuffer.append(this.theDateSeparator);
                stringBuffer.append(string2);
                stringBuffer.append(this.theDateSeparator);
                stringBuffer.append(string3);
            }
        } else {
            stringBuffer.append(DEFAULT_TABLE_DATE_PATTERN);
        }
        return stringBuffer.toString();
    }
}

