/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import lombok.NonNull;

public class FileUtils {
    public void copyFile(@NonNull File file, @NonNull File file2) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("in is marked non-null but is null");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("out is marked non-null but is null");
        }
        Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFile(@NonNull String string, @NonNull String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("inPath is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("outPath is marked non-null but is null");
        }
        this.copyFile(new File(string), new File(string2));
    }

    public boolean setReadable(@NonNull String string, boolean bl, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException("filePath is marked non-null but is null");
        }
        File file = new File(string);
        return file.setReadable(bl, bl2);
    }

    public boolean isReadable(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists() && file.canRead() && !file.isDirectory();
        }
        return bl;
    }

    public boolean isExecutable(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = !file.isDirectory() && file.canExecute();
        }
        return bl;
    }
}

