/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostNameLookUpTable {
    private static final Logger logger = LogManager.getLogger(HostNameLookUpTable.class);
    private static HostNameLookUpTable theInstance = null;
    private Hashtable<String, String> lookUpTable = new Hashtable();

    protected HostNameLookUpTable() {
    }

    public static synchronized HostNameLookUpTable getInstance() {
        if (theInstance == null) {
            theInstance = new HostNameLookUpTable();
        }
        return theInstance;
    }

    public String lookUp(InetAddress inetAddress) {
        String string;
        String string2 = null;
        if (inetAddress != null && (string2 = this.lookUpTable.get(string = inetAddress.getHostAddress())) == null) {
            string2 = this.getHostName(inetAddress, string);
            this.lookUpTable.put(string, string2);
        }
        return string2;
    }

    public String lookUp(String string) {
        String string2 = null;
        if (string != null && (string2 = this.lookUpTable.get(string)) == null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                String string3 = inetAddress.getHostAddress();
                string2 = this.getHostName(inetAddress, string3);
            }
            catch (UnknownHostException unknownHostException) {
                logger.warn("Unable to resolve hostname, using IP: " + string);
            }
        }
        return string2;
    }

    public synchronized void cleanLookUpTable() {
        this.lookUpTable = new Hashtable();
    }

    private String getHostName(InetAddress inetAddress, String string) {
        String string2;
        int n;
        String string3 = null;
        string3 = inetAddress.getHostName();
        if (!(string.equalsIgnoreCase(string3) || (n = string3.indexOf(".")) >= 0 || string3.equalsIgnoreCase(string2 = inetAddress.getCanonicalHostName()) || string.equalsIgnoreCase(string2))) {
            string3 = string2;
        }
        this.lookUpTable.put(string, string3);
        return string3;
    }
}

