/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import com.apcc.pcns.configservice.validation.StringSetValidator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IPUtils {
    private static final Logger logger = LogManager.getLogger(IPUtils.class);

    public static InetAddress getLoopbackAddress() {
        InetAddress inetAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration2.nextElement();
                    if (!inetAddress2.isLoopbackAddress() || !(inetAddress2 instanceof Inet4Address)) continue;
                    inetAddress = inetAddress2;
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        logger.debug("getLoopbackAddress() - returning " + String.valueOf(inetAddress != null ? inetAddress.getHostAddress() : inetAddress));
        return inetAddress;
    }

    public static InetAddress getIPv6LoopbackAddress() {
        InetAddress inetAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration2.nextElement();
                    if (!inetAddress2.isLoopbackAddress() || !(inetAddress2 instanceof Inet6Address)) continue;
                    inetAddress = inetAddress2;
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        return inetAddress;
    }

    public static boolean isValidAddress(String string) {
        logger.debug("Checking if " + string + " is a valid localhost address.");
        boolean bl = false;
        if (string != null && !string.trim().isEmpty()) {
            string = string.trim();
            Set<InetAddress> set = IPUtils.getLocalhostAddresses();
            for (InetAddress inetAddress : set) {
                String string2 = inetAddress.getHostAddress();
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                    logger.debug(string + " matches " + string2);
                    break;
                }
                logger.debug(string + " does not match " + string2);
            }
        }
        if (bl) {
            logger.debug(string + " is a valid localhost address.");
        } else {
            logger.debug(string + " is not a valid localhost address.");
        }
        return bl;
    }

    public static boolean isValidIpv6Address(String string) {
        logger.debug("Checking if " + string + " is a valid localhost address.");
        boolean bl = false;
        if (string != null && !string.trim().isEmpty()) {
            string = string.trim();
            Set<InetAddress> set = IPUtils.getLocalhostIPv6Addresses();
            for (InetAddress inetAddress : set) {
                String string2 = inetAddress.getHostAddress();
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                    logger.debug(string + " matches " + string2);
                    break;
                }
                logger.debug(string + " does not match " + string2);
            }
        }
        if (bl) {
            logger.debug(string + " is a valid localhost address.");
        } else {
            logger.debug(string + " is not a valid localhost address.");
        }
        return bl;
    }

    public static InetAddress getLocalhostAddress() {
        Set<InetAddress> set = IPUtils.getLocalhostAddresses();
        InetAddress inetAddress = null;
        inetAddress = set.isEmpty() ? IPUtils.getLoopbackAddress() : (InetAddress)set.toArray()[0];
        String string = inetAddress != null ? inetAddress.getHostAddress() : "null";
        logger.debug("getLocalhostAddress() - returning {}", (Object)string);
        return inetAddress;
    }

    public static InetAddress getLocalIPv6hostAddress() {
        Set<InetAddress> set = IPUtils.getLocalhostIPv6Addresses();
        InetAddress inetAddress = null;
        inetAddress = set.isEmpty() ? IPUtils.getIPv6LoopbackAddress() : (InetAddress)set.toArray()[0];
        return inetAddress;
    }

    public static InetAddress getBroadcastAddress(InetAddress inetAddress) {
        InetAddress inetAddress2 = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    InetAddress inetAddress3 = interfaceAddress.getAddress();
                    if (!inetAddress3.equals(inetAddress)) continue;
                    inetAddress2 = interfaceAddress.getBroadcast();
                    continue block2;
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        return inetAddress2;
    }

    public static Set<InetAddress> getLocalhostAddresses() {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    logger.debug("Adding " + inetAddress.getHostAddress() + " to ip set.");
                    hashSet.add(inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        return hashSet;
    }

    public static Set<InetAddress> getLocalhostIPv6Addresses() {
        HashSet<InetAddress> hashSet = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    Object object;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet6Address)) continue;
                    logger.debug("Adding " + inetAddress.getHostAddress() + " to ip set.");
                    String string = inetAddress.getHostAddress();
                    if (string.contains("%")) {
                        object = new StringTokenizer(string, "%");
                        string = ((StringTokenizer)object).nextToken();
                    }
                    try {
                        object = IPUtils.getCompressedAddress(string);
                        hashSet.add(InetAddress.getByName((String)object));
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.error((Object)unknownHostException);
                    }
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        return hashSet;
    }

    public static int getLocalhostAddressCount() {
        int n = IPUtils.getLocalhostAddresses().size();
        logger.debug("getLocalhostAddressCount() - returning " + n);
        return n;
    }

    public static int getLocalhostIPv6AddressCount() {
        int n = IPUtils.getLocalhostIPv6Addresses().size();
        logger.debug("getLocalhostAddressCount() - returning " + n);
        return n;
    }

    public static StringSetValidator getLocalhostValidator() {
        StringSetValidator stringSetValidator = new StringSetValidator();
        Set<InetAddress> set = IPUtils.getLocalhostAddresses();
        for (InetAddress inetAddress : set) {
            stringSetValidator.add(inetAddress.getHostAddress());
        }
        return stringSetValidator;
    }

    public static StringSetValidator getLocalhostIPv6Validator() {
        StringSetValidator stringSetValidator = new StringSetValidator();
        Set<InetAddress> set = IPUtils.getLocalhostIPv6Addresses();
        for (InetAddress inetAddress : set) {
            String string = inetAddress.getHostAddress();
            if (string.contains("%")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "%");
                string = stringTokenizer.nextToken();
            }
            try {
                stringSetValidator.add(IPUtils.getCompressedAddress(string));
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException);
            }
        }
        return stringSetValidator;
    }

    public static String getCompressedAddress(String string) throws UnknownHostException {
        string = InetAddress.getByName(string).getHostAddress();
        return string.replaceFirst("(^|:)(0+(:|$)){2,8}", "::");
    }

    public static boolean isValidIPAddress(String string) {
        boolean bl = false;
        String string2 = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
        if (string != null) {
            if (string.matches(string2)) {
                bl = true;
            } else if (string.contains(":") && !string.contains(".")) {
                bl = true;
            }
        }
        return bl;
    }

    public static String getCurrentAddress(Boolean bl) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || (bl.booleanValue() || !(inetAddress instanceof Inet4Address)) && (!bl.booleanValue() || !(inetAddress instanceof Inet6Address))) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        return null;
    }

    public static boolean isLocalhostAddress(@NonNull InetAddress inetAddress) {
        if (inetAddress == null) {
            throw new IllegalArgumentException("addr is marked non-null but is null");
        }
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException socketException) {
            logger.debug("isLocalhostAddress() - Socket Exception {}", (Throwable)socketException);
            return false;
        }
    }
}

