/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OSVersionInfo {
    private static final Logger logger = LogManager.getLogger(OSVersionInfo.class);
    private String name;
    private String version;
    private String edition;
    private static OSVersionInfo instance = null;

    protected OSVersionInfo(String string, String string2, String string3) {
        this.name = string;
        this.edition = string2;
        this.version = string3;
    }

    public static OSVersionInfo getOSVersionInfo() {
        Object object;
        if (instance != null) {
            return instance;
        }
        logger.debug("OSVersionInfo");
        String string2 = SystemUtils.OS_NAME;
        String string3 = "";
        String string4 = SystemUtils.OS_VERSION;
        if (SystemUtils.IS_OS_WINDOWS) {
            string2 = "Windows";
            logger.debug("OSVersionInfo: is windows");
            String string5 = "";
            try {
                String[] stringArray2 = new String[]{"cmd", "/c", "chcp 437 & SYSTEMINFO "};
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
                Process process = processBuilder.start();
                InputStream inputStream = process.getInputStream();
                object = new BufferedReader(new InputStreamReader(inputStream));
                for (int i = 0; i < 6 && (string5 = ((BufferedReader)object).readLine()) != null; ++i) {
                    logger.debug("OSVersionInfo: line:" + string5);
                    if (!string5.startsWith("OS Name:")) continue;
                    string3 = string5.substring(string5.lastIndexOf("OS Name:") + "OS Name:".length(), string5.length());
                }
            }
            catch (Exception exception) {
                logger.info("Unable to get windows OS version, using system.properties:", (Throwable)exception);
            }
        }
        if (SystemUtils.IS_OS_LINUX) {
            logger.debug("getting Linux Version Info");
            Path path = Paths.get("/etc/os-release", new String[0]);
            if (Files.isReadable(path)) {
                try (Stream<String> stream = Files.lines(path);){
                    object = stream.map(string -> string.split("=")).filter(stringArray -> ((String[])stringArray).length == 2).collect(Collectors.toMap(stringArray -> stringArray[0].toUpperCase(), stringArray -> stringArray[1].replaceAll("\"", "")));
                    logger.debug("data:" + String.valueOf(object));
                    if (object.containsKey("ID")) {
                        string3 = object.get("ID");
                    }
                    if (object.containsKey("VERSION_ID")) {
                        string4 = (String)object.get("VERSION_ID");
                    }
                }
                catch (IOException iOException) {
                    logger.debug("Unable to read os-release, using system.properties:", (Throwable)iOException);
                }
                catch (Exception exception) {
                    logger.info("Unable to get linux OS version, using system.properties:", (Throwable)exception);
                }
            } else {
                logger.debug("Unable to read from os-release.  File does not exist or is not readable.");
            }
        }
        instance = new OSVersionInfo(string2.trim(), string3.trim(), string4.trim());
        logger.debug("OSVersionInfo done:" + string2.trim() + string3.trim() + " " + string4.trim());
        return instance;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getEdition() {
        return this.edition;
    }
}

