/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import com.apcc.pcns.util.RetryException;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RetryCommand<T> {
    private static final Logger logger = LogManager.getLogger(RetryCommand.class);
    private int maxRetries;

    public RetryCommand(int n) {
        this.maxRetries = n;
    }

    public T execute(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (RetryException retryException) {
            return this.retry(supplier);
        }
    }

    private T retry(Supplier<T> supplier) {
        int n = 0;
        while (n < this.maxRetries) {
            try {
                return supplier.get();
            }
            catch (RetryException retryException) {
                logger.debug("Command failed with error {}", (Object)retryException.getMessage());
                if (++n < this.maxRetries) continue;
                throw retryException;
            }
        }
        return null;
    }
}

