/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.pcns.ServiceManager;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShutdownLogger {
    private final Set<ShutdownEntry> shutdownReasons = new HashSet<ShutdownEntry>();
    private static final Logger logger = LogManager.getLogger(ShutdownLogger.class);

    public void logShutdownReason(String string, int n) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            logger.debug("host: {} shutdownEventCode: {}", (Object)string, (Object)n);
            String string2 = inetAddress.getHostAddress() != null ? inetAddress.getHostAddress().toString() : string;
            this.shutdownReasons.add(new ShutdownEntry(string2, n));
        }
        catch (Exception exception) {
            logger.error("Error logging the host {} to eventlog: {}", (Object)string, (Object)exception.getMessage());
        }
    }

    public void printShutdownReasons() {
        if (this.shutdownReasons.isEmpty()) {
            logger.debug("No shutdown reasons logged.");
        } else {
            logger.debug("Shutdown Reasons:");
            for (ShutdownEntry shutdownEntry : this.shutdownReasons) {
                logger.debug("Log shutdown: {} -> {}", (Object)shutdownEntry.shutdownEventCode, (Object)shutdownEntry.hostname);
            }
        }
    }

    public void sendShutdownReasonsToEventLog() {
        try {
            for (ShutdownEntry shutdownEntry : this.shutdownReasons) {
                logger.debug("sendShutdownReasonsToEventLog() - target host shutdown failed for host: {}", (Object)shutdownEntry.hostname);
                String string = new VirtualizationFeaturesFormatter((Integer)shutdownEntry.shutdownEventCode, shutdownEntry.hostname).format(null);
                ServiceManager.getInstance().getApplicationErrorHandler().put(string);
            }
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("sendShutdownReasonsToEventLog() - error logging event", throwable);
        }
    }

    public void sendSingleEventToEventLog(String string, int n) {
        try {
            logger.debug("sendSingleEventToEventLog() - target host shutdown failed for host: {}", (Object)string);
            String string2 = new VirtualizationFeaturesFormatter((Integer)n, string).format(null);
            ServiceManager.getInstance().getApplicationErrorHandler().put(string2);
        }
        catch (FormatterException | UnsupportedLocaleException throwable) {
            logger.error("sendSingleEventToEventLog() - error logging event", throwable);
        }
    }

    public boolean findAndRemoveLogsByHostname(String string) {
        List<ShutdownEntry> list = this.shutdownReasons.stream().filter(shutdownEntry -> shutdownEntry.hostname.equals(string)).toList();
        list.forEach(shutdownEntry -> {
            logger.debug("{} -> {}", (Object)shutdownEntry.shutdownEventCode, (Object)shutdownEntry.hostname);
            this.sendSingleEventToEventLog(shutdownEntry.hostname, shutdownEntry.shutdownEventCode);
            logger.debug("Retrieved and removing: {} -> {}", (Object)shutdownEntry.shutdownEventCode, (Object)shutdownEntry.hostname);
        });
        boolean bl = !list.isEmpty();
        this.shutdownReasons.removeAll(list);
        return bl;
    }

    public void clearShutdownReasons() {
        this.shutdownReasons.clear();
    }

    private static class ShutdownEntry {
        private final String hostname;
        private final int shutdownEventCode;

        public ShutdownEntry(String string, int n) {
            this.hostname = string;
            this.shutdownEventCode = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ShutdownEntry shutdownEntry = (ShutdownEntry)object;
            return this.shutdownEventCode == shutdownEntry.shutdownEventCode && Objects.equals(this.hostname, shutdownEntry.hostname);
        }

        public int hashCode() {
            return Objects.hash(this.hostname, this.shutdownEventCode);
        }
    }
}

