/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.util;

import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UTF8ResourceBundle {
    private static final Logger logger = LogManager.getLogger(UTF8ResourceBundle.class);
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final ResourceBundle.Control UTF8_CONTROL = new UTF8Control();

    public static final ResourceBundleWrapper getBundle(String string, Locale locale) {
        logger.trace("getBundle baseName=" + string + " targetLocale=" + String.valueOf(locale));
        return new ResourceBundleWrapper(ResourceBundle.getBundle(string, locale, UTF8_CONTROL), string);
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            logger.debug("newBundle baseName=" + string + " locale=" + String.valueOf(locale) + " format=" + string2);
            String string3 = this.toBundleName(string, locale);
            PropertyResourceBundle propertyResourceBundle = null;
            if (string2.equals("java.class")) {
                super.newBundle(string, locale, string2, classLoader, bl);
            } else if (string2.equals("java.properties")) {
                final String string4 = this.toResourceName(string3, "properties");
                if (string4 == null) {
                    return propertyResourceBundle;
                }
                final ClassLoader classLoader2 = classLoader;
                final boolean bl2 = bl;
                InputStream inputStream = null;
                InputStreamReader inputStreamReader = null;
                try {
                    inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            InputStream inputStream = null;
                            if (bl2) {
                                URLConnection uRLConnection;
                                URL uRL = classLoader2.getResource(string4);
                                if (uRL != null && (uRLConnection = uRL.openConnection()) != null) {
                                    uRLConnection.setUseCaches(false);
                                    inputStream = uRLConnection.getInputStream();
                                }
                            } else {
                                inputStream = classLoader2.getResourceAsStream(string4);
                            }
                            return inputStream;
                        }
                    });
                    if (inputStream != null) {
                        inputStreamReader = new InputStreamReader(inputStream, UTF8ResourceBundle.ENCODING_UTF8);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
                if (inputStreamReader != null) {
                    try {
                        propertyResourceBundle = new PropertyResourceBundle(inputStreamReader);
                    }
                    finally {
                        inputStreamReader.close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown format: " + string2);
            }
            return propertyResourceBundle;
        }
    }
}

