/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vsan;

import com.apcc.pcns.sshservice.SshService;
import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.vsan.VsanHostConnection;
import com.apcc.pcns.vsan.VsanHostDetails;
import com.apcc.pcns.vsan.VsanHostSshConnection;
import java.io.IOException;
import lombok.NonNull;

public class VsanHostConnectionManager {
    private SshService sshService;

    public VsanHostConnectionManager(@NonNull SshService sshService) {
        if (sshService == null) {
            throw new IllegalArgumentException("sshService is marked non-null but is null");
        }
        this.sshService = sshService;
    }

    public VsanHostConnection createConnection(@NonNull VsanHostDetails vsanHostDetails) throws IOException {
        if (vsanHostDetails == null) {
            throw new IllegalArgumentException("hostInfo is marked non-null but is null");
        }
        SshSession.SshConnectionConfig sshConnectionConfig = vsanHostDetails.toSshConnectionConfig();
        SshSession sshSession = this.sshService.getSshSession();
        sshSession.setConnectionConfig(sshConnectionConfig);
        return new VsanHostSshConnection(sshSession);
    }
}

