/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vsan;

import com.apcc.pcns.sshservice.SshSession;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;

public class VsanHostDetails
implements Serializable {
    private static final long serialVersionUID = 7598299352981885273L;
    private String host;
    private String username;
    private String password;
    private int keepAlivePeriod = 5;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private long timeout = 0L;

    public VsanHostDetails(String string, String string2, String string3) {
        this.host = string;
        this.username = string2;
        this.password = string3;
    }

    public SshSession.SshConnectionConfig toSshConnectionConfig() {
        SshSession.SshConnectionConfig sshConnectionConfig = new SshSession.SshConnectionConfig();
        sshConnectionConfig.host = this.host;
        sshConnectionConfig.username = this.username;
        sshConnectionConfig.password = this.password;
        sshConnectionConfig.timeout = (int)this.getTimeout(TimeUnit.MILLISECONDS);
        sshConnectionConfig.keepAlivePeriod = this.keepAlivePeriod;
        return sshConnectionConfig;
    }

    public long getTimeout(@NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit is marked non-null but is null");
        }
        return timeUnit.convert(this.timeout, this.timeoutUnit);
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public int getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    @Generated
    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setHost(String string) {
        this.host = string;
    }

    @Generated
    public void setUsername(String string) {
        this.username = string;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public void setKeepAlivePeriod(int n) {
        this.keepAlivePeriod = n;
    }

    @Generated
    public void setTimeoutUnit(TimeUnit timeUnit) {
        this.timeoutUnit = timeUnit;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VsanHostDetails)) {
            return false;
        }
        VsanHostDetails vsanHostDetails = (VsanHostDetails)object;
        if (!vsanHostDetails.canEqual(this)) {
            return false;
        }
        if (this.getKeepAlivePeriod() != vsanHostDetails.getKeepAlivePeriod()) {
            return false;
        }
        if (this.getTimeout() != vsanHostDetails.getTimeout()) {
            return false;
        }
        String string = this.getHost();
        String string2 = vsanHostDetails.getHost();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getUsername();
        String string4 = vsanHostDetails.getUsername();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getPassword();
        String string6 = vsanHostDetails.getPassword();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        TimeUnit timeUnit = this.getTimeoutUnit();
        TimeUnit timeUnit2 = vsanHostDetails.getTimeoutUnit();
        return !(timeUnit == null ? timeUnit2 != null : !((Object)((Object)timeUnit)).equals((Object)timeUnit2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof VsanHostDetails;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getKeepAlivePeriod();
        long l = this.getTimeout();
        n = n * 59 + (int)(l >>> 32 ^ l);
        String string = this.getHost();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getUsername();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getPassword();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        TimeUnit timeUnit = this.getTimeoutUnit();
        n = n * 59 + (timeUnit == null ? 43 : ((Object)((Object)timeUnit)).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "VsanHostDetails(host=" + this.getHost() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", keepAlivePeriod=" + this.getKeepAlivePeriod() + ", timeoutUnit=" + String.valueOf((Object)this.getTimeoutUnit()) + ", timeout=" + this.getTimeout() + ")";
    }
}

