/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vsan;

import com.apcc.pcns.sshservice.GenericSSHConnection;
import com.apcc.pcns.sshservice.SshSession;
import com.apcc.pcns.vsan.VSanCommand;
import com.apcc.pcns.vsan.VsanHostConnection;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.matcher.Matchers;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VsanHostSshConnection
extends GenericSSHConnection
implements VsanHostConnection {
    private static final Logger logger = LogManager.getLogger(VsanHostSshConnection.class);
    private static final int MAX_RETRIES = 1;
    private static final String IGNORE_CLUSTER_MEMBER_LIST_UPDATES_RESPONSE = "Value of IgnoreClusterMemberListUpdates is %s";
    private static final String REBOOT_HELPER_PREPARE_RESPONSE = "Cluster preparation is done.";
    private static final String REBOOT_HELPER_RECOVER_RESPONSE = "Cluster reboot/power-on is completed successfully!";

    public VsanHostSshConnection(SshSession sshSession) {
        super(sshSession);
    }

    @Override
    public boolean setIgnoreClusterMemberListUpdates(boolean bl) {
        logger.debug("setIgnoreClusterMemberListUpdates() - start");
        boolean bl2 = false;
        String string = bl ? "1" : "0";
        String string2 = String.format(IGNORE_CLUSTER_MEMBER_LIST_UPDATES_RESPONSE, string);
        String string3 = String.format(VSanCommand.SET_IGNORE_MEMBER_LIST_UPDATES.getCommand(), string);
        int n = VSanCommand.SET_IGNORE_MEMBER_LIST_UPDATES.getWait();
        logger.debug("setIgnoreClusterMemberListUpdates() - command to send: {}", (Object)string3);
        try {
            if (this.isConnected()) {
                SshSession.CmdResult cmdResult = this.executeCommandWithRetry(1, string3, n);
                if (!this.isResultOk(0, cmdResult)) {
                    logger.error("setIgnoreClusterMemberListUpdates() - Setting IgnoreClusterMemberListUpdates failed with error: {} and exit code: {}", (Object)cmdResult.error, (Object)cmdResult.exitStatus);
                } else if (cmdResult.output == null) {
                    logger.error("setIgnoreClusterMemberListUpdates() - Setting IgnoreClusterMemberListUpdates failed, output is null, error output: {}, exit status: {}", (Object)cmdResult.error, (Object)cmdResult.exitStatus);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)string2, (CharSequence)cmdResult.output.trim())) {
                    logger.debug("setIgnoreClusterMemberListUpdates() - successfully set IgnoreClusterMemberListUpdates to value: {}", (Object)cmdResult.output.trim());
                    bl2 = true;
                } else {
                    logger.error("setIgnoreClusterMemberListUpdates() - Failed to set IgnoreClusterMemberListUpdates to {}, current value is: {}", (Object)string, (Object)cmdResult.output.trim());
                }
            }
        }
        catch (IOException iOException) {
            logger.error("setIgnoreClusterMemberListUpdates() - could not connect to vSAN host, error: {}", (Throwable)iOException);
        }
        return bl2;
    }

    @Override
    public boolean setRebootHelperRecover() throws RemoteException {
        logger.debug("setRebootHelperRecover() - start");
        return this.setRebootHelper(VSanCommand.SET_REBOOT_HELPER_RECOVER, REBOOT_HELPER_RECOVER_RESPONSE);
    }

    @Override
    public boolean setRebootHelperPrepare() throws RemoteException {
        logger.debug("setRebootHelperPrepare() - start");
        return this.setRebootHelper(VSanCommand.SET_REBOOT_HELPER_PREPARE, REBOOT_HELPER_PREPARE_RESPONSE);
    }

    private boolean setRebootHelper(VSanCommand vSanCommand, String string) throws RemoteException {
        logger.debug("setRebootHelper() - start, command: {}", (Object)vSanCommand.getCommand());
        boolean bl = false;
        if (!this.isConnected()) {
            logger.error("setRebootHelper() - host is not connected, cannot execute command");
            throw new RemoteException("No host connection available for reboot_helper command execution");
        }
        String string2 = vSanCommand.getCommand();
        int n = vSanCommand.getWait();
        logger.debug("setRebootHelper() - command to send: {}", (Object)string2);
        logger.info("setRebootHelper() - starting shell streams");
        try {
            SshSession.ShellStreams shellStreams = this.sshSession.startShell();
            Expect expect = new ExpectBuilder().withInputs(new InputStream[]{shellStreams.shellInput}).withOutput(shellStreams.shellOutput).build();
            expect.sendLine(string2);
            expect.withTimeout((long)n, TimeUnit.SECONDS).expect(Matchers.contains((String)string));
            expect.close();
            bl = true;
            this.sshSession.closeShellSession();
        }
        catch (Exception exception) {
            logger.error("setRebootHelper() - shell session to execute command failed, error: {}", (Throwable)exception);
            throw new RemoteException("Failed to execute command", exception);
        }
        logger.debug("setRebootHelper() - end, command successfully executed: {}", (Object)bl);
        return bl;
    }
}

