/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail;

import com.apcc.pcns.restservice.RestService;
import com.apcc.pcns.vxrail.VxRailConnection;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.apcc.pcns.vxrail.VxRailRestClient;
import com.apcc.pcns.vxrail.VxRailRestConnection;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class VxRailConnectionManager {
    private RestService restService;

    public VxRailConnectionManager(@NonNull RestService restService) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        this.restService = restService;
    }

    public VxRailConnection getConnection(@NonNull VxRailDetails vxRailDetails) {
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailConfig is marked non-null but is null");
        }
        if (StringUtils.isBlank((CharSequence)vxRailDetails.getVxRailManagerIp())) {
            throw new IllegalArgumentException("Host cannot be blank");
        }
        VxRailRestClient vxRailRestClient = new VxRailRestClient(this.restService, vxRailDetails);
        return new VxRailRestConnection(vxRailRestClient, vxRailDetails);
    }
}

