/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail;

import com.apcc.m11.components.webserver.model.VMSettings;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class VxRailDetails
implements Serializable {
    private static final long serialVersionUID = 1695008443594954766L;
    private String vxRailManagerIp;
    private String vxRailUsername;
    private String vxRailPassword;
    private Integer shutdownDelay = VMSettings.VXRAIL_DEFAULT_CLUSTER_SHUTDOWN_DELAY;
    private int shutdownDuration = 300;
    private String pcnsIp;
    private X509Certificate vxRailCert;
    private Integer retryLimit;
    private Integer retryInterval;
    private Integer networkTimeout;
    private boolean dryrun = false;

    public VxRailDetails(String string) {
        this.vxRailManagerIp = string;
    }

    public VxRailDetails(String string, String string2, String string3) {
        this.vxRailManagerIp = string;
        this.vxRailUsername = string2;
        this.vxRailPassword = string3;
    }

    public boolean hasValidConnectionDetails() {
        return !Stream.of(this.vxRailManagerIp, this.vxRailUsername, this.vxRailPassword).anyMatch(StringUtils::isBlank);
    }

    public void setShutdownDelay(int n) {
        n = NumberUtils.max((int[])new int[]{0, n});
        n = NumberUtils.min((int[])new int[]{172800, n});
        this.shutdownDelay = n;
    }

    public void setShutdownDuration(int n) {
        n = NumberUtils.max((int[])new int[]{0, n});
        this.shutdownDuration = n = NumberUtils.min((int[])new int[]{172800, n});
    }

    @Generated
    public String getVxRailManagerIp() {
        return this.vxRailManagerIp;
    }

    @Generated
    public String getVxRailUsername() {
        return this.vxRailUsername;
    }

    @Generated
    public String getVxRailPassword() {
        return this.vxRailPassword;
    }

    @Generated
    public Integer getShutdownDelay() {
        return this.shutdownDelay;
    }

    @Generated
    public int getShutdownDuration() {
        return this.shutdownDuration;
    }

    @Generated
    public String getPcnsIp() {
        return this.pcnsIp;
    }

    @Generated
    public X509Certificate getVxRailCert() {
        return this.vxRailCert;
    }

    @Generated
    public Integer getRetryLimit() {
        return this.retryLimit;
    }

    @Generated
    public Integer getRetryInterval() {
        return this.retryInterval;
    }

    @Generated
    public Integer getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Generated
    public boolean isDryrun() {
        return this.dryrun;
    }

    @Generated
    public void setVxRailManagerIp(String string) {
        this.vxRailManagerIp = string;
    }

    @Generated
    public void setVxRailUsername(String string) {
        this.vxRailUsername = string;
    }

    @Generated
    public void setVxRailPassword(String string) {
        this.vxRailPassword = string;
    }

    @Generated
    public void setPcnsIp(String string) {
        this.pcnsIp = string;
    }

    @Generated
    public void setVxRailCert(X509Certificate x509Certificate) {
        this.vxRailCert = x509Certificate;
    }

    @Generated
    public void setRetryLimit(Integer n) {
        this.retryLimit = n;
    }

    @Generated
    public void setRetryInterval(Integer n) {
        this.retryInterval = n;
    }

    @Generated
    public void setNetworkTimeout(Integer n) {
        this.networkTimeout = n;
    }

    @Generated
    public void setDryrun(boolean bl) {
        this.dryrun = bl;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VxRailDetails)) {
            return false;
        }
        VxRailDetails vxRailDetails = (VxRailDetails)object;
        if (!vxRailDetails.canEqual(this)) {
            return false;
        }
        if (this.getShutdownDuration() != vxRailDetails.getShutdownDuration()) {
            return false;
        }
        if (this.isDryrun() != vxRailDetails.isDryrun()) {
            return false;
        }
        Integer n = this.getShutdownDelay();
        Integer n2 = vxRailDetails.getShutdownDelay();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            return false;
        }
        Integer n3 = this.getRetryLimit();
        Integer n4 = vxRailDetails.getRetryLimit();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            return false;
        }
        Integer n5 = this.getRetryInterval();
        Integer n6 = vxRailDetails.getRetryInterval();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            return false;
        }
        Integer n7 = this.getNetworkTimeout();
        Integer n8 = vxRailDetails.getNetworkTimeout();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            return false;
        }
        String string = this.getVxRailManagerIp();
        String string2 = vxRailDetails.getVxRailManagerIp();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getVxRailUsername();
        String string4 = vxRailDetails.getVxRailUsername();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getVxRailPassword();
        String string6 = vxRailDetails.getVxRailPassword();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getPcnsIp();
        String string8 = vxRailDetails.getPcnsIp();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        X509Certificate x509Certificate = this.getVxRailCert();
        X509Certificate x509Certificate2 = vxRailDetails.getVxRailCert();
        return !(x509Certificate == null ? x509Certificate2 != null : !((Object)x509Certificate).equals(x509Certificate2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof VxRailDetails;
    }

    @Generated
    public int hashCode() {
        int n = 1;
        n = n * 59 + this.getShutdownDuration();
        n = n * 59 + (this.isDryrun() ? 79 : 97);
        Integer n2 = this.getShutdownDelay();
        n = n * 59 + (n2 == null ? 43 : ((Object)n2).hashCode());
        Integer n3 = this.getRetryLimit();
        n = n * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        Integer n4 = this.getRetryInterval();
        n = n * 59 + (n4 == null ? 43 : ((Object)n4).hashCode());
        Integer n5 = this.getNetworkTimeout();
        n = n * 59 + (n5 == null ? 43 : ((Object)n5).hashCode());
        String string = this.getVxRailManagerIp();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getVxRailUsername();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getVxRailPassword();
        n = n * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getPcnsIp();
        n = n * 59 + (string4 == null ? 43 : string4.hashCode());
        X509Certificate x509Certificate = this.getVxRailCert();
        n = n * 59 + (x509Certificate == null ? 43 : ((Object)x509Certificate).hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "VxRailDetails(vxRailManagerIp=" + this.getVxRailManagerIp() + ", vxRailUsername=" + this.getVxRailUsername() + ", vxRailPassword=" + this.getVxRailPassword() + ", shutdownDelay=" + this.getShutdownDelay() + ", shutdownDuration=" + this.getShutdownDuration() + ", pcnsIp=" + this.getPcnsIp() + ", vxRailCert=" + String.valueOf(this.getVxRailCert()) + ", retryLimit=" + this.getRetryLimit() + ", retryInterval=" + this.getRetryInterval() + ", networkTimeout=" + this.getNetworkTimeout() + ", dryrun=" + this.isDryrun() + ")";
    }
}

