/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail;

import com.apcc.pcns.trustmanagement.TrustStoreManager;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VxRailInterceptingCertificateTrustManager
implements X509TrustManager {
    private X509TrustManager defaultTrustManager;
    private TrustStoreManager trustStore;
    private UnverifiedCertificateManager unverifiedCertificateManager;
    private static final Logger logger = LogManager.getLogger(VxRailInterceptingCertificateTrustManager.class);

    public VxRailInterceptingCertificateTrustManager(@NonNull X509TrustManager x509TrustManager, @NonNull TrustStoreManager trustStoreManager, @NonNull UnverifiedCertificateManager unverifiedCertificateManager) {
        if (x509TrustManager == null) {
            throw new IllegalArgumentException("trustManager is marked non-null but is null");
        }
        if (trustStoreManager == null) {
            throw new IllegalArgumentException("trustStore is marked non-null but is null");
        }
        if (unverifiedCertificateManager == null) {
            throw new IllegalArgumentException("unverifiedCertificateManager is marked non-null but is null");
        }
        this.defaultTrustManager = x509TrustManager;
        this.trustStore = trustStoreManager;
        this.unverifiedCertificateManager = unverifiedCertificateManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
        if (!this.trustStore.hasVxRailRootCert()) {
            logger.debug("checkServerTrusted() - Certificate chain is trusted, but vxrail alias not in use.  Moving certs to the correct alias.");
            for (X509Certificate x509Certificate : x509CertificateArray) {
                this.unverifiedCertificateManager.moveVxRailRooCertToTrustStore(x509Certificate);
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

