/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail;

import com.apcc.pcns.restservice.RestService;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.apcc.pcns.vxrail.requests.GetSystemVersionRequest;
import com.apcc.pcns.vxrail.requests.SystemVersionData;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.client.RestTemplate;

public class VxRailRestClient {
    private static final Logger logger = LogManager.getLogger(VxRailRestClient.class);
    private RestTemplate restTemplate;
    private RestService restService;

    public VxRailRestClient(@NonNull RestService restService, @NonNull VxRailDetails vxRailDetails) {
        if (restService == null) {
            throw new IllegalArgumentException("restService is marked non-null but is null");
        }
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailConfig is marked non-null but is null");
        }
        this.restService = restService;
        logger.debug("VxRailRestClient() - retrieving Rest template");
        this.restTemplate = restService.getVxRailCertificateInterceptingTemplateBasicAuth(vxRailDetails.getVxRailUsername(), vxRailDetails.getVxRailPassword(), null);
    }

    public SystemVersionData getSystemVersion(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("host is marked non-null but is null");
        }
        logger.debug("getSystemVersion() - start, querying about info for host {}", (Object)string);
        if (StringUtils.isBlank((CharSequence)string)) {
            logger.error("getSystemVersion() - host is blank.");
            throw new IllegalArgumentException("Invalid empty argument received");
        }
        GetSystemVersionRequest getSystemVersionRequest = new GetSystemVersionRequest();
        SystemVersionData systemVersionData = (SystemVersionData)this.restService.executeGetRequest(this.restTemplate, getSystemVersionRequest, string);
        logger.debug("getSystemVersion() - request succeeded, returning system version");
        return systemVersionData;
    }
}

