/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail;

import com.apcc.pcns.restservice.ConnectionFailException;
import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.vxrail.VxRailConnection;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.apcc.pcns.vxrail.VxRailRestClient;
import java.rmi.RemoteException;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VxRailRestConnection
implements VxRailConnection {
    private static final Logger logger = LogManager.getLogger(VxRailRestConnection.class);
    private VxRailRestClient restClient;
    private VxRailDetails vxRailConfig = null;

    public VxRailRestConnection(@NonNull VxRailRestClient vxRailRestClient, @NonNull VxRailDetails vxRailDetails) {
        if (vxRailRestClient == null) {
            throw new IllegalArgumentException("restClient is marked non-null but is null");
        }
        if (vxRailDetails == null) {
            throw new IllegalArgumentException("vxRailConfig is marked non-null but is null");
        }
        this.restClient = vxRailRestClient;
        this.vxRailConfig = vxRailDetails;
    }

    @Override
    public String getClusterProductVersion() throws RemoteException {
        logger.debug("getClusterProductVersion() - start");
        try {
            return this.restClient.getSystemVersion(this.vxRailConfig.getVxRailManagerIp()).getVersion();
        }
        catch (ConnectionFailException connectionFailException) {
            throw new RemoteException("Rest service not available", (Throwable)((Object)connectionFailException));
        }
        catch (RequestFailException | IllegalArgumentException runtimeException) {
            throw new RemoteException("Failed to get system version info", runtimeException);
        }
    }
}

