/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.pcns.vxrail.requests;

import com.apcc.pcns.restservice.RequestFailException;
import com.apcc.pcns.restservice.RequestModel;
import com.apcc.pcns.vxrail.VxRailEndpoint;
import com.apcc.pcns.vxrail.requests.SystemVersionData;
import java.util.Collections;
import java.util.InputMismatchException;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class GetSystemVersionRequest
implements RequestModel {
    @NonNull
    private MediaType contentType = MediaType.APPLICATION_JSON;
    private static final String NA_VALUE = "0";
    private static final HttpStatus SUCCESS_STATUS = HttpStatus.OK;
    public static final String VERSION_KEY = "version";
    private static final Logger logger = LogManager.getLogger(GetSystemVersionRequest.class);

    @Override
    public HttpEntity<String> getHttpEntity() {
        logger.debug("getHttpEntity() - start");
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.contentType);
        httpHeaders.setAccept(Collections.singletonList(this.contentType));
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        logger.debug("getHttpEntity() - entity set with headers - returning entity");
        return httpEntity;
    }

    @Override
    public String getEndpoint() {
        return VxRailEndpoint.SYSTEM_VERSION.getEndpoint();
    }

    @Override
    public SystemVersionData getResult(@NonNull ResponseEntity<String> responseEntity) {
        String string;
        if (responseEntity == null) {
            throw new IllegalArgumentException("response is marked non-null but is null");
        }
        logger.debug("getResult() - start");
        SystemVersionData systemVersionData = null;
        if (responseEntity.getStatusCode() != SUCCESS_STATUS) {
            logger.error("getResult() - failed to retrieve system info, status code: {}, response: {}", (Object)responseEntity.getStatusCode(), responseEntity.getBody());
            throw new RequestFailException("Unexpected response status code");
        }
        try {
            JSONObject jSONObject = new JSONObject((String)responseEntity.getBody());
            string = jSONObject.getString(VERSION_KEY);
        }
        catch (JSONException jSONException) {
            logger.error("getResult() - response does not contain expected keys, response body: {}", responseEntity.getBody());
            throw new RequestFailException("Unable to retrieve system details", jSONException);
        }
        try {
            systemVersionData = new SystemVersionData(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("getResult() - response missing items, version blank: {}", (Object)StringUtils.isBlank((CharSequence)string));
        }
        catch (InputMismatchException inputMismatchException) {
            logger.error("getResult() - response has unexpected version value with invalid characters");
        }
        if (systemVersionData == null) {
            logger.error("getResult() - no valid version found, setting to {}", (Object)NA_VALUE);
            systemVersionData = new SystemVersionData(NA_VALUE);
        }
        logger.debug("getResult() - end");
        return systemVersionData;
    }
}

