#!/bin/sh
# Copyright (c) 1999-2018 Schneider Electric, All Rights Reserved. 

INSTALL_PATH="/opt/APC/PowerChute/group1"
cd $INSTALL_PATH

JAVA_PATH=`sed -e 's/ //' java.cfg`
if [ -z "$JAVA_PATH" ]; then
    JAVA_PATH=`cat java.cfg`
fi


# Show JRE Version
${JAVA_PATH}java -version &>/dev/null
if [ $? -ne 0 ]; then
    echo
    echo Error: Invalid java path in java.cfg
    exit 1
fi


ps -p `cat $INSTALL_PATH/pcns.pid 2>/dev/null | awk "{ print "'$1'" }"` | grep 'java' > /dev/null
if [ $? -eq 0 -a -f $INSTALL_PATH/pcns.pid ]
then
    echo Process Already Started. Cannot start twice.
    exit 1
else
    #fixes developer.java.sun.com  bug id #4059472 -java.net.SocketException: too many files open
    ulimit -n 1024
    nohup ${JAVA_PATH}java -Xrs -Xms32m -Xmx64m -Xverify:none -Dfile.encoding=UTF-8 -Dservice=true -Dlog4j.configurationFile=log4j2.xml -Djava.library.path=./lib -cp .:./lib/*:./comp/pcns.jar:./comp/Notifier.jar com.apcc.m11.arch.application.Application everything > m11Debug.log &
    PROCESSID=$!
    echo $PROCESSID > pcns.pid
fi
exit 0
