/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter;

import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Globals;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PGiLogger;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PiaClientClass;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.WebSocketKeepAliveTimer;
import java.net.URI;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

@ClientEndpoint
public final class ClientWebSocket {
    private Boolean keepAliveInitiated;
    private PGiLogger logger;
    protected Boolean isBound;
    protected PiaClientClass _piaClient;
    protected String _sessionId;
    private String _subId;
    private String _subPw;
    private String _webId;
    private String _webPw;
    private String _subToken;
    private String _uriRest;
    private WebSocketKeepAliveTimer _webSocketKeepAliveTimer;
    protected String _uriWebSocket;
    protected Session _session;
    protected WebSocketContainer _container;

    public ClientWebSocket(PiaClientClass paramPiaClientClass, String wsURI, String sessionId, Globals paramGlobals, PGiLogger pgiLogger) {
        block6: {
            this.keepAliveInitiated = false;
            this.isBound = false;
            this._piaClient = paramPiaClientClass;
            this._sessionId = sessionId;
            this._uriWebSocket = wsURI;
            this.logger = pgiLogger;
            this._subId = paramGlobals.subId;
            this._subPw = paramGlobals.subPW;
            this._webId = paramGlobals.webId;
            this._webPw = paramGlobals.webPassword;
            this._uriRest = paramGlobals.host;
            try {
                this.logger.info("ClientWebSocket sessionId: " + sessionId);
                this._container = ContainerProvider.getWebSocketContainer();
                if (this._container == null) {
                    this.logger.info("ClientWebSocket null container.");
                }
                this._container.setAsyncSendTimeout(-1L);
                this._container.setDefaultMaxSessionIdleTimeout(-1L);
                this._session = this._container.connectToServer((Object)this, new URI(this._uriWebSocket));
                this._session.setMaxIdleTimeout(-1L);
                if (!this._session.isOpen()) {
                    this._session.getContainer().connectToServer(ClientWebSocket.class, new URI(this._uriWebSocket));
                }
            }
            catch (Exception exception) {
                this.logger.error("ClientWebSocket instantiation error.", exception);
                if (this._session == null || this._session.isOpen() || this._session.getId().equals("")) break block6;
                try {
                    this._session.getContainer().connectToServer((Object)this, new URI(this._uriWebSocket));
                }
                catch (Exception ex) {
                    this.logger.error("ClientWebSocket instantiation final connect error.", ex);
                }
            }
        }
        this.logger.info("ClientWebSocket session: " + this._session.getId().toString() + " : " + this._session.isOpen());
    }

    public void connect() {
        try {
            if (this._container == null) {
                this.logger.info("ClientWebSocket connect null container.");
                this._container = ContainerProvider.getWebSocketContainer();
            }
            if (this._session == null) {
                this._session = this._container.connectToServer((Object)this, new URI(this._uriWebSocket));
            }
            if (!this._session.isOpen()) {
                this.logger.info("Connecting websocket.");
                this._session.getContainer().connectToServer(ClientWebSocket.class, new URI(this._uriWebSocket));
            }
        }
        catch (Exception ex) {
            this.logger.error("ClientWebSocket connect error.", ex);
        }
    }

    public boolean isOpen() {
        return this._session.isOpen();
    }

    @OnClose
    public void onClose(Session paramSession, CloseReason paramCloseReason) {
        try {
            this.logger.info("ClientWebSocket onClose: " + paramCloseReason.toString());
            this._container = ContainerProvider.getWebSocketContainer();
        }
        catch (Exception exception) {
            this.logger.error("ClientWebSocket onClose error.", exception);
        }
    }

    @OnOpen
    public void onOpen(Session paramSession) {
        this._session = paramSession;
        try {
            this.logger.info("Websocket onopen: " + this._sessionId);
            JsonObject jSONObject = new JsonObject();
            jSONObject.put((Object)"command", (Object)"bind");
            jSONObject.put((Object)"PIASID", (Object)this._sessionId);
            jSONObject.put((Object)"ID", (Object)paramSession.getId());
            paramSession.getAsyncRemote().sendText(jSONObject.toJson());
            this.isBound = true;
            if (!this.keepAliveInitiated.booleanValue()) {
                this._webSocketKeepAliveTimer = new WebSocketKeepAliveTimer(this, this._sessionId, this._session.getId(), this.logger);
                this._webSocketKeepAliveTimer.KeepAliveStart();
                this.keepAliveInitiated = true;
            }
        }
        catch (Exception exception) {
            this.logger.error("ClientWebSocket onOpen error.", exception);
        }
    }

    @OnMessage
    public void onMessage(Session paramSession, String paramString) {
        try {
            JsonObject jSONObject = (JsonObject)Jsoner.deserialize((String)paramString);
            this.handleMessage(jSONObject, this._session.getId());
        }
        catch (Exception exception) {
            this.logger.error("ClientWebSocket onMessage error.", exception);
        }
    }

    public void destroy() {
        try {
            this.closeSocket();
            this._session = null;
            this._container = null;
            this._webSocketKeepAliveTimer = null;
            this._sessionId = null;
        }
        catch (Exception ex) {
            this.logger.error("destroy websocket error.", ex);
        }
    }

    public void closeSocket() {
        try {
            this._session.close();
            this._session = null;
            this._webSocketKeepAliveTimer.KeepAliveCancel();
            this.isBound = false;
            this.keepAliveInitiated = false;
        }
        catch (Exception exception) {
            this.logger.error("ClientWebSocket closeSocket error.", exception);
        }
    }

    public void handleMessage(JsonObject paramJSONObject, String paramString) {
        try {
            this.logger.info("Websocket message: " + paramJSONObject.toString());
            if (this.isUnsolicitedMessageType(paramJSONObject).booleanValue()) {
                this._piaClient.processEvent(paramJSONObject.toJson());
            } else if (paramJSONObject.containsKey((Object)"command") && paramJSONObject.containsKey((Object)"PIASID") && paramJSONObject.containsKey((Object)"Status")) {
                this.logger.info("Websocket message not unsolicited: " + paramJSONObject.toString());
                this.logger.info("WebSocket status: " + paramJSONObject.get((Object)"Status").toString());
                if ("1".equals(paramJSONObject.get((Object)"Status").toString())) {
                    this._webSocketKeepAliveTimer.KeepAliveCancel();
                    this.isBound = false;
                    this.keepAliveInitiated = false;
                    this.logger.info("WebSocket status of 1 received, invalid SID, re-subscribing.");
                    JsonObject subRes = this._piaClient.httpClient.subscribeToPiaAsync(this._subId, this._subPw, this._subToken, this._webId, this._webPw, this._uriRest).get();
                    this.logger.info("WebSocket subRes: " + subRes.toJson());
                    if (!"4".equals(subRes.get((Object)"ResultCode").toString())) {
                        this._piaClient._sessionId = subRes.get((Object)"SessionId").toString();
                        this._sessionId = subRes.get((Object)"SessionId").toString();
                        this._piaClient.httpClient.setSessionId(subRes.get((Object)"SessionId").toString());
                        this._container = ContainerProvider.getWebSocketContainer();
                        if (this._container == null) {
                            this.logger.info("ClientWebSocket null container.");
                        }
                        this._container.setAsyncSendTimeout(-1L);
                        this._container.setDefaultMaxSessionIdleTimeout(-1L);
                        this._session = this._container.connectToServer((Object)this, new URI(this._uriWebSocket));
                        this._session.setMaxIdleTimeout(-1L);
                        if (!this._session.isOpen()) {
                            this._session.getContainer().connectToServer(ClientWebSocket.class, new URI(this._uriWebSocket));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("Error in handleMessage: " + paramJSONObject.toJson(), exception);
        }
    }

    public Boolean isCommandType(JsonObject paramJSONObject) {
        return paramJSONObject.containsKey((Object)"command");
    }

    public Boolean isUnsolicitedMessageType(JsonObject paramJSONObject) {
        return !paramJSONObject.containsKey((Object)"command") && (paramJSONObject.containsKey((Object)"ConfID") || paramJSONObject.containsKey((Object)"ConferenceId"));
    }

    public Boolean validateMessage(JsonObject paramJSONObject) {
        return this.isCommandType(paramJSONObject) != false || this.isUnsolicitedMessageType(paramJSONObject) != false;
    }

    public String messageType(JsonObject paramJSONObject) {
        return paramJSONObject.get((Object)"MsgType").toString();
    }

    public void sendMessage(JsonObject paramJSONObject) {
        try {
            if (this._session.isOpen()) {
                this._session.getAsyncRemote().sendText(paramJSONObject.toJson());
            }
        }
        catch (Exception exception) {
            this.logger.error("ClientWebSocket sendMessage error.", exception);
        }
    }
}

