/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ClientCredentialType;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Globals;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.HttpClientInterface;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PGiLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public class HttpClient
implements HttpClientInterface {
    private HttpRequestFactory _hrf = new NetHttpTransport().createRequestFactory();
    private String _sessionId;
    private String _subId;
    private String _subPw;
    private String _webId;
    private String _webPw;
    private String _subToken;
    private String _uriRest;
    private String _uriWebsocket;
    private final ClientCredentialType _clientCredentialType;
    private final ConcurrentHashMap<String, JsonObject> _conferences;
    private final Globals _globalsClass;
    private final PGiLogger logger;

    public HttpClient(ConcurrentHashMap<String, JsonObject> paramConcurrentHashMap, ClientCredentialType paramClientCredentialType, Globals paramGlobals, PGiLogger pgiLogger) {
        this.logger = pgiLogger;
        this._conferences = paramConcurrentHashMap;
        this._clientCredentialType = paramClientCredentialType;
        this._globalsClass = paramGlobals;
        this._subId = this._globalsClass.subId;
        this._subPw = this._globalsClass.subPW;
        this._webId = this._globalsClass.webId;
        this._webPw = this._globalsClass.webPassword;
        this._uriRest = this._globalsClass.host;
        this._uriWebsocket = this._globalsClass.webSocket;
        try {
            JsonObject jSONObject = new JsonObject();
            jSONObject = this.subscribeToPiaAsync(this._subId, this._subPw, this._subToken, this._webId, this._webPw, this._uriRest).get();
            this.logger.info("HttpClient response to subscribe: " + jSONObject.toJson());
            if (jSONObject == new JsonObject() || jSONObject.containsKey((Object)"ResultCode") && !"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                this.logger.error("Error getting PIA subscription. Result code: " + jSONObject.get((Object)"ResultCode").toString());
                return;
            }
            if (!jSONObject.containsKey((Object)"SessionId")) {
                this.logger.warn("HttpClient subscribe response does not contain session id.");
                return;
            }
            this._sessionId = jSONObject.get((Object)"SessionId").toString();
        }
        catch (Exception exception) {
            this.logger.error(exception.toString());
        }
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    public String getSubId() {
        return this._subId;
    }

    public String getSubPw() {
        return this._subPw;
    }

    public String getSubToken() {
        return this._subToken;
    }

    public String getWebId() {
        return this._webId;
    }

    public String getWebPw() {
        return this._webPw;
    }

    public String getUriRest() {
        return this._uriRest;
    }

    public String getUriWebSocket() {
        return this._uriWebsocket;
    }

    public CompletableFuture<JsonObject> sendToSumo(String log) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            if (this._uriRest == null || "".equals(this._uriRest)) {
                this.logger.info("sendToSumo null or blank REST uri.");
                return null;
            }
            try {
                String sumoUri = "";
                sumoUri = this._uriRest.contains("piacloud.pgiconnect.com") ? "https://endpoint1.collection.sumologic.com/receiver/v1/http/ZaVnC4dhaV2msc6WO9cxTYLt6_bfg_e1TNLFlCW50JpJ2moo7FmuciPS7NnH_iC7YDWcC_CITQfLgPV9WxpHT1-7N-yzCIbww1jr4DKJZfRWsnfz-h85ig==" : (this._uriRest.contains("piacloud-qa") ? "https://endpoint1.collection.sumologic.com/receiver/v1/http/ZaVnC4dhaV1hMuuF7F5Q-lh85GdeT05SsKX3aQyY89D1xFL6qlId1ufYLeappEPPq_d6fm-Z169Es4bIX2wovMU20c4KBzJHrywk-rLWASK2TJO34WvvHA==" : "https://endpoint1.collection.sumologic.com/receiver/v1/http/ZaVnC4dhaV2lOMh9qi2V_2amfm4IIr7QJw_GKw6J-ucZbmdmw_xjmxsw8_iBTLM79wKmS0-kl6YUZVtUIhoSYuw2ikp5qKtyHLSzUshzIwUacEqBVc4lzA==");
                HttpRequest _req = this._hrf.buildPostRequest(new GenericUrl(sumoUri), (HttpContent)ByteArrayContent.fromString((String)"raw", (String)log));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                _req.executeAsync();
            }
            catch (Exception ex) {
                this.logger.error(null, ex);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> cancelDialoutAsync(String paramString1, String paramString2, String paramString3, String paramString4) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Cancel dialout out req: " + paramString3 + "/canceldialout?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2);
                }
                this.logger.info("Cancel dialout out req: " + paramString3 + "/canceldialout?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString3) + "/canceldialout?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException je) {
                this.logger.error("error deserializing.", je);
            }
            catch (IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> clearAccessCodeAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Clear Access Code req: " + paramString2 + "/clearaccesscode?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("Clear Access Code req: " + paramString2 + "/clearaccesscode?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/clearaccesscode?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> clearConferenceWatchAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Clear Conference Watch req: " + paramString2 + "/clearconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("Clear Conference Watch req: " + paramString2 + "/clearconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/clearconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException iOException) {
                this.logger.error(null, iOException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> dialOutAsync(String paramString1, String paramString2, Integer paramInteger1, Integer paramInteger2, Integer paramInteger3, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7, String paramString8, Optional<Integer> paramOptional, Boolean paramBoolean, String paramString9, String paramString10) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jSONObject = new JsonObject();
            try {
                String str1 = "";
                String str2 = "";
                String str3 = "";
                String str4 = "";
                String str5 = "";
                String str6 = "";
                String str7 = "";
                str1 = paramString1 != null && !"".equals(paramString1) ? "dialoutani?" : "dialout?";
                if (paramString3 != null && !"".equals(paramString3)) {
                    str3 = "&firstname=" + paramString3;
                }
                if (paramString6 != null && !"".equals(paramString6)) {
                    str4 = "&lastname=" + paramString6;
                }
                if (paramString5 != null && !"".equals(paramString5)) {
                    str5 = "&companyname=" + paramString5;
                }
                if (paramString4 != null && !"".equals(paramString4)) {
                    str6 = "&language=" + paramString4;
                }
                if (Objects.equals(paramBoolean, Boolean.TRUE)) {
                    str7 = "&overridelock=" + paramBoolean.toString();
                }
                try {
                    if (this._globalsClass.enableSumo) {
                        this.sendToSumo("Dialout req: " + paramString9 + "/" + str1 + "sessionid=" + paramString10 + "&conferenceId=" + paramString1 + "&phonenumber=" + paramString2 + "&dialouttype=" + paramInteger1 + "&participanttype=" + paramInteger2 + str2 + str3 + str4 + str5 + str6 + str7);
                    }
                    this.logger.info("Dialout req: " + paramString9 + "/" + str1 + "sessionid=" + paramString10 + "&conferenceId=" + paramString1 + "&phonenumber=" + paramString2 + "&dialouttype=" + paramInteger1 + "&participanttype=" + paramInteger2 + str2 + str3 + str4 + str5 + str6 + str7);
                    HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString9) + "/" + str1 + "sessionid=" + paramString10 + "&conferenceId=" + paramString1 + "&phonenumber=" + paramString2 + "&dialouttype=" + paramInteger1 + "&participanttype=" + paramInteger2 + str2 + str3 + str4 + str5 + str6 + str7));
                    HttpHeaders headers = _req.getHeaders();
                    headers.set("Connection", (Object)"close");
                    jSONObject = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
                }
                catch (JsonException ex) {
                    this.logger.error("Error deserializing: " + ex.toString());
                }
                if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                    if (this._globalsClass.enableSumo) {
                        this.sendToSumo("Dial Out result code not success: " + jSONObject.get((Object)"ResultCode").toString());
                    }
                } else {
                    JsonObject jSONObject1 = new JsonObject();
                    JsonObject jSONObject2 = new JsonObject();
                    jSONObject1.put((Object)"ANI", (Object)paramString1);
                    jSONObject1.put((Object)"callerPin", (Object)"");
                    jSONObject1.put((Object)"company", (Object)paramString5);
                    jSONObject1.put((Object)"confId", (Object)paramString9);
                    jSONObject1.put((Object)"connected", (Object)true);
                    jSONObject1.put((Object)"DNIS", (Object)"");
                    jSONObject1.put((Object)"email", (Object)"");
                    jSONObject1.put((Object)"firstName", (Object)paramString3);
                    jSONObject1.put((Object)"hangUpState", (Object)false);
                    jSONObject1.put((Object)"holdState", (Object)false);
                    jSONObject1.put((Object)"holdWithMusicState", (Object)false);
                    jSONObject1.put((Object)"lastName", (Object)paramString4);
                    jSONObject1.put((Object)"listenLevel", (Object)0);
                    jSONObject1.put((Object)"listenOnly", (Object)false);
                    jSONObject1.put((Object)"listenTickDown", (Object)false);
                    jSONObject1.put((Object)"listenTickUp", (Object)false);
                    jSONObject1.put((Object)"muteState", (Object)false);
                    jSONObject1.put((Object)"participantId", (Object)jSONObject.get((Object)"ParticipantId").toString());
                    jSONObject1.put((Object)"participantType", (Object)paramInteger2);
                    jSONObject1.put((Object)"phone", (Object)paramString10);
                    jSONObject1.put((Object)"subConfId", (Object)"");
                    jSONObject1.put((Object)"voiceLevel", (Object)0);
                    jSONObject1.put((Object)"voiceTickDown", (Object)false);
                    jSONObject1.put((Object)"voiceTickUp", (Object)false);
                    jSONObject1.put((Object)"codec", (Object)"");
                    jSONObject1.put((Object)"dialOut", (Object)true);
                    String str8 = jSONObject.get((Object)"ParticipantId").toString() != null && !jSONObject.get((Object)"ParticipantId").toString().isEmpty() ? jSONObject.get((Object)"ParticipantId").toString() : jSONObject.get((Object)"PartID").toString();
                    jSONObject2.put((Object)str8, (Object)jSONObject1);
                }
            }
            catch (IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return jSONObject;
        });
    }

    @Override
    public CompletableFuture<JsonObject> endConferenceAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("End conference req: " + paramString2 + "/endconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("End conference req: " + paramString2 + "/endconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/endconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> findConferenceAsync(Optional<String> paramOptional1, Optional<String> paramOptional2, Optional<String> paramOptional3, String paramString1, String paramString2) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jSONObject = new JsonObject();
            try {
                String str1;
                String string3 = str1 = paramOptional1.isPresent() && !"".equals(paramOptional1.get()) ? "/getconferenceinfo?sessionid=" + paramString2 + "&conferenceid=" + (String)paramOptional1.get() : "/findconference?sessionid=" + paramString2 + "&passcode=" + (String)paramOptional2.get() + "&phonenumber=" + (String)paramOptional3.get();
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Find conference req: " + paramString1 + str1);
                }
                this.logger.info("Find conference req: " + paramString1 + str1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString1) + str1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                jSONObject = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
                if (jSONObject.containsKey((Object)"ConferenceId") && !"".equals(jSONObject.get((Object)"ConferenceId").toString())) {
                    JsonObject jSONObject1 = new JsonObject();
                    JsonObject jSONObject2 = new JsonObject();
                    JsonObject jSONObject3 = new JsonObject();
                    jSONObject1.put((Object)"conferenceId", (Object)jSONObject.get((Object)"ConferenceId").toString());
                    jSONObject1.put((Object)"active", (Object)false);
                    jSONObject1.put((Object)"conferenceLink", (Object)"");
                    jSONObject2.put((Object)"lock", (Object)false);
                    jSONObject2.put((Object)"musicState", (Object)false);
                    jSONObject2.put((Object)"muteState", (Object)false);
                    jSONObject2.put((Object)"recordingPermitted", (Object)false);
                    jSONObject2.put((Object)"recordingState", (Object)false);
                    jSONObject2.put((Object)"talkerNotifyState", (Object)false);
                    jSONObject1.put((Object)"conferenceOptions", (Object)jSONObject2);
                    jSONObject1.put((Object)"conferenceWatch", (Object)false);
                    jSONObject1.put((Object)"numberOfActiveParticipants", (Object)0);
                    jSONObject1.put((Object)"participants", (Object)new JsonArray());
                    jSONObject3.put((Object)"listenOnlyPasscode", (Object)"");
                    jSONObject3.put((Object)"moderatorPasscode", (Object)"");
                    jSONObject3.put((Object)"participantPasscode", (Object)"");
                    jSONObject1.put((Object)"passcodes", (Object)jSONObject3);
                    jSONObject1.put((Object)"recordingFileName", (Object)"");
                    jSONObject1.put((Object)"toneOnEntry", (Object)"");
                    jSONObject1.put((Object)"toneOnExit", (Object)"");
                    jSONObject1.put((Object)"voiceOnEntry", (Object)"");
                    jSONObject1.put((Object)"voiceOnExit", (Object)"");
                    this._conferences.putIfAbsent(jSONObject.get((Object)"ConferenceId").toString(), jSONObject1);
                }
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return jSONObject;
        });
    }

    @Override
    public CompletableFuture<JsonObject> getConferenceStateAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Get Conference State req: " + paramString2 + "/getconferencestate?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("Get Conference State req: " + paramString2 + "/getconferencestate?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/getconferencestate?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<InputStream> getRecording(String downloadUrl, String fileName) {
        return CompletableFuture.supplyAsync(() -> {
            InputStream str = null;
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("getRecording req: " + downloadUrl + this._globalsClass.webId + "/" + fileName);
                }
                this.logger.info("getRecording req: " + downloadUrl + this._globalsClass.webId + "/" + fileName);
                HttpRequest req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(downloadUrl) + this._globalsClass.webId + "/" + fileName));
                String pass = String.valueOf(this._globalsClass.webId) + ":" + this._globalsClass.webPassword;
                byte[] arrayOfByte = Base64.encodeBase64((byte[])pass.getBytes(StandardCharsets.UTF_8));
                String encodedPass = "Basic " + new String(arrayOfByte);
                HttpHeaders headers = req.getHeaders();
                headers.setAuthorization(encodedPass);
                headers.set("Connection", (Object)"close");
                req.setHeaders(headers);
                str = ((HttpResponse)req.executeAsync().get()).getContent();
            }
            catch (Exception ex) {
                if (ex.toString().contains("404 Not Found")) {
                    this.logger.info("Get Recording, recording not available yet.");
                }
                this.logger.error(null, ex);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> getPiaVersion(String paramString1, String paramString2) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Get PIA Version req: " + paramString1 + "/getsysteminfo?sessionid=" + paramString2);
                }
                this.logger.info("Get PIA Version req: " + paramString1 + "/getsysteminfo?sessionid=" + paramString2);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString1) + "/getsysteminfo?sessionid=" + paramString2));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> getWatchesAsync(String paramString1, String paramString2) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Get Watches req: " + paramString1 + "/getwatches?sessionid=" + paramString2);
                }
                this.logger.info("Get Watches req: " + paramString1 + "/getwatches?sessionid=" + paramString2);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString1) + "/getwatches?sessionid=" + paramString2));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> hangupAsync(String paramString1, String paramString2, String paramString3, String paramString4) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Hangup req: " + paramString3 + "/hangup?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2);
                }
                this.logger.info("Hangup req: " + paramString3 + "/hangup?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString3) + "/hangup?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantId=" + paramString2));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> mohOffAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("MOH Off req: " + paramString2 + "/mohoff?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("MOH Off req: " + paramString2 + "/mohoff?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/mohoff?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException iOException) {
                this.logger.error(null, iOException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> moveToMainConfAsync(String confId, String partId, String url, String sessionId) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Move to main conference req: " + url + "/movetomainconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId);
                }
                this.logger.info("Move to main conference req: " + url + "/movetomainconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(url) + "/movetomainconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> moveToSubConfAsync(String confId, String partId, String subConfId, String uri, String sessionId) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Move to subconference req: " + uri + "/movetosubconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId + "&subConferenceId=" + subConfId);
                }
                this.logger.info("httpClient move to subconf: " + uri + "/movetosubconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId + "&subConferenceId=" + subConfId);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(uri) + "/movetosubconference?sessionid=" + sessionId + "&conferenceId=" + confId + "&participantId=" + partId + "&subConferenceId=" + subConfId));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> pauseRecordingAsync(String paramString1, Boolean paramBoolean, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Pause recording req: " + paramString2 + "/pauserecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                }
                this.logger.info("Pause recording req: " + paramString2 + "/pauserecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/pauserecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> removeAllConferenceWatchesAsync(String paramString1, String paramString2) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Remove all watches req: " + paramString2 + "/removeallwatches?sessionid=" + paramString1);
                }
                this.logger.info("Remove all watches req: " + paramString2 + "/removeallwatches?sessionid=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/removeallwatches?sessionid=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> removeConferenceWatchesAsync(String[] paramArrayOfString, String paramString1, String paramString2) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Remove Conference Watches req: " + paramString1 + "/removewatches?sessionid=" + paramString2 + "&confIds=" + String.join((CharSequence)",", paramArrayOfString));
                }
                this.logger.info("Remove Conference Watches req: " + paramString1 + "/removewatches?sessionid=" + paramString2 + "&confIds=" + String.join((CharSequence)",", paramArrayOfString));
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString1) + "/removewatches?sessionid=" + paramString2 + "&confIds=" + String.join((CharSequence)",", paramArrayOfString)));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> reservationBy(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str1 = new JsonObject();
            String str2 = null;
            String servicesUrlBase = "";
            servicesUrlBase = this.getUriRest().toLowerCase().contains("qab") ? "https://servicespubqab.pgilab.com/Rest/V1/Services" : (this.getUriRest().toLowerCase().contains("qac") ? "https://servicespubqac.pgilab.com/Rest/V1/Services" : "https://services.pgiconnect.com/Rest/V1/Services");
            try {
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(servicesUrlBase) + "/Security.svc/Token/New?apiId=" + paramString1 + "&apiPassword=" + paramString2 + "&clientId=" + paramString3 + "&clientPassword=" + paramString4));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                JsonObject jSONObject = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
                str2 = ((JsonObject)jSONObject.get((Object)"LogOnResult")).get((Object)"Token").toString();
                if (!"".equals(str2) && str2 != null) {
                    String str3 = "";
                    str3 = "/Reservation/By?modpasscode=" + paramString6 + "&clientId=" + paramString3 + "&token=" + str2;
                    if (this._globalsClass.enableSumo) {
                        this.sendToSumo("Reservation by req: " + servicesUrlBase + "/Reservation.svc" + str3);
                    }
                    this.logger.info("Reservation by req: " + servicesUrlBase + "/Reservation.svc" + str3);
                    HttpRequest _req2 = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(servicesUrlBase) + "/Reservation.svc" + str3));
                    HttpHeaders headers2 = _req2.getHeaders();
                    headers2.set("Connection", (Object)"close");
                    JsonObject str4 = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req2.executeAsync().get()).parseAsString());
                    if (!"".equals(str4) && str4 != null) {
                        str1 = str4;
                    }
                } else {
                    this.logger.error("HttpClient reservationBy token null or blank.");
                }
            }
            catch (Exception exception) {
                this.logger.error(null, exception);
            }
            return str1;
        });
    }

    @Override
    public CompletableFuture<JsonObject> resumeRecordingAsync(String paramString1, Boolean paramBoolean, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Resume Recording req: " + paramString2 + "/resumerecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                }
                this.logger.info("Resume Recording req: " + paramString2 + "/resumerecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/resumerecording?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> setAccessCodeAsync(String paramString1, String paramString2, String paramString3, String paramString4) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Set Access Code req: " + paramString3 + "/setaccesscode?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&pin=" + paramString2);
                }
                this.logger.info("Set Access Code req: " + paramString3 + "/setaccesscode?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&pin=" + paramString2);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString3) + "/setaccesscode?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&pin=" + paramString2));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> setConferenceOptionAsync(String paramString1, Integer paramInteger, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Set Conference Option req: " + paramString2 + "/setconferenceoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&option=" + paramInteger.toString());
                }
                this.logger.info("Set Conference Option req: " + paramString2 + "/setconferenceoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&option=" + paramInteger.toString());
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/setconferenceoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&option=" + paramInteger.toString()));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> setParticipantInfoAsync(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7, String paramString8, String paramString9) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Set Participant Info req: " + paramString8 + "/setparticipantinfo?sessionid=" + paramString9 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&firstName=" + paramString3 + "&lastName=" + paramString4 + "&companyname=" + paramString5 + "&phonenumber=" + paramString6 + "&emailaddress=" + paramString7);
                }
                this.logger.info("Set Participant Info req: " + paramString8 + "/setparticipantinfo?sessionid=" + paramString9 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&firstName=" + paramString3 + "&lastName=" + paramString4 + "&companyname=" + paramString5 + "&phonenumber=" + paramString6 + "&emailaddress=" + paramString7);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString8) + "/setparticipantinfo?sessionid=" + paramString9 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&firstName=" + paramString3 + "&lastName=" + paramString4 + "&companyname=" + paramString5 + "&phonenumber=" + paramString6 + "&emailaddress=" + paramString7));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> setParticipantOptionAsync(String paramString1, String paramString2, Integer paramInteger, String paramString3, String paramString4) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Set Participant Option req: " + paramString3 + "/setparticipantoption?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&option=" + paramInteger.toString());
                }
                this.logger.info("Set Participant Option req: " + paramString3 + "/setparticipantoption?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&option=" + paramInteger.toString());
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString3) + "/setparticipantoption?sessionid=" + paramString4 + "&conferenceId=" + paramString1 + "&participantid=" + paramString2 + "&option=" + paramInteger.toString()));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> startConferenceAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Start Conference req: " + paramString2 + "/startconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("Start Conference req: " + paramString2 + "/startconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/startconference?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Start Conf response: " + str.toString());
                }
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> startRecordingAsync(String clientId, String clientPw, String webId, String webPw, String fileName, String fileType, Boolean playPrompt, Boolean disableDTMF, String uri, String sessionId, String confId) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Start recording req: " + uri + "/startrecording?sessionid=" + sessionId + "&conferenceId=" + confId + "&clientid=******" + "&clientpw=*******" + "&webid=******" + "&webpw=*******" + "&filename=" + fileName + "&filetype=" + fileType + "&playprompt=true&disableDTMF=" + disableDTMF);
                }
                this.logger.info("Start recording req: " + uri + "/startrecording?sessionid=" + sessionId + "&conferenceId=" + confId + "&clientid=******" + "&clientpw=*******" + "&webid=******" + "&webpw=*******" + "&filename=" + fileName + "&filetype=" + fileType + "&playprompt=true&disableDTMF=" + disableDTMF);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(uri) + "/startrecording?sessionid=" + sessionId + "&conferenceId=" + confId + "&clientid=" + clientId + "&clientpw=" + clientPw + "&webid=" + webId + "&webpw=" + webPw + "&filename=" + fileName + "&filetype=" + fileType + "&playprompt=true&disableDTMF=" + disableDTMF));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> startRecordingWarnAsync(String paramString1, Boolean paramBoolean, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Start Recording Warn req: " + paramString2 + "/startrecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                }
                this.logger.info("Start Recording Warn req: " + paramString2 + "/startrecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/startrecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> stopRecordingAsync(String confId, Boolean disableDTMF, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Stop recording req: " + paramString2 + "/stoprecording?sessionid=" + paramString3 + "&conferenceId=" + confId + "&disableDTMF=" + disableDTMF);
                }
                this.logger.info("Stop recording req: " + paramString2 + "/stoprecording?sessionid=" + paramString3 + "&conferenceId=" + confId + "&disableDTMF=" + disableDTMF);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/stoprecording?sessionid=" + paramString3 + "&conferenceId=" + confId + "&disableDTMF=" + disableDTMF));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> stopRecordingWarnAsync(String paramString1, Boolean paramBoolean, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Stop Recording Warn req: " + paramString2 + "/stoprecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                }
                this.logger.info("Stop Recording Warn req: " + paramString2 + "/stoprecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/stoprecordingwarn?sessionid=" + paramString3 + "&conferenceId=" + paramString1 + "&disableDTMF=" + paramBoolean));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> subscribeToPiaAsync(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) {
        return CompletableFuture.supplyAsync(() -> {
            HttpRequest httpRequest = null;
            JsonObject str = new JsonObject();
            try {
                String str1;
                httpRequest = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString6) + "/subscribe"));
                HttpHeaders httpHeaders = httpRequest.getHeaders();
                String string7 = str1 = this._clientCredentialType == ClientCredentialType.Client ? "client:" + paramString1 + ":" + paramString2 + ":" + paramString4 + ":" + paramString5 : "pgi:" + paramString1 + ":" + paramString2 + ":" + paramString4 + ":" + paramString5;
                if (paramString6 != null && !"".equals(paramString6)) {
                    if (!"".equals(this._subId)) {
                        httpHeaders.set("PGI-XCLIENT", (Object)this._subId);
                    }
                    httpHeaders.set("Bearer", (Object)paramString3);
                }
                if (str1 != null && !"".equals(str1)) {
                    byte[] arrayOfByte = Base64.encodeBase64((byte[])str1.getBytes(StandardCharsets.UTF_8));
                    String str2 = "Basic " + new String(arrayOfByte);
                    httpHeaders.setAuthorization(str2);
                    if (this._globalsClass.enableSumo) {
                        this.sendToSumo("Subscribe req: " + paramString6 + "/subscribe *****END OF REQ*****  Str2:" + str2);
                    }
                    this.logger.info("Subscribe req: " + paramString6 + "/subscribe *****END OF REQ*****  Str2:" + str2);
                }
                httpRequest.setHeaders(httpHeaders);
                httpHeaders.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)httpRequest.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> toggleEntryExitOptionAsync(String paramString1, String paramString2, String paramString3) {
        return CompletableFuture.supplyAsync(() -> {
            JsonObject str = new JsonObject();
            try {
                if (this._globalsClass.enableSumo) {
                    this.sendToSumo("Toggle Entry Exit Option req: " + paramString2 + "/toggleentryexitoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                }
                this.logger.info("Toggle Entry Exit Option req: " + paramString2 + "/toggleentryexitoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/toggleentryexitoption?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                HttpHeaders headers = _req.getHeaders();
                headers.set("Connection", (Object)"close");
                str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
            }
            catch (JsonException | IOException | InterruptedException | ExecutionException interruptedException) {
                this.logger.error(null, interruptedException);
            }
            return str;
        });
    }

    @Override
    public CompletableFuture<JsonObject> watchConferenceAsync(String paramString1, String paramString2, String paramString3) {
        if (!"".equals(paramString1)) {
            return CompletableFuture.supplyAsync(() -> {
                JsonObject str = new JsonObject();
                try {
                    if (this._globalsClass.enableSumo) {
                        this.sendToSumo("Watch Conference req: " + paramString2 + "/setconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                    }
                    this.logger.info("Watch Conference req: " + paramString2 + "/setconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1);
                    HttpRequest _req = this._hrf.buildGetRequest(new GenericUrl(String.valueOf(paramString2) + "/setconferencewatch?sessionid=" + paramString3 + "&conferenceId=" + paramString1));
                    HttpHeaders headers = _req.getHeaders();
                    headers.set("Connection", (Object)"close");
                    str = (JsonObject)Jsoner.deserialize((String)((HttpResponse)_req.executeAsync().get()).parseAsString());
                }
                catch (JsonException je) {
                    this.logger.error("error deserializing watchconf.", je);
                }
                catch (Exception exception) {
                    this.logger.error("WatchConferenceAsync error.", exception);
                }
                return str;
            });
        }
        return null;
    }
}

