/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter;

import com.adobe.connectpro.telephony.adaptor.AdaptorException;
import com.adobe.connectpro.telephony.adaptor.AdaptorField;
import com.adobe.connectpro.telephony.adaptor.AnnouncementOption;
import com.adobe.connectpro.telephony.adaptor.ConferenceInfo;
import com.adobe.connectpro.telephony.adaptor.ConferenceNumber;
import com.adobe.connectpro.telephony.adaptor.ConferenceOption;
import com.adobe.connectpro.telephony.adaptor.DialInStep;
import com.adobe.connectpro.telephony.adaptor.FailureCode;
import com.adobe.connectpro.telephony.adaptor.NumberType;
import com.adobe.connectpro.telephony.adaptor.TelephonyAdaptor;
import com.adobe.connectpro.telephony.adaptor.TelephonyCallback;
import com.adobe.connectpro.telephony.adaptor.TelephonyUserInfo;
import com.adobe.connectpro.telephony.adaptor.UserOption;
import com.adobe.connectpro.telephony.adaptor.ValidateException;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ClientCredentialType;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ClientWebSocket;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ConfNumber;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ConnectionHandler;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Constants;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Download;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.DownloadRetrieve;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Globals;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PGiLogger;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PiaClientClass;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PiaOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class PGi_PIA_Adapter
implements TelephonyAdaptor {
    public Constants constantsClass;
    protected static PGiLogger logger;
    public static final String adapterVersion = "PGi PIA v1.0.8.19 ";
    protected ConnectionHandler _connectionHandler = null;
    protected PiaClientClass piaClient;
    private Globals globalsClass;
    private TelephonyCallback cb;
    String xtelpremiereconfnum = "";
    String xtelpremiereuvconfnum = "";
    private AtomicLong downloadId = new AtomicLong(0L);
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption;

    public PGi_PIA_Adapter() throws ClassNotFoundException {
        this.constantsClass = new Constants();
        this.globalsClass = new Globals(false);
    }

    public void initAdaptor(TelephonyCallback paramTelephonyCallback, Map<String, String> incomingParamMap, String paramString) throws AdaptorException {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            incomingParamMap.forEach((k, v) -> {
                if (k.contains("EMEA_")) {
                    paramMap.put(k.replace("EMEA_", ""), (String)v);
                } else {
                    paramMap.put((String)k, (String)v);
                }
            });
            this.globalsClass.propertiesMap = paramMap;
            this.globalsClass.enableSumo = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_ENABLE_SUMO") ? Boolean.parseBoolean((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_ENABLE_SUMO")) : this.globalsClass.enableSumo;
            this.globalsClass.host = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_HOST") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_HOST") : this.globalsClass.host;
            this.globalsClass.port = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_PORT") ? Integer.parseInt((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_PORT")) : this.globalsClass.port;
            String string = this.globalsClass.webId = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_WEB_ID") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_WEB_ID") : this.globalsClass.webId;
            this.globalsClass.moreInfoURL = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_MORE_INFO_URL") ? (paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_MORE_INFO_URL") == null ? "" : ((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_MORE_INFO_URL")).trim()) : this.globalsClass.moreInfoURL;
            this.globalsClass.webPassword = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_PASSWORD") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_PASSWORD") : this.globalsClass.webPassword;
            this.globalsClass.adaptorInstanceId = paramString;
            this.globalsClass.DEBUG_PREFIX = String.valueOf(this.globalsClass.DEBUG_PREFIX) + "[" + paramString + "]";
            this.globalsClass.subId = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_SUBID") ? ((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_SUBID")).toString() : this.globalsClass.subId;
            this.globalsClass.subPW = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_SUBPW") ? ((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_SUBPW")).toString() : this.globalsClass.subPW;
            this.globalsClass.allowUnresolvedIPofPGiEndPoint = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "ALLOW_UNRESOLVED_PGI_ENDPOINT_IP") ? Boolean.parseBoolean((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "ALLOW_UNRESOLVED_PGI_ENDPOINT_IP")) : this.globalsClass.allowUnresolvedIPofPGiEndPoint;
            boolean bl = this.globalsClass.isProxyEnabled = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "ENABLE_PROXY") ? Boolean.parseBoolean((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "ENABLE_PROXY")) : this.globalsClass.isProxyEnabled;
            if (this.globalsClass.isProxyEnabled && paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PROXY_HOST")) {
                this.globalsClass.proxyHost = (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PROXY_HOST");
                this.globalsClass.proxyPort = Integer.parseInt((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PROXY_PORT"));
            }
            this.globalsClass.downloadURL = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_URL") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_URL") : this.globalsClass.downloadURL;
            this.globalsClass.downloadLogin = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_LOGIN") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_LOGIN") : this.globalsClass.downloadLogin;
            this.globalsClass.downloadPassword = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_PASSWORD") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DOWNLOAD_PASSWORD") : this.globalsClass.downloadPassword;
            this.globalsClass.webSocket = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_WEBSOCKET") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_WEBSOCKET") : this.globalsClass.webSocket;
            this.globalsClass.uvNumberCountryCode = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_UV_COUNTRY_CODE") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_UV_COUNTRY_CODE") : this.globalsClass.uvNumberCountryCode;
            this.globalsClass.uvNumberType = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_UV_NUMBER_TYPE") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_UV_NUMBER_TYPE") : this.globalsClass.uvNumberType;
            this.globalsClass.countryCodes = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DISPLAY_COUNTRY_CODES") ? ((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DISPLAY_COUNTRY_CODES")).split(",") : this.globalsClass.countryCodes;
            this.globalsClass.numberTypes = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DISPLAY_NUMBER_TYPES") ? ((String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DISPLAY_NUMBER_TYPES")).split(",") : this.globalsClass.numberTypes;
            this.globalsClass.dialoutType = paramMap.containsKey(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DIALOUTTYPE") ? (String)paramMap.get(String.valueOf(this.globalsClass.whichClass) + "PREMIERE_DIALOUTTYPE") : this.globalsClass.dialoutType;
            this.cb = paramTelephonyCallback;
            logger = new PGiLogger(LogManager.getLogger((String)this.getClass().getName()), adapterVersion, this.globalsClass);
            logger.info(adapterVersion);
            paramMap.forEach((paramName, paramValue) -> {
                if (paramName.contains("PW") || paramName.toUpperCase().contains("PASSWORD")) {
                    paramValue = "xxxxxx";
                } else {
                    logger.info("InitAdapter paramMap: " + paramName + " = " + paramValue);
                }
            });
            this.piaClient = new PiaClientClass(ClientCredentialType.Client, null, paramTelephonyCallback, this.globalsClass, this);
            logger.log(Level.INFO, PiaClientClass.class.getName());
        }
        catch (Exception exception) {
            logger.error("Init Adapter error.", exception);
        }
    }

    public String addPendingAudioDownload(final String[] downloadURLs, final String[] headers, final String downloadPath) {
        final long dlID = this.downloadId.addAndGet(1L) % 1000000000L;
        logger.info("Beginning addPendingAudioDownload.");
        new Thread(){

            @Override
            public void run() {
                try {
                    Download download = new Download(dlID, downloadPath, headers, downloadURLs);
                    DownloadRetrieve downloadRetrieve = new DownloadRetrieve(download, PGi_PIA_Adapter.this.globalsClass, PGi_PIA_Adapter.this.piaClient, logger);
                }
                catch (Exception ex) {
                    logger.error("Error starting DownloadRetrieve.", ex);
                }
            }
        }.start();
        return String.valueOf(dlID);
    }

    public void connect(ConnectionHandler paramConnectionHandler) {
        this._connectionHandler = paramConnectionHandler;
    }

    public void destroyConferenceSession(String paramString) {
        try {
            logger.info("destroy conference session called: " + paramString);
            this.piaClient._telephonyConferences.remove(paramString);
            this.piaClient._telephonyUsers.remove(paramString);
        }
        catch (Exception exception) {
            logger.error("destroyConferenceSession error.", exception);
        }
    }

    public String dialOut(String paramString1, String paramString2, TelephonyUserInfo.UserType paramUserType, String paramString3, boolean paramBoolean) throws AdaptorException {
        String str = this.dialOut(paramString1, paramString2, paramUserType, paramString3);
        return str;
    }

    public String dialOut(String paramString1, String paramString2, TelephonyUserInfo.UserType paramUserType, String paramString3) {
        Integer integer1 = Integer.valueOf(this.globalsClass.dialoutType);
        Integer integer2 = 0;
        switch (paramUserType) {
            case PARTICIPANT: {
                integer2 = 0;
                break;
            }
            case MODERATOR: {
                integer2 = 1;
                break;
            }
            default: {
                integer2 = 0;
            }
        }
        JsonObject str = new JsonObject();
        String retStr = null;
        try {
            JsonObject jSONObject = str = this.piaClient.dialOutAsync(paramString1, paramString2, integer1, integer2, 120, paramString2, this.globalsClass.dialoutLanguage, "", paramString3, "", "", null, false).get();
            if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                logger.error("Error dialing out, result code: " + jSONObject.toJson());
                if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                    jSONObject = this.piaClient.dialOutAsync(paramString1, paramString2, integer1, integer2, 120, paramString2, this.globalsClass.dialoutLanguage, "", paramString3, "", "", null, false).get();
                } else {
                    retStr = jSONObject.get((Object)"ResultCode").toString();
                    return new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR).toString();
                }
            }
            logger.info("dialout jSONObject: " + jSONObject.toString());
            if (jSONObject.containsKey((Object)"ParticipantId")) {
                retStr = jSONObject.get((Object)"ParticipantId").toString();
                TelephonyUserInfo telephonyUserInfo = new TelephonyUserInfo(paramString1);
                telephonyUserInfo.setPhoneNumber(paramString2);
                telephonyUserInfo.setTelephonyUserId(retStr);
                if (!this.piaClient._telephonyUsers.containsKey(paramString1)) {
                    ArrayList<TelephonyUserInfo> arrayList = new ArrayList<TelephonyUserInfo>();
                    arrayList.add(telephonyUserInfo);
                    this.piaClient._telephonyUsers.put(paramString1, arrayList);
                    logger.info("Dialout telephony users new list.");
                } else {
                    Boolean bool = false;
                    ArrayList<TelephonyUserInfo> list = this.piaClient._telephonyUsers.get(paramString1);
                    list.add(telephonyUserInfo);
                    for (TelephonyUserInfo telephonyUserInfo1 : list) {
                        if (!telephonyUserInfo1.getTelephonyUserId().equals(telephonyUserInfo.getTelephonyUserId())) continue;
                        bool = true;
                    }
                    if (bool.booleanValue()) {
                        logger.info("Dialout telephony users existing list.");
                        this.piaClient._telephonyUsers.put(paramString1, list);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error("DialOut error.", exception);
        }
        return retStr;
    }

    public void endConference(String paramString) throws AdaptorException {
        try {
            logger.info("endConference: " + paramString);
            this.piaClient.endConferenceAsync(paramString);
            this.piaClient.clearWatchAsync(paramString);
            this.piaClient._telephonyConferences.remove(paramString);
            this.piaClient._conferences.remove(paramString);
            this.piaClient._telephonyUsers.remove(paramString);
        }
        catch (Exception exception) {
            logger.error("endConference error in cleaning up collections.", exception);
        }
    }

    public ConferenceInfo getConferenceInfo(String paramString) throws AdaptorException {
        try {
            ConferenceInfo conferenceInfo = this.piaClient._telephonyConferences.get(paramString);
            if (!this.piaClient._telephonyConferences.containsKey(paramString)) {
                conferenceInfo = new ConferenceInfo(paramString);
                this.piaClient._telephonyConferences.putIfAbsent(paramString, conferenceInfo);
            } else {
                conferenceInfo = this.piaClient._telephonyConferences.get(paramString);
            }
            return conferenceInfo;
        }
        catch (Exception exception) {
            logger.error("GetConferenceInfo error.", exception);
            return null;
        }
    }

    public List<String> getSubConferenceIds(String paramString, int paramInt) throws AdaptorException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int b = 0;
        while (b < paramInt) {
            char c = (char)(65 + b);
            arrayList.add(Character.toString(c));
            b = (byte)(b + 1);
        }
        return arrayList;
    }

    public List<AdaptorField> getTelephonyFieldInfo() throws AdaptorException {
        ArrayList<AdaptorField> arrayList = new ArrayList<AdaptorField>();
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-conference-id}", "x-tel-premiere-conference-id", false, AdaptorField.UIType.HIDDEN, false, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-premiere-direct-phone}", "x-premiere-direct-phone", true, AdaptorField.UIType.HIDDEN, false, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-premiere-direct-phone-key}", "x-premiere-direct-phone-key", false, AdaptorField.UIType.HIDDEN, false, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-conference-number}", "x-tel-premiere-conference-number", false, this.globalsClass.isEMEA ? AdaptorField.UIType.TEXTAREA : AdaptorField.UIType.TEXT, false, AdaptorField.InMeetingDisplayLevel.PARTICIPANTS));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-uv-conference-number}", "x-tel-premiere-uv-conference-number", false, AdaptorField.UIType.HIDDEN, false, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-participant-code}", "x-tel-premiere-participant-code", false, AdaptorField.UIType.TEXT, false, AdaptorField.InMeetingDisplayLevel.PARTICIPANTS));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-user-id}", "x-tel-premiere-user-id", true, AdaptorField.UIType.TEXT, true, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-password}", "x-tel-premiere-password", true, AdaptorField.UIType.PASSWORD, true, AdaptorField.InMeetingDisplayLevel.NONE));
        arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-moderator-code}", "x-tel-premiere-moderator-code", true, AdaptorField.UIType.TEXT, true, AdaptorField.InMeetingDisplayLevel.HOSTS));
        String str = "{x-tel-premiere-sign-up-text-value}";
        arrayList.add(PGi_PIA_Adapter.createPremiereField(str, "x-tel-premiere-sign-up-text", false, AdaptorField.UIType.TEXT, false, AdaptorField.InMeetingDisplayLevel.NONE));
        if (this.globalsClass.moreInfoURLEnabled) {
            Objects.requireNonNull(this.globalsClass);
            Objects.requireNonNull(this.globalsClass);
            arrayList.add(PGi_PIA_Adapter.createPremiereField("{x-tel-premiere-company-url}", "x-tel-premiere-company-url", false, AdaptorField.UIType.URL, false, AdaptorField.InMeetingDisplayLevel.PARTICIPANTS));
        }
        return arrayList;
    }

    public List<TelephonyUserInfo> getUserList(String paramString) throws AdaptorException {
        return this.piaClient._telephonyUsers.get(paramString);
    }

    public void hangUp(String confId, String telephonyUserId) throws AdaptorException {
        logger.info("hangUp: " + confId + ":" + telephonyUserId);
        this.piaClient.userOfflineAdobe(confId, telephonyUserId, this.cb);
        this.piaClient.hangUpAsync(confId, telephonyUserId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String initConferenceSession(Map<String, String> paramMap) throws AdaptorException {
        String confPassCode = "";
        String confPhone = "";
        String confId = "";
        paramMap.forEach((paramString1, paramString2) -> {
            if (paramString1.toUpperCase().contains("PW") || paramString1.toUpperCase().contains("PASSWORD")) {
                paramString2 = "xxxxxx";
            }
            logger.info("initConference telMap k,v: " + paramString1 + "," + paramString2);
        });
        String str1 = paramMap.get("x-tel-premiere-company-url").toString();
        if (paramMap.containsKey("x-tel-premiere-uv-conference-number") && !"".equals(paramMap.get("x-tel-premiere-uv-conference-number").toString()) && !paramMap.get("x-tel-premiere-uv-conference-number").toString().contains("x-tel-premiere-uv-conference-number")) {
            confPhone = paramMap.get("x-tel-premiere-uv-conference-number").toString();
            this.globalsClass.xtelpremiereconfnum = paramMap.get("x-tel-premiere-uv-conference-number").toString();
        } else if (paramMap.containsKey("x-tel-premiere-conference-number") && !"".equals(paramMap.get("x-tel-premiere-conference-number").toString()) && !paramMap.get("x-tel-premiere-conference-number").toString().contains("x-tel-premiere-conference-number")) {
            confPhone = paramMap.get("x-tel-premiere-conference-number").toString();
            this.globalsClass.xtelpremiereconfnum = paramMap.get("x-tel-premiere-conference-number").toString();
        } else if ("".equals(confPhone) && (!paramMap.containsKey("x-tel-premiere-conference-number") || "".equals(paramMap.get("x-tel-premiere-conference-number").toString()) || !paramMap.get("x-tel-premiere-conference-number").toString().contains("x-tel-premiere-conference-number")) && str1.contains("num=")) {
            confPhone = str1.substring(str1.indexOf("num=")).replace("num=", "");
            this.globalsClass.xtelpremiereconfnum = str1.substring(str1.indexOf("num=")).replace("num=", "");
        }
        if (paramMap.containsKey("x-tel-premiere-conference-id") && !"".equals(paramMap.get("x-tel-premiere-conference-id").toString())) {
            confId = paramMap.get("x-tel-premiere-conference-id").toString();
        }
        if (paramMap.containsKey("x-tel-premiere-uv-conference-number") && !"".equals(paramMap.get("x-tel-premiere-uv-conference-number").toString()) && !paramMap.get("x-tel-premiere-uv-conference-number").toString().contains("x-tel-premiere-uv-conference-number")) {
            this.globalsClass.xtelpremiereuvconfnum = paramMap.get("x-tel-premiere-uv-conference-number").toString();
        }
        confPassCode = paramMap.get("x-tel-premiere-moderator-code").toString();
        String str2 = null;
        try {
            if (!this.piaClient._cws.isOpen()) {
                logger.info("initConference opening websocket.");
                this.piaClient._cws.connect();
            }
            JsonObject jSONObject = null;
            if ("".equals(confPhone) || "".equals(confPassCode)) {
                if ("".equals(confId)) {
                    logger.error("initConferenceSession, one of x-tel-premiere-conference-number, conf phone, or conf passcode were missing.");
                    return "";
                }
                jSONObject = this.piaClient.findConferenceAsync(confId, "", "").get();
            } else {
                jSONObject = this.piaClient.findConferenceAsync("", confPassCode, confPhone).get();
            }
            logger.info("findConferenceAsync response: " + jSONObject.toJson());
            if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                logger.error("FindConference returned response code 4, invalid SID.");
                if (!"4".equals(jSONObject.get((Object)"ResultCode").toString())) throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR);
                this.invalidSID();
                jSONObject = this.piaClient.findConferenceAsync("", confPassCode, confPhone).get();
                logger.info("findConferenceAsync response: " + jSONObject.toJson());
            }
            if (jSONObject.containsKey((Object)"TollfreePhoneNumber")) {
                this.globalsClass.xtelpremiereconfnum = jSONObject.get((Object)"TollfreePhoneNumber").toString();
            }
            if (!jSONObject.containsKey((Object)"TollPhoneNumber")) return jSONObject.get((Object)"ConferenceId").toString();
            this.globalsClass.xtelpremiereuvconfnum = jSONObject.get((Object)"TollPhoneNumber").toString();
            return jSONObject.get((Object)"ConferenceId").toString();
        }
        catch (Exception exception) {
            logger.error("InitConferenceSession error.", exception);
        }
        return str2;
    }

    public void moveAllToMainConference(String paramString) throws AdaptorException {
        logger.info("moveAllToMainConference: " + paramString);
        try {
            for (TelephonyUserInfo telephonyUserInfo : this.piaClient._telephonyUsers.get(paramString)) {
                this.piaClient.moveToMainConfAsync(paramString, telephonyUserInfo.getTelephonyUserId()).get();
            }
        }
        catch (Exception exception) {
            logger.error("Error in moveAllToMainConference.", exception);
        }
    }

    public void moveUserToSubConference(String confId, String partId, String subConfId) throws AdaptorException {
        logger.info("moveUserToSubConference: " + confId + ":" + partId + ":" + subConfId);
        try {
            ArrayList<TelephonyUserInfo> list = this.piaClient._telephonyUsers.get(confId);
            if (confId.equals(subConfId) || "".equals(subConfId)) {
                for (TelephonyUserInfo tui : this.piaClient._telephonyUsers.get(confId)) {
                    logger.info("moveUserToMainConference pre: " + tui.getSubconferenceId());
                    if (!tui.getTelephonyUserId().equals(partId)) continue;
                    logger.info("moveUserToMainConference: " + confId + ":" + partId + ":" + subConfId);
                    tui.setSubconferenceId("");
                    this.piaClient.updateUserInfoAdobe(confId, tui, this.cb);
                    this.piaClient.moveToMainConfAsync(confId, partId).get();
                    int tuiIdx = 0;
                    for (TelephonyUserInfo tui1 : list) {
                        if (tui1 != null && tui != null && tui.getTelephonyUserId().equals(tui1.getTelephonyUserId())) break;
                        ++tuiIdx;
                    }
                    if (tuiIdx < list.size()) {
                        list.set(tuiIdx, tui);
                    }
                    this.piaClient._telephonyUsers.put(confId, list);
                    break;
                }
                return;
            }
            for (TelephonyUserInfo tui : this.piaClient._telephonyUsers.get(confId)) {
                if (!tui.getTelephonyUserId().equals(partId)) continue;
                logger.info("moving user: " + partId + " to subconf: " + subConfId);
                tui.setSubconferenceId(subConfId);
                this.piaClient.updateUserInfoAdobe(confId, tui, this.cb);
                this.piaClient.moveToSubConfAsync(confId, partId, subConfId).get();
                int tuiIdx = 0;
                for (TelephonyUserInfo tui1 : list) {
                    if (tui1 != null && tui != null && tui.getTelephonyUserId().equals(tui1.getTelephonyUserId())) break;
                    ++tuiIdx;
                }
                if (tuiIdx < list.size()) {
                    list.set(tuiIdx, tui);
                }
                this.piaClient._telephonyUsers.put(confId, list);
                return;
            }
        }
        catch (Exception exception) {
            logger.error("Error in moveUserToSubConference.", exception);
        }
    }

    public void muteAll(String paramString) throws AdaptorException {
        if (!Boolean.parseBoolean(((JsonObject)this.piaClient._conferences.get(paramString).get((Object)"conferenceOptions")).get((Object)"muteState").toString())) {
            try {
                this.piaClient._telephonyConferences.get(paramString).setConferenceOption(ConferenceOption.MUTE, "true");
                ((JsonObject)this.piaClient._conferences.get(paramString).get((Object)"conferenceOptions")).replace((Object)"muteState", (Object)true);
                this.piaClient.setConferenceOptionAsync(paramString, 4).get();
            }
            catch (Exception exception) {
                logger.error("muteAll mute.", exception);
            }
        } else {
            try {
                this.piaClient._telephonyConferences.get(paramString).setConferenceOption(ConferenceOption.MUTE, "false");
                ((JsonObject)this.piaClient._conferences.get(paramString).get((Object)"conferenceOptions")).replace((Object)"muteState", (Object)false);
                this.piaClient.setConferenceOptionAsync(paramString, 5).get();
            }
            catch (Exception exception) {
                logger.error("muteAll unmute.", exception);
            }
        }
    }

    public void onConnectRoomEmpty(String paramString) {
        logger.info("OnConnectRoomEmpty: " + paramString);
        this.piaClient.endConferenceAsync(paramString);
    }

    public void onConnectUserLeft(String paramString1, String paramString2) {
        logger.info("onConnectUserLeft: " + paramString1 + ":" + paramString2);
    }

    public String reconnectConference(Map<String, String> paramMap, List<TelephonyUserInfo> paramList) throws AdaptorException {
        paramMap.forEach((paramString1, paramString2) -> logger.info("reconnectConference map k,v: " + paramString1 + "," + (paramString1.contains("password") ? "XXXXX" : paramString2)));
        this.reconnectConferenceSession(paramMap.get("x-tel-premiere-conference-id"));
        return paramMap.get("x-tel-premiere-conference-id");
    }

    public void setAnnouncementOption(String paramString1, AnnouncementOption paramAnnouncementOption, String paramString2) throws AdaptorException {
        logger.info("setAnnouncementOption: " + paramString1 + ":" + paramAnnouncementOption.name() + ":" + paramString2);
    }

    public void setConferenceOption(String paramString1, ConferenceOption paramConferenceOption, String paramString2) throws AdaptorException {
        logger.info("setConferenceOption: " + paramString1 + ":" + paramConferenceOption.name() + ":" + paramString2);
        try {
            switch (paramConferenceOption) {
                case LOCK: {
                    if (Boolean.parseBoolean(paramString2)) {
                        this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.Lock.getResponseCode()).get();
                        break;
                    }
                    this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.UnLock.getResponseCode()).get();
                    break;
                }
                case MUSIC: {
                    if (Boolean.parseBoolean(paramString2)) {
                        this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.MusicOn.getResponseCode());
                        break;
                    }
                    this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.MusicOff.getResponseCode());
                    break;
                }
                case MUSIC_ON_HOLD: {
                    if (Boolean.parseBoolean(paramString2)) {
                        this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.MusicOn.getResponseCode());
                        break;
                    }
                    this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.MusicOff.getResponseCode());
                    break;
                }
                case MUTE: {
                    if (Boolean.parseBoolean(paramString2)) {
                        this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.Mute.getResponseCode()).get();
                        break;
                    }
                    this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.UnMute.getResponseCode()).get();
                    break;
                }
                case TALKER_NOTIFY: {
                    if (Boolean.parseBoolean(paramString2)) {
                        this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.TalkerNotifyOn.getResponseCode()).get();
                        break;
                    }
                    this.piaClient.setConferenceOptionAsync(paramString1, PiaOptions.PiaConfOption.TalkerNotifyOff.getResponseCode()).get();
                    break;
                }
                case MUTE_USERS_ON_ENTRY: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            logger.error("Error in setConferenceOption.", exception);
        }
    }

    public String setConferenceOption(String paramString, Integer paramInteger) {
        JsonObject jSONObject;
        block3: {
            jSONObject = null;
            try {
                jSONObject = this.piaClient.setConferenceOptionAsync(paramString, paramInteger).get();
                if ("0".equals(jSONObject.get((Object)"ResultCode").toString())) break block3;
                if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                    this.invalidSID();
                    jSONObject = this.piaClient.setConferenceOptionAsync(paramString, paramInteger).get();
                    break block3;
                }
                logger.error("Error setting conference option: " + paramInteger + " for confId: " + paramString + ". Response: " + jSONObject.toJson());
                return jSONObject.toJson();
            }
            catch (Exception exception) {
                logger.error("SetConferenceOption errror" + null != jSONObject.toJson() ? ": " + jSONObject.toJson() : ".", exception);
            }
        }
        return jSONObject.toJson();
    }

    public void setCustomConferenceOption(String paramString1, String paramString2, String paramString3) throws AdaptorException {
        logger.info("setCustomConferenceOption: " + paramString1 + ":" + paramString2 + ":" + paramString3);
    }

    public void setCustomUserOption(String paramString1, String paramString2, String paramString3, String paramString4) throws AdaptorException {
        logger.info("setCustomUserOption: " + paramString1 + ":" + paramString2 + ":" + paramString3 + ":" + paramString4);
    }

    /*
     * Unable to fully structure code
     */
    public void setUserOption(String confId, String partId, UserOption paramUserOption, String userOptionValue) throws AdaptorException {
        PGi_PIA_Adapter.logger.info("setUserOption: " + confId + ":" + partId + ":" + paramUserOption.name() + ":" + userOptionValue);
        try {
            block1 : switch (PGi_PIA_Adapter.$SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption()[paramUserOption.ordinal()]) {
                case 1: {
                    telephonyUserInfo = null;
                    if (!Boolean.parseBoolean(userOptionValue)) ** GOTO lbl17
                    for (TelephonyUserInfo telephonyUserInfo1 : this.piaClient._telephonyUsers.get(confId)) {
                        if (!partId.equals(telephonyUserInfo1.getTelephonyUserId()) || (JsonObject)((JsonObject)this.piaClient._conferences.get(confId).get((Object)"participants")).get((Object)telephonyUserInfo1.getTelephonyUserId()) == null || Boolean.parseBoolean(((JsonObject)((JsonObject)this.piaClient._conferences.get(confId).get((Object)"participants")).get((Object)telephonyUserInfo1.getTelephonyUserId())).get((Object)"muteState").toString())) continue;
                        telephonyUserInfo1.setOption(UserOption.MUTE, "true");
                        telephonyUserInfo = telephonyUserInfo1;
                        this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.Mute.getResponseCode()).get();
                        ((JsonObject)((JsonObject)this.piaClient._conferences.get(confId).get((Object)"participants")).get((Object)telephonyUserInfo1.getTelephonyUserId())).put((Object)"muteState", (Object)true);
                        ** GOTO lbl26
                    }
                    ** GOTO lbl26
lbl17:
                    // 2 sources

                    for (TelephonyUserInfo telephonyUserInfo1 : this.piaClient._telephonyUsers.get(confId)) {
                        if (!partId.equals(telephonyUserInfo1.getTelephonyUserId()) || !Boolean.parseBoolean(((JsonObject)((JsonObject)this.piaClient._conferences.get(confId).get((Object)"participants")).get((Object)telephonyUserInfo1.getTelephonyUserId())).get((Object)"muteState").toString())) continue;
                        telephonyUserInfo1.setOption(UserOption.MUTE, "false");
                        telephonyUserInfo = telephonyUserInfo1;
                        this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.UnMute.getResponseCode()).get();
                        ((JsonObject)((JsonObject)this.piaClient._conferences.get(confId).get((Object)"participants")).get((Object)telephonyUserInfo1.getTelephonyUserId())).put((Object)"muteState", (Object)false);
                        break;
                    }
lbl26:
                    // 4 sources

                    if (telephonyUserInfo != null) {
                        this.piaClient.updateUserInfoAdobe(confId, telephonyUserInfo, this.cb);
                    }
                    break;
                }
                case 2: {
                    if (Boolean.parseBoolean(userOptionValue)) {
                        this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.Hold.getResponseCode()).get();
                        break;
                    }
                    this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.UnHold.getResponseCode()).get();
                    break;
                }
                case 4: {
                    var6_11 = userOptionValue.toUpperCase();
                    tmp = -1;
                    switch (var6_11.hashCode()) {
                        case 75572: {
                            if (var6_11.equals("LOW")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 2217378: {
                            if (var6_11.equals("HIGH")) {
                                tmp = 2;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 2: {
                            this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.ListenTickUp.getResponseCode()).get();
                            break block1;
                        }
                        case 1: {
                            this.piaClient.setParticipantOptionAsync(confId, partId, PiaOptions.PiaPartOption.ListenTickDown.getResponseCode()).get();
                        }
                    }
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        catch (Exception exception) {
            PGi_PIA_Adapter.logger.error("Error in setUserOption.", exception);
        }
    }

    private void reconnectConferenceSession(String confId) {
        try {
            this.startConference(confId);
            this.cb.conferenceReconnected(confId, this.getConferenceInfo(confId), (List)this.piaClient._telephonyUsers.get(confId));
        }
        catch (Exception ex) {
            logger.error("Error reconnecting conference.", ex);
        }
    }

    public void startConference(String paramString) throws AdaptorException {
        try {
            JsonObject jSONObject = this.piaClient.watchConferenceAsync(paramString).get();
            if (jSONObject == null) {
                logger.error("Null response from watch on confId: " + paramString);
                return;
            }
            if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                this.invalidSID();
                jSONObject = this.piaClient.watchConferenceAsync(paramString).get();
            } else if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                logger.error("Watch Conference error in response code: " + jSONObject.toJson());
            }
            if (jSONObject.containsKey((Object)"ResultCode") && "0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                ConferenceInfo confInfo;
                long startTime = System.currentTimeMillis();
                long endTime = startTime + 10000L;
                while (!this.piaClient._conferences.containsKey(paramString)) {
                    if (System.currentTimeMillis() > endTime) {
                        logger.info("Start conf collection did not show conference. Returning.");
                        if (this.piaClient._conferences.containsKey(paramString)) {
                            logger.info(this.piaClient._conferences.get(paramString).toJson());
                        }
                        return;
                    }
                    Thread.sleep(1000L);
                }
                jSONObject = this.piaClient.startConferenceAsync(paramString).get();
                logger.info("start conference jSONObject: " + jSONObject.toJson());
                if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                    if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                        this.invalidSID();
                        jSONObject = this.piaClient.startConferenceAsync(paramString).get();
                    } else {
                        logger.error("Start Conference error in response code: " + jSONObject.toJson());
                        return;
                    }
                }
                logger.info("before notifying adobe connect of conference started: " + paramString);
                if (this.cb == null) {
                    logger.info("Null callback on conf start.");
                }
                if ((confInfo = this.getConferenceInfo(paramString)) == null) {
                    logger.info("null confInfo");
                } else {
                    logger.info("ConfInfo not null: " + confInfo.getConferenceId());
                }
                this.piaClient.conferenceStartedAdobe(paramString, confInfo, this.cb);
                JsonObject conf = this.piaClient._conferences.get(paramString);
                logger.info("Start conf conf obj before put: " + conf.toJson());
                conf.put((Object)"active", (Object)true);
                logger.info("Start conf conf obj after put: " + conf.toJson());
                this.piaClient.updateConfCollection(paramString, conf, null);
                logger.info("Start conf _conferences after put: " + this.piaClient._conferences.get(paramString).toJson());
            }
        }
        catch (Exception exception) {
            logger.error(exception.toString());
        }
    }

    public void startRecording(String confId, String fileName) throws AdaptorException {
        JsonObject conf = this.piaClient._conferences.get(confId);
        if (conf == null) {
            logger.info("Conf does not exist in collection, returning from StartRecording");
            return;
        }
        logger.info("startRecording conf: " + conf.toJson());
        JsonObject confOptions = (JsonObject)conf.get((Object)"conferenceOptions");
        try {
            JsonObject startRecRes;
            if (confOptions != null && confOptions.containsKey((Object)"recordingState") && Boolean.parseBoolean(confOptions.get((Object)"recordingState").toString())) {
                logger.info("Recording was already in progress, stopping it to restart");
                this.stopRecording(confId, TelephonyAdaptor.StopRecordingCause.HOST_REQUEST);
                Thread.sleep(2000L);
            }
            if (!"0".equals((startRecRes = this.piaClient.startRecordingAsync(this.piaClient.httpClient.getSubId(), this.piaClient.httpClient.getSubPw(), this.piaClient.httpClient.getWebId(), this.piaClient.httpClient.getWebPw(), fileName, "mp3", true, true, confId).get()).get((Object)"ResultCode").toString())) {
                if ("4".equals(startRecRes.get((Object)"ResultCode").toString())) {
                    this.invalidSID();
                    startRecRes = this.piaClient.startRecordingAsync(this.piaClient.httpClient.getSubId(), this.piaClient.httpClient.getSubPw(), this.piaClient.httpClient.getWebId(), this.piaClient.httpClient.getWebPw(), fileName, "mp3", true, true, confId).get();
                } else {
                    logger.error("Error starting recording for confId: " + confId + ". Response: " + startRecRes.toJson());
                }
            }
            this.piaClient.recordingStartedAdobe(confId, String.valueOf(this.globalsClass.downloadURL) + this.piaClient.httpClient.getWebId() + "/" + fileName, " ", this.cb);
            logger.info("Recording started: confId=" + confId + ", fileName=" + fileName);
        }
        catch (Exception ex) {
            logger.fatal("Error while starting recording", ex);
            throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR, "Error while starting recording", (Throwable)ex);
        }
    }

    public void stopRecording(String confId, TelephonyAdaptor.StopRecordingCause stopRecordingCause) throws AdaptorException {
        JsonObject conf = this.piaClient._conferences.get(confId);
        if (conf == null) {
            logger.info("Conf does not exist in collection, returning from StopRecording");
            return;
        }
        JsonObject confOptions = (JsonObject)conf.get((Object)"conferenceOptions");
        try {
            JsonObject stopRecRes;
            if (confOptions != null && confOptions.containsKey((Object)"recordingState") && !Boolean.parseBoolean(confOptions.get((Object)"recordingState").toString())) {
                logger.info("Recording already stopped.");
            }
            if (!"0".equals((stopRecRes = this.piaClient.stopRecordingAsync(confId, true).get()).get((Object)"ResultCode").toString())) {
                if ("4".equals(stopRecRes.get((Object)"ResultCode").toString())) {
                    this.invalidSID();
                    stopRecRes = this.piaClient.stopRecordingAsync(confId, true).get();
                } else {
                    logger.error("Error stopping recording for confId: " + confId + ". Response: " + stopRecRes.toJson());
                }
            }
            this.piaClient.recordingStoppedAdobe(confId, this.cb);
            logger.info("Recording stopped: confId=" + confId + ", stopRecordingCause=" + stopRecordingCause);
        }
        catch (Exception ex) {
            logger.fatal("Error while stopping recording", ex);
            throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR, "Error while stopping recording", (Throwable)ex);
        }
    }

    protected void invalidSID() {
        logger.info("Invalid SID. Attempting to get a new SID.");
        try {
            logger.info("invalidSID invalid SID. Retrying subscribe.");
            if (this.piaClient != null && this.piaClient._cws != null) {
                this.piaClient._cws.destroy();
            }
            JsonObject jSONObject = this.piaClient.subscribeToPiaAsync(this.piaClient.httpClient.getSubId(), this.piaClient.httpClient.getSubPw(), this.piaClient.httpClient.getSubToken(), this.piaClient.httpClient.getWebId(), this.piaClient.httpClient.getWebPw(), this.piaClient.httpClient.getUriRest()).get();
            this.piaClient._sessionId = jSONObject.get((Object)"SessionId").toString();
            this.piaClient._cws = new ClientWebSocket(this.piaClient, this.piaClient.httpClient.getUriWebSocket(), this.piaClient._sessionId, this.globalsClass, logger);
        }
        catch (Exception exception) {
            logger.error(null, exception);
        }
    }

    public List<ConferenceNumber> validateTelephonyProfile(Map<String, String> paramMap) throws AdaptorException {
        try {
            String str1 = null;
            String str2 = null;
            String valPhone = "";
            String valPassCode = "";
            ArrayList<ConferenceNumber> arrayList = new ArrayList<ConferenceNumber>();
            for (String str : paramMap.keySet()) {
                String paramValue = "XXXXXXXX";
                if (!str.toUpperCase().contains("PASSWORD") && !str.toUpperCase().contains("PW")) {
                    paramValue = paramMap.get(str).toString();
                }
                logger.info("validateTelephonyProfile telephonyProfileInfo: " + str + ":" + paramValue);
                if (str.contains("x-tel-premiere-moderator-code")) {
                    valPassCode = paramMap.get(str).toString();
                }
                if (str.contains("x-tel-premiere-conference-number")) {
                    valPhone = paramMap.get(str).toString();
                }
                if ("x-tel-premiere-user-id".equals(str)) {
                    str1 = paramMap.get(str).toString();
                }
                if (!"x-tel-premiere-password".equals(str)) continue;
                str2 = paramMap.get(str).toString();
            }
            ValidateException validateException = new ValidateException(FailureCode.TELEPHONY_INVALID_FIELDS);
            ArrayList<String> arrayList1 = new ArrayList<String>();
            if (this.globalsClass.PREMIERE_ID == null) {
                arrayList1.add(this.globalsClass.PREMIERE_ID);
            }
            if (this.globalsClass.PREMIERE_PASSWORD == null) {
                arrayList1.add(this.globalsClass.PREMIERE_PASSWORD);
            }
            if (arrayList1.size() > 0) {
                validateException.setInvalidFields(arrayList1);
                throw validateException;
            }
            JsonObject jSONObject = null;
            JsonObject str3 = new JsonObject();
            JsonObject str4 = new JsonObject();
            JsonObject resObj = new JsonObject();
            if (!("".equals(valPassCode) || "".equals(valPhone) || "x-tel-premiere-conference-number".equals(valPhone.replace("{", "").replace("}", "")) || "".equals(valPhone.replace("{", "").replace("}", "")))) {
                str3 = this.piaClient.findConferenceAsync("", valPassCode, valPhone).get();
                if (!"".equals(str3) && str3 != null && !"0".equals(str3.get((Object)"ResultCode").toString())) {
                    if ("4".equals(str3.get((Object)"ResultCode").toString())) {
                        this.invalidSID();
                        str3 = this.piaClient.findConferenceAsync("", valPassCode, valPhone).get();
                    } else {
                        logger.error("Error finding conference, result code: " + str3.get((Object)"ResultCode").toString());
                        throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR);
                    }
                }
                jSONObject = str3;
                str4 = this.piaClient.reservationBy(this.globalsClass.webId, this.globalsClass.webPassword, str1, str2, valPassCode, valPassCode).get();
                resObj = (JsonObject)((JsonArray)((JsonObject)str4.get((Object)"ByResult")).get((Object)"SearchResults")).get(0);
            } else {
                str4 = this.piaClient.reservationBy(this.globalsClass.webId, this.globalsClass.webPassword, str1, str2, valPassCode, valPassCode).get();
                resObj = (JsonObject)((JsonArray)((JsonObject)str4.get((Object)"ByResult")).get((Object)"SearchResults")).get(0);
                if (!"".equals(resObj)) {
                    logger.info("ReservationDetail: " + resObj.toJson());
                    if (!resObj.containsKey((Object)"ReservationDetail")) {
                        logger.error("Error validating profile. Reservation response did not contain reservation detail. Reservation response: " + resObj.toJson());
                        throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR, "Error validating profile. Reservation response did not contain reservation detail. Reservation response: " + resObj.toJson());
                    }
                    valPhone = ((JsonObject)resObj.get((Object)"ReservationDetail")).get((Object)"PrimaryAccessNumber").toString();
                    valPassCode = ((JsonObject)resObj.get((Object)"PassCodes")).get((Object)"ParticipantPassCode").toString();
                    str3 = this.piaClient.findConferenceAsync("", valPassCode, valPhone).get();
                    if (!"".equals(str3) && str3 != null) {
                        if ("4".equals(str3.get((Object)"ResultCode").toString())) {
                            this.invalidSID();
                            str3 = this.piaClient.findConferenceAsync("", valPassCode, valPhone).get();
                        } else if (!"0".equals(str3.get((Object)"ResultCode").toString())) {
                            logger.error("Error finding conference, result code: " + str3.get((Object)"ResultCode").toString());
                            throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR);
                        }
                        jSONObject = str3;
                    }
                }
            }
            String str5 = jSONObject.get((Object)"PgsErrorCode").toString();
            if (!str5.equals("0")) {
                if (str5.equals("4043") || str5.equals("4044") || str5.equals("4003")) {
                    arrayList1.add(this.globalsClass.MODERATOR_CODE);
                } else {
                    arrayList1.add(this.globalsClass.PREMIERE_ID);
                    arrayList1.add(this.globalsClass.PREMIERE_PASSWORD);
                }
            }
            if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                    this.invalidSID();
                    jSONObject = str3 = this.piaClient.findConferenceAsync("", valPassCode, valPhone).get();
                } else {
                    logger.error("Error from find conference while validating telephony conference. Error code: " + jSONObject.get((Object)"ResultCode").toString());
                    throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR);
                }
            }
            if (arrayList1.size() > 0) {
                validateException.setInvalidFields(arrayList1);
                throw validateException;
            }
            Map<String, String> map = Collections.emptyMap();
            if (resObj != null && !"".equals(resObj) && resObj.containsKey((Object)"ReservationDetail")) {
                map = this.reservationDetailsToMap(resObj);
            }
            paramMap.put(this.globalsClass.CONF_ID, jSONObject.get((Object)"ConferenceId").toString());
            paramMap.put(this.globalsClass.PARTICIPANT_CODE, valPassCode);
            List<Object> list1 = new ArrayList();
            List<Object> list2 = new ArrayList();
            ConfNumber confNumber = null;
            String str6 = null;
            if (!this.globalsClass.isEMEA) {
                if (!((jSONObject.containsKey((Object)"TollPhoneNumber") || jSONObject.containsKey((Object)"TollfreePhoneNumber")) && (jSONObject.containsKey((Object)"TollPhoneNumber") && !"".equals(jSONObject.get((Object)"TollPhoneNumber").toString()) || jSONObject.containsKey((Object)"TollfreePhoneNumber") && !"".equals(jSONObject.get((Object)"TollfreePhoneNumber").toString())) && resObj.containsKey((Object)"PhoneNumbers"))) {
                    logger.error("Error while validating profile. Reservation response did not contain phone numbers for conference.");
                    throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR, "Error while validating profile. Reservation response did not contain phone numbers for conference.");
                }
                list1 = this.getConfNums(resObj, this.globalsClass.countryCodes, this.globalsClass.numberTypes, this.globalsClass.maxNumbersPerClient);
                list2 = this.getConfNums(resObj, new String[]{this.globalsClass.uvNumberCountryCode}, new String[]{this.globalsClass.uvNumberType}, 1);
                paramMap.put(this.globalsClass.CONFERENCE_NUMBER, jSONObject.get((Object)"TollfreePhoneNumber").toString());
                paramMap.put(this.globalsClass.DEFAULT_CONFERENCE_NUMBER, jSONObject.get((Object)"TollfreePhoneNumber").toString());
            }
            if (list2.size() > 0) {
                confNumber = (ConfNumber)((Object)list2.get(0));
                str6 = confNumber.getConfNumber();
                logger.info("Validate Telephony Profile UV number: " + str6);
            }
            paramMap.put(this.globalsClass.UV_CONFERENCE_NUMBER, str6);
            if (str6 == null || "".equals(str6)) {
                logger.warn("Conference number not set for UV");
            } else if (str6.contains("(0)")) {
                str6 = str6.replace("(0)", "");
                paramMap.put(this.globalsClass.UV_CONFERENCE_NUMBER, str6);
            }
            if (this.globalsClass.moreInfoURLEnabled && list1.size() > 0) {
                Objects.requireNonNull(this.globalsClass);
                paramMap.put("x-tel-premiere-company-url", this.getMoreInfoUrl(paramMap, map, ((ConfNumber)((Object)list1.get(0))).getConfNumber()));
            }
            list1.forEach(paramConfNumber -> {
                boolean bl = arrayList.add(paramConfNumber.copy(true));
            });
            paramMap.forEach((k, v) -> logger.info("Validate Telephony Profile telephony profile key, value: " + k + ", " + v));
            return arrayList;
        }
        catch (Exception exception) {
            logger.fatal("Error while validating profile", exception);
            if (exception instanceof ValidateException) {
                throw (ValidateException)exception;
            }
            if (exception instanceof AdaptorException) {
                throw (AdaptorException)exception;
            }
            throw new AdaptorException(FailureCode.TELEPHONY_UNKNOWN_ERROR, "Error while validating profile", (Throwable)exception);
        }
    }

    private List<ConfNumber> getConfNums(JsonObject reservation, String[] countryCodes, String[] numberTypes, int maxNums) {
        ArrayList<ConfNumber> arrayList;
        block7: {
            arrayList = new ArrayList<ConfNumber>();
            ArrayList arrayList1 = new ArrayList();
            try {
                ((JsonArray)reservation.get((Object)"PhoneNumbers")).forEach(paramObject -> {
                    JsonObject jSONObject = (JsonObject)paramObject;
                    NumberType numberType = NumberType.valueOfCustom((String)jSONObject.get((Object)"PhoneType").toString());
                    ConfNumber confNumber = null;
                    String str1 = jSONObject.get((Object)"Number").toString();
                    String str2 = jSONObject.get((Object)"LocationCode").toString().replace("USACOS", "USAUSA").replace("USATLF", "USAUSA");
                    if (str2 == null || str2.isEmpty()) {
                        str2 = "USAUSA";
                    }
                    if (!arrayList1.contains((Object)(confNumber = new ConfNumber(str1, str2, numberType, this.IsTollFreeNumberType(numberType))))) {
                        arrayList1.add(confNumber);
                    }
                });
                if (countryCodes.equals(null)) break block7;
                block2: for (ConfNumber confNumber : arrayList1) {
                    String[] stringArray = countryCodes;
                    int n = countryCodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        Pattern pattern = Pattern.compile(str);
                        Matcher matcher = pattern.matcher(confNumber.getLocation());
                        if (matcher.find()) {
                            String[] stringArray2 = numberTypes;
                            int n3 = numberTypes.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String str1 = stringArray2[n4];
                                logger.info("getConfNums confNum.getNumberType() - NumberType.valueOfCustom(numberType): " + confNumber.getNumberType() + "-" + NumberType.valueOfCustom((String)str1));
                                if (confNumber.getNumberType().equals((Object)NumberType.valueOfCustom((String)str1))) {
                                    arrayList.add(confNumber);
                                }
                                ++n4;
                            }
                            continue block2;
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                logger.info("getConfNums error.", exception);
            }
        }
        return arrayList;
    }

    private Boolean IsTollFreeNumberType(NumberType paramNumberType) {
        switch (paramNumberType) {
            case TOLL_FREE: 
            case NATIONAL_FREE_PHONE: 
            case UNIVERSAL_FREE_PHONE: 
            case INTERNATIONAL_TOLL_FREE: 
            case NATIONAL_TOLL_FREE: 
            case NATIONAL_MOBILE_TOLL_FREE: 
            case INTERNATIONAL_TOLL_FREE_MOBILE: {
                return true;
            }
            case CARRIER_BILLED: {
                break;
            }
            case LOCAL: {
                break;
            }
            case LO_CALL: {
                break;
            }
            case SHARE_TARIFF: {
                break;
            }
            case TIE: {
                break;
            }
            case TOLL: {
                break;
            }
            case VOIP_SIP: {
                break;
            }
        }
        return false;
    }

    private Map<String, String> reservationDetailsToMap(JsonObject paramJSONObject) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("telephony-id", paramJSONObject.get((Object)"ConfId").toString());
        hashMap.put("participant-passcode", ((JsonObject)paramJSONObject.get((Object)"PassCodes")).get((Object)"ParticipantPassCode").toString());
        hashMap.put("moderator-passcode", ((JsonObject)paramJSONObject.get((Object)"PassCodes")).get((Object)"ModeratorPassCode").toString());
        hashMap.put("listen-only-passcode", ((JsonObject)paramJSONObject.get((Object)"PassCodes")).get((Object)"ListenOnlyPassCode").toString());
        return hashMap;
    }

    private static AdaptorField createPremiereField(String paramString1, String paramString2, boolean paramBoolean1, AdaptorField.UIType paramUIType, boolean paramBoolean2, AdaptorField.InMeetingDisplayLevel paramInMeetingDisplayLevel) {
        AdaptorField adaptorField = new AdaptorField(paramString2, paramString1, paramUIType, paramInMeetingDisplayLevel, paramBoolean2, paramBoolean1);
        return adaptorField;
    }

    private String getMoreInfoUrl(Map<String, String> paramMap1, Map<String, String> paramMap2, String paramString) {
        int i;
        String str = this.globalsClass.moreInfoURL;
        while ((i = str.indexOf("{")) > -1) {
            int j = str.indexOf("}");
            String str1 = str.substring(i + 1, j);
            String str2 = "";
            if (str1.contains("x-tel-premiere-moderator-code")) {
                str2 = paramMap1.get(this.globalsClass.MODERATOR_CODE).trim();
            }
            if (str1.contains("x-tel-premiere-user-id")) {
                str2 = paramMap1.get(this.globalsClass.PREMIERE_ID).trim();
            }
            if (str1.contains("x-tel-premiere-participant-code")) {
                str2 = paramMap2.get("participant-passcode");
            }
            if (str1.contains("x-tel-premiere-conference-number")) {
                str2 = paramString;
            }
            str = str.replaceFirst("\\{" + str1 + "\\}", str2 != null ? str2 : "");
        }
        return str;
    }

    public String adaptorCallback(Map<String, String[]> paramMap) {
        paramMap.forEach((k, v) -> logger.info("adaptor Callback: " + k + " : " + v));
        return null;
    }

    public void destroyAdaptor() {
    }

    public List<DialInStep> getDialInSteps() throws AdaptorException {
        return null;
    }

    public Map<String, Map<String, String>> getLocalizationStrings() throws AdaptorException {
        return null;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption() {
        if ($SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption != null) {
            return $SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption;
        }
        int[] nArray = new int[UserOption.values().length];
        try {
            nArray[UserOption.HOLD.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserOption.MIC_LEVEL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserOption.MUTE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[UserOption.PAUSE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$adobe$connectpro$telephony$adaptor$UserOption = nArray;
        return nArray;
    }
}

