/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter;

import com.adobe.connectpro.telephony.adaptor.ConferenceInfo;
import com.adobe.connectpro.telephony.adaptor.ConferenceOption;
import com.adobe.connectpro.telephony.adaptor.FailureCode;
import com.adobe.connectpro.telephony.adaptor.TelephonyCallback;
import com.adobe.connectpro.telephony.adaptor.TelephonyUserInfo;
import com.adobe.connectpro.telephony.adaptor.UserOption;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ClientCredentialType;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ClientWebSocket;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.Globals;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.HttpClient;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PGiLogger;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PGi_PIA_Adapter;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PiaClientInterface;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.PiaEvents;
import com.macromedia.breeze_ext.PGi_PIA_AdobeConnect_Adapter.ResponseTypes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public class PiaClientClass
implements PiaClientInterface {
    public PiaEvents piaEvents;
    public final ConcurrentHashMap<String, JsonObject> _conferences;
    protected ClientWebSocket _cws;
    protected HttpClient httpClient;
    protected ConcurrentHashMap<String, ArrayList<TelephonyUserInfo>> _telephonyUsers;
    protected ConcurrentHashMap<String, ConferenceInfo> _telephonyConferences;
    protected PGiLogger logger;
    private ConcurrentHashMap<String, LocalDateTime> _talkerMap = new ConcurrentHashMap();
    protected TelephonyCallback _cb;
    public String _sessionId;
    private final ClientCredentialType _clientCredentialType;
    private Globals _globalsClass;
    private final PGi_PIA_Adapter _adapter;

    public PiaClientClass(ClientCredentialType paramClientCredentialType, String paramString, TelephonyCallback paramTelephonyCallback, Globals paramGlobals, PGi_PIA_Adapter adapter) {
        this._globalsClass = paramGlobals;
        JsonObject jSONObject = new JsonObject();
        String str = "";
        this._cb = paramTelephonyCallback;
        this._conferences = new ConcurrentHashMap();
        this._telephonyConferences = new ConcurrentHashMap();
        this._telephonyUsers = new ConcurrentHashMap();
        this._clientCredentialType = paramClientCredentialType;
        this._adapter = adapter;
        this.logger = PGi_PIA_Adapter.logger;
        this.httpClient = new HttpClient(this._conferences, this._clientCredentialType, paramGlobals, this.logger);
        this.logger.setHttpClient(this.httpClient);
        while ("".equals(this.httpClient.getSessionId())) {
        }
        try {
            this._sessionId = this.httpClient.getSessionId();
            jSONObject = this.httpClient.getPiaVersion(this.httpClient.getUriRest(), this._sessionId).get();
            String piaVersion = jSONObject.get((Object)"Version").toString();
            this.logger.info("PIA Version: " + piaVersion);
            this._cws = new ClientWebSocket(this, this.httpClient.getUriWebSocket(), this._sessionId, paramGlobals, this.logger);
        }
        catch (Exception exception) {
            this.logger.error("json response: " + str, exception);
        }
    }

    public void conferenceEndedAdobe(final String confId, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Conference Ended error.", exception);
                }
                try {
                    if (_cb != null && confId != null && !"".equals(confId)) {
                        _cb.conferenceEnded(confId);
                    }
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Conference Ended error.", exception);
                }
            }
        }.start();
    }

    public void conferenceStartedAdobe(final String confId, final ConferenceInfo confInfo, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                try {
                    while (!PiaClientClass.this._telephonyConferences.containsKey(confId)) {
                        PiaClientClass.this.logger.info("Waiting to send conference start to ACS until conf id in collection.");
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.info("Conference Start sleep error.", exception);
                    _cb.startConferenceFailed(confId, FailureCode.TELEPHONY_UNKNOWN_ERROR);
                }
                try {
                    _cb.conferenceStarted(confId, confInfo, null);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error starting adobe conf.", exception);
                }
            }
        }.start();
    }

    public void recordingStartedAdobe(final String confId, final String fileType, final String fileName, TelephonyCallback cb) {
        final TelephonyCallback _cb = cb;
        new Thread(){

            @Override
            public void run() {
                try {
                    if (!(_cb == null || "".equals(confId) || "".equals(fileType) || "".equals(fileName))) {
                        _cb.audioRecordingStarted(confId, fileType, fileName);
                        PiaClientClass.this.logger.info("recordingStartedAdobe completed: " + confId + ":" + fileType + ":" + fileName);
                    }
                }
                catch (Exception ex) {
                    PiaClientClass.this.logger.error("Error sending recording started to callback.", ex);
                }
            }
        }.start();
    }

    public void recordingStoppedAdobe(final String confId, TelephonyCallback cb) {
        final TelephonyCallback _cb = cb;
        new Thread(){

            @Override
            public void run() {
                try {
                    if (_cb != null && !"".equals(confId)) {
                        _cb.audioRecordingStopped(confId);
                        PiaClientClass.this.logger.info("recordingStoppedAdobe completed: " + confId);
                    }
                }
                catch (Exception ex) {
                    PiaClientClass.this.logger.error("Error sending recording stopped to callback.", ex);
                }
            }
        }.start();
    }

    public void updateConfAdobe(final String confId, final ConferenceInfo confInfo, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe conference info.", exception);
                }
                try {
                    if (_cb != null && confId != null && !"".equals(confId) && confInfo != null) {
                        _cb.conferenceInfoUpdated(confId, confInfo);
                    }
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe conf info.", exception);
                }
            }
        }.start();
    }

    public void updateUserInfoAdobe(final String confId, final TelephonyUserInfo userInfo, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe user info.", exception);
                }
                try {
                    if (confId != null && !"".equals(confId) && userInfo != null) {
                        _cb.userInfoUpdated(confId, userInfo);
                    }
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe user info.", exception);
                }
            }
        }.start();
    }

    public void updateUserInfoAdobe(final String confId, final List<TelephonyUserInfo> userInfo, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe user info.", exception);
                }
                try {
                    _cb.userInfoUpdated(confId, userInfo);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error updating adobe user info.", exception);
                }
            }
        }.start();
    }

    public void userOnlineAdobe(final String confId, final TelephonyUserInfo userInfo, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                while (!PiaClientClass.this._telephonyUsers.containsKey(confId)) {
                    PiaClientClass.this.logger.info("User Online sleeping while waiting for users collection.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        PiaClientClass.this.logger.error("userOnlineAdobe error.", exception);
                    }
                }
                try {
                    _cb.userOnline(confId, userInfo);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error setting adobe user online.", exception);
                }
            }
        }.start();
    }

    public void userOfflineAdobe(final String confId, final String partId, TelephonyCallback paramTelephonyCallback) {
        final TelephonyCallback _cb = paramTelephonyCallback;
        new Thread(){

            @Override
            public void run() {
                while (!PiaClientClass.this._telephonyUsers.containsKey(confId)) {
                    PiaClientClass.this.logger.info("User Offline sleeping while waiting for users collection.");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        PiaClientClass.this.logger.error("userOfflineAdobe error.", exception);
                    }
                }
                try {
                    Thread.sleep(1000L);
                    _cb.userOffline(confId, partId);
                }
                catch (Exception exception) {
                    PiaClientClass.this.logger.error("Error setting adobe user offline.", exception);
                }
            }
        }.start();
    }

    public void processEvent(String paramString) {
        block103: {
            try {
                JsonObject jSONObject4;
                JsonObject jSONObject;
                boolean newConfInfo;
                block102: {
                    newConfInfo = true;
                    jSONObject = new JsonObject();
                    jSONObject4 = new JsonObject();
                    try {
                        if (paramString != null && !"".equals(paramString)) {
                            this.logger.info("event not null and not blank: " + paramString);
                            Object parsedObj = Jsoner.deserialize((String)paramString);
                            jSONObject = (JsonObject)parsedObj;
                            break block102;
                        }
                        this.logger.info("Received null event.");
                        return;
                    }
                    catch (JsonException parseException) {
                        this.logger.info(" ****** position" + parseException.getPosition());
                        this.logger.info(paramString);
                        this.logger.error("Parse Exception", parseException);
                        return;
                    }
                    catch (Exception exception) {
                        this.logger.error("processEvent error parsing string message to JSON: " + paramString, exception);
                        return;
                    }
                }
                if (jSONObject.containsKey((Object)"command")) {
                    return;
                }
                this.logger.info("process Event: " + paramString);
                if (jSONObject.containsKey((Object)"Status") && "4".equals(jSONObject.get((Object)"Status").toString())) {
                    this.logger.info("Invalid SID. Attempting to get a new SID.");
                    String[] arrayOfString = (String[])((ConcurrentHashMap.CollectionView)((Object)this._conferences.keySet())).toArray();
                    try {
                        this.logger.info("proceessEvent invalid SID. Retrying subscribe.");
                        this.httpClient.removeConferenceWatchesAsync(arrayOfString, this.httpClient.getUriRest(), this._sessionId);
                        JsonObject jSONObject1 = this.httpClient.subscribeToPiaAsync(this.httpClient.getSubId(), this.httpClient.getSubPw(), this.httpClient.getSubToken(), this.httpClient.getWebId(), this.httpClient.getWebPw(), this.httpClient.getUriRest()).get();
                        this._sessionId = jSONObject1.get((Object)"SessionId").toString();
                        this._cws = new ClientWebSocket(this, this.httpClient.getUriWebSocket(), this._sessionId, this._globalsClass, this.logger);
                        String[] stringArray = arrayOfString;
                        int n = arrayOfString.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str1 = stringArray[n2];
                            this.httpClient.watchConferenceAsync(str1, this.httpClient.getUriRest(), this._sessionId);
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error(null, exception);
                    }
                }
                if (!jSONObject.containsKey((Object)"MsgType")) break block103;
                String str = jSONObject.get((Object)"MsgType").toString();
                JsonObject jSONObject1 = null;
                if (!this._conferences.containsKey(jSONObject.get((Object)"ConfID").toString()) && !this._telephonyConferences.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                    try {
                        if ("confinfo".equals(str) || "confstate".equals(str)) {
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject, null);
                        }
                        long startTime = System.currentTimeMillis();
                        long endTime = startTime + 10000L;
                        while (!this._conferences.containsKey(jSONObject.get((Object)"ConfID").toString()) && !this._telephonyConferences.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                            if (System.currentTimeMillis() <= endTime) continue;
                            this.logger.warn("processEvent waiting for conference collection to populate, conference did not appear after 10 seconds. Returning.");
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.logger.error("processEvent error while retrieving _conf", exception);
                    }
                }
                jSONObject1 = this._conferences.get(jSONObject.get((Object)"ConfID").toString());
                JsonObject jSONObject2 = new JsonObject();
                this.logger.info("jsonobject1: " + jSONObject1.toJson());
                if (jSONObject1.containsKey((Object)"conferenceOptions")) {
                    jSONObject2 = (JsonObject)jSONObject1.get((Object)"conferenceOptions");
                    this.logger.info("jsonobject2: " + jSONObject2.toJson());
                }
                JsonObject jSONObject3 = this.mapAndTranslateMessage(jSONObject, ResponseTypes.PiaPollMsgType.valueOf(str));
                this.logger.info("jsonobject: " + jSONObject.toJson());
                this.logger.info("jsonobject3: " + jSONObject3.toJson());
                switch (ResponseTypes.PiaPollMsgType.valueOf(str)) {
                    case confinfo: 
                    case confstate: {
                        ConferenceInfo conferenceInfo = null;
                        if (!this._telephonyConferences.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                            conferenceInfo = new ConferenceInfo(jSONObject.get((Object)"ConfID").toString());
                            conferenceInfo.setConferenceId(jSONObject.get((Object)"ConfID").toString());
                            this.logger.info("ProcessEvent new confinfo: " + conferenceInfo.getConferenceId());
                        } else {
                            conferenceInfo = this._telephonyConferences.get(jSONObject.get((Object)"ConfID").toString());
                            this.logger.info("ProcessEvent existing confinfo: " + conferenceInfo.getConferenceId());
                        }
                        if (jSONObject1 != null && jSONObject1.containsKey((Object)"active") && !Boolean.parseBoolean(jSONObject1.get((Object)"active").toString()) && jSONObject != null && !jSONObject.isEmpty() && Boolean.parseBoolean(jSONObject.get((Object)"Active").toString())) {
                            this.logger.info("conf message triggered conference started and update conf collection: " + jSONObject.toJson());
                            this.logger.info("Signalling set talker.");
                            jSONObject = (JsonObject)Jsoner.deserialize((String)this._adapter.setConferenceOption(jSONObject.get((Object)"ConfID").toString(), 6));
                            if (!"0".equals(jSONObject.get((Object)"ResultCode").toString())) {
                                if ("4".equals(jSONObject.get((Object)"ResultCode").toString())) {
                                    this._adapter.invalidSID();
                                    jSONObject = (JsonObject)Jsoner.deserialize((String)this._adapter.setConferenceOption(jSONObject.get((Object)"ConfID").toString(), 6));
                                } else {
                                    this.logger.error("Set Talker notify error in response code, non-fatal: " + jSONObject.get((Object)"ResultCode").toString());
                                }
                            }
                        }
                        if (jSONObject1 != null && jSONObject1.containsKey((Object)"active") && Boolean.parseBoolean(jSONObject1.get((Object)"active").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"active") && !Boolean.parseBoolean(jSONObject.get((Object)"Active").toString())) {
                            this.logger.info("conf message triggered conference ended adobe and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conference ended adobe and update conf collection: " + jSONObject3.toJson());
                            this.conferenceEndedAdobe(jSONObject.get((Object)"ConfID").toString(), this._cb);
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                            this._conferences.remove(jSONObject.get((Object)"ConfID").toString());
                            this._telephonyConferences.remove(jSONObject.get((Object)"ConfID").toString());
                            this._telephonyUsers.remove(jSONObject.get((Object)"ConfID").toString());
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"muteState") && !Boolean.parseBoolean(jSONObject2.get((Object)"muteState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"ConfMute") && Boolean.parseBoolean(jSONObject.get((Object)"ConfMute").toString())) {
                            this.logger.info("conf message triggered conf mute true and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered cconf mute true and update conf collection: " + jSONObject3.toJson());
                            conferenceInfo.setConferenceOption(ConferenceOption.MUTE, "true");
                            for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                telephonyUserInfo1.setOption(UserOption.MUTE, "true");
                                this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                            }
                            jSONObject2.replace((Object)"muteState", (Object)true);
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"muteState") && Boolean.parseBoolean(jSONObject2.get((Object)"muteState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"ConfMute") && !Boolean.parseBoolean(jSONObject.get((Object)"ConfMute").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.MUTE, "false");
                            this.logger.info("conf message triggered conf mute false and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered cconf mute false and update conf collection: " + jSONObject3.toJson());
                            for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                telephonyUserInfo1.setOption(UserOption.MUTE, "false");
                                this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                            }
                            jSONObject2.replace((Object)"muteState", (Object)false);
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"lock") && !Boolean.parseBoolean(jSONObject2.get((Object)"lock").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"Locked") && Boolean.parseBoolean(jSONObject.get((Object)"Locked").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.LOCK, "true");
                            this.logger.info("ProcessEvent locking conf: " + conferenceInfo.getConferenceOption(ConferenceOption.LOCK));
                            this.logger.info("conf message triggered conf lock and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf lock and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"lock") && Boolean.parseBoolean(jSONObject2.get((Object)"lock").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"Locked") && !Boolean.parseBoolean(jSONObject.get((Object)"Locked").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.LOCK, "false");
                            this.logger.info("ProcessEvent unlocking conf: " + conferenceInfo.getConferenceOption(ConferenceOption.LOCK));
                            this.logger.info("conf message triggered conf unlock and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf unlock and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"musicState") && !Boolean.parseBoolean(jSONObject2.get((Object)"musicState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"MusicOn") && Boolean.parseBoolean(jSONObject.get((Object)"MusicOn").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.MUSIC_ON_HOLD, "true");
                            this.logger.info("ProcessEvent MOH conf: " + conferenceInfo.getConferenceOption(ConferenceOption.MUSIC_ON_HOLD));
                            this.logger.info("conf message triggered conf moh true and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf moh true and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"musicState") && Boolean.parseBoolean(jSONObject2.get((Object)"musicState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"MusicOn") && !Boolean.parseBoolean(jSONObject.get((Object)"MusicOn").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.MUSIC_ON_HOLD, "false");
                            this.logger.info("ProcessEvent unset MOH conf: " + conferenceInfo.getConferenceOption(ConferenceOption.MUSIC_ON_HOLD));
                            this.logger.info("conf message triggered conf moh false and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf moh false and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"recordingState") && !Boolean.parseBoolean(jSONObject2.get((Object)"recordingState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"Recording") && Boolean.parseBoolean(jSONObject.get((Object)"Recording").toString()) && !"".equals(jSONObject.get((Object)"RecFileName").toString())) {
                            this._cb.audioRecordingStarted(jSONObject.get((Object)"ConfID").toString(), jSONObject.get((Object)"RecFileName").toString(), "");
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("file-name", jSONObject.get((Object)"RecFileName").toString());
                            hashMap.put("type", "start");
                            this._cb.sendCustomMessage(jSONObject.get((Object)"ConfID").toString(), new String[0], new TelephonyUserInfo.UserType[0], "recording-update", hashMap);
                            this.logger.info("ProcessEvent recording conf");
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"recordingState") && Boolean.parseBoolean(jSONObject2.get((Object)"recordingState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"Recording") && !Boolean.parseBoolean(jSONObject.get((Object)"Recording").toString())) {
                            this._cb.audioRecordingStopped(jSONObject.get((Object)"ConfID").toString());
                            this.logger.info("ProcessEvent stop recording conf");
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"talkerNotifyState") && !Boolean.parseBoolean(jSONObject2.get((Object)"talkerNotifyState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"TalkerNotify") && Boolean.parseBoolean(jSONObject.get((Object)"TalkerNotify").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.TALKER_NOTIFY, "true");
                            this.logger.info("ProcessEvent set talker conf");
                            this.logger.info("conf message triggered conf talker true and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf talker true and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (jSONObject2 != null && jSONObject2.containsKey((Object)"talkerNotifyState") && Boolean.parseBoolean(jSONObject2.get((Object)"talkerNotifyState").toString()) && jSONObject != null && !jSONObject.isEmpty() && jSONObject.containsKey((Object)"TalkerNotify") && !Boolean.parseBoolean(jSONObject.get((Object)"TalkerNotify").toString())) {
                            conferenceInfo.setConferenceOption(ConferenceOption.TALKER_NOTIFY, "false");
                            this.logger.info("ProcessEvent unset talker conf");
                            this.logger.info("conf message triggered conf talker false and update conf collection: " + jSONObject.toJson());
                            this.logger.info("conf message triggered conf talker false and update conf collection: " + jSONObject3.toJson());
                            this.updateConfCollection(jSONObject.get((Object)"ConfID").toString(), jSONObject1, conferenceInfo);
                        }
                        if (newConfInfo) {
                            if (jSONObject.containsKey((Object)"Parts") && (JsonArray)jSONObject.get((Object)"Parts") != null) {
                                for (Object part : (JsonArray)jSONObject.get((Object)"Parts")) {
                                    JsonObject partJsonObj = new JsonObject();
                                    JsonObject message = (JsonObject)part;
                                    partJsonObj.put((Object)"ANI", (Object)(message.containsKey((Object)"ANI") ? message.get((Object)"ANI").toString() : ""));
                                    partJsonObj.put((Object)"Company", (Object)(message.containsKey((Object)"Company") ? message.get((Object)"Company").toString() : ""));
                                    partJsonObj.put((Object)"ConfID", (Object)(message.containsKey((Object)"ConfID") ? message.get((Object)"ConfID").toString() : ""));
                                    partJsonObj.put((Object)"Connected", message.containsKey((Object)"Connected") ? message.get((Object)"Connected") : Boolean.valueOf(false));
                                    partJsonObj.put((Object)"Email", (Object)(message.containsKey((Object)"Email") ? message.get((Object)"Email").toString() : ""));
                                    partJsonObj.put((Object)"FirstName", (Object)(message.containsKey((Object)"FirstName") ? message.get((Object)"FirstName").toString() : ""));
                                    partJsonObj.put((Object)"HangUp", (Object)(message.containsKey((Object)"HangUp") ? Boolean.parseBoolean(message.get((Object)"HangUp").toString()) : false));
                                    partJsonObj.put((Object)"Hold", (Object)(message.containsKey((Object)"Hold") ? Boolean.parseBoolean(message.get((Object)"Hold").toString()) : false));
                                    partJsonObj.put((Object)"LastName", (Object)(message.containsKey((Object)"LastName") ? message.get((Object)"LastName").toString() : ""));
                                    partJsonObj.put((Object)"ListenLevel", message.containsKey((Object)"ListenLevel") ? message.get((Object)"ListenLevel") : Integer.valueOf(0));
                                    partJsonObj.put((Object)"ListenOnly", (Object)(message.containsKey((Object)"ListenOnly") ? Boolean.parseBoolean(message.get((Object)"ListenOnly").toString()) : false));
                                    partJsonObj.put((Object)"ListenTickDown", (Object)(message.containsKey((Object)"ListenTickDown") ? Boolean.parseBoolean(message.get((Object)"ListenTickDown").toString()) : false));
                                    partJsonObj.put((Object)"ListenTickUp", (Object)(message.containsKey((Object)"ListenTickUp") ? Boolean.parseBoolean(message.get((Object)"ListenTickUp").toString()) : false));
                                    partJsonObj.put((Object)"Mute", (Object)(message.containsKey((Object)"Mute") ? Boolean.parseBoolean(message.get((Object)"Mute").toString()) : false));
                                    partJsonObj.put((Object)"PartID", (Object)(message.containsKey((Object)"PartID") ? message.get((Object)"PartID").toString() : ""));
                                    partJsonObj.put((Object)"PartType", message.containsKey((Object)"PartType") ? message.get((Object)"PartType") : "");
                                    partJsonObj.put((Object)"Phone", (Object)(message.containsKey((Object)"Phone") ? message.get((Object)"Phone").toString() : ""));
                                    partJsonObj.put((Object)"SubConfID", (Object)(message.containsKey((Object)"SubConfID") ? message.get((Object)"SubConfID").toString() : ""));
                                    partJsonObj.put((Object)"VoiceLevel", message.containsKey((Object)"VoiceLevel") ? message.get((Object)"VoiceLevel") : "0");
                                    partJsonObj.put((Object)"VoiceTickDown", (Object)(message.containsKey((Object)"VoiceTickDown") ? Boolean.parseBoolean(message.get((Object)"VoiceTickDown").toString()) : false));
                                    partJsonObj.put((Object)"VoiceTickUp", (Object)(message.containsKey((Object)"VoiceTickUp") ? Boolean.parseBoolean(message.get((Object)"VoiceTickUp").toString()) : false));
                                    partJsonObj.put((Object)"Codec", message.containsKey((Object)"Codec") ? message.get((Object)"Codec") : "");
                                    partJsonObj.put((Object)"DialOut", (Object)false);
                                    JsonObject partObj = this.mapAndTranslateMessage(partJsonObj, ResponseTypes.PiaPollMsgType.valueOf(message.get((Object)"MsgType").toString()));
                                    this.updateParticipantsEntry(partObj, partJsonObj);
                                    TelephonyUserInfo telephonyUserInfo1 = new TelephonyUserInfo(partJsonObj.get((Object)"PartID").toString());
                                    if (partJsonObj.containsKey((Object)"ANI") && !"".equals(partJsonObj.get((Object)"ANI"))) {
                                        telephonyUserInfo1.setPhoneNumber(partJsonObj.get((Object)"ANI").toString());
                                    } else if (partJsonObj.containsKey((Object)"Phone")) {
                                        telephonyUserInfo1.setPhoneNumber(partJsonObj.get((Object)"Phone").toString());
                                    } else {
                                        telephonyUserInfo1.setPhoneNumber("");
                                    }
                                    telephonyUserInfo1.setTelephonyUserId(partJsonObj.get((Object)"PartID").toString());
                                    if (partJsonObj.containsKey((Object)"LineID")) {
                                        telephonyUserInfo1.setTelephonyToken(partJsonObj.get((Object)"LineID").toString());
                                    }
                                    if (this._telephonyUsers.containsKey(partJsonObj.get((Object)"ConfID").toString())) {
                                        ArrayList<TelephonyUserInfo> list = this._telephonyUsers.get(partJsonObj.get((Object)"ConfID").toString());
                                        list.add(telephonyUserInfo1);
                                        this._telephonyUsers.put(partJsonObj.get((Object)"ConfID").toString(), list);
                                    } else {
                                        ArrayList<TelephonyUserInfo> arrayList = new ArrayList<TelephonyUserInfo>();
                                        arrayList.add(telephonyUserInfo1);
                                        this._telephonyUsers.put(partJsonObj.get((Object)"ConfID").toString(), arrayList);
                                    }
                                    if (telephonyUserInfo1 == null || telephonyUserInfo1.getPhoneNumber().equals("") || telephonyUserInfo1.getTelephonyUserId().equals("")) continue;
                                    this.logger.info("updating userinfoadobe: " + telephonyUserInfo1.getPhoneNumber() + ":" + telephonyUserInfo1.getTelephonyUserId());
                                    this.updateUserInfoAdobe(partJsonObj.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                                }
                            }
                            newConfInfo = false;
                        }
                        break;
                    }
                    case conflinked: {
                        this.logger.info(String.valueOf(str) + " handled: " + paramString + System.lineSeparator());
                        break;
                    }
                    case confunlinked: {
                        this.logger.info(String.valueOf(str) + " handled: " + paramString + System.lineSeparator());
                        break;
                    }
                    case partinfo: {
                        JsonObject jSONArray1 = (JsonObject)this._conferences.get(jSONObject.get((Object)"ConfID").toString()).get((Object)"participants");
                        TelephonyUserInfo telephonyUserInfo = null;
                        if (jSONArray1 != null) {
                            this.logger.info("msgParts: " + jSONArray1.toJson());
                            if (jSONArray1.containsKey(jSONObject.get((Object)"PartID"))) {
                                this.logger.info("jSONArray1 contains PartID:" + jSONObject.get((Object)"PartID"));
                            }
                            if ((jSONObject4 = (JsonObject)jSONArray1.get(jSONObject.get((Object)"PartID"))) != null && jSONObject4.toJson() != "{}") {
                                this.logger.info("part: " + jSONObject4.toJson());
                            }
                        }
                        if (jSONObject4 != null && !jSONObject4.isEmpty() && this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                            for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                if (!jSONObject.get((Object)"PartID").toString().equals(telephonyUserInfo1.getTelephonyUserId())) continue;
                                telephonyUserInfo = telephonyUserInfo1;
                                this.logger.info("tui partid and message part id equal: " + telephonyUserInfo.getTelephonyUserId());
                            }
                            if (this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString()) && telephonyUserInfo != null && !Boolean.parseBoolean(jSONObject.get((Object)"Connected").toString())) {
                                this.logger.info("user offline partinfo contains key: " + jSONObject.get((Object)"ConfID").toString());
                                telephonyUserInfo.setSpeaking(false);
                                try {
                                    this.userOfflineAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo.getTelephonyUserId(), this._cb);
                                }
                                catch (Exception exception) {
                                    this.logger.info("Error sleeping before user offline.", exception);
                                }
                                this.updateParticipantsEntry(jSONObject3, jSONObject);
                                break;
                            }
                            if (this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString()) && telephonyUserInfo != null) {
                                Boolean.parseBoolean(jSONObject.get((Object)"Connected").toString());
                            }
                            if (!this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString()) || telephonyUserInfo == null) {
                                this.logger.info("Telephony users does not contain conf id or tuser is null.");
                            }
                            if (telephonyUserInfo != null && jSONObject.containsKey((Object)"LineID") && !"".equals(jSONObject.get((Object)"LineID").toString())) {
                                telephonyUserInfo.setTelephonyToken(jSONObject.get((Object)"LineID").toString());
                                this.logger.info("PiaClientClass processEvent update user LineID: " + telephonyUserInfo.getTelephonyUserId());
                            }
                            this.logger.info("Message Mute: " + jSONObject.get((Object)"Mute").toString());
                            this.logger.info("jsonobject4: " + jSONObject4.toJson());
                            if (telephonyUserInfo != null && Boolean.parseBoolean(jSONObject.get((Object)"Mute").toString()) && !jSONObject4.isEmpty() && !Boolean.parseBoolean(jSONObject4.get((Object)"muteState").toString())) {
                                telephonyUserInfo.setOption(UserOption.MUTE, "true");
                                this.logger.info("PiaClientClass processEvent mute user: " + telephonyUserInfo.getTelephonyUserId() + "-" + telephonyUserInfo.getOption(UserOption.MUTE));
                            }
                            if (telephonyUserInfo != null && !Boolean.parseBoolean(jSONObject.get((Object)"Mute").toString()) && jSONObject4 != null && !jSONObject4.isEmpty() && Boolean.parseBoolean(jSONObject4.get((Object)"muteState").toString())) {
                                if (jSONObject2.containsKey((Object)"muteState") && Boolean.parseBoolean(jSONObject2.get((Object)"muteState").toString()) && "0".equals(jSONObject4.get((Object)"participantType").toString())) break;
                                telephonyUserInfo.setOption(UserOption.MUTE, "false");
                                this.logger.info("PiaClientClass processEvent unmute user: " + telephonyUserInfo.getTelephonyUserId() + "-" + telephonyUserInfo.getOption(UserOption.MUTE));
                            }
                            if (telephonyUserInfo != null && !jSONObject4.isEmpty() && Boolean.parseBoolean(jSONObject4.get((Object)"connected").toString()) && !Boolean.parseBoolean(jSONObject.get((Object)"Connected").toString())) {
                                this.userOfflineAdobe(jSONObject.get((Object)"ConfID").toString(), jSONObject.get((Object)"PartID").toString(), this._cb);
                                this.logger.info("process event removing user: " + jSONObject4.toJson());
                                ((List)this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())).remove(telephonyUserInfo);
                                ((JsonObject)this._conferences.get(jSONObject.get((Object)"ConfID").toString()).get((Object)"participants")).remove((Object)jSONObject.get((Object)"PartID").toString());
                            }
                            if (telephonyUserInfo != null && !"".equals(jSONObject.get((Object)"SubConfID").toString())) {
                                this.logger.info("Message SubConfID not null: " + jSONObject.get((Object)"SubConfID").toString());
                                if (!jSONObject4.isEmpty() && "".equals(jSONObject4.get((Object)"subConfId").toString())) {
                                    this.logger.info("part SubConfID null: " + jSONObject4.get((Object)"subConfId").toString());
                                    telephonyUserInfo.setSubconferenceId(jSONObject.get((Object)"SubConfID").toString());
                                }
                            }
                            if (telephonyUserInfo != null && "".equals(jSONObject.get((Object)"SubConfID").toString()) && !jSONObject4.isEmpty() && !"".equals(jSONObject4.get((Object)"subConfId").toString())) {
                                telephonyUserInfo.setSubconferenceId("");
                            }
                            if (telephonyUserInfo != null && !jSONObject4.isEmpty() && Integer.parseInt(jSONObject.get((Object)"ListenLevel").toString()) > Integer.parseInt(jSONObject4.get((Object)"listenLevel").toString())) {
                                for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                    if (telephonyUserInfo.getTelephonyUserId().equals(telephonyUserInfo1.getTelephonyUserId())) continue;
                                    telephonyUserInfo1.setOption(UserOption.MIC_LEVEL, "high");
                                }
                            }
                            if (telephonyUserInfo != null && !jSONObject4.isEmpty() && Integer.parseInt(jSONObject.get((Object)"ListenLevel").toString()) < Integer.parseInt(jSONObject4.get((Object)"listenLevel").toString())) {
                                for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                    if (telephonyUserInfo.getTelephonyUserId().equals(telephonyUserInfo1.getTelephonyUserId())) {
                                        // empty if block
                                    }
                                    telephonyUserInfo1.setOption(UserOption.MIC_LEVEL, "low");
                                }
                            }
                            if (telephonyUserInfo != null && !jSONObject4.isEmpty() && Integer.parseInt(jSONObject.get((Object)"VoiceLevel").toString()) > Integer.parseInt(jSONObject4.get((Object)"voiceLevel").toString())) {
                                telephonyUserInfo.setOption(UserOption.MIC_LEVEL, "high");
                            }
                            if (telephonyUserInfo != null && !jSONObject4.isEmpty() && Integer.parseInt(jSONObject.get((Object)"VoiceLevel").toString()) < Integer.parseInt(jSONObject4.get((Object)"voiceLevel").toString())) {
                                telephonyUserInfo.setOption(UserOption.MIC_LEVEL, "low");
                            }
                            ArrayList<TelephonyUserInfo> list = this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString());
                            int tuiIdx = 0;
                            for (TelephonyUserInfo tui1 : list) {
                                if (tui1 != null && telephonyUserInfo != null && telephonyUserInfo.getTelephonyUserId().equals(tui1.getTelephonyUserId())) break;
                                ++tuiIdx;
                            }
                            if (tuiIdx < list.size()) {
                                list.set(tuiIdx, telephonyUserInfo);
                            }
                            this._telephonyUsers.put(jSONObject.get((Object)"ConfID").toString(), list);
                        } else {
                            this.logger.info("telephonyUserInfo1 creation: " + jSONObject.get((Object)"PartID").toString());
                            this.logger.info("jSONObject as string: " + jSONObject.toJson());
                            TelephonyUserInfo telephonyUserInfo1 = new TelephonyUserInfo(jSONObject.get((Object)"PartID").toString());
                            if (jSONObject.containsKey((Object)"ANI") && !"".equals(jSONObject.get((Object)"ANI"))) {
                                telephonyUserInfo1.setPhoneNumber(jSONObject.get((Object)"ANI").toString());
                            } else if (jSONObject.containsKey((Object)"Phone")) {
                                telephonyUserInfo1.setPhoneNumber(jSONObject.get((Object)"Phone").toString());
                            } else {
                                telephonyUserInfo1.setPhoneNumber("");
                            }
                            telephonyUserInfo1.setTelephonyUserId(jSONObject.get((Object)"PartID").toString());
                            if (jSONObject.containsKey((Object)"LineID")) {
                                telephonyUserInfo1.setTelephonyToken(jSONObject.get((Object)"LineID").toString());
                            }
                            if (this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                                ArrayList<TelephonyUserInfo> list = this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString());
                                list.add(telephonyUserInfo1);
                                this._telephonyUsers.put(jSONObject.get((Object)"ConfID").toString(), list);
                            } else {
                                ArrayList<TelephonyUserInfo> arrayList = new ArrayList<TelephonyUserInfo>();
                                arrayList.add(telephonyUserInfo1);
                                this._telephonyUsers.put(jSONObject.get((Object)"ConfID").toString(), arrayList);
                            }
                            this.logger.info("part was null, updating participants.");
                            telephonyUserInfo = telephonyUserInfo1;
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception) {
                                this.logger.error("Error sleeping in null part.", exception);
                            }
                        }
                        this.updateParticipantsEntry(jSONObject3, jSONObject);
                        if (telephonyUserInfo != null && !telephonyUserInfo.getPhoneNumber().equals("") && !telephonyUserInfo.getTelephonyUserId().equals("")) {
                            this.logger.info("updating userinfoadobe: " + telephonyUserInfo.getPhoneNumber() + ":" + telephonyUserInfo.getTelephonyUserId());
                            this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo, this._cb);
                        }
                        break;
                    }
                    case talker: {
                        if (!this._telephonyUsers.containsKey(jSONObject.get((Object)"ConfID").toString())) {
                            return;
                        }
                        this.logger.info("talker parts: " + jSONObject.get((Object)"Parts").toString());
                        if (jSONObject.get((Object)"Parts").toString().equals("[]")) {
                            this.logger.info("talker parts contains no parts, setting talker false.");
                            for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                if (!telephonyUserInfo1.isSpeaking()) continue;
                                telephonyUserInfo1.setSpeaking(false);
                                this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                            }
                        } else {
                            List<String> partList = Arrays.asList(jSONObject.get((Object)"Parts").toString().replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "").split(","));
                            this.logger.info("Talker partlist: " + partList.toString());
                            for (String talkerPart : partList) {
                                this.logger.info("Talker partId: " + talkerPart.trim());
                                for (TelephonyUserInfo telephonyUserInfo1 : this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString())) {
                                    this.logger.info("Talker tui partId: " + telephonyUserInfo1.getTelephonyUserId() + ":" + telephonyUserInfo1.isSpeaking());
                                    if (talkerPart.equals(telephonyUserInfo1.getTelephonyUserId()) && !telephonyUserInfo1.isSpeaking()) {
                                        this.logger.info("Talker Message: " + telephonyUserInfo1.getTelephonyUserId() + ":" + talkerPart);
                                        telephonyUserInfo1.setSpeaking(true);
                                        this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                                    }
                                    if (partList.contains(telephonyUserInfo1.getTelephonyUserId()) || !telephonyUserInfo1.isSpeaking()) continue;
                                    this.logger.info("Talker partlist ! contains: " + telephonyUserInfo1.getTelephonyUserId());
                                    telephonyUserInfo1.setSpeaking(false);
                                    this.updateUserInfoAdobe(jSONObject.get((Object)"ConfID").toString(), telephonyUserInfo1, this._cb);
                                }
                            }
                        }
                        break;
                    }
                    case watchlost: {
                        this.logger.info("PiaClientClass processEvent " + str + " message: " + jSONObject.toJson());
                        String[] arrayOfString = (String[])((ConcurrentHashMap.CollectionView)((Object)this._conferences.keySet())).toArray();
                        try {
                            this.httpClient.removeConferenceWatchesAsync(arrayOfString, this.httpClient.getUriRest(), this._sessionId);
                            JsonObject jSONObject5 = this.httpClient.subscribeToPiaAsync(this.httpClient.getSubId(), this.httpClient.getSubPw(), this.httpClient.getSubToken(), this.httpClient.getWebId(), this.httpClient.getWebPw(), this.httpClient.getUriRest()).get();
                            this._sessionId = jSONObject5.get((Object)"SessionId").toString();
                            this._cws = new ClientWebSocket(this, this.httpClient.getUriWebSocket(), this._sessionId, this._globalsClass, this.logger);
                            String[] stringArray = arrayOfString;
                            int n = arrayOfString.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String str2 = stringArray[n3];
                                JsonObject str3 = this.httpClient.watchConferenceAsync(str2, this.httpClient.getUriRest(), this._sessionId).get();
                                if (str3.get((Object)"ResultCode") == "0") {
                                    List list = this._telephonyUsers.get(jSONObject.get((Object)"ConfID").toString());
                                    this._cb.conferenceReconnected(jSONObject.get((Object)"ConfID").toString(), this._telephonyConferences.get(jSONObject.get((Object)"ConfID").toString()), list);
                                }
                                ++n3;
                            }
                        }
                        catch (InterruptedException | ExecutionException interruptedException) {
                            this.logger.error(null, interruptedException);
                        }
                        this.logger.info(String.valueOf(str) + " handled: " + paramString + System.lineSeparator());
                        break;
                    }
                }
            }
            catch (Exception parseException) {
                this.logger.error(null, parseException);
            }
        }
    }

    public void updateConfCollection(String confId, JsonObject confJsonObj, ConferenceInfo paramConferenceInfo) {
        this.logger.info("updateconfcollection: " + confId + ":" + confJsonObj.toString());
        if (confJsonObj != null && !confJsonObj.equals((Object)new JsonObject()) && confJsonObj.toJson() != "{}") {
            if (confJsonObj.containsKey((Object)"participants")) {
                this.logger.info("updateConfCollection participants class name: " + confJsonObj.get((Object)"participants").getClass().getName());
            }
            if (confJsonObj.containsKey((Object)"participants") && confJsonObj.get((Object)"participants") instanceof JsonArray || confJsonObj.get((Object)"participants") instanceof Object[]) {
                JsonObject parts = new JsonObject();
                ((JsonArray)confJsonObj.get((Object)"participants")).forEach(v -> {
                    this.logger.info("updateconfcollection confJsonObj iterators: " + ((String)((JsonObject)v).keySet().iterator().next()).toLowerCase() + ":" + ((JsonObject)v).values().iterator().next().toString());
                    parts.put((Object)((String)((JsonObject)v).keySet().iterator().next()).toString(), (Object)((JsonObject)v).values().iterator().next().toString());
                });
                confJsonObj.put((Object)"participants", (Object)parts);
            }
            this.logger.info("_conferences paramString, confJsonObj: " + confId + "," + confJsonObj.toJson());
            this.logger.info("confJsonObj == {}: " + (confJsonObj.toJson() == "{}"));
            this.logger.info("confJsonObj == new JsonObject" + confJsonObj.equals((Object)new JsonObject()));
            this._conferences.put(confId, confJsonObj);
        } else {
            this.logger.info("mappedMessage not right.");
        }
        if (paramConferenceInfo != null) {
            this.updateConfAdobe(confId, paramConferenceInfo, this._cb);
        } else {
            this.updateConfAdobe(confId, this._telephonyConferences.get(confId), this._cb);
        }
    }

    public void updateParticipantsEntry(JsonObject mappedMessage, JsonObject message) {
        try {
            if (mappedMessage != null && mappedMessage != new JsonObject()) {
                if (this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants") instanceof JsonArray) {
                    JsonObject parts = new JsonObject();
                    ((JsonArray)this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants")).forEach(v -> parts.put((Object)((String)((JsonObject)v).keySet().iterator().next()).toString(), (Object)((JsonObject)v).values().iterator().next().toString()));
                    this._conferences.get(message.get((Object)"ConfID").toString()).put((Object)"participants", (Object)parts);
                }
                if (this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants") == null) {
                    this.logger.info("updateParticipantsEntry null participants, adding empty json object.");
                    this._conferences.get(message.get((Object)"ConfID").toString()).put((Object)"participants", (Object)new JsonObject());
                }
                this.logger.info("updateParticipantsEntry participants before: " + ((JsonObject)this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants")).toJson());
                ((JsonObject)this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants")).put((Object)message.get((Object)"PartID").toString(), mappedMessage.get((Object)message.get((Object)"PartID").toString()));
                this.logger.info("updateParticipantsEntry participants after: " + ((JsonObject)this._conferences.get(message.get((Object)"ConfID").toString()).get((Object)"participants")).toJson());
            } else {
                this.logger.info("mappedMessage not right.");
            }
        }
        catch (Exception ex) {
            this.logger.error("Update Participants Entry error.", ex);
        }
    }

    @Override
    public CompletableFuture<JsonObject> cancelDialoutAsync(String paramString1, String paramString2) {
        return this.httpClient.cancelDialoutAsync(paramString1, paramString2, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> clearAccessCodeAsync(String paramString) {
        return this.httpClient.clearAccessCodeAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> clearWatchAsync(String paramString) {
        return this.httpClient.clearConferenceWatchAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> dialOutAsync(String paramString1, String paramString2, Integer paramInteger1, Integer paramInteger2, Integer paramInteger3, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7, String paramString8, Optional<Integer> paramOptional, Boolean paramBoolean) {
        return this.httpClient.dialOutAsync(paramString1, paramString2, paramInteger1, paramInteger2, paramInteger3, paramString3, paramString4, paramString5, paramString6, paramString7, paramString8, paramOptional, paramBoolean, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> endConferenceAsync(String paramString) {
        return this.httpClient.endConferenceAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> findConferenceAsync(String paramString1, String paramString2, String paramString3) {
        Optional<String> optional1 = Optional.of(paramString1);
        Optional<String> optional2 = Optional.of(paramString2);
        Optional<String> optional3 = Optional.of(paramString3);
        return this.httpClient.findConferenceAsync(optional1, optional2, optional3, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> getConferenceStateAsync(String paramString) {
        return this.httpClient.getConferenceStateAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> getPIAVersion() {
        return this.httpClient.getPiaVersion(this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> getWatchesAsync() {
        return this.httpClient.getWatchesAsync(this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> hangUpAsync(String paramString1, String paramString2) {
        return this.httpClient.hangupAsync(paramString1, paramString2, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> mohOffAsync(String paramString) {
        return this.httpClient.mohOffAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> moveToMainConfAsync(String paramString1, String paramString2) {
        return this.httpClient.moveToMainConfAsync(paramString1, paramString2, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> moveToSubConfAsync(String confId, String partId, String subConfId) {
        if (subConfId.equals(confId)) {
            return this.httpClient.moveToMainConfAsync(confId, partId, this.httpClient.getUriRest(), this._sessionId);
        }
        return this.httpClient.moveToSubConfAsync(confId, partId, subConfId, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> pauseRecordingAsync(String paramString, Boolean paramBoolean) {
        return this.httpClient.pauseRecordingAsync(paramString, paramBoolean, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> removeAllWatchesAsync() {
        return this.httpClient.removeAllConferenceWatchesAsync(this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> removeWatchesAsync(String[] paramArrayOfString) {
        return this.httpClient.removeConferenceWatchesAsync(paramArrayOfString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> reservationBy(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) {
        return this.httpClient.reservationBy(paramString1, paramString2, paramString3, paramString4, paramString5, paramString6);
    }

    @Override
    public CompletableFuture<JsonObject> resumeRecordingAsync(String paramString, Boolean paramBoolean) {
        return this.httpClient.resumeRecordingAsync(paramString, paramBoolean, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> setAccessCodeAsync(String paramString1, String paramString2) {
        return this.httpClient.setAccessCodeAsync(paramString1, paramString2, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> setConferenceOptionAsync(String paramString, Integer paramInteger) {
        return this.httpClient.setConferenceOptionAsync(paramString, paramInteger, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> setParticipantInfoAsync(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6, String paramString7) {
        return this.httpClient.setParticipantInfoAsync(paramString1, paramString2, paramString3, paramString4, paramString5, paramString6, paramString7, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> setParticipantOptionAsync(String paramString1, String paramString2, Integer paramInteger) {
        return this.httpClient.setParticipantOptionAsync(paramString1, paramString2, paramInteger, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> startConferenceAsync(String paramString) {
        this._talkerMap.put(paramString, LocalDateTime.now());
        return this.httpClient.startConferenceAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> startRecordingAsync(String clientId, String clientPw, String webId, String webPw, String fileName, String fileType, Boolean playPrompt, Boolean disableDTMF, String confId) {
        return this.httpClient.startRecordingAsync(clientId, clientPw, webId, webPw, fileName, fileType, playPrompt, disableDTMF, this.httpClient.getUriRest(), this._sessionId, confId);
    }

    @Override
    public CompletableFuture<JsonObject> startRecordingWarnAsync(String paramString, Boolean paramBoolean) {
        return this.httpClient.startRecordingWarnAsync(paramString, paramBoolean, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> stopRecordingAsync(String confId, Boolean disableDTMF) {
        return this.httpClient.stopRecordingAsync(confId, disableDTMF, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> stopRecordingWarnAsync(String paramString, Boolean paramBoolean) {
        return this.httpClient.stopRecordingWarnAsync(paramString, paramBoolean, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> subscribeToPiaAsync(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) {
        return this.httpClient.subscribeToPiaAsync(paramString1, paramString2, paramString3, paramString4, paramString5, this.httpClient.getUriRest());
    }

    @Override
    public CompletableFuture<JsonObject> toggleEntryExitOptionAsync(String paramString) {
        return this.httpClient.toggleEntryExitOptionAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    @Override
    public CompletableFuture<JsonObject> watchConferenceAsync(String paramString) {
        return this.httpClient.watchConferenceAsync(paramString, this.httpClient.getUriRest(), this._sessionId);
    }

    /*
     * Exception decompiling
     */
    public JsonObject mapAndTranslateMessage(JsonObject message, ResponseTypes.PiaPollMsgType messageType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

