-------------------------------------------------------------------------------
-- This is the update template file
--
-- For every hotfix/service pack there is a unique update script that is 
-- executed by the installer. 
--
-- The first statement is a logging statement to indicate what db version
-- the database currently has.
--
-- The script ends with an update statement to increment the database version
-- and another log statement to indicate completion of the update script.
-- Wrap all blocks with begin/end keywords, even if there is only one statement.
--
-- If some sql statements only need to be executed against a hosted or licensed -- database, use the dbo.isHosted() function call. This function returns 1 if 
-- the database is a hosted database and 0 if licensed, i.e. 
--	if dbo.isHosted() = 1
--		begin
--			print 'hosted';
--		end
--
--
-- Please use isBigint() function to determine if database uses bigint for IDs:
--	if dbo.isBigint() = 1
--		begin
--			print 'IDs are of BIGINT type';
--		end
-- else 
--		begin
--			print 'IDs are of INTERGER type';
--		end
-------------------------------------------------------------------------------

IF((SELECT COMPATIBILITY_LEVEL FROM SYS.DATABASES WHERE NAME = DB_NAME()) < 110)
BEGIN
	PRINT 'Please alter your database compatibility level'
	PRINT 'Minimal compatibility level is 110 - SQL Server 2012'
	SET NOEXEC ON
END
GO
SET NOCOUNT ON
GO
EXECUTE updateLogger '$Id: //depot/main/AdobeConnect/components/dbscripts/updates/update_11_3_0_0.sql#2 $', '$Change: 1425020 $', 'Start';
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--------------------------------------
-- Start of updates
--------------------------------------

----------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4127559 - On-Demand recording Event report Time Taken field is NULL
----------------------------------------------------------------------------------------
IF OBJECT_ID('ReportingDAL_getReportQuizTakers') IS NOT NULL
	DROP PROCEDURE ReportingDAL_getReportQuizTakers
GO
CREATE PROCEDURE ReportingDAL_getReportQuizTakers 
	@sco bigint, 
	@principal bigint = null,
	@transcript bigint = null,
	@type int = 8,
	@filter nvarchar(400)
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @sql NVARCHAR(4000)
	SET @sql = ''
	SET @sql = @sql + 'SELECT * FROM ('
	SET @sql = @sql + ' SELECT '
	SET @sql = @sql + '  t.transcript_id, '
	SET @sql = @sql + '  t.sco_id, '
	SET @sql = @sql + '  scos.name AS name, '
	SET @sql = @sql + '  p.principal_id, '
    SET @sql = @sql + '  p.login, ' 
    SET @sql = @sql + '  t.status AS status, ' 
    SET @sql = @sql + '  t.score, '
	SET @sql = @sql + '  t.max_score, '
	SET @sql = @sql + '  t.date_created, '
    SET @sql = @sql + '  t.asset_id, '
    SET @sql = @sql + '  t.permission_id, '
	SET @sql = @sql + '  x.attempts, '
    SET @sql = @sql + '  (SELECT sum(time_aicc) FROM PPS_TRANSCRIPTS t3 '
    SET @sql = @sql + '    WHERE t3.principal_id IS NOT NULL '
    SET @sql = @sql + '     AND t3.sco_id = t.sco_id '
    SET @sql = @sql + '     AND t3.status != ''D'' '
    SET @sql = @sql + '     AND t3.principal_id = t.principal_id) '
    SET @sql = @sql + '   AS time_aicc, '
    SET @sql = @sql + '  tt.time_taken, '
	SET @sql = @sql + '  (CASE t.status '
    SET @sql = @sql + '    WHEN ''P'' THEN t.transcript_id '
    SET @sql = @sql + '    WHEN ''C'' THEN t.transcript_id '
	SET @sql = @sql + '   END) AS certificate, '
    SET @sql = @sql + '  p.name AS principal_name, '
	SET @sql = @sql + '  (SELECT count(distinct transcript_id) '
	SET @sql = @sql + '    FROM pps_transcript_details '
    SET @sql = @sql + '    WHERE transcript_id=t.transcript_id '
	SET @sql = @sql + '  ) AS answered_survey, '
	SET @sql = @sql + '  (CASE scos.type ' 
	-- links should look at the source for version.
    -- QW-NOTE: Always assume the max version for asset-id and sco.
    -- We can have different versions for the same sco and asset, which the case for courses.
    SET @sql = @sql + '   WHEN 15 THEN '
	SET @sql = @sql + '    (SELECT max(version) FROM pps_sco_assets sa WHERE '
    SET @sql = @sql + '      sa.asset_id = t.asset_id AND sa.sco_id = scos.source_sco_id) '
    SET @sql = @sql + '   ELSE (SELECT max(version) FROM pps_sco_assets sa '
	SET @sql = @sql + '           WHERE sa.asset_id = t.asset_id AND	sa.sco_id = scos.sco_id) '
	SET @sql = @sql + '   END) AS version, '
	SET @sql = @sql + '   (CASE (SELECT count(US.SESSION_COOKIE) AS SESSION_COOKIE FROM '
    SET @sql = @sql + '           pps_user_sessions us WHERE t.session_id = us.session_id and '
	SET @sql = @sql + '           US.SESSION_COOKIE LIKE ''tsovr%'') ' 
	SET @sql = @sql + '     WHEN 0 THEN ''false'' '
	SET @sql = @sql + '     ELSE ''true'' '
    SET @sql = @sql + '    END) as override '
    SET @sql = @sql + ' FROM pps_scos scos, '
    SET @sql = @sql + '   pps_principals p LEFT OUTER JOIN '
	SET @sql = @sql + '   (SELECT MAX(t.DATE_CREATED) AS DATE_CREATED, SUM(t.attempt_count) AS ATTEMPTS, '
	SET @sql = @sql + '     t.sco_id, t.principal_id '
	SET @sql = @sql + '     FROM ('
	SET @sql = @sql + '      SELECT TRANSCRIPT_ID, DATE_CREATED, SCO_ID, PRINCIPAL_ID, '
	SET @sql = @sql + '       (CASE STATUS '
	SET @sql = @sql + '         WHEN ''N'' THEN 0 '
    SET @sql = @sql + '         WHEN ''Q'' THEN 0 '
	SET @sql = @sql + '         ELSE 1 '
	SET @sql = @sql + '       END) AS attempt_count '
	SET @sql = @sql + '       FROM PPS_TRANSCRIPTS tx '
	SET @sql = @sql + '       WHERE EXISTS(SELECT transcript_id FROM pps_transcripts ty WHERE ty.sco_id = ' + CAST(@sco as nvarchar(30)) + ' AND tx.principal_id = ty.principal_id AND ty.status IN (''P'', ''F'', ''C'', ''I'')) AND '
    SET @sql = @sql + '        status IN (''P'', ''F'', ''C'', ''I'', ''N'', ''Q'') '
	IF @principal IS NOT NULL
		SET @sql = @sql + ' AND principal_id = ' + CAST(@principal as nvarchar(30))
	ELSE 
		SET @sql = @sql + ' AND principal_id IS NOT NULL '
	IF @sco IS NOT NULL
		SET @sql = @sql + ' AND sco_id = ' + CAST(@sco AS nvarchar(30))
	SET @sql = @sql + ' ) t '
    SET @sql = @sql + ' GROUP BY principal_id, sco_id '
    SET @sql = @sql + ') X ON (P.PRINCIPAL_ID = X.PRINCIPAL_ID) '
    SET @sql = @sql + ' LEFT OUTER JOIN PPS_TRANSCRIPTS t ON X.DATE_CREATED = T.DATE_CREATED '
	SET @sql = @sql + ' OUTER APPLY ('
    SET @sql = @sql + '  SELECT ROUND(SUM(session_time) * (24*60*60*1000), 0) as time_taken '
    SET @sql = @sql + '   FROM '
    SET @sql = @sql + '    (SELECT CAST(MAX(ISNULL(td.date_modified, t2.date_closed)) - t2.date_created AS FLOAT) AS session_time '
    SET @sql = @sql + '      FROM pps_transcripts t2 '
    SET @sql = @sql + '      LEFT JOIN pps_transcript_details td ON td.TRANSCRIPT_ID = t2.TRANSCRIPT_ID '
    SET @sql = @sql + '      WHERE t2.sco_id = t.sco_id '
    SET @sql = @sql + '       AND t2.principal_id IS NOT NULL '
    SET @sql = @sql + '       AND t2.principal_id = t.principal_id '
    SET @sql = @sql + '       AND ISNULL(td.date_created, t2.date_closed) >= t2.date_created '
    SET @sql = @sql + '       AND (t2.transcript_id = td.transcript_id OR td.transcript_id IS NULL) '
    SET @sql = @sql + '       AND (t2.transcript_id = t.transcript_id OR (t2.status IN (''P'', ''F'', ''C'', ''I'', ''X'') AND t2.date_created < t.date_created)) '
    SET @sql = @sql + '      GROUP BY t2.transcript_id, t2.date_created '
    SET @sql = @sql + '     ) t3 '
    SET @sql = @sql + '  ) tt '
    SET @sql = @sql + ' WHERE t.status IN (''P'', ''F'', ''C'', ''I'', ''N'', ''Q'') '
    SET @sql = @sql + '  AND X.principal_id = t.principal_id '
    IF @principal IS NOT NULL 
        SET @sql = @sql + ' AND t.principal_id = ' + CAST(@principal AS NVARCHAR(30))
	ELSE 
		SET @sql = @sql + ' AND t.principal_id IS NOT NULL '
	IF @sco IS NOT NULL
        SET @sql = @sql + ' AND t.sco_id=' + CAST(@sco AS NVARCHAR(30))
	SET @sql = @sql + ' AND t.sco_id = scos.sco_id '
	IF @transcript IS NOT NULL
		SET @sql = @sql + ' AND t.transcript_id = ' + CAST(@transcript AS NVARCHAR(30))
	IF @type IS NOT NULL
		SET @sql = @sql + ' AND scos.type=' + CAST(@type AS NVARCHAR(30))
     SET @sql = @sql + ' ) t WHERE 1 = 1 ' + @filter

	 EXEC (@sql)
END
GO
----------------------------------------------------------------------------------------
--END Jira: CONN-4127559
----------------------------------------------------------------------------------------

--------------------------
--BEGIN Jira: CONN-4127396
--------------------------
-- Custom fields cleanup
--  Remove field names that reference field ids from 1001 to 1004
--  Only hosted databases will be affected
--------------------------
IF dbo.isHosted() = 1
BEGIN
	DELETE FROM PPS_ACL_FIELDS WHERE FIELD_ID IN (SELECT FIELD_ID FROM PPS_FIELD_NAMES WHERE FIELD_ID BETWEEN 1001 AND 1004 AND XML_NAME IN ('x-1001','x-1002','x-1003','x-1004'));

	DELETE FROM PPS_FIELDS WHERE FIELD_ID IN (SELECT FIELD_ID FROM PPS_FIELD_NAMES WHERE FIELD_ID BETWEEN 1001 AND 1004 AND XML_NAME IN ('x-1001','x-1002','x-1003','x-1004'));

	DELETE FROM PPS_FIELD_NAMES WHERE FIELD_ID BETWEEN 1001 AND 1004 AND XML_NAME IN ('x-1001','x-1002','x-1003','x-1004');
END
GO
--------------------------
--END Jira: CONN-4127396
--------------------------

--------------------------
--BEGIN Jira: CONN-4121117
--------------------------
-- System fields cleanup: Adding missing fields to PPS_FIELD_NAMES
IF NOT EXISTS (SELECT * FROM PPS_FIELD_NAMES WHERE FIELD_ID = 154)
BEGIN
	INSERT INTO PPS_FIELD_NAMES (FIELD_ID, XML_NAME) VALUES (154, 'vc_course_sco_id');
END
GO
IF NOT EXISTS (SELECT * FROM PPS_FIELD_NAMES WHERE FIELD_ID = 192)
BEGIN
	INSERT INTO PPS_FIELD_NAMES (FIELD_ID, XML_NAME) VALUES (192, 'account-background-inset-color');
END
GO
IF NOT EXISTS (SELECT * FROM PPS_FIELD_NAMES WHERE FIELD_ID = 193)
BEGIN
	INSERT INTO PPS_FIELD_NAMES (FIELD_ID, XML_NAME) VALUES (193, 'account-tab-unselected-color');
END
GO
IF NOT EXISTS (SELECT * FROM PPS_FIELD_NAMES WHERE FIELD_ID = 752)
BEGIN
	INSERT INTO PPS_FIELD_NAMES (FIELD_ID, XML_NAME) VALUES (752, 'account-level-preload-hybrid-ppt-conversion');
END
GO

IF OBJECT_ID(N'PPS_FEATURE_VERSIONS', N'U') IS  NULL
BEGIN
	CREATE TABLE PPS_FEATURE_VERSIONS (
		FEATURE_ID BIGINT NOT NULL CONSTRAINT PK_PPS_FEATURE_VERSIONS PRIMARY KEY,
		VERSION INTEGER NOT NULL
	);

	-- Features added in 9.0 or older releases have VERSION set to 0
	-- Features added after 9.0, have corresonding Connect version set as VERSION (for example, 1120 for Connect 11.2)
	INSERT INTO PPS_FEATURE_VERSIONS (FEATURE_ID, VERSION)
	VALUES
		(1, 0),
		(2, 0),
		(3, 0),
		(4, 0),
		(5, 0),
		(6, 0),
		(7, 0),
		(8, 0),
		(9, 0),
		(10, 0),
		(11, 0),
		(12, 0),
		(13, 0),
		(14, 0),
		(15, 0),
		(16, 0),
		(17, 0),
		(18, 0),
		(19, 0),
		(20, 0),
		(21, 0),
		(22, 0),
		(23, 0),
		(24, 0),
		(25, 0),
		(26, 0),
		(27, 0),
		(28, 0),
		(29, 0),
		(30, 0),
		(31, 0),
		(32, 0),
		(33, 0),
		(34, 0),
		(35, 0),
		(36, 0),
		(37, 0),
		(38, 0),
		(39, 0),
		(40, 0),
		(41, 0),
		(42, 0),
		(43, 0),
		(44, 0),
		(45, 0),
		(46, 0),
		(47, 0),
		(48, 0),
		(49, 0),
		(50, 0),
		(51, 0),
		(52, 0),
		(53, 0),
		(54, 0),
		(55, 0),
		(56, 0),
		(57, 0),
		(58, 0),
		(59, 0),
		(60, 0),
		(61, 0),
		(62, 0),
		(63, 0),
		(64, 0),
		(65, 0),
		(66, 0),
		(67, 0),
		(68, 0),
		(69, 0),
		(70, 0),
		(71, 0),
		(72, 0),
		(73, 0),
		(75, 0),
		(76, 0),
		(77, 0),
		(78, 0),
		(79, 0),
		(80, 0),
		(81, 0),
		(82, 0),
		(83, 0),
		(84, 0),
		(85, 0),
		(86, 0),
		(87, 0),
		(88, 0),
		(89, 0),
		(90, 0),
		(91, 0),
		(92, 0),
		(93, 0),
		(94, 0),
		(95, 0),
		(96, 0),
		(97, 0),
		(98, 0),
		(99, 0),
		(100, 0),
		(101, 0),
		(102, 910),
		(103, 910),
		(104, 920),
		(150, 0),
		(160, 904),
		(161, 910),
		(162, 920),
		(170, 920),
		(171, 920),
		(172, 920),
		(173, 920),
		(174, 920),
		(175, 920),
		(176, 930),
		(177, 940),
		(180, 952),
		(181, 952),
		(182, 952),
		(183, 960),
		(184, 960),
		(185, 960),
		(186, 975),
		(190, 1050),
		(191, 1050),
		(192, 1050),
		(193, 1050),
		(194, 1050),
		(195, 1080),
		(196, 1100),
		(197, 1061),
		(198, 1100),
		(200, 1100),
		(201, 1120),
		(202, 1120),
		(210, 1120);
END
GO

IF NOT EXISTS(SELECT 1 FROM sys.columns WHERE Name = N'VERSION' AND Object_ID = Object_ID(N'PPS_FIELD_NAMES'))
BEGIN
	ALTER TABLE PPS_FIELD_NAMES ADD VERSION INTEGER NULL;
END
GO

-- Field names added in 9.0 or older releases have VERSION set to 0
-- Field names added after 9.0, have corresonding Connect version set as VERSION (for example, 1120 for Connect 11.2)
-- Custom fields created by customers will have VERSION set as NULL

-- First update all exisitng system field names to VERSION=0
UPDATE PPS_FIELD_NAMES SET VERSION = 0 WHERE FIELD_ID <= 902
GO

-- Then update all field names added after version 9.0 with corresponding VERSION number
UPDATE PPS_FIELD_NAMES SET VERSION = 904 WHERE FIELD_ID = 325;
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 910
	WHERE FIELD_ID IN (323,324,326,327,328,329,330);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 911
	WHERE FIELD_ID IN (331,332,333,334,335,336,337,338);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 920
	WHERE FIELD_ID IN (339,340,341,342,343,344,345,346,347,348,349,350);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 930
	WHERE FIELD_ID IN (351,352,353,354,355,356,357,358);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 940
	WHERE FIELD_ID IN (359,360,361,362,363,365,366,367);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 950
	WHERE FIELD_ID IN (368,369,380,381,382,383,384,385,386,387,388,389,390,391,392,393);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 953
	WHERE FIELD_ID IN (364,394);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 960
	WHERE FIELD_ID IN (395,396,397,398,399,400,401,402,403);

UPDATE PPS_FIELD_NAMES SET VERSION = 961
	WHERE FIELD_ID IN (404,405);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 975
	WHERE FIELD_ID IN (406,407,408,502,503,504);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1000
	WHERE FIELD_ID IN (128,129,410,411,412,413,501);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1010
	WHERE FIELD_ID IN (450,451,452,600);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1020 WHERE FIELD_ID = 500;
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1050
	WHERE FIELD_ID IN (505,506,507,508,601,602,603,604,605);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1051
	WHERE FIELD_ID IN (701,702);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1060 WHERE FIELD_ID = 550;
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1080 WHERE FIELD_ID = 551;
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1100
	WHERE FIELD_ID IN (751,800,801,802,806,807,808,820);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1106 WHERE FIELD_ID = 752;
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1120
	WHERE FIELD_ID IN (810,811,812,902);
GO

UPDATE PPS_FIELD_NAMES SET VERSION = 1123 WHERE FIELD_ID = 1000;
GO
--------------------------
--END Jira: CONN-4121117
--------------------------

----------------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4126255 Content Security - provide control for allowing or blocking MP4 download
----------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM PPS_FIELD_NAMES WHERE FIELD_ID = 903)
BEGIN
	INSERT INTO PPS_FIELD_NAMES (FIELD_ID, XML_NAME, VERSION) VALUES (903, 'download-control-for-content', 1130);
END
GO
--------------------------
--END Jira: CONN-4126255
--------------------------

----------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4128758 Process of user-sessions/transcripts daily cleanup is not efficient
----------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT TOP 1 1 FROM sys.indexes WHERE name='PPS_USER_DOWNLOAD_CONTENT_TRANSCRIPT_ID')
	CREATE NONCLUSTERED INDEX [PPS_USER_DOWNLOAD_CONTENT_TRANSCRIPT_ID] ON [PPS_USER_DOWNLOAD_CONTENT] ([TRANSCRIPT_ID] ASC)
		WITH (PAD_INDEX = ON, SORT_IN_TEMPDB = ON, FILLFACTOR = 80)
GO
IF NOT EXISTS(SELECT TOP 1 1 FROM sys.indexes WHERE name='PPS_TRAINING_LICENSE_ACTIVITY_TRANSCRIPT_ID')
	CREATE NONCLUSTERED INDEX [PPS_TRAINING_LICENSE_ACTIVITY_TRANSCRIPT_ID] ON [PPS_TRAINING_LICENSE_ACTIVITY] ([TRANSCRIPT_ID] ASC)
		WITH (PAD_INDEX = ON, SORT_IN_TEMPDB = ON, FILLFACTOR = 80)
GO
--------------------------
--END Jira: CONN-4128758
--------------------------

----------------------------------------------------------------------------------
--BEGIN Jira: CONN-4122287 Need method to change meeting room permission in bulk
----------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM sys.objects WHERE type = 'P' AND name = 'BulkModifyAccountMeetingAccessLevel')
   DROP PROCEDURE BulkModifyAccountMeetingAccessLevel
GO
IF EXISTS (SELECT 1 FROM sys.objects WHERE type = 'P' AND name = 'BulkModifyMeetingsAccessLevel')
   DROP PROCEDURE BulkModifyMeetingsAccessLevel
GO
------------------------------------------------------------------
-- Modify access level for all meetings belonging to given account
------------------------------------------------------------------
CREATE PROCEDURE BulkModifyMeetingsAccessLevel
	@accountId bigint,
    @sourceAccessLevel varchar(30), -- anyone | account-members-only | accepted-guests | account-members-and-accepted-guests
	@targetAccessLevel varchar(30), -- anyone | account-members-only | accepted-guests | account-members-and-accepted-guests
	-- Output
	@numOfMeetingsProcessed int output,
	@errorNumber int output,
	@errorMessage nvarchar(4000) output
AS
BEGIN
	SET NOCOUNT ON
	-- access levels
	DECLARE @REG_USERS varchar(30) = 'registered-users'
	DECLARE @ACCOUNT_MEMBERS_ONLY varchar(30) = 'account-members-only'
	DECLARE @ACCEPTED_GUESTS varchar(30) = 'accepted-guests'
	DECLARE @ACCOUNT_MEMBERS_PLUS_ACCEPTED_GUESTS varchar(30) = 'account-members-and-accepted-guests'
	DECLARE @ANYONE varchar(30) = 'anyone'
		
	SET @numOfMeetingsProcessed = 0
	SET @errorNumber = 0
	SET @errorMessage = ''
	
	IF (OBJECT_ID('tempdb..#pps_acl_entries_temp') IS NOT NULL)
	BEGIN
		DROP TABLE #pps_acl_entries_temp
	END
	ELSE
		
	CREATE TABLE #pps_acl_entries_temp (
	[ACL_ID] [bigint] NOT NULL,
	[PRINCIPAL_ID] [bigint] NULL,
	[PERMISSION_ID] [bigint] NULL,
	)
	
	-- Backup existing data into a temp table
	INSERT INTO #pps_acl_entries_temp (acl_id, principal_id, permission_id)
	SELECT s.sco_id, principal_id, permission_id
		FROM pps_scos s
			LEFT JOIN pps_acl_entries ae ON ae.acl_id = s.sco_id 
			WHERE s.[type] = 3 AND s.icon IN (3, 19) AND s.[disabled] IS NULL
				AND s.account_id = @accountId
				AND 
				(
					-- reg users + account members
					(
						@sourceAccessLevel = @ACCOUNT_MEMBERS_ONLY
						AND
						EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-12 AND ae2.permission_id=2)
						AND 
						EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-10 AND ae2.permission_id=6)
					)
					OR 
					-- reg users + accepted guests
					(
						@sourceAccessLevel = @ACCEPTED_GUESTS
						AND
						NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-10)
						AND
						NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-12)
					)
					OR 
					(
					-- reg users + account members + accepted guests
						@sourceAccessLevel = @ACCOUNT_MEMBERS_PLUS_ACCEPTED_GUESTS
						AND
						NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-10)
						AND
						EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-12)
					)
					OR
					(
					-- reg users + account members + accepted guests + anyone
						@sourceAccessLevel = @ANYONE 
						AND
						EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-10 AND ae2.permission_id=13)
						AND
						NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-12)
					)
					OR
					(
					-- reg users
						@sourceAccessLevel = @REG_USERS 
						AND
						EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-10 AND ae2.permission_id=6)
						AND
						NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae2 WHERE ae.acl_id=ae2.acl_id AND ae2.principal_id=-12)
					)
				)
	BEGIN TRY
		SET XACT_ABORT ON
		BEGIN TRANSACTION
			-- Delete existing data
			-- alias 'b' stands for 'backup'
			DELETE ae FROM pps_acl_entries ae 
				JOIN #pps_acl_entries_temp b ON ae.acl_id=b.acl_id 
				WHERE ae.principal_id IN (-10, -12)
				
			-- Now inject desired access level
			IF @targetAccessLevel = @REG_USERS
			BEGIN
				INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
				SELECT DISTINCT acl_id, -10 as principal_id, 6 as permission_id
					FROM #pps_acl_entries_temp
				END
			ELSE IF @targetAccessLevel = @ACCOUNT_MEMBERS_ONLY
			BEGIN
				INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
				SELECT DISTINCT acl_id, -10 as principal_id, 6 as permission_id
					FROM #pps_acl_entries_temp
				INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
				SELECT DISTINCT acl_id, -12 as principal_id, 2 as permission_id
					FROM #pps_acl_entries_temp
			END
			ELSE IF @targetAccessLevel = @ACCOUNT_MEMBERS_PLUS_ACCEPTED_GUESTS
			BEGIN
				INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
				SELECT DISTINCT acl_id, -12 as principal_id, 2 as permission_id
					FROM #pps_acl_entries_temp
			END
			ELSE IF @targetAccessLevel = @ANYONE
			BEGIN
				INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
				SELECT DISTINCT acl_id, -10 as principal_id, 13 as permission_id
					FROM #pps_acl_entries_temp
			END
		COMMIT
		SET @numOfMeetingsProcessed = (SELECT COUNT(DISTINCT acl_id) FROM #pps_acl_entries_temp)
	END TRY
	BEGIN CATCH  
		ROLLBACK
		SET @errorNumber = ERROR_NUMBER()
		SET @errorMessage = ERROR_MESSAGE()
	END CATCH
	DROP TABLE #pps_acl_entries_temp
END			
GO
--------------------------
--END Jira: CONN-4122287
--------------------------

--------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4125407 Closed Captions - Create a persistent token for each meeting room
--------------------------------------------------------------------------------------------
IF (OBJECT_ID('pps_ccapp_provider') IS NOT NULL)
BEGIN
	DROP TABLE pps_ccapp_provider
END
GO

IF dbo.isBigint() = 1
		BEGIN
			CREATE TABLE PPS_CCAPP_PROVIDER (
			CCAPP_PROVIDER_ID BIGINT NOT NULL,
			PROVIDER_MEETING_ID VARCHAR(150) NOT NULL,
			TOKEN VARCHAR(50) NOT NULL,
			SCO_ID BIGINT NOT NULL,
			ACCOUNT_ID BIGINT NOT NULL,
			PRINCIPAL_ID BIGINT NOT NULL,
			[DATE_MODIFIED] DATETIME NOT NULL,
			[DISABLED] DATETIME,
			CONSTRAINT [PK_PPS_CCAPP_PROVIDER] PRIMARY KEY CLUSTERED ([CCAPP_PROVIDER_ID] ASC)
			);
		END
	ELSE
		BEGIN
			CREATE TABLE PPS_CCAPP_PROVIDER (
			CCAPP_PROVIDER_ID BIGINT NOT NULL,
			PROVIDER_MEETING_ID VARCHAR(150) NOT NULL,
			TOKEN VARCHAR(50) NOT NULL,
			SCO_ID INT NOT NULL,
			ACCOUNT_ID INT NOT NULL,
			PRINCIPAL_ID INT NOT NULL,
			[DATE_MODIFIED] DATETIME NOT NULL,
			[DISABLED] DATETIME,
			CONSTRAINT [PK_PPS_CCAPP_PROVIDER] PRIMARY KEY CLUSTERED ([CCAPP_PROVIDER_ID] ASC)
			);
		END	
GO
	 
CREATE UNIQUE NONCLUSTERED INDEX PPS_CCAPP_PROVIDER_TOKEN ON PPS_CCAPP_PROVIDER (TOKEN ASC) WITH (FILLFACTOR=80, PAD_INDEX=ON)
GO
	 
CREATE INDEX PPS_CCAPP_PROVIDER_SCO_ID ON PPS_CCAPP_PROVIDER (SCO_ID) WITH (FILLFACTOR=80, PAD_INDEX=ON)
GO

ALTER TABLE PPS_CCAPP_PROVIDER 
	ADD CONSTRAINT FK_PPS_CCAPP_PROVIDER_ACCOUNT_ID FOREIGN KEY(ACCOUNT_ID) REFERENCES PPS_ACCOUNTS (ACCOUNT_ID)
GO
ALTER TABLE PPS_CCAPP_PROVIDER 
	ADD CONSTRAINT FK_PPS_CCAPP_PROVIDER_SCO_ID FOREIGN KEY(SCO_ID) REFERENCES PPS_SCOS (SCO_ID)
GO
ALTER TABLE PPS_CCAPP_PROVIDER 
	ADD CONSTRAINT FK_PPS_CCAPP_PROVIDER_PRINCIPAL_ID FOREIGN KEY(PRINCIPAL_ID) REFERENCES PPS_USERS (USER_ID)
GO
--------------------------
--END Jira: CONN-4125407
--------------------------

-----------------------------------------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4129261 Create API (and stored procedure, as needed) to enable bulk modification of recordings permissions
-----------------------------------------------------------------------------------------------------------------------------
DELETE FROM PPS_FEATURE_VERSIONS WHERE FEATURE_ID = 251
GO
DELETE FROM PPS_FEATURE_VERSIONS WHERE FEATURE_ID = 252
GO
IF EXISTS(SELECT TOP 1 1 FROM sys.procedures WHERE name = 'BulkModifyRecordingsAccessLevel')
	DROP PROCEDURE BulkModifyRecordingsAccessLevel
GO
----------------------------------------------------------------
-- Bulk modify access levels of all recordings for given account
----------------------------------------------------------------
CREATE PROCEDURE BulkModifyRecordingsAccessLevel
	@accountId bigint,
	@sourceAccessLevel varchar(30), -- public | account-members-only | private
	@targetAccessLevel varchar(30), -- public | account-members-only | private
	@password nvarchar(255), -- null or empty will considered as no-password
	@passwordInitVector nvarchar(255), -- used if password is given only
	@numOfRecordingsProcessed int = 0 output,
	@errorNumber int output,
	@errorMessage nvarchar(4000) output
AS
BEGIN
	SET NOCOUNT ON;
	SET XACT_ABORT ON
	SET @numOfRecordingsProcessed = 0
	SET @errorNumber = 0
	SET @errorMessage = ''
	

	DECLARE @public nvarchar(10) = 'public'
	DECLARE @accountMembersOnly nvarchar(25) = 'account-members-only'
	DECLARE @private nvarchar(10) = 'private'

	IF NOT EXISTS(SELECT TOP 1 1 FROM pps_accounts WHERE account_id = @accountId)
	BEGIN
		SET @errorNumber = 16
		SET @errorMessage = 'BulkModifyRecordingsAccessLevel - account does not exist'
		RAISERROR (@errorMessage, @errorNumber, -1); 
		RETURN
	END

	IF @sourceAccessLevel <> @public AND @sourceAccessLevel <> @accountMembersOnly AND @sourceAccessLevel <> @private
	BEGIN
		SET @errorNumber = 16
		SET @errorMessage = 'BulkModifyRecordingsAccessLevel - invalid source access level'
		RAISERROR (@errorMessage, @errorNumber, -1);
		RETURN
	END

	IF @targetAccessLevel <> @public AND @targetAccessLevel <> @accountMembersOnly AND @targetAccessLevel <> @private
	BEGIN
		SET @errorNumber = 16
		SET @errorMessage = 'BulkModifyRecordingsAccessLevel - invalid target access level'
		RAISERROR (@errorMessage, @errorNumber, -1); 
		RETURN
	END

	-- raise error if password is not empty but init vection was not provided
	IF LEN(@password) > 0 AND (@passwordInitVector IS NULL OR @passwordInitVector = '')
	BEGIN
		SET @errorNumber = 16
		SET @errorMessage = 'BulkModifyRecordingsAccessLevel - missing init vector'
		RAISERROR (@errorMessage, @errorNumber, -1); 
		RETURN
	END

	DECLARE @recIds TABLE (rec_id bigint not null primary key, is_in_meeting bit not null)

	INSERT INTO @recIds
	SELECT sco_id, 
		CASE WHEN folder_type.[type] IN (3, 19) THEN 1 ELSE 0 END is_in_meeting_recording
		FROM pps_scos recording WITH(NOLOCK)
		CROSS APPLY (SELECT TOP 1 1 AS is_recording  FROM pps_sco_assets sa 
									JOIN pps_assets a ON a.asset_id = sa.asset_id 
									JOIN pps_asset_entries ae ON ae.asset_id = a.asset_id 
									WHERE recording.sco_id = sa.sco_id  
								AND recording.version = sa.version 
								AND sa.asset_type = 0 -- output
								AND a.asset_id = ae.asset_id  
								AND (
									ae.filename <> '/common/players/flvplayer.swf'
									OR ae.filename NOT LIKE '%/shell.swf'
									OR ae.filename NOT LIKE '%\\shell.swf'
								)) x
		OUTER APPLY (SELECT TOP 1 s.[type] FROM pps_scos s WHERE sco_id = recording.folder_id) folder_type
		WHERE recording.account_id = @accountId
			AND recording.type IN (0, 15)  
			AND (recording.icon = 8 OR 
				(recording.icon = 1034 AND NOT EXISTS (SELECT 1 FROM pps_scos s2 WITH(NOLOCK) WHERE s2.sco_id = recording.source_sco_id AND s2.icon = 1034)
			))
			AND recording.[disabled] IS NULL

	DECLARE rec CURSOR FOR SELECT rec_id, is_in_meeting FROM @recIds
	DECLARE @recId bigint = 0
	DECLARE @isInMeeting bit = 0

	OPEN rec
	FETCH NEXT FROM rec INTO @recId, @isInMeeting

	DECLARE @currentAccessLevel varchar(25) = null
	DECLARE @isPublicAccess bit = 0
	DECLARE @isAccountMembersOnlyAccess bit = 0
	DECLARE @isPrivateAccess bit = 0

	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- check if there are custom permissions defined
		IF EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 6)
			AND NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -12)
		BEGIN
			FETCH NEXT FROM rec INTO @recId, @isInMeeting
			CONTINUE
		END
		BEGIN TRY
			BEGIN TRANSACTION
			IF @isInMeeting = 1
			BEGIN
				SET @isPublicAccess = (CASE WHEN EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 2) THEN 1 ELSE 0 END)
				SET @isAccountMembersOnlyAccess = (CASE WHEN EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -12 AND permission_id = 2) THEN 1 ELSE 0 END)
				SET @isPrivateAccess = (CASE WHEN EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 28) THEN 1 ELSE 0 END)

				SET @currentAccessLevel = (CASE 
											WHEN @isPublicAccess = 1 THEN @public
											WHEN @isAccountMembersOnlyAccess = 1 THEN @accountMembersOnly
											WHEN @isPrivateAccess = 1 THEN @private
											END
											)

				-- public
				IF @targetAccessLevel = @public AND @sourceAccessLevel = @currentAccessLevel
				BEGIN
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -12
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -10
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 223
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 406
					INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
					SELECT @recId, -10, 2

					IF @password IS NOT NULL
					BEGIN
						INSERT INTO pps_acl_fields (acl_id, field_id, value, RecordCreated)
						SELECT @recId, 223, @password, GETUTCDATE()

						INSERT INTO pps_acl_fields (acl_id, field_id, value, RecordCreated)
						SELECT @recId, 406, @passwordInitVector, GETUTCDATE()
					END
					SET @numOfRecordingsProcessed = @numOfRecordingsProcessed + 1
				END
				-- all account members
				ELSE IF @targetAccessLevel = @accountMembersOnly AND @sourceAccessLevel = @currentAccessLevel
				BEGIN
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -12
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -10
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 223
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 406
					INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
					SELECT @recId, -10, 28
					INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
					SELECT @recId, -12, 2
					SET @numOfRecordingsProcessed = @numOfRecordingsProcessed + 1
				END
				-- private
				ELSE IF @targetAccessLevel = @private AND @sourceAccessLevel = @currentAccessLevel
				BEGIN
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -10
					DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -12
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 223
					DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 406

					INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
					SELECT @recId, -10, 28
					SET @numOfRecordingsProcessed = @numOfRecordingsProcessed + 1
				END
			END
			ELSE 
			BEGIN
				IF EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 6)
					AND NOT EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -12)
				BEGIN
					PRINT 'Skipping SCO ID = ' + CAST(@recId AS varchar(20)) + ' because it has custom permissions set'
				END
				ELSE 
				BEGIN
					SET @isPublicAccess = (CASE WHEN EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 11) THEN 1 ELSE 0 END)
					SET @isAccountMembersOnlyAccess =
						(CASE WHEN
							EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -10 AND permission_id = 6)
							AND
							EXISTS(SELECT TOP 1 1 FROM pps_acl_entries ae WHERE ae.acl_id = @recId AND principal_id = -12 AND permission_id = 2)
							THEN 1
							ELSE 0
							END)

					SET @currentAccessLevel = (CASE 
												WHEN @isPublicAccess = 1 THEN @public
												WHEN @isAccountMembersOnlyAccess = 1 THEN @accountMembersOnly
												END
												)
					IF @targetAccessLevel = @public AND @sourceAccessLevel = @currentAccessLevel
					BEGIN
						DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -10
						DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -12
						DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 223
						DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 406
						IF @password IS NOT NULL
						BEGIN
							INSERT INTO pps_acl_fields (acl_id, field_id, value, RecordCreated)
							SELECT @recId, 223, @password, GETUTCDATE()

							INSERT INTO pps_acl_fields (acl_id, field_id, value, RecordCreated)
							SELECT @recId, 406, @passwordInitVector, GETUTCDATE()
						END
						INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
						SELECT @recId, -10, 11
						SET @numOfRecordingsProcessed = @numOfRecordingsProcessed + 1
					END
					ELSE IF @targetAccessLevel = @accountMembersOnly AND @sourceAccessLevel = @currentAccessLevel 
					BEGIN
						DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -10
						DELETE FROM pps_acl_entries WHERE acl_id = @recId AND principal_id = -12
						DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 223
						DELETE FROM pps_acl_fields WHERE acl_id = @recId AND field_id = 406
						INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
						SELECT @recId, -10, 6
						INSERT INTO pps_acl_entries (acl_id, principal_id, permission_id)
						SELECT @recId, -12, 2
						SET @numOfRecordingsProcessed = @numOfRecordingsProcessed + 1
					END
				END
			END
			COMMIT
		END TRY
		BEGIN CATCH  
			ROLLBACK
			SET @errorNumber = ERROR_NUMBER()
			SET @errorMessage = ERROR_MESSAGE()
			RETURN
		END CATCH
		FETCH NEXT FROM rec INTO @recId, @isInMeeting
	END
	CLOSE rec
	DEALLOCATE rec
	SET NOCOUNT OFF;
END
GO
-----------------------------------------------------------------------------------------------------------------------------
--END Jira: CONN-4129261
-----------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4085212 Uniforming DW table CRS_REPORTING_TABLE_DIM_SCO_DETAILS with view REPORTING_DIM_SCO_DETAILS
----------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM information_schema.views WHERE TABLE_NAME = 'REPORTING_DIM_SCO_DETAILS')
	DROP VIEW REPORTING_DIM_SCO_DETAILS
GO

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- dim_sco_details
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

CREATE VIEW REPORTING_DIM_SCO_DETAILS 
    AS 
        SELECT
            all_fields.sco_id,
            all_fields.sco_version,
            all_fields.name AS sco_name,
            all_fields.description AS sco_description,
            (SELECT e.name FROM pps_ext_enum_type e WHERE e.type = all_fields.type) AS sco_type,
            all_fields.type AS sco_int_type,
            all_fields.is_content,
				all_fields.is_recording,
            all_fields.url,
            all_fields.parent_name,
            
            CASE all_fields.type
                WHEN 15 THEN 
                    (SELECT TOP 1 
                        acl.parent_acl_id 
                    FROM 
                        pps_acl_rollup acl
						JOIN pps_scos wrapper ON acl.parent_acl_id = wrapper.sco_id 
                    WHERE
                        acl.acl_id = all_fields.sco_id AND
                        wrapper.icon IN (14, 19) AND
                        depth > 0
                    ORDER BY depth ASC)
               ELSE all_fields.parent_id
            END AS parent_sco_id,

            all_fields.parent_link_id AS parent_link_sco_id,

            CASE 
                WHEN all_fields.parent_type IN (0, 3) 
                THEN (SELECT name FROM pps_ext_enum_type WHERE type = all_fields.parent_icon)
                ELSE (SELECT name FROM pps_ext_enum_type WHERE type = all_fields.parent_type)
            END AS parent_type,

            all_fields.created_date AS date_sco_created,
            all_fields.modified_date AS date_sco_modified,
            all_fields.begin_date AS sco_start_date,
            all_fields.end_date AS sco_end_date,
            all_fields.version_start_date,
            all_fields.version_end_date,
            MAX(all_fields.sco_tag_id) AS sco_tag_id,
            
            CASE
                WHEN MAX(all_fields.passing_score) = 'NaN' THEN 0
                WHEN MAX(all_fields.passing_score) = NULL THEN 0
                ELSE MAX(all_fields.passing_score)
            END AS passing_score,  
            CASE
                WHEN MAX(all_fields.max_possible_score) = 'NaN' THEN 0
                WHEN MAX(all_fields.max_possible_score) = NULL THEN 0
                ELSE MAX(all_fields.max_possible_score)
            END AS max_possible_score,  

            all_fields.source_sco_id AS linked_sco_id,

            CASE all_fields.type
                WHEN 15 THEN 
                    (SELECT 
                        CASE s.type
                            WHEN 0 THEN (SELECT name FROM pps_ext_enum_type WHERE type = s.icon)
                            WHEN 3 THEN (SELECT name FROM pps_ext_enum_type WHERE type = s.icon)
                            ELSE (SELECT name FROM pps_ext_enum_type WHERE type = s.type)
                        END AS type 
                     FROM 
                        pps_scos s 
                     WHERE 
                        s.sco_id = all_fields.source_sco_id
                    )
                ELSE NULL
            END AS linked_type,

            CASE all_fields.type
                WHEN 15 THEN 
                    (SELECT 
                        CASE s.icon
                            WHEN 1 THEN (SELECT en.name FROM pps_ext_enum_type en, pps_scos s1 WHERE en.type = s1.icon AND s1.sco_id = s.source_sco_id)
                            ELSE NULL
                        END AS contents 
                     FROM 
                        pps_scos s 
                     WHERE 
                        s.sco_id = all_fields.source_sco_id
                    )
                WHEN 1 THEN 
                    (SELECT en.name FROM pps_ext_enum_type en, pps_scos s1 WHERE en.type = s1.icon AND s1.sco_id = all_fields.source_sco_id)
                ELSE NULL
            END AS linked_course_contents,
            (
                SELECT
                    owner_principal_id
                FROM
                    pps_acls
                WHERE
                    acl_id = all_fields.sco_id
            ) AS owner_user_id,
            (SELECT SUM(CONVERT(BIGINT,(a.byte_count))/1024)
                FROM pps_sco_assets sa, pps_assets a 
                WHERE a.asset_id = sa.asset_id AND sa.sco_id = all_fields.sco_id
            ) AS storage_bytes_kb,
            CASE all_fields.parent_name
                WHEN '{tree-type-content}' THEN '{true}'
                WHEN '{tree-type-courses}' THEN '{true}'
                WHEN '{tree-type-meetings}' THEN '{true}'
                ELSE '{false}'
            END AS is_shared,
            all_fields.account_id,
			all_fields.account_type
        FROM (
        SELECT 
            main_fields.sco_id,
            main_fields.sco_version,
            main_fields.name,
            main_fields.description,
            main_fields.type,
            main_fields.is_content,
				main_fields.is_recording,
            main_fields.url,
            main_fields.parent_id,
            main_fields.parent_link_id,
            (SELECT name FROM pps_scos WHERE sco_id = main_fields.parent_id) AS parent_name,
            (SELECT icon FROM pps_scos WHERE sco_id = main_fields.parent_id) AS parent_icon,
            (SELECT type FROM pps_scos WHERE sco_id = main_fields.parent_id) AS parent_type,
            main_fields.created_date,
            main_fields.modified_date,
            main_fields.begin_date,
            main_fields.end_date,
            main_fields.version_start_date,
            main_fields.version_end_date,
            main_fields.source_sco_id,
            main_fields.account_id,
			main_fields.account_type,
            CASE custom_fields.field_id WHEN 4 THEN custom_fields.value END AS sco_tag_id,
            CASE custom_fields.field_id WHEN 114 THEN custom_fields.value END AS passing_score,
            CASE custom_fields.field_id WHEN 117 THEN custom_fields.value END AS max_possible_score
        FROM
        (

            SELECT
                y.sco_id,

                CASE 
                    WHEN y.type = 14
                    THEN 1
                    WHEN y.version IS NULL
                    THEN 1
                    ELSE y.version
                END AS sco_version,   

                y.name,
                y.description,
                y.type,
                y.is_content,
					 y.is_recording,
                y.url,
                y.parent_id,
                y.parent_link_id,
                y.created_date,
                y.modified_date,
                y.begin_date,
                CASE 
                    WHEN y.asset_id IS NULL
                    THEN NULL
                    ELSE (SELECT MIN(date_created) FROM pps_transcripts WHERE asset_id = y.asset_id AND status IN ('P', 'F', 'C', 'I'))
                END AS version_start_date,   
                CASE 
                    WHEN y.asset_id IS NULL
                    THEN NULL
                    ELSE (SELECT MAX(date_closed) FROM pps_transcripts WHERE asset_id = y.asset_id AND status IN ('P', 'F', 'C', 'I'))
                END AS version_end_date,   
                y.source_sco_id,
                y.account_id,
				y.account_type,
                y.end_date
            FROM
            (
                SELECT
                    x.sco_id,
                    x.name,
                    x.description,
                    x.type,
                    x.is_content,
						  x.is_recording,
                    x.url,
                    x.parent_id,
                    x.parent_link_id,
                    x.created_date,
                    x.modified_date,
                    x.begin_date,
                    x.end_date,
                    x.source_sco_id,
                    x.account_id,
					x.account_type,
                    sa.version,
                    sa.asset_id
                FROM 
                (
                    SELECT
                        s.sco_id AS sco_id,
                        s.name,
                        s.description,

                        CASE
                            WHEN s.icon = 3 AND s.type = 3 AND EXISTS
                                (SELECT ss.sco_id
                                    FROM pps_scos ss, pps_acl_rollup p
                                    WHERE p.acl_id = s.sco_id
                                        AND p.parent_acl_id = ss.sco_id
                                        AND ss.name = '{tree-type-seminars}'
                                )
                            THEN 18
                            WHEN s.type IN (0, 3)
                            THEN s.icon
                            ELSE s.type
                        END AS type,

                        CASE 
                            WHEN (s.type = 0 AND s.icon != 1)
                            THEN '{true}'
                            ELSE '{false}'
                        END AS is_content,

								(SELECT CASE WHEN 
												s.[type] IN (0, 15) 
												AND s.icon IN (8, 1034)
												AND EXISTS(SELECT TOP 1 AE.FILENAME FROM pps_sco_assets sa  
														JOIN pps_assets a ON a.asset_id = sa.asset_id  
														JOIN pps_asset_entries ae ON ae.asset_id = a.asset_id  
														WHERE s.sco_id = sa.sco_id  
 															AND s.version = sa.version  
															AND sa.asset_type = 0  
															AND a.asset_id = ae.asset_id  
															AND ae.filename <> '/common/players/flvplayer.swf'  
															AND ae.filename NOT LIKE '%/shell.swf'  
															AND ae.filename NOT LIKE '%\\shell.swf')
									THEN '{true}' 
									ELSE '{false}' END
								) AS is_recording,

                        s.url_path AS url,
                        s.folder_id AS parent_id,
                        (SELECT TOP 1 sco_id FROM pps_scos where source_sco_id = s.folder_id) AS parent_link_id,
                        s.date_created AS created_date,
                        s.date_modified AS modified_date,
                        s.date_begin AS begin_date,
                        s.date_end AS end_date,
                        s.source_sco_id,
                        s.account_id,
						act.type as account_type
                    FROM
                        pps_scos s, pps_ext_enum_type e, pps_accounts act
                    WHERE
                        s.type = e.type AND
                        s.type IN (-1, 0, 3, 14, 15, 17) AND
                        s.disabled IS NULL AND 
						s.account_id = act.account_id AND
						act.disabled is null
                ) x

                LEFT OUTER JOIN 
                    pps_sco_assets sa
                ON
                    x.sco_id = sa.sco_id AND
                    sa.asset_type IN (0, 3)
            ) y
            
        ) main_fields
        LEFT OUTER JOIN
        ( SELECT acl_id, field_id, value  
        FROM 
            pps_acl_fields 
        WHERE 
            field_id IN(4, 114, 117)) custom_fields
        ON 
            custom_fields.acl_id = main_fields.sco_id ) all_fields 
        GROUP BY 
            all_fields.sco_id,
            all_fields.sco_version,
            all_fields.name,
            all_fields.description,
            all_fields.type,
            all_fields.is_content,
				all_fields.is_recording,
            all_fields.url,
            all_fields.parent_id,
            all_fields.parent_link_id,
            all_fields.parent_type,
            all_fields.parent_icon,
            all_fields.parent_name,
            all_fields.created_date,
            all_fields.modified_date,
            all_fields.begin_date,
            all_fields.end_date,
            all_fields.version_start_date,
            all_fields.version_end_date,
            all_fields.source_sco_id,
            all_fields.account_id,
			all_fields.account_type
            
GO
--------------------------
--END Jira: CONN-4085212
--------------------------

-------------------------------------------------------------------------------------------------------------------------
--BEGIN Jira: CONN-4085203 Uniforming view REPORTING_VIEW_MEETING_STATUS with DW table CRS_REPORTING_TABLE_MEETING_STATUS 
-------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM information_schema.views WHERE TABLE_NAME = 'REPORTING_VIEW_MEETING_STATUS')
	DROP VIEW REPORTING_VIEW_MEETING_STATUS
GO

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- view_meeting_status
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
CREATE VIEW REPORTING_VIEW_MEETING_STATUS 
    AS 
	WITH
	t_scos_all (sco_id, reporting_sco_id, principal_id, account_id, meeting_type, [type], source_sco_id) AS
	(
		-- invited users
		SELECT 
            s.sco_id, s.sco_id AS reporting_sco_id, 
			
			g.principal_id, s.account_id, 
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type,
			s.source_sco_id
        FROM 
		pps_scos s
        JOIN pps_acl_entries ae ON ae.acl_id = s.sco_id 
		JOIN pps_group_member_rollup g ON ae.principal_id = g.group_id
		JOIN pps_accounts a ON a.account_id = s.account_id
		WHERE 
		EXISTS (SELECT 1 FROM pps_principals p WHERE g.principal_id = p.principal_id AND p.has_children = 0 AND p.disabled IS NULL) AND
        ae.permission_id IN (2, 10, 22) AND
        s.type = 3 AND
		s.account_id IS NOT NULL AND
		a.disabled IS NULL AND a.date_expired > getutcdate() + 30

		UNION ALL

		-- attendees
        SELECT 
            t.sco_id, s.sco_id AS reporting_sco_id,  
			ISNULL(t.principal_id, -t.session_id) AS principal_id, 
			s.account_id,
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type,
			s.source_sco_id
        FROM
			pps_transcripts t
			JOIN pps_scos s ON t.sco_id = s.sco_id
			JOIN pps_accounts a ON a.account_id = s.account_id
			WHERE
				s.type = 3 AND
				t.status IN ('P', 'F', 'C', 'I') AND
				s.account_id IS NOT NULL AND
				a.disabled IS NULL AND a.date_expired > getutcdate() + 30
		
		UNION ALL

		-- inivited users via link
		SELECT 
			links.sco_id, links.source_sco_id AS reporting_sco_id, 
			
            g.principal_id, s.account_id,
            CASE 
                WHEN source.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type, 
			links.source_sco_id
            FROM 
                pps_acl_entries ae
				JOIN pps_group_member_rollup g ON ae.principal_id = g.group_id 
				JOIN pps_scos s ON ae.acl_id = s.sco_id
				JOIN pps_scos links ON s.sco_id = links.folder_id
				JOIN pps_scos source ON links.source_sco_id = source.sco_id
				JOIN pps_accounts a ON a.account_id = s.account_id
            WHERE 
				EXISTS (SELECT 1 FROM pps_principals p WHERE g.principal_id = p.principal_id AND p.has_children = 0 AND p.disabled IS NULL) AND
                ae.permission_id IN (2, 10, 22) AND
                (s.type = 14) AND
                links.type = 15 AND
                source.type = 3 AND
				s.account_id IS NOT NULL AND
				a.disabled IS NULL AND a.date_expired > getutcdate() + 30

		UNION ALL

		-- attendees via link
        SELECT
            links.sco_id, 
			links.source_sco_id AS reporting_sco_id, 
			ISNULL(t.principal_id, -t.session_id) AS principal_id, 
			s.account_id,
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type, 
			links.source_sco_id
			-- , t.asset_id
        FROM
			pps_transcripts t
			JOIN pps_scos links ON t.sco_id = links.sco_id
			JOIN pps_scos s ON links.source_sco_id = s.sco_id
			JOIN pps_accounts a ON a.account_id = s.account_id
		WHERE
			s.type IN (3, 19) AND
			links.type = 15 AND
			t.status IN ('P', 'F', 'C', 'I') AND
			links.account_id IS NOT NULL AND
			a.disabled IS NULL AND a.date_expired > getutcdate() + 30
	)
	, t_scos (sco_id, reporting_sco_id, principal_id, account_id, meeting_type, [type], source_sco_id) AS (
		SELECT DISTINCT * FROM t_scos_all
	)
	, t_peak_attendees (acl_id, peak_session_users) AS (
		SELECT acl_id, MAX(tc.transcript_count) AS peak_session_users FROM pps_transcript_counts tc GROUP BY acl_id
	)
	SELECT 
	-- principal/SCO dim/fact
	ss.sco_id AS dim_sco_details_sco_id,
	ISNULL(sapf.dim_sco_details_sco_version, 1) AS dim_sco_details_sco_version,
	-- certificate: version, ID
	cert.version_accessed,
	cert.certificate_id,
	ss.principal_id as dim_users_user_id,
	(SELECT TOP 1 
		CASE
			WHEN tt.date_created IS NULL THEN NULL
			WHEN tt.principal_id IS NULL AND tt.date_created IS NOT NULL THEN '{guest}'
			WHEN tt.permission_id = 10 THEN '{host}'
			WHEN tt.permission_id = 22 THEN '{presenter}'
			ELSE '{participant}'
		END AS entry_role
		FROM pps_transcripts tt WHERE tt.sco_id = ss.reporting_sco_id AND tt.status IN ('P', 'F', 'C', 'I') AND ISNULL(tt.principal_id, -tt.session_id) = ss.principal_id
		ORDER BY ISNULL(date_closed, DATEADD(minute, 30, date_created)) DESC
	) AS entry_role,
	spf.total_time_seconds,
	spf.date_first_attendance,
	spf.date_last_attendance,
	spf.sessions_attended,
	spf.sessions_attended AS distinct_sessions,
	sapf.average_time_seconds,
	CASE WHEN spf.sessions_attended > 0 THEN '{true}' ELSE '{false}' END AS attended,
	-- most recent session
	msi.is_mobile,
	-- SCO fact
	(SELECT TOP 1 peak_session_users FROM t_peak_attendees pa WHERE pa.acl_id = ss.reporting_sco_id) AS peak_session_users,
	stf.date_first_session,
	stf.date_last_session,
	stf.average_session_duration_seconds,
    (SELECT 
        CASE
            WHEN COUNT(tt.asset_id) = 0 THEN 0
			ELSE CAST(stf.distinct_attendees_count AS float)/stf.distinct_asset_count
        END
        FROM pps_transcripts tt
        WHERE tt.sco_id = ss.reporting_sco_id AND tt.status IN ('P', 'F', 'C', 'I')
    ) AS average_session_users,
	t_total_content_bytes.total_content_bytes_kb,
	ss.meeting_type,
	af.[value] AS dim_cost_center_id,
	gsf.number_of_guest_attendees,
	msf.total_mobile_minutes,
	msf.total_mobile_users,
	ss.account_id
	FROM t_scos ss
		-- mobile session info
		LEFT JOIN (SELECT DISTINCT tt.sco_id, ISNULL(tt.principal_id, -tt.session_id) AS principal_id, us.is_mobile 
					FROM pps_transcripts tt 
					JOIN pps_user_sessions us ON tt.session_id = us.session_id 
					WHERE tt.status IN ('P', 'C', 'F', 'I') 
		) msi ON msi.principal_id = ss.principal_id AND msi.sco_id = ss.reporting_sco_id
		-- SCO-principal facts
		LEFT JOIN (SELECT 
					tt.sco_id, 
					(CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END) AS principal_id,
					SUM(
						CASE 
							WHEN tt.date_closed IS NULL THEN 1800
							ELSE DATEDIFF(second, tt.date_created, tt.date_closed)
					END) AS total_time_seconds,
					MIN(tt.date_created) AS date_first_attendance,
					MAX(tt.date_closed) AS date_last_attendance,
					COUNT(DISTINCT tt.asset_id) AS sessions_attended
					FROM pps_transcripts tt WHERE tt.status IN ('P', 'F', 'C', 'I') 
					GROUP BY tt.sco_id, (CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END)
		) spf ON spf.sco_id = ss.reporting_sco_id AND spf.principal_id = ss.principal_id
		-- certificate
		LEFT JOIN (SELECT 
					tt.sco_id, 
					(CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END) AS principal_id,
					MAX(tt.transcript_id) AS certificate_id,
					MAX(sa.version) AS version_accessed
					FROM pps_transcripts tt JOIN pps_sco_assets sa ON tt.sco_id = sa.sco_id AND tt.asset_id = sa.asset_id AND sa.asset_type = 3
					WHERE tt.status IN ('P', 'C')
					GROUP BY tt.sco_id, (CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END)
		) cert ON cert.sco_id = ss.reporting_sco_id AND cert.principal_id = ss.principal_id
		-- SCO-asset principal facts
		LEFT JOIN (
			SELECT sa.sco_id, ISNULL(tt.principal_id, -tt.session_id) AS principal_id, MAX(sa.version) AS dim_sco_details_sco_version
			, AVG(
				CASE 
					WHEN tt.date_closed IS NULL THEN 1800
					ELSE DATEDIFF(second, tt.date_created, tt.date_closed) END
				)  AS average_time_seconds
				FROM pps_Sco_assets sa 
					JOIN pps_transcripts tt ON sa.sco_id = tt.sco_id AND sa.asset_id = tt.asset_id 
				WHERE sa.asset_type = 3 AND tt.status IN ('P', 'F', 'C', 'I')
			GROUP BY sa.sco_id, ISNULL(tt.principal_id, -tt.session_id)
		) sapf ON sapf.sco_id = ss.sco_id AND sapf.principal_id = ss.principal_id
		-- cost center
		LEFT JOIN pps_acl_fields af ON af.acl_id = ss.reporting_sco_id AND af.field_id = 131
		-- SCO transcripts fact
		LEFT JOIN (
			SELECT 
				tt.sco_id,
				MIN(tt.date_created) AS date_first_session,
				MAX(tt.date_closed) AS date_last_session,
				AVG(
					CASE 
						WHEN tt.date_closed IS NULL THEN 1800
						ELSE DATEDIFF(second, tt.date_created, tt.date_closed) 
					END
				) AS average_session_duration_seconds,
				COUNT(DISTINCT ISNULL(tt.principal_id, -tt.session_id)) AS distinct_attendees_count,
				COUNT(DISTINCT tt.asset_id) AS distinct_asset_count
				FROM pps_transcripts tt 
				WHERE tt.status IN ('P', 'F', 'C', 'I')
				GROUP BY tt.sco_id
		) AS stf ON stf.sco_id = ss.reporting_sco_id
		-- content size summary
		LEFT JOIN 
			(SELECT s1.folder_id, SUM(a.byte_count)/1024 AS total_content_bytes_kb
				FROM pps_sco_assets sa 
				JOIN pps_assets a ON a.asset_id = sa.asset_id
				JOIN pps_scos s1 ON sa.sco_id = s1.sco_id
				GROUP BY s1.folder_id
			) AS t_total_content_bytes ON ss.reporting_sco_id = t_total_content_bytes.folder_id
		-- guest sessions fact
		LEFT JOIN (
			SELECT tt.sco_id, COUNT(DISTINCT(us.[name])) AS number_of_guest_attendees 
				FROM pps_user_sessions us 
					JOIN pps_transcripts tt ON us.session_id = tt.session_id 
				WHERE tt.principal_id IS NULL
					AND tt.status IN ('P', 'F', 'C', 'I')
				GROUP BY tt.sco_id
			) gsf ON gsf.sco_id = ss.reporting_sco_id
		-- mobile sessions fact
		LEFT JOIN (
			SELECT 
				tt.sco_id, 
				SUM(
					CASE 
						WHEN tt.date_closed IS NULL THEN 30
						ELSE DATEDIFF(minute, tt.date_created, tt.date_closed) 
					END
				) AS total_mobile_minutes,
				COUNT(DISTINCT(us.[name])) AS total_mobile_users
				FROM pps_user_sessions us 
					JOIN pps_transcripts tt ON us.session_id = tt.session_id 
				WHERE tt.status IN ('P', 'F', 'C', 'I') AND us.is_mobile = 1
				GROUP BY tt.sco_id
		) msf ON msf.sco_id = ss.reporting_sco_id
GO
--------------------------
--END Jira: CONN-4085203
--------------------------

----------------------------------------------------------
--BEGIN Jira: CONN-4129547 - Reports displaying NaN values
----------------------------------------------------------
GO
IF EXISTS(SELECT TOP 1 1 FROM sys.views WHERE name = 'REPORTING_VIEW_MEETING_STATUS')
	DROP VIEW REPORTING_VIEW_MEETING_STATUS
GO
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
-- view_meeting_status
-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
CREATE VIEW REPORTING_VIEW_MEETING_STATUS 
    AS 
	WITH
	t_scos_all (sco_id, reporting_sco_id, principal_id, account_id, meeting_type, [type], source_sco_id) AS
	(
		-- invited users
		SELECT 
            s.sco_id, s.sco_id AS reporting_sco_id, 
			
			g.principal_id, s.account_id, 
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type,
			s.source_sco_id
        FROM 
		pps_scos s
        JOIN pps_acl_entries ae ON ae.acl_id = s.sco_id 
		JOIN pps_group_member_rollup g ON ae.principal_id = g.group_id
		JOIN pps_accounts a ON a.account_id = s.account_id
		WHERE 
		EXISTS (SELECT 1 FROM pps_principals p WHERE g.principal_id = p.principal_id AND p.has_children = 0 AND p.disabled IS NULL) AND
        ae.permission_id IN (2, 10, 22) AND
        s.type = 3 AND
		s.account_id IS NOT NULL AND
		a.disabled IS NULL AND a.date_expired > getutcdate() + 30

		UNION ALL

		-- attendees
        SELECT 
            t.sco_id, s.sco_id AS reporting_sco_id,  
			ISNULL(t.principal_id, -t.session_id) AS principal_id, 
			s.account_id,
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type,
			s.source_sco_id
        FROM
			pps_transcripts t
			JOIN pps_scos s ON t.sco_id = s.sco_id
			JOIN pps_accounts a ON a.account_id = s.account_id
			WHERE
				s.type = 3 AND
				t.status IN ('P', 'F', 'C', 'I') AND
				s.account_id IS NOT NULL AND
				a.disabled IS NULL AND a.date_expired > getutcdate() + 30
		
		UNION ALL

		-- inivited users via link
		SELECT 
			links.sco_id, links.source_sco_id AS reporting_sco_id, 
			
            g.principal_id, s.account_id,
            CASE 
                WHEN source.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type, 
			links.source_sco_id
            FROM 
                pps_acl_entries ae
				JOIN pps_group_member_rollup g ON ae.principal_id = g.group_id 
				JOIN pps_scos s ON ae.acl_id = s.sco_id
				JOIN pps_scos links ON s.sco_id = links.folder_id
				JOIN pps_scos source ON links.source_sco_id = source.sco_id
				JOIN pps_accounts a ON a.account_id = s.account_id
            WHERE 
				EXISTS (SELECT 1 FROM pps_principals p WHERE g.principal_id = p.principal_id AND p.has_children = 0 AND p.disabled IS NULL) AND
                ae.permission_id IN (2, 10, 22) AND
                (s.type = 14) AND
                links.type = 15 AND
                source.type = 3 AND
				s.account_id IS NOT NULL AND
				a.disabled IS NULL AND a.date_expired > getutcdate() + 30

		UNION ALL

		-- attendees via link
        SELECT
            links.sco_id, 
			links.source_sco_id AS reporting_sco_id, 
			ISNULL(t.principal_id, -t.session_id) AS principal_id, 
			s.account_id,
            CASE 
                WHEN s.icon = 19 
                THEN '{classroom}'                       
                ELSE '{meeting}'
            END AS meeting_type,
			s.type, 
			links.source_sco_id
			-- , t.asset_id
        FROM
			pps_transcripts t
			JOIN pps_scos links ON t.sco_id = links.sco_id
			JOIN pps_scos s ON links.source_sco_id = s.sco_id
			JOIN pps_accounts a ON a.account_id = s.account_id
		WHERE
			s.type IN (3, 19) AND
			links.type = 15 AND
			t.status IN ('P', 'F', 'C', 'I') AND
			links.account_id IS NOT NULL AND
			a.disabled IS NULL AND a.date_expired > getutcdate() + 30
	)
	, t_scos (sco_id, reporting_sco_id, principal_id, account_id, meeting_type, [type], source_sco_id) AS (
		SELECT DISTINCT * FROM t_scos_all
	)
	, t_peak_attendees (acl_id, peak_session_users) AS (
		SELECT acl_id, MAX(tc.transcript_count) AS peak_session_users FROM pps_transcript_counts tc GROUP BY acl_id
	)
	SELECT 
	-- principal/SCO dim/fact
	ss.sco_id AS dim_sco_details_sco_id,
	ISNULL(sapf.dim_sco_details_sco_version, 1) AS dim_sco_details_sco_version,
	-- certificate: version, ID
	cert.version_accessed,
	cert.certificate_id,
	ss.principal_id as dim_users_user_id,
	(SELECT TOP 1 
		CASE
			WHEN tt.date_created IS NULL THEN NULL
			WHEN tt.principal_id IS NULL AND tt.date_created IS NOT NULL THEN '{guest}'
			WHEN tt.permission_id = 10 THEN '{host}'
			WHEN tt.permission_id = 22 THEN '{presenter}'
			ELSE '{participant}'
		END AS entry_role
		FROM pps_transcripts tt WHERE tt.sco_id = ss.reporting_sco_id AND tt.status IN ('P', 'F', 'C', 'I') AND ISNULL(tt.principal_id, -tt.session_id) = ss.principal_id
		ORDER BY ISNULL(date_closed, DATEADD(minute, 30, date_created)) DESC
	) AS entry_role,
	spf.total_time_seconds,
	spf.date_first_attendance,
	spf.date_last_attendance,
	ISNULL(spf.sessions_attended, 0) AS sessions_attended,
	ISNULL(stf.distinct_attendees_count, 0) AS distinct_sessions,
	sapf.average_time_seconds,
	CASE WHEN spf.sessions_attended > 0 THEN '{true}' ELSE '{false}' END AS attended,
	-- most recent session
	msi.is_mobile,
	-- SCO fact
	(SELECT TOP 1 peak_session_users FROM t_peak_attendees pa WHERE pa.acl_id = ss.reporting_sco_id) AS peak_session_users,
	stf.date_first_session,
	stf.date_last_session,
	stf.average_session_duration_seconds,
    (SELECT 
        CASE
            WHEN COUNT(tt.asset_id) = 0 THEN 0
			ELSE CAST(stf.distinct_attendees_count AS float)/stf.distinct_asset_count
        END
        FROM pps_transcripts tt
        WHERE tt.sco_id = ss.reporting_sco_id AND tt.status IN ('P', 'F', 'C', 'I')
    ) AS average_session_users,
	ISNULL(t_total_content_bytes.total_content_bytes_kb, 0) AS total_content_bytes_kb,
	ss.meeting_type,
	af.[value] AS dim_cost_center_id,
	ISNULL(gsf.number_of_guest_attendees, 0) AS number_of_guest_attendees,
	msf.total_mobile_minutes,
	msf.total_mobile_users,
	ss.account_id
	FROM t_scos ss
		-- mobile session info
		LEFT JOIN (SELECT DISTINCT tt.sco_id, ISNULL(tt.principal_id, -tt.session_id) AS principal_id, us.is_mobile 
					FROM pps_transcripts tt 
					JOIN pps_user_sessions us ON tt.session_id = us.session_id 
					WHERE tt.status IN ('P', 'C', 'F', 'I') 
		) msi ON msi.principal_id = ss.principal_id AND msi.sco_id = ss.reporting_sco_id
		-- SCO-principal facts
		LEFT JOIN (SELECT 
					tt.sco_id, 
					(CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END) AS principal_id,
					SUM(
						CASE 
							WHEN tt.date_closed IS NULL THEN 1800
							ELSE DATEDIFF(second, tt.date_created, tt.date_closed)
					END) AS total_time_seconds,
					MIN(tt.date_created) AS date_first_attendance,
					MAX(tt.date_closed) AS date_last_attendance,
					COUNT(DISTINCT tt.asset_id) AS sessions_attended
					FROM pps_transcripts tt WHERE tt.status IN ('P', 'F', 'C', 'I') 
					GROUP BY tt.sco_id, (CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END)
		) spf ON spf.sco_id = ss.reporting_sco_id AND spf.principal_id = ss.principal_id
		-- certificate
		LEFT JOIN (SELECT 
					tt.sco_id, 
					(CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END) AS principal_id,
					MAX(tt.transcript_id) AS certificate_id,
					MAX(sa.version) AS version_accessed
					FROM pps_transcripts tt JOIN pps_sco_assets sa ON tt.sco_id = sa.sco_id AND tt.asset_id = sa.asset_id AND sa.asset_type = 3
					WHERE tt.status IN ('P', 'C')
					GROUP BY tt.sco_id, (CASE WHEN tt.principal_id IS NOT NULL THEN tt.principal_id ELSE -tt.session_id END)
		) cert ON cert.sco_id = ss.reporting_sco_id AND cert.principal_id = ss.principal_id
		-- SCO-asset principal facts
		LEFT JOIN (
			SELECT sa.sco_id, ISNULL(tt.principal_id, -tt.session_id) AS principal_id, MAX(sa.version) AS dim_sco_details_sco_version
			, AVG(
				CASE 
					WHEN tt.date_closed IS NULL THEN 1800
					ELSE DATEDIFF(second, tt.date_created, tt.date_closed) END
				)  AS average_time_seconds
				FROM pps_Sco_assets sa 
					JOIN pps_transcripts tt ON sa.sco_id = tt.sco_id AND sa.asset_id = tt.asset_id 
				WHERE sa.asset_type = 3 AND tt.status IN ('P', 'F', 'C', 'I')
			GROUP BY sa.sco_id, ISNULL(tt.principal_id, -tt.session_id)
		) sapf ON sapf.sco_id = ss.sco_id AND sapf.principal_id = ss.principal_id
		-- cost center
		LEFT JOIN pps_acl_fields af ON af.acl_id = ss.reporting_sco_id AND af.field_id = 131
		-- SCO transcripts fact
		LEFT JOIN (
			SELECT 
				tt.sco_id,
				MIN(tt.date_created) AS date_first_session,
				MAX(tt.date_closed) AS date_last_session,
				AVG(
					CASE 
						WHEN tt.date_closed IS NULL THEN 1800
						ELSE DATEDIFF(second, tt.date_created, tt.date_closed) 
					END
				) AS average_session_duration_seconds,
				COUNT(DISTINCT ISNULL(tt.principal_id, -tt.session_id)) AS distinct_attendees_count,
				COUNT(DISTINCT tt.asset_id) AS distinct_asset_count
				FROM pps_transcripts tt 
				WHERE tt.status IN ('P', 'F', 'C', 'I')
				GROUP BY tt.sco_id
		) AS stf ON stf.sco_id = ss.reporting_sco_id
		-- content size summary
		LEFT JOIN 
			(SELECT s1.folder_id, SUM(a.byte_count)/1024 AS total_content_bytes_kb
				FROM pps_sco_assets sa 
				JOIN pps_assets a ON a.asset_id = sa.asset_id
				JOIN pps_scos s1 ON sa.sco_id = s1.sco_id
				GROUP BY s1.folder_id
			) AS t_total_content_bytes ON ss.reporting_sco_id = t_total_content_bytes.folder_id
		-- guest sessions fact
		LEFT JOIN (
			SELECT tt.sco_id, COUNT(DISTINCT(us.[name])) AS number_of_guest_attendees 
				FROM pps_user_sessions us 
					JOIN pps_transcripts tt ON us.session_id = tt.session_id 
				WHERE tt.principal_id IS NULL
					AND tt.status IN ('P', 'F', 'C', 'I')
				GROUP BY tt.sco_id
			) gsf ON gsf.sco_id = ss.reporting_sco_id
		-- mobile sessions fact
		LEFT JOIN (
			SELECT 
				tt.sco_id, 
				SUM(
					CASE 
						WHEN tt.date_closed IS NULL THEN 30
						ELSE DATEDIFF(minute, tt.date_created, tt.date_closed) 
					END
				) AS total_mobile_minutes,
				COUNT(DISTINCT(us.[name])) AS total_mobile_users
				FROM pps_user_sessions us 
					JOIN pps_transcripts tt ON us.session_id = tt.session_id 
				WHERE tt.status IN ('P', 'F', 'C', 'I') AND us.is_mobile = 1
				GROUP BY tt.sco_id
		) msf ON msf.sco_id = ss.reporting_sco_id
GO
--------------------------
--END Jira: CONN-4129547
--------------------------

--------------------------------------
-- End of updates
--------------------------------------

--------------------------------------------------------------------
-- BEGIN REFRESH block
--
-- Recompile SPs, views and other objects that need to be recompiled
-- Please DO NOT change following lines
--------------------------------------------------------------------
GO
IF CURSOR_STATUS('global', 'ObjectCursor') >= -1
BEGIN
	DEALLOCATE ObjectCursor;
END
GO

DECLARE @Name nvarchar(1000);
DECLARE @Sql nvarchar(1000);
DECLARE @Result int;

DECLARE ObjectCursor CURSOR FAST_FORWARD FOR
	SELECT SCHEMA_NAME(o.schema_id) + '.[' + OBJECT_NAME(o.object_id) + ']'
	FROM sys.objects o 
	WHERE type_desc IN ('SQL_STORED_PROCEDURE', 'SQL_TRIGGER', 'SQL_SCALAR_FUNCTION', 'SQL_TABLE_VALUED_FUNCTION',
								'SQL_INLINE_TABLE_VALUED_FUNCTION',	'VIEW')
	AND ISNULL(OBJECTPROPERTY(o.object_id,'IsSchemaBound'), 0) = 0	 -- don't check schemabinding they don't like it

OPEN ObjectCursor;
FETCH NEXT FROM ObjectCursor INTO @Name;

WHILE @@FETCH_STATUS = 0
BEGIN
   SET @Sql = N'EXEC sp_refreshsqlmodule ''' + @Name + '''';
   PRINT @Sql;

   BEGIN TRY
		EXEC @Result = sp_executesql @Sql;
		IF @Result <> 0 RAISERROR('Failed', 16, 1);
   END TRY
   BEGIN CATCH
		-- PRINT @Sql
      PRINT 'The module ''' + @Name + ''' does not compile.';
   IF @@TRANCOUNT > 0 ROLLBACK TRANSACTION;
    END CATCH

    FETCH NEXT FROM ObjectCursor INTO @Name;
END

CLOSE ObjectCursor;
DEALLOCATE ObjectCursor;
GO

----------------------------------------------------------------------------------------------------------
-- Change the version number to match the file build number below
-- MINOR_RELEASE is tantamount to Service Pack
-- The REVISION field should never really be set to anything other than 0 in the DB update scripts context
----------------------------------------------------------------------------------------------------------
UPDATE PPS_DATABASE_VERSION 
	SET MAJOR_RELEASE = 11, 
	MINOR_RELEASE = 3, 
	[UPDATE] = 0, 
	REVISION = 0
GO

EXECUTE updateLogger '$Id: //depot/main/AdobeConnect/components/dbscripts/updates/update_11_3_0_0.sql#2 $', '$Change: 1425020 $', 'Finish';
GO
SET NOEXEC OFF
SET NOCOUNT OFF
GO