SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE OR ALTER PROCEDURE [dbo].[ReportingDAL_getReportQuizResults] 
	@curriculum bigint,
    @sco bigint,
	@account bigint,
    @emailFieldId int = 1,
    @trainingType int,
    @principal bigint,
	@transcript bigint = null,
	@type int = 8,
	@filter nvarchar(400)
AS
	SET NOCOUNT ON;
	DECLARE @sql NVARCHAR(MAX)
	SET @sql = ''
    SET @sql = @sql + 'WITH PrincipalsTree ( prin_id, login, status, has_children) AS'  
    SET @sql = @sql + '('  
    SET @sql = @sql + '	SELECT principal_id as prin_id, p.login as login, ''N'' as status, has_children FROM   '  
    SET @sql = @sql + '		(SELECT p.principal_id, p.login, p.name, p.has_children, e.permission_id FROM pps_principals p '  
    SET @sql = @sql + '	      LEFT OUTER JOIN pps_acl_entries AS e WITH (INDEX(PK2_PPS_ACL_ENTRIES)) ON e.principal_id = p.principal_id '
	IF @sco IS NOT NULL
	BEGIN
		SET @sql = @sql + ' AND e.acl_id= ' 
		SET @sql = @sql + '  (SELECT CASE S.TYPE WHEN 15 THEN S.FOLDER_ID ELSE S.SCO_ID END AS ACL_ID '  
		SET @sql = @sql + '    FROM (SELECT TYPE, FOLDER_ID, SCO_ID FROM PPS_SCOS WHERE SCO_ID=' + CAST(@sco AS NVARCHAR(30))
		SET @sql = @sql + ') S) '
	END
    SET @sql = @sql + '  WHERE (p.principal_id IN (-10, -12) OR p.account_id = ' + CAST(@account AS NVARCHAR(30)) + ' AND p.disabled IS NULL)) p    '  
	SET @sql = @sql + '			LEFT OUTER JOIN    (SELECT value AS email, acl_id, field_id from pps_acl_fields) ' 
	SET @sql = @sql + '			AS f ON p.principal_id = f.acl_id AND f.field_id=' + CAST(@emailFieldId AS NVARCHAR(10))  
    SET @sql = @sql + '			LEFT OUTER JOIN    (SELECT prin.principal_id AS training_group_id, ''true'' AS is_training_group  '  
	SET @sql = @sql + '		FROM pps_principals prin  '  
    SET @sql = @sql + '			WHERE prin.principal_id in (   '  
    SET @sql = @sql + '				SELECT acl_id   FROM pps_acls a WHERE a.owner_principal_id = (   '  
	SET @sql = @sql + '               SELECT principal_id '  
	SET @sql = @sql + '					FROM pps_principals '  
	SET @sql = @sql + '					WHERE account_id = ' + CAST(@account AS NVARCHAR(30)) 
	SET @sql = @sql + '                  AND type IN (-1000, ' + CAST(@trainingType AS NVARCHAR(20)) + ')   AND disabled IS NULL AND is_primary = 1 '  
	SET @sql = @sql + '				)   '  
	SET @sql = @sql + '			)'  
	SET @sql = @sql + '		) training ON (p.principal_id = training.training_group_id) WHERE 1 = 1  AND PRINCIPAL_ID NOT IN (-12,-10) AND PERMISSION_ID IS NOT NULL '  
	SET @sql = @sql + '), actual_results as ('  
    SET @sql = @sql + '	SELECT * FROM ('
	SET @sql = @sql + '   SELECT t.transcript_id, t.sco_id, p.principal_id as p_id, p.login, t.status AS display_status, t.score, t.max_score, '  
    SET @sql = @sql + '     t.date_created, t.asset_id, t.permission_id, X.attempts, ' 
	SET @sql = @sql + '     tt.time_taken, '
	SET @sql = @sql + '    	(CASE t.status '  
	SET @sql = @sql + '    		   WHEN ''P'' THEN t.transcript_id '  
	SET @sql = @sql + '    		   WHEN ''C'' THEN t.transcript_id '  
	SET @sql = @sql + '    	END) AS certificate, '
	SET @sql = @sql + '		p.name AS principal_name,  '  
	SET @sql = @sql + '		(CASE scos.type   '  
	SET @sql = @sql + '			WHEN 15 THEN (SELECT max(version) FROM pps_sco_assets sa WHERE '  
	SET @sql = @sql + '							sa.asset_id = t.asset_id and '  
	SET @sql = @sql + '							sa.sco_id = scos.source_sco_id) '  
	SET @sql = @sql + '		 	ELSE (SELECT max(version) FROM pps_sco_assets sa WHERE '  
	SET @sql = @sql + '		 					sa.asset_id = t.asset_id and '  
	SET @sql = @sql + '							sa.sco_id = scos.sco_id) '  
	SET @sql = @sql + '		END) AS version, '  
	SET @sql = @sql + '		(CASE (SELECT count(US.SESSION_COOKIE) AS SESSION_COOKIE FROM '  
	SET @sql = @sql + '				PPS_USER_SESSIONS US WHERE T.SESSION_ID = US.SESSION_ID AND '  
	SET @sql = @sql + '				US.SESSION_COOKIE LIKE ''tsovr%'')'
	SET @sql = @sql + '				WHEN 0 THEN ''false'' '  
	SET @sql = @sql + '				ELSE ''true'' '  
	SET @sql = @sql + '				END) as override ' 
	SET @sql = @sql + '		FROM pps_scos scos,  pps_principals p '  
	SET @sql = @sql + '		LEFT OUTER JOIN '  
	SET @sql = @sql + '       (SELECT MAX(t.DATE_CREATED) AS DATE_CREATED, ' 
    -- Bug #3088729 - if the course has a recording as content, ATTEMPTS is always 1, even though there are 2 completed 
    -- transcripts for each enrollee that viewed the course.
	SET @sql = @sql + '           (CASE (SELECT count(s.sco_id) as countrec ' 
	SET @sql = @sql + '                  FROM pps_scos s WITH (NOLOCK), pps_scos ss WITH (NOLOCK) ' 
	SET @sql = @sql + '                  WHERE s.type = 0 AND s.icon = 1 AND s.source_sco_id = ss.sco_id ' 
	SET @sql = @sql + '                  AND  ss.type = 15 AND ss.icon = 8 AND t.sco_id = s.sco_id) ' 
	SET @sql = @sql + '            WHEN 0 THEN COUNT(t.TRANSCRIPT_ID) ' 
	SET @sql = @sql + '            ELSE 1 ' 
	SET @sql = @sql + '            END) AS ATTEMPTS, ' 
	SET @sql = @sql + '		    t.principal_id '  
	SET @sql = @sql + '		    FROM PPS_TRANSCRIPTS t WHERE   '  
	SET @sql = @sql + '		    t.status IN (''P'', ''F'', ''C'', ''I'') '  
	IF @principal IS NOT NULL
		SET @sql = @sql + 'AND t.principal_id =' + CAST(@principal AS NVARCHAR(30))
	ELSE
		SET @sql = @sql + 'AND t.principal_id IS NOT NULL '
	IF @sco IS NOT NULL
		SET @sql = @sql + 'AND t.sco_id = ' + CAST(@sco AS NVARCHAR(30))
	SET @sql = @sql + '			GROUP BY t.principal_id, t.sco_id) X   ' 
	SET @sql = @sql + '			ON (P.PRINCIPAL_ID = X.PRINCIPAL_ID)  ' 
	SET @sql = @sql + '			LEFT OUTER JOIN PPS_TRANSCRIPTS t ON X.DATE_CREATED = T.DATE_CREATED ' 

	SET @sql = @sql + '     OUTER APPLY(SELECT ROUND(SUM(session_time) * (24*60*60*1000), 0) as time_taken '  
	SET @sql = @sql + '    		 FROM '  
	SET @sql = @sql + '    		    (SELECT CAST(max(td.date_modified) - t2.date_created AS FLOAT) AS session_time '  
	SET @sql = @sql + '    		      FROM pps_transcript_details td, pps_transcripts t2 '  
	SET @sql = @sql + '    		     WHERE t2.sco_id =t.sco_id '  
	SET @sql = @sql + '    		         AND t2.principal_id = t.principal_id '  
	SET @sql = @sql + '    		         AND td.date_created > t2.date_created '  
	SET @sql = @sql + '    		         AND t2.transcript_id = td.transcript_id '  
	SET @sql = @sql + '    		         AND (t2.transcript_id = t.transcript_id OR '  
    -- AEC - Fix for Bug #: 3521230 - Time Spent does not include Failed Transcripts
    -- added 'P','F','C' to the list of rows to include for the sum of time taken
	SET @sql = @sql + '    		                  (t2.status IN (''P'',''F'',''C'',''I'',''X'') AND t2.status <> ''R'' '  
	SET @sql = @sql + '    		                   AND t2.date_created < t.date_created)) '  
	SET @sql = @sql + '    		      GROUP BY t2.transcript_id, t2.date_created) '
	SET @sql = @sql + '    		    t3 '  
	SET @sql = @sql + '    		   ) tt ' 
	SET @sql = @sql + '			WHERE t.status IN (''P'', ''F'', ''C'', ''I'') ' 
	SET @sql = @sql + '			  AND X.principal_id = t.principal_id ' 
	IF @principal IS NOT NULL
		SET @sql = @sql + ' AND t.principal_id = ' + CAST(@principal AS NVARCHAR(30))
	ELSE
		SET @sql = @sql + ' AND t.principal_id IS NOT NULL '
	IF @sco IS NOT NULL
		SET @sql = @sql + ' AND t.sco_id=' +  CAST(@sco AS NVARCHAR(30))
	SET @sql = @sql + '    AND t.sco_id = scos.sco_id ' 
	IF @transcript IS NOT NULL
		SET @sql = @sql + ' AND t.transcript_id = ' + CAST(@transcript AS NVARCHAR(30))
	IF @type IS NOT NULL
		SET @sql = @sql + ' AND scos.type=' + CAST(@type AS NVARCHAR(10))
	SET @sql = @sql + '	) t WHERE 1 = 1' 
	SET @sql = @sql + ') ' 
	SET @sql = @sql + 'SELECT * FROM ( '  
	-- CONN-3759676, CONN-4118590 - On loading enums in Dictionary, status was not recognized as enum from Transcript
	-- This was fixed by having transcript_id as first column in select, so that transcript_id marker is used for dictionary
	SET @sql = @sql + 'SELECT distinct ar.transcript_id, ' 
	SET @sql = @sql + 'prin.principal_id, prin.name as principal_name, prin.login, '  
	SET @sql = @sql + 'ar.sco_id, ISNULL(ar.display_status,''N'') as status, ar.score, ar.max_score, '  
	SET @sql = @sql + 'ar.date_created, ar.asset_id, ar.permission_id, ar.attempts, ar.time_taken, ' 
	SET @sql = @sql + 'ar.certificate, ar.version, ar.override ' 
	SET @sql = @sql + 'FROM PrincipalsTree pt, ' 
	SET @sql = @sql + '  (' 
	SET @sql = @sql + '     SELECT principal_id as rprin_id, group_id ' 
	SET @sql = @sql + '     FROM pps_group_member_rollup' 
	SET @sql = @sql + '  ) rollup, ' 
	SET @sql = @sql + '  PPS_PRINCIPALS prin ' 
	SET @sql = @sql + 'LEFT OUTER JOIN actual_results ar ON ar.p_id = prin.principal_id '  
	SET @sql = @sql + 'WHERE pt.prin_id = rollup.GROUP_ID ' 
	SET @sql = @sql + '  and rollup.rprin_id = prin.PRINCIPAL_ID ' 
	SET @sql = @sql + '  and prin.DISABLED is null ' 
	SET @sql = @sql + '  and prin.has_children = 0 ' 
	SET @sql = @sql + ') t_wrapper WHERE 1=1 '
    SET @sql = @sql + @filter

	--select @sql
	EXEC (@sql)
