<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Default content script.
  Draws the HTML content.
  ==============================================================================
--%>

<%@ page import="com.day.cq.wcm.api.WCMMode, 
                com.adobe.connect.osgi.service.*,
                com.adobe.connect.osgi.info.Event,
                com.adobe.connect.osgi.info.EventInfo" %>
<%@include file="/apps/connect/common.jsp" %>
<% 

	String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
	EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
	String eventId = eventInfo != null ? eventInfo.getScoId() : null;
	String downloadPath = request.getContextPath() + resource.getPath() + ".item.ics"; 
	String[] eventIds = new String[1];
	eventIds[0] = eventId;
	StringBuilder ownerEmail = new StringBuilder("");
	
    List<Event> eventList; 
    try { 
      // eventList = connectAPIService.getEventList(eventIds, accountId, dateStart, dateEnd, folderId, tagIdList, Event.EventCategory.LIVE, subFilterTagId, filterTagsRule, false, Event.FilterFields.DATE_BEGIN.toString(), "asc", -1, -1, isIndependentCQInstance, false);
       eventList = connectAPIService.getEventList(eventIds, accountId, null, null, null, null, null, null, null, false, null, null, -1, -1, isIndependentCQInstance, false);
    } catch(ConnectServiceException ex) {
        if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
            throw ex;
        }
        out.write(eventResBundle.getString("errConnectingToServer"));
        return;
    }
	
    String rawMessage = properties.get("text", "Hello {first-name},\n We are pleased to confirm your registration for {event-name}. We look forward to your participation.\nEvent:{event-time}\nTime Zone:{time-zone}\nTo access the event, please go to the following link at the time of the event and login with your username and password (if required) with which you have registered for this event:\n{event-login-url}\nThank you,\n{event-creator-name}\n------------------------\nIf you've never used Adobe Connect, get a quick overview: <a href=\"http://www.adobe.com/products/adobeconnect.html\">http://www.adobe.com/products/adobeconnect.html\nAdobe, the Adobe logo, Acrobat and Adobe Connect are either registered trademarks or trademarks of Adobe Systems Incorporated in the United States and/or other countries.");
	String resolvedMsg;
		
	try {
		if(rawMessage.indexOf("{") == -1)
		{
			resolvedMsg = rawMessage;
		}
		else
		{
			connectSessionId = (String)request.getParameter("session");
			resolvedMsg = connectAPIService.getEventResolvedMsg(eventId, rawMessage, connectSessionId, ownerEmail);
			resolvedMsg = resolvedMsg.replaceAll("\\<.*?>","");
			resolvedMsg = resolvedMsg.replaceAll("&nbsp;"," ");
		}	
	} catch ( ConnectServiceException ex ) {
       if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
       {
           throw ex;
       }
		out.write(eventResBundle.getString("errConnectingToServer"));
		return;     
	}

    // put event list and timeZone into session to make it available in item.ics, i.e. in "Download ICS" servlet 
    slingRequest.getSession().setAttribute("eventList", eventList);
    slingRequest.getSession().setAttribute("timeZone", getTimeZone(request));
	slingRequest.getSession().setAttribute("eventOwnerEmail", ownerEmail.toString());
	slingRequest.getSession().setAttribute("resolvedMsg", resolvedMsg);

    response.sendRedirect(downloadPath);
%>
