<%--
  Copyright 1997-2010 Day Management AG
  Barfuesserplatz 6, 4001 Basel, Switzerland
  All Rights Reserved.

  This software is the confidential and proprietary information of
  Day Management AG, ("Confidential Information"). You shall not
  disclose such Confidential Information and shall use it only in
  accordance with the terms of the license agreement you entered into
  with Day.

  ==============================================================================

  Carousel component

--%>
<%@include file="/apps/connect/common.jsp" %>
<%
%><%@ page import="java.util.LinkedHashMap,
                   java.util.Map,
                   com.day.cq.commons.Doctype,
                   com.day.cq.wcm.api.WCMMode,
                   com.day.cq.wcm.api.components.DropTarget,
                   com.day.text.Text,
                   com.adobe.connect.osgi.service.*,
                   com.adobe.connect.osgi.info.Event,
                   com.adobe.connect.osgi.info.EventInfo,
                   com.adobe.connect.osgi.info.Tag,
                   java.util.EnumSet, 
                   java.util.List,
                   com.adobe.connect.osgi.info.TagGroupType"
%><%
    %>
<%!

    /**
     * Container class for slides
     */
    public static final class Slide {
        private String img = "";
        private String title = "";
        private String name = "";
        private String desc = "";
        private String path = "";

        private Slide(String title, String description, String imgPath, String slideId, String pagePath) {
            this.title = title;
            desc = description;
            if (desc == null) {
                desc = "";
            }
            path = pagePath;
            img = imgPath;
            name = slideId;
        }
        
        public String getImg() {
            return img;
        }

        public String getTitle() {
            return title;
        }

        public String getName() {
            return name;
        }

        public String getDesc() {
            return desc;
        }

        public String getPath() {
            return path;
        }
    }
%>


<%
    String xs = Doctype.isXHTML(request) ? "/" : "";

    if (WCMMode.fromRequest(request) == WCMMode.EDIT) {
        //drop target css class = dd prefix + name of the drop target in the edit config
        String ddClassName = DropTarget.CSS_CLASS_PREFIX + "pages";
        %><div class="<%= ddClassName %>"><%
    }

    
    String accountId   = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
    Date dateBegin = Calendar.getInstance().getTime();
    
    List<Tag> tagList;
    try { 
        tagList = connectAPIService.getTagList(accountId, EnumSet.of(TagGroupType.FEATURED_EVENT_TAGS));
    } catch ( ConnectServiceException ex ) {
        if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
            throw ex;
        }
        out.write(eventResBundle.getString("errConnectingToServer"));
        return;     
    }
    List<String> tagIdList = new ArrayList<String>();
    for(Tag tag : tagList){
        tagIdList.add(tag.getTagId());
    }
    
    //get folder-id
	String folderId  = xssUtilService.getValidLongAsString(slingRequest.getParameter("folder-id"));
	    
  
    //fetch event list
    boolean buildCatalogUsingConnectServer = "connectServer".equals(properties.get("buildCatalogUsing", "local"));    
    Map<String, String> subscribedEvents = null;
    String[] eventIds = null;
    if ( isIndependentCQInstance && ! buildCatalogUsingConnectServer ) {
        subscribedEvents = ConnectUtil.getSubscribedEventIds(currentNode, currentPage.getParent().getPath(), Constants.EVENT_ASSOCIATER_COMPONENT);
        Object[] objectArr = subscribedEvents.keySet().toArray();          
        eventIds = Arrays.copyOf(objectArr, objectArr.length, String[].class);
    }
    
    //return all featured events
    List<Event> eventList = connectAPIService.getEventList(eventIds, accountId, dateBegin, null, folderId, tagIdList, null, "any", false, Event.FilterFields.DATE_BEGIN.toString(), "asc", 0, 0, isIndependentCQInstance);
    
    if (!eventList.isEmpty()) {
        // config options
        int playDelay = properties.get("playSpeed", 6000);
        int transTime = properties.get("transTime", 1000);
        int bannerHeight = properties.get("height", 300);
        String backgroundColor = "#" + properties.get("backgroundColor", "484848" );  

        String eventDescCss = ContentUtils.getCSSStyle(properties, "eventDesc", isIndependentCQInstance);
        String eventTitleCss = ContentUtils.getCSSStyle(properties, "eventTitle", isIndependentCQInstance);
        
        int heightOffset = 50;//height of switcher controls;
        int widthOffset = 120;//2x(39+20);
        
        //override banner height
        String overrideCqCarouselBannerItem = " height:" + bannerHeight + "px; background-color: " + backgroundColor;

        //calculate carousel height
        String overrideCqCarousel = " height:" + (bannerHeight + heightOffset) + "px;";
        
        String cssCarouselBannerItemImg = "max-height:" + (bannerHeight - 2*20) + "px; display: none;";
        
        //center prev/next controls verticaly
        String overrideCqCarouselControlPrev = " top:" + (bannerHeight/2 - 20)+ "px;";//prev/next image is 39px high
        String overrideCqCarouselControlNext = overrideCqCarouselControlPrev;
        
        String controlsType = "-bc";
        boolean showControls = true;

        // first shove all slides into a map in order to calculate distinct ids
        Map<String, Slide> slides = new LinkedHashMap<String, Slide>();
       
        String pfx = "cqc-" + Text.getName(resource.getPath()) + "-";
        for (Event event : eventList){
            String banner;
            String bannerRelativePath = event.getEventBannerLarge();
            if ( bannerRelativePath == null || "".equals(bannerRelativePath)){
                //set placeholder image
                banner = "/etc/designs/default/0.gif";
            } else {
                String domainName = event.getDomainName();
                if(domainName==null || "".equals(domainName)){
                    domainName = connectServer;
                }
                banner = domainName + bannerRelativePath;
            }
            
            Session session = currentNode.getSession();          
            String preview = xssUtilService.getValidJSToken(request.getParameter("preview"));            
            String landPageUrl = ContentUtils.buildEventPagePath("landing", event, null, session, campaignId, preview, isIndependentCQInstance, buildCatalogUsingConnectServer, currentPage);             
            
            //remove all white spaces, since this ID is going to be used as part of element identifier and css class name
            String slideId = event.getName().replaceAll("\\W","");
            Slide slide = new Slide (event.getName(), event.getBriefInfo(), banner, slideId, landPageUrl);
            String name = pfx + slide.name;
            int idx = 0;
            while (slides.containsKey(name)) {
                name = pfx + slide.name + (idx++);
            }
            slide.name = name;
            slides.put(name, slide);
        }

        %>
        
        <div class="cq-connect-carousel" style="<%=overrideCqCarousel%>">
            <var title="play-delay"><%= playDelay %></var>
            <var title="transition-time"><%= transTime %></var>

            <%-- write the actual slides --%>
            <div class="cq-carousel-banners" >
                <c:forEach var="slide" varStatus="loop" items="<%= slides.values() %>">
                <div style="${loop.first ? "left: 0px; opacity: 1;" : "left: -1060px; opacity: 0;"}" id="${slide.name}" class="cq-carousel-banner-item" >
                    <%//must use a div wrapper since cq-carousel-banner-item style atribute is going to be overwritten by slide animation! %>
                    <div class="eventcarousel-banner-item" style="<%=overrideCqCarouselBannerItem %>">
                        <c:if test="${!empty slide.img}">
							<label id="${slide.name}-aria" class="invisibleLabelClass">${slide.title} <%=eventResBundle.getString("slideLabel")%> </label>
                            <a href="${slide.path}" title="${slide.title}" aria-labelledby="${slide.name}-aria">
                                <div class="eventcarousel-banner-div" style="background-color: <%= backgroundColor %>">
                                <%
								//using table to do vertical align, since many other CSS solutions will not work in IE, since we don't have fixed hight 
								%> 
                                    <table style="table-layout: fixed;">
                                        <tr>
                                            <td class="eventcarousel-banner-info">
                                                <div class="eventcarousel-title" aria-hidden="true" <%= eventTitleCss %>>${slide.title}</div>
                                                <div class="eventcarousel-desc" aria-hidden="true" ><pre <%= eventDescCss %>>${slide.desc}</pre><br<%= xs %>></div>
                                            </td>
                                            
                                            
                                            
                                            <td class="eventcarousel-img">
                                                 <img aria-hidden="true" src="${slide.img}" style="<%=cssCarouselBannerItemImg %>" alt="${slide.title}"<%= xs %>>
                                            </td>
                                            
                                            
                                        </tr>
                                    </table>
                                </div> 
                                
                            </a>
                        </c:if>
                    </div>
                </div>
                </c:forEach>
            </div>

            <%-- defines the controls --%>
            <c:if test="<%= showControls %>">
                <div class="cq-carousel-controls">
                    <label id="nav-left-aria" class="invisibleLabelClass"><%= eventResBundle.getString("previousSlideLabel")  %></label>
                    <label id="nav-right-aria" class="invisibleLabelClass"><%= eventResBundle.getString("nextSlideLabel")  %></label>
                    <a class="cq-carousel-control-prev" href="#" style="<%=overrideCqCarouselControlPrev%>" aria-labelledby="nav-left-aria"></a>
                    <a class="cq-carousel-control-next" href="#" style="<%=overrideCqCarouselControlNext%>" aria-labelledby="nav-right-aria"></a>
                </div>
            </c:if>

            <%-- write the switches, also needed when disabled --%>
            <div class="cq-carousel-banner-switches<%= controlsType %>">
            
               <table align="center">
                   <tr>
                       <td >            
                            <ul class="cq-carousel-banner-switch">
                                <c:forEach var="slide" varStatus="loop" items="<%= slides.values() %>">
                                    <li>
                                    <label id="${slide.name}-bullet-aria" class="invisibleLabelClass">${slide.title} <%= eventResBundle.getString("slideBulletLabel")  %></label>
                                    <a class="${loop.first ? "cq-carousel-active" : ""}" title="${slide.title}" href="#${slide.name}" aria-labelledby="${slide.name}-bullet-aria"><img src="/etc/designs/default/0.gif" aria-hidden="true" alt=""<%= xs %>></a>
                                    </li>
                                </c:forEach>
                            </ul>
                         </td>
                     </tr>
                 </table>
                                 
            </div>

        </div><%
    } else {
        if (WCMMode.fromRequest(request) == WCMMode.EDIT){
            %><img src="/libs/cq/ui/resources/0.gif" class="cq-carousel-placeholder" alt=""><%
        }
    }

    if (WCMMode.fromRequest(request) == WCMMode.EDIT) {
        %></div><%
    }

%> 


<script>

/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
(function($) {
    $(function () {
        // Used to output caught errors
        function errorLog(error, message) {
            try {
                if ($.cq.isAuthor() || window.location.hash == '#debug') {
                    if (typeof console != 'undefined' && typeof console.log  != 'undefined') {
                        console.log(error);
                        console.log(message);
                    }
                    alert(error.name+':\n'+error.message+'.\n'+message+'.');
                }
            } catch (e) { }
        }

        try {
            // Opacity fading conflicts in IE8 with the PNG fix and text anti-aliasing
            var fadingSpeed = $.browser.msie ? 0 : 250;

            // Removes the URL hash if it corresponds to the id of an element in the given context
            function removeHash(context) {
                try {
                    if (window.location.hash.length > 0 && $(window.location.hash, context).length > 0) {
                        window.location = (window.location+'').replace(window.location.hash, '');
                    }
                } catch (e) {
                    errorLog(e, 'Could not remove hash');
                }
            }

            // carousel code
            try {
                $('.cq-connect-carousel').each(function () {
                    var carousel = $(this);
                    var playDelay = +$("var[title='play-delay']", this).text();
                    if (!playDelay) {
                        playDelay = 6000;
                    }
                    var slidingSpeed = +$("var[title='transition-time']", this).text();
                    if (!slidingSpeed) {
                        slidingSpeed = 1000;
                    }
                    var banners = $('.cq-carousel-banners', this);
                    //do not why, but
                    // var links = $('.cq-carousel-banner-switch a', this);
                    //returns more links than expected after component reload. Changed to "find" = works......
                    var switcher = $('.cq-carousel-banner-switch', this);
                    var links = switcher.find('a');
                    var items = $('.cq-carousel-banner-item', this);
                    var width = items.outerWidth();
                    var itemActive = items.filter(':first');
                    var itemPrevious = null;
                    var interval = null;
                    var i = 0;

                    var ctlPrev = $('a.cq-carousel-control-prev', this);
                    ctlPrev.click(function() {
                        if (ctlPrev.is('.cq-carousel-active')) {
                            $(links[(i+links.length-1)%links.length]).click();
                        }
                        return false;
                    });
                    var ctlNext = $('a.cq-carousel-control-next', this);
                    ctlNext.click(function() {
                        if (ctlNext.is('.cq-carousel-active')) {
                            $(links[(i+1)%links.length]).click();
                        }
                        return false;
                    });
                    if (links.length > 1) {
                        ctlNext.addClass('cq-carousel-active');
                    }
                    function play() {
                        stop();
                        if( playDelay > 0) {
                            interval = setInterval(function () {
                                $(links[(i+1)%links.length]).click();
                            }, playDelay);
                        }
                    }
                    function stop() {
                        if (interval !== null) {
                            clearInterval(interval);
                            interval = null;
                        }
                    }

                    // Show first item (needed for browsers that don't support CSS3 selector :first-of-type)
                    if (fadingSpeed || $.browser.version > 6) {
                        itemActive.css('left', 0);
                    } else {
                        itemActive.show();
                    }

                    links
                        .click(function () {
                            var link = $(this);
                            var itemNew = items.filter(link.attr('href'));
                            var j = itemNew.prevAll().length;
                            var direction = (j > i || interval !== null) ? 1 : -1;

                            if (!link.is('.cq-carousel-active')) {
                                links.removeClass('cq-carousel-active');
                                link.addClass('cq-carousel-active');

                                if (itemActive.is(':animated')) {
                                    itemActive.stop(true, true);
                                    itemPrevious.stop(true, true);
                                }

                                if (fadingSpeed) {
                                    itemNew.css({'left': direction*width}).animate({'left': 0, 'opacity': 1}, slidingSpeed);
                                    itemActive.animate({'left': -direction*width, 'opacity': 0}, slidingSpeed);
                                } else if ($.browser.version > 6) {
                                    itemNew.css({'left': direction*width}).animate({'left': 0}, slidingSpeed);
                                    itemActive.animate({'left': -direction*width}, slidingSpeed);
                                } else {
                                    itemNew.fadeIn();
                                    itemActive.fadeOut();
                                }

                                itemPrevious = itemActive;
                                itemActive = itemNew;
                                i = j;
                                if (i > 0) {
                                    ctlPrev.addClass('cq-carousel-active');
                                } else {
                                    ctlPrev.removeClass('cq-carousel-active');
                                }
                                if (i < links.length-1) {
                                    ctlNext.addClass('cq-carousel-active');
                                } else {
                                    ctlNext.removeClass('cq-carousel-active');
                                }
                            }

                            return false;
                        })
                        .each(function () {
                            var link = $(this);

                            link.attr('title', link.text());
                        })
                        .filter(':first').addClass('cq-carousel-active');

                    play();
                    carousel.hover(
                            function() {
                                stop();
                                ctlPrev.fadeIn();
                                ctlNext.fadeIn();
                            },
                            function() {
                                play();
                                ctlPrev.fadeOut();
                                ctlNext.fadeOut();
                            }
                    );

                    // Accessing the page with the anchor of a banner in the URL can break the layout
                    removeHash(this);
                });
            } catch (e) {
                errorLog(e, 'Could not initialize the banners');
            }
        } catch (e) {
            errorLog(e, 'Init failed');
        }
    });
})($CQ || $);





</script>

