function selectSize(checkbox, record, path){

	var dlg = checkbox.findParentByType("dialog");
	var sizeSelector = dlg.getField("./sizeSelector");
	
	var size = dlg.getField("./size");
	var dimension = dlg.getField("./dimension");
	var dimensionSelector = dlg.getField("./dimensionSelector");
	
	size.disable();
	dimension.disable();
	dimensionSelector.disable();
	
	if (sizeSelector.getValue() == "originalSize") { //Use original size
		dimension.setValue("");
		size.setValue("");
		
	}else if(sizeSelector.getValue() == "predefinedSize"){ //Use predefined
		dimension.setValue("");
		size.setValue("");
		
		// case when selection changed event fire then path will be undefined.
		if(path == undefined)
			path = dlg.path;
		
		// set the predefined width and height in dialog box
       	var predefinedWidth = "360"; // account logo default width
		var predefinedHeight = "50";  // accountlogo default height
        if(path.includes("eventbannersmall")){
			predefinedWidth = "560";
            predefinedHeight = "230";
        }
        else if(path.includes("eventbannerlarge")){
			predefinedWidth = "740";
            predefinedHeight = "300";
        }
		
		// size.setValue is function which takes string argument as type of w,h. where w = width and h = height
		size.setValue(predefinedWidth + "," + predefinedHeight);
		// on opened dialog set the width and height
		if(record != undefined && record.data != undefined){
			record.data.width = predefinedWidth;
			record.data.height = predefinedHeight;
		}
	
	} else if (sizeSelector.getValue() == "maintainAspectRatio"){// Maintain aspect ratio
		size.setValue("");
		
		dimension.enable();
		dimensionSelector.enable();
		
	} else{//Enter size
		dimension.setValue("");
		size.enable();
	}
	
}

function onLoadSelectSize(field, record, path){
	selectSize(field, record, path);
}
