<%--
/****************************************************************/
/*                                                              */
/* ADOBE CONFIDENTIAL                                           */
/* _ _ _ _ _ _ _ _ _ _ _ _ _                                    */
/*                                                              */
/* Copyright [2010-2011] Adobe Systems Incorporated             */
/* All Rights Reserved.                                         */
/*                                                              */
/* NOTICE: All information contained herein is, and remains the */
/* property of Adobe Systems Incorporated and its suppliers, if */
/* any. The intellectual and technical concepts contained       */
/* herein are proprietary to Adobe Systems Incorporated and its */
/* suppliers and may be covered by U.S. and Foreign Patents,    */
/* patents in process, and are protected by trade secret or     */
/* copyright law. Dissemination of this information or          */
/* reproduction of this material is strictly forbidden unless   */
/* prior written permission is obtained from Adobe Systems      */
/* Incorporated.                                                */
/*                                                              */
/****************************************************************/

  ==============================================================================
  Default content script.
  Draws the HTML content.
  ==============================================================================
--%>

<%@include file="/apps/connect/common.jsp" %>

<%
String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
OmnitureAcountInfo omnitureAccountInfo = connectAPIService.getOmnitureAccountInfo(accountId);
EventInfo eventInfo = getEventInfo(request, currentNode, connectAPIService);
String eventId = eventInfo != null ? eventInfo.getScoId() : null;

%>

<%
    String foreGroundStyle = "";
    String foregroundColor =  properties.get("foregroundColor", "");
    if ( ! "".equals(foregroundColor) )
        foreGroundStyle += "background-color: #" + foregroundColor + "; ";

    foreGroundStyle = "style=\"" + foreGroundStyle + "\"";
%>


<div class="main_event_page" <%= foreGroundStyle %>>
    <cq:include path="par" resourceType="foundation/components/parsys"/>
</div>

<script type="text/javascript">	
	window.onload=pushAnalyticEventLandingPageEvent;
	function pushAnalyticEventLandingPageEvent()
	{
		<%
			if(omnitureAccountInfo.getIsInUse() && omnitureAccountInfo.getReportSuiteId()!=null && eventInfo!=null && eventInfo.getName()!=null)
			{
		%>
				var omnitureReportSuiteId ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getReportSuiteId()) %>";
				var omnitureVisitorNamespace ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getVisitorNamespace()) %>";
				var omnitureTrackingServer ="<%= ConnectUtil.escapeJavaScript(omnitureAccountInfo.getTrackingServer()) %>";
				createOmnitureReportingTracker(omnitureReportSuiteId,omnitureVisitorNamespace,omnitureTrackingServer);
				var campaign = "";
				<% if ( null != eventId ) { %>
					campaign = getCampaignCookie("<%= eventId %>");
					if(campaign == undefined || campaign == null)
					{
						campaign = "";
					}
				<% } %>
				
				var scoNameSignature = "<%= ConnectUtil.escapeJavaScript(eventInfo.getSCTrackingScoNameSignature()) %>";
				pushEventLandingPageEvent(scoNameSignature,campaign);
		<%
			}
		%>
	}
</script>