/**
 * This is a function for loading a script file from the provided URL into the HEAD element, with support for a callback function.
 * @param url The URL of the script loaded.
 * @param callback The function to be executed on after the script is loaded.
 */
function loadScript(url, callback) {

	var script = document.createElement("script")
	script.type = "text/javascript";

	if (script.readyState) { //IE
		script.onreadystatechange = function() {
			if (script.readyState == "loaded"
					|| script.readyState == "complete") {
				script.onreadystatechange = null;
				callback();
			}
		};
	} else { //Others
		script.onload = function() {
			callback();
		};
	}

	script.src = url;
	document.getElementsByTagName("head")[0].appendChild(script);
}