<%@include file="/apps/connect/common.jsp" %>

<%@page import="com.adobe.connect.osgi.service.*,
                java.util.Map,
                java.util.LinkedHashMap,
                com.day.cq.wcm.foundation.forms.FormsHelper,
                java.util.Calendar,
                com.adobe.connect.osgi.util.ConnectUtil,
                com.adobe.connect.osgi.util.ContentUtils,
                com.adobe.connect.osgi.info.Event,
                com.adobe.connect.osgi.info.Tag,
                java.util.EnumSet,
                com.adobe.connect.osgi.info.TagGroupType"%>


<%@page import="com.day.cq.wcm.api.WCMMode"%>

<cq:setContentBundle/>
<%


    String componentName = currentNode.getName();
    
    String formId = "form_"+componentName;
    String componentPath = request.getContextPath() + resource.getPath();
        
    // handle configured tag list
    
    String tagPanelPosition = "right";
    if(currentNode.hasProperty("tagPanelPosition")){
        tagPanelPosition = currentNode.getProperty("tagPanelPosition").getString();
    }
    
    //Tag Panel Title
    String tagPanelTitle = "Popular Tags";
    if(currentNode.hasProperty("tagPanelTitle")){
        tagPanelTitle = currentNode.getProperty("tagPanelTitle").getString();
    }
    
    // Events per page
    String eventsPerPageLabel = "Events per page";
    if(currentNode.hasProperty("eventListEventsPerPage")){
        eventsPerPageLabel = currentNode.getProperty("eventListEventsPerPage").getString();
    }
    
    // Date View
    String eventDateViewLabel = "Date View";
    if(currentNode.hasProperty("eventDateViewLabel")){
        eventDateViewLabel = currentNode.getProperty("eventDateViewLabel").getString();
    }
    
    // List View
    String eventListViewLabel = "List View";
    if(currentNode.hasProperty("eventListViewLabel")){
        eventListViewLabel = currentNode.getProperty("eventListViewLabel").getString();
    }
    
    // Next
    String eventListNextPageLabel = "Next";
    if(currentNode.hasProperty("eventListNextPageLabel")){
        eventListNextPageLabel = currentNode.getProperty("eventListNextPageLabel").getString();
    }
    
    // Prev
    String eventListPrevPageLabel = "Prev";
    if(currentNode.hasProperty("eventListPrevPageLabel")){
        eventListPrevPageLabel = currentNode.getProperty("eventListPrevPageLabel").getString();
    }
    

 // Back To Events
    String eventListBackToEvents = "Back To Events";
    if(currentNode.hasProperty("eventListBackToEvents")){
        eventListBackToEvents = currentNode.getProperty("eventListBackToEvents").getString();
    }

    // Showing events tagged under: 
    String eventListShowingEventsTaggedUnder = "Showing events tagged under: ";
    if(currentNode.hasProperty("eventListShowingEventsTaggedUnder")){
        eventListShowingEventsTaggedUnder = currentNode.getProperty("eventListShowingEventsTaggedUnder").getString();
    }

    // Previous Month
    String eventListPreviousMonth = "Previous Month";
    if(currentNode.hasProperty("eventListPreviousMonth")){
        eventListPreviousMonth = currentNode.getProperty("eventListPreviousMonth").getString();
    }

    // Next Month
    String eventListNextMonth = "Next Month";
    if(currentNode.hasProperty("eventListNextMonth")){
        eventListNextMonth = currentNode.getProperty("eventListNextMonth").getString();
    }

    // Page
    String eventListPageNo = "Page";
    if(currentNode.hasProperty("eventListPageNo")){
        eventListPageNo = currentNode.getProperty("eventListPageNo").getString();
    }

    // Download Calendar
    String eventListDownloadCalendar = "Download Calendar";
    if(currentNode.hasProperty("eventListDownloadCalendar")){
        eventListDownloadCalendar = currentNode.getProperty("eventListDownloadCalendar").getString();
    }
    


    boolean enableTagBasedFiltering = false;
    if(currentNode.hasProperty("enableTagBasedFiltering")){
        enableTagBasedFiltering = currentNode.getProperty("enableTagBasedFiltering").getBoolean();
    }

    String accountId   = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
    String filterTagIds= "";//configued tag ids set in format tagId1,tagId2,tagId3 - used to create JavaScript Array 
    String tagsMapJS = "";
    List<Tag> displayTagList = new ArrayList<Tag>();
    List<Tag> fullTagList; 
    try { 
    	fullTagList = connectAPIService.getTagList(accountId, EnumSet.of(TagGroupType.EVENT_TAGS, TagGroupType.FEATURED_EVENT_TAGS));
    } catch ( ConnectServiceException ex ) {
		if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
        	throw ex;
        }
    	out.write(eventResBundle.getString("errConnectingToServer"));
        return;
    }

    //prepare filter tags
    List<String> filterTagIdList = Collections.emptyList();
    //if enableTagBasedFiltering is false, leave filter list empty.
    if(enableTagBasedFiltering && currentNode.hasProperty("filterTagList")){
        String[] defaultTagList = {};
        String[] filterTagIdArray = properties.get("filterTagList", defaultTagList);
        filterTagIdList = Arrays.asList(filterTagIdArray);
    }
    
    List<String> displayTagIdList = Collections.emptyList();
    
    // do not render displat tag panel if this panel is not going to be displayed
    if (!"none".equals(tagPanelPosition)){
        if(currentNode.hasProperty("displayTagList")){
            String[] defaultTagList = {};
            String[] displayTagIdArray = properties.get("displayTagList", defaultTagList);
            displayTagIdList = Arrays.asList(displayTagIdArray);
        }
    }
    
    String showAll = properties.get("showAllTagsHidden", "true");
        
    //prepare Tag map for JS code, filter tags and display tags
    for (Tag tag : fullTagList) {
        
    	tagsMapJS = tagsMapJS + "," + tag.getTagId() + ":'" + ConnectUtil.escapeHtml(ConnectUtil.escapeJavaScript(tag.getTagName())) + "'";
        
        if(filterTagIdList.contains(tag.getTagId().trim())){
               filterTagIds = filterTagIds + ",'" +  tag.getTagId()+ "'";
        }
        
        if(!"none".equals(tagPanelPosition)) {
            if("true".equals(showAll)){
                displayTagList.add(tag);
            } else if ( displayTagIdList.contains(tag.getTagId().trim())){
               displayTagList.add(tag);
            }
        }
    }
    
    if(!"".equals(filterTagIds)){
        //remove leading comma
        filterTagIds = filterTagIds.substring(1);
    }
    if(!"".equals(tagsMapJS)){
        //remove leading comma
        tagsMapJS = tagsMapJS.substring(1);
    }

   //prepare CSS class names depending on Tap Panel postion configuration

   //default is right position
   String tagPositionCssClass = "tag_right";
   String tagLinkCssClasses = "tag_link_v";
   String tagSeparatorCssClass = "";
   String tagSeparatorCssClassLast = "";//CSS specific for last item
   String tagItemCssClasses = "tag_item_v";
   String spacerTagTopCss = "spacer_25";
   String spacerTagRightCss = "";
 
   if("top".equals(tagPanelPosition)){
       tagPositionCssClass  = "tag_top";
       tagLinkCssClasses = "tag_link_h ";//tag_separator_v
       tagSeparatorCssClass = "tag_separator_v";
       tagSeparatorCssClassLast = "tag_last";
       tagItemCssClasses = "tag_item_h";
       tagPanelTitle = "";       
       spacerTagRightCss = "spacer_20";
   } else if ("none".equals(tagPanelPosition)){
       tagPositionCssClass  = "tag_none";
   }
   
   //get folder-id
   Long folderId  = xssUtilService.getValidLong(slingRequest.getParameter("folder-id"));
   
   String eventListTagsFillAndBorderCSS = ContentUtils.getCSSStyleFillAndBorder(properties, "eventListTags");
   String eventPopularTagsCSS = ContentUtils.getCSSStyle(properties, "eventPopularTags", isIndependentCQInstance);
   String campaignIDParameter = request.getParameter("campaign-id");
   if(campaignIDParameter != null)
   {
       campaignIDParameter = ConnectUtil.customUrlEncode(xssUtilService.filter(campaignIDParameter));
   }
   %>

<div id="eventlist_<%=componentName%>" class="list_container">

    <form id="<%=formId %>">

		<script type="text/javascript">

            $(document).ready(function(){                                                                                                                           

                	  var campaignId = '<%=campaignIDParameter%>';
	                  obj_<%=componentName%> = new Eventlist('<%=componentName%>', '<%=componentPath%>',  {<%=tagsMapJS%>}, [<%=filterTagIds%>], <%= folderId %>, 'viewType_<%=currentNode.getIdentifier()%>', campaignId);
	                  var anchorParams = getAnchorParams();
	                  if ( anchorParams.params.currentSearchTag ) {
	                      obj_<%=componentName%>.searchByTag(document.getElementById("tagItem_" + anchorParams.params.currentSearchTag), anchorParams.params.currentSearchTag); 
	                  } else {
	                      obj_<%=componentName%>.onLoadGetEvents();
	                  }
            });

		</script>

        <%@include file="eventlistHeader.jsp" %>

        <% if ( "top".equals(tagPanelPosition) ) {  %>
            <div class="tag_top" <%=eventListTagsFillAndBorderCSS%>>
                <%@include file="tagPanel.jsp" %>
            </div>
        <% } %>
        
        <div class="<%=spacerTagTopCss %>"> </div>
   
        <table width="100%" border="0" cellspacing="1" cellpadding="0">
            <tr>
                <td valign="top" id="listPanel_td_<%=componentName%>">	                  
                    <div id="listPanel_<%=componentName%>"></div>
                </td>
                
                <% if( "right".equals(tagPanelPosition) ) { %>
                    <td valign="top" width="4">&nbsp;</td>
                    <td valign="top" class="tag_right" <%=eventListTagsFillAndBorderCSS%>>                        
                        <%@include file="tagPanel.jsp" %>
                    </td>
                <% } %>    
            </tr>
        </table>
    
        <div class="spacer_20"> </div>

        <%@include file="eventlistFooter.jsp" %>
    
    </form>
     
</div>