  
<%@include file="/apps/connect/common.jsp" %>

<%@page import="com.adobe.connect.osgi.service.*,
                java.util.Calendar,
                com.adobe.connect.osgi.util.*,
                com.adobe.connect.osgi.common.Constants,                
                com.adobe.connect.osgi.info.Event,
                com.adobe.connect.osgi.info.Tag,
                com.day.cq.wcm.api.WCMMode"%>

<cq:setContentBundle/>

   <!-- LOOP trough event list-->

   <%
   
   String componentName = currentNode.getName();
   
   // Register Btn Label
   String eventListRegister = "Register";
   if(currentNode.hasProperty("eventListRegister")){
       eventListRegister = currentNode.getProperty("eventListRegister").getString();
   }
   
   // Event Details Btn Label
   String eventListEventDetails = "Event Details";
   if(currentNode.hasProperty("eventListEventDetails")){
       eventListEventDetails = currentNode.getProperty("eventListEventDetails").getString();
   }
   
   // Event Tags
   String eventListTags = "Tags";
   if(currentNode.hasProperty("eventListTags")){
       eventListTags = currentNode.getProperty("eventListTags").getString();
   }
   
   // No Upcoming Events with Tag
   String eventListNoUpcomingEventsWithTag = "No Upcoming Events with Tag";
   if(currentNode.hasProperty("eventListNoUpcomingEventsWithTag")){
       eventListNoUpcomingEventsWithTag = currentNode.getProperty("eventListNoUpcomingEventsWithTag").getString();
   }
   
   // No Upcoming Events
   String eventListNoUpcomingEvents = "No Upcoming Events.";
   if(currentNode.hasProperty("eventListNoUpcomingEvents")){
       eventListNoUpcomingEvents = currentNode.getProperty("eventListNoUpcomingEvents").getString();
   }
   
   

   //render Tags panel on top or right depending on the configuration
   String tagPanelPosition = "right";
   String eventSummaryCss = "event_summary_3column";

   if(currentNode.hasProperty("tagPanelPosition")){
       tagPanelPosition = currentNode.getProperty("tagPanelPosition").getString();
   }
   if("top".equals(tagPanelPosition) || "none".equals(tagPanelPosition)){
       eventSummaryCss = "event_summary_2column";
   }
   
   // Event Logo Width and display settings 
   
   int logoWidth = 200;//have to set some value - this value is not set after drag&drop of component
   if(currentNode.hasProperty("eventLogoWidth")){
       logoWidth = (int) currentNode.getProperty("eventLogoWidth").getLong();
   }
   
   boolean showLogo = true;
   if(currentNode.hasProperty("eventLogoShow")){
       showLogo = currentNode.getProperty("eventLogoShow").getBoolean();
   }
   
   StringBuilder overrideEventLogoCss = new StringBuilder();
   overrideEventLogoCss.append("width:");
   overrideEventLogoCss.append(logoWidth);
   overrideEventLogoCss.append("px; ");
   
   overrideEventLogoCss.append("display:");
   overrideEventLogoCss.append((showLogo)? "block" : "none");
   overrideEventLogoCss.append("; ");
   
   StringBuilder overrideEventSummaryCss = new StringBuilder();
   overrideEventSummaryCss.append("margin-left:");
   overrideEventSummaryCss.append((showLogo) ? logoWidth + 20 : 20);
   overrideEventSummaryCss.append("px; ");
   
   //page size
   int pageSize = 0;
   if(slingRequest.getParameter("paramPageSize") != null){
		pageSize = xssUtilService.getValidInteger(slingRequest.getParameter("paramPageSize"));
   }
      
   //page number
   int pageNumber = 0;
   if(slingRequest.getParameter("paramPageNumber") != null){
	pageNumber = xssUtilService.getValidInteger(slingRequest.getParameter("paramPageNumber"));
   }
   
   
   //get Tag id for search
   List<String> tagIdList = new ArrayList<String>(); 
   String[] paramTagIdList = slingRequest.getParameterValues("paramTagIdList");
   if (paramTagIdList != null && paramTagIdList.length>0){
       tagIdList = Arrays.asList(paramTagIdList);
   }
   
   //get filter tags rule
   String filterTagsRule  = "any";
   if(currentNode.hasProperty("filterTagsRule")){
       filterTagsRule = currentNode.getProperty("filterTagsRule").getString();
   }
  
   //get sub-filter tag
   String subFilterTagId  = xssUtilService.filter(slingRequest.getParameter("paramSubFilterTagId"));
   
   
   //get folder-id
   String folderId  =  xssUtilService.getValidLongAsString(slingRequest.getParameter("folder-id"));
  
   
    
   //get Tag name for case when seearch by tag is performed
   String paramTagName =  xssUtilService.filter(slingRequest.getParameter("paramTagName"));
  
  
   //get filter parameters from configuration dialog
   int daysNo = 365;
   if(currentNode.hasProperty("daysNo")){
       daysNo = (int) currentNode.getProperty("daysNo").getLong();
   }
   Calendar currDate = ConnectUtil.resetTime(Calendar.getInstance());
   Date dateBegin = currDate.getTime();
   currDate.add(Calendar.DAY_OF_MONTH, daysNo);
   Date dateEnd = currDate.getTime();
 
   String accountId = getAccountId(currentNode, request, connectInfo, connectAPIService, isIndependentCQInstance);
   
   //fetch event list   
   boolean buildCatalogUsingConnectServer = "connectServer".equals(properties.get("buildCatalogUsing", "local")); 
   Map<String, String> subscribedEvents = null;
   String[] eventIds = null;
   if ( isIndependentCQInstance && ! buildCatalogUsingConnectServer ) {
       subscribedEvents = ConnectUtil.getSubscribedEventIds(currentNode, currentPage.getParent().getPath(), Constants.EVENT_ASSOCIATER_COMPONENT);
       Object[] objectArr = subscribedEvents.keySet().toArray();          
       eventIds = Arrays.copyOf(objectArr, objectArr.length, String[].class);       
   }
   
   List<Event> eventList; 
   try { 
       eventList = connectAPIService.getEventList(eventIds, accountId, dateBegin, dateEnd, folderId, tagIdList, subFilterTagId, filterTagsRule, false, Event.FilterFields.DATE_BEGIN.toString(), "asc", pageSize, pageNumber, isIndependentCQInstance);
   } catch ( ConnectServiceException ex ) {
       if ( ! FailureCode.API_ERROR.equals(ex.getErrorCode()) )
        {
            throw ex;
        }
       out.write(eventResBundle.getString("errConnectingToServer"));
       return;
   }    

   //handle pagination links
    boolean firstPage = pageNumber==0;
   //check if last page is reached
    boolean lastPage = false;
   if (eventList.size() < pageSize){
        lastPage = true;
   } else if (eventList.size()==pageSize ){
        //TODO: this is work around - check if this is final solution
        int nextPage = pageNumber + 1;
        //do extra call to fetch next page
        List<Event>  eventListNext = connectAPIService.getEventList(eventIds, accountId, dateBegin, dateEnd, folderId, tagIdList, subFilterTagId, filterTagsRule, false, Event.FilterFields.DATE_BEGIN.toString(), "asc", pageSize, nextPage, isIndependentCQInstance);
        lastPage = eventListNext.isEmpty();
   } else if (eventList.isEmpty()){
        //this should never happen if everything works!
       lastPage = true;
        //return to previous page
       pageNumber--;
       eventList = connectAPIService.getEventList(eventIds, accountId, dateBegin, dateEnd, folderId, tagIdList, subFilterTagId, filterTagsRule, false, Event.FilterFields.DATE_BEGIN.toString(), "asc", pageSize, pageNumber, isIndependentCQInstance);
   }
    
   
   %>
   <table cellspacing="0" cellpadding="0" width="100%">
   <%
    if(eventList != null && !eventList.isEmpty()){
    int totalEvents = eventList.size();
    for ( int eventNumber = 0 ; eventNumber < totalEvents ; eventNumber ++ ) {    
        Event event = eventList.get(eventNumber);
        //name
        String eventName = event.getName();
        if (eventName==null){
            eventName = "";
        }
        
        //event time
        String beginDateStr = event.getBeginDate();
        String endDateStr   = event.getEndDate();
        String eventLang    = event.getLang();
		String eventTime = null;

        if (beginDateStr != null && beginDateStr.length() > 0 && 
			endDateStr != null && endDateStr.length() > 0 && 
			eventLang != null && eventLang.length() > 0) {
            Calendar beginDate = ConnectUtil.parseDate(beginDateStr);
            Calendar endDate   = ConnectUtil.parseDate(endDateStr);
            beginDate.setTimeZone(getTimeZone(request));
            endDate.setTimeZone(getTimeZone(request));

            // get date & time pattern
            String datePattern = null;
            if (currentNode.hasProperty("dateFormat")) {
                datePattern = properties.get("dateFormat", "");
            }
            String timePattern = null;
            if (currentNode.hasProperty("timeFormat")) {
                timePattern = properties.get("timeFormat", "");
            }

            Locale locale = Locale.getDefault();
            if (event.getLang()!=null){
                locale = new Locale(event.getLang());
            }
            eventTime = ConnectUtil.getLocalizedCalendarSpanString(beginDate, endDate, datePattern, timePattern, locale);
        }
        
        //event summary
        String briefInfoHtml = event.getBriefInfo();
        if(briefInfoHtml == null){
             briefInfoHtml = "";  
        }
        
        //event logo
        String eventLogo;
        String overrideEventLogoImgCss = "";
        if (event.getEventLogo() == null || "".equals(event.getEventLogo())){
            //remove border
            overrideEventLogoImgCss = "border: 0 none;";
            //set placeholder image
            if (WCMMode.fromRequest(request) == WCMMode.EDIT){
                eventLogo = "/etc/designs/connect/images/EventLogo_200x120px.jpg";
                //placeholder image already has border;
            } else {
                eventLogo = "/etc/designs/default/0.gif";
                overrideEventLogoImgCss = overrideEventLogoImgCss + " height: 0px;";
            }
        } else {
            String domainName = event.getDomainName();
            if(domainName==null || "".equals(domainName)){
                domainName = connectServer;
            }
                        
            String dmQueryParam = "";
            if (event.getDateModified() != null) {
            	dmQueryParam = "?dm=" + String.valueOf(ConnectUtil.parseDate(event.getDateModified()).getTimeInMillis());
            }
             
            eventLogo = domainName + event.getEventLogo() + dmQueryParam;
        }
        
        
        Session session = currentNode.getSession();
        String preview =  xssUtilService.getValidJSToken(request.getParameter("preview"));
		
        String landPageUrl = ContentUtils.buildEventPagePath("landing", event, null, session, campaignId, preview, isIndependentCQInstance, buildCatalogUsingConnectServer, currentPage);
        String regPageUrl = ContentUtils.buildEventPagePath("registration", event, null, session, campaignId, preview, isIndependentCQInstance, buildCatalogUsingConnectServer, currentPage);
    %>
        <tr>
        <td class="event_thumbnail verTopAlignedTableCol" style="<%=overrideEventLogoCss %>">
            <img class="list_event_logo" src="<%=eventLogo %>" />
        </td>
        
        <td style="width: 20px;">&nbsp;</td>
        
        <td class="verTopAlignedTableCol horLeftAlignedTableCol">
            <div class="list_event_name list_item_title" <%= ContentUtils.getCSSStyle(properties, "eventName", isIndependentCQInstance) %>>
                <span tabindex="0"><cq:text value="<%=eventName%>" /></span>
            </div>
            <div class="list_event_time list_item_subtitle " <%= ContentUtils.getCSSStyle(properties, "eventTime", isIndependentCQInstance) %>>
                <span tabindex="0"><%=eventTime%></span>
            </div>
            <div class="list_item_body" <%= ContentUtils.getCSSStyle(properties, "eventBody", isIndependentCQInstance) %>>
            <% if (!"".equals(briefInfoHtml)) { %>           	
                <span tabindex="0"><cq:text value="<%=ConnectUtil.escapeHtml(briefInfoHtml)%>" /></span>
            <% } %>
            </div>
            
            <% if (  event.getTagList().size() > 0 ) { %>
                <div class="list_item_tags">
                <%
                //FIXME: should those tags be displayed as links when tag panel is not shown? search by tag should be disabled than.
                %>
                <span class="list_item_subtitle"><%= eventListTags %>: </span>
                <%
                String eventTagsCSS = ContentUtils.getCSSStyle(properties, "eventTags", isIndependentCQInstance);
                for (Tag tag : event.getTagList()){
                    String tagTitle = (tag.getTagDescription() == null || tag.getTagDescription().trim().length() == 0) ? ConnectUtil.escapeHtml(tag.getTagName()) : ConnectUtil.escapeJava(tag.getTagDescription().trim());
                    String tagName = ConnectUtil.escapeHtml(tag.getTagName());
                %>              
                    <a href="#" <%= eventTagsCSS %> class="list_item_tag" onclick="obj_<%=componentName%>.searchByTag(this,'<%=tag.getTagId()%>');return false;" title="<%= tagTitle %>"><cq:text value="<%= tagName %>"/></a>   
                <%
                }
                %>
                </div>
            <% } %>
            
            <div class="event_buttons">
                <a class="roundCornerButtonLink" onclick="window.location.href='<%=regPageUrl%>';return false;" href="javascript:">
                    <span class="leftBtnImg">&nbsp;</span>
                    <span class="centerBtnImg">
                        <div style="vertical-align: middle; padding-top: 4px;"><%= eventListRegister %></div>
                    </span>
                    <span class="rightBtnImg">&nbsp;</span>
                </a>                
                <span style="float:left">&nbsp;&nbsp;</span>
                <a class="roundCornerButtonLink" onclick="window.location.href='<%=landPageUrl%>';return false;" href="javascript:">
                    <span class="leftBtnImg">&nbsp;</span>
                    <span class="centerBtnImg">
                        <div style="vertical-align: middle; padding-top: 4px;"><%= eventListEventDetails %></div>
                    </span>
                    <span class="rightBtnImg">&nbsp;</span>
                </a>
                <div style="clear: left; height: 0px;"></div> 
            </div> 
        </td>
        </tr>
        
        <% if ( eventNumber + 1 != pageSize && eventNumber + 1 != totalEvents ) { %>
            <tr>
                <td><div class="spacer_20"> </div> </td>
            </tr> 
        <% } %>
    <%
       }//for 
    } else {
        //no results
    %> 
        <tr>
        <td>
        <div class="list_search_message">
    <%
        if(subFilterTagId!=null && !"".equals(subFilterTagId)){
            //subFilterTagIdList will always be just one element
            String tagName = (paramTagName==null) ? "" : paramTagName;
    %>
            <%= eventListNoUpcomingEventsWithTag %> : <span title="<%= tagName %>"><%= TextUtils.ellipsisString(tagName, 30) %></span> 
    <%
        } else {
    %>
            <%= eventListNoUpcomingEvents %>
    <% 
        }
    %>   
        </div></td>
        </tr> 
        </div>
        <div class="spacer_20"> </div>
    <%
    }
    %>
    </table>

    <script type="text/javascript">

        $(document).ready(function(){
            hideElement('nextpage_<%=componentName%>', <%=lastPage%>);
            hideElement('prevpage_<%=componentName%>', <%=firstPage%>);
            obj_<%=componentName%>.currentPage = <%=pageNumber%>;
            //update page number
            var currPageElem = $('#currentPage_<%=componentName%>');
            $(currPageElem).html(obj_<%=componentName%>.currentPage + 1);// + 1 since pageNumber starts from 0
        });

    </script>
    
    
   
