function initEventLogin(eventId, isPreview, componentPath) {

    validateRequiredText = function(field) {
        if(field == null || field == undefined) {
            return true;
        }
        var elementId = field.id +"_errorMessage";
        var iserror = false;
        if (field.type=="text" || field.type=="password")
        {
            if ((field.type=="text" && field.value.trim()=="") || (field.type=="password" && field.value==""))
            {
                 msg = eventResBundle.getMessage('fieldRequired');
                 document.getElementById(elementId).innerHTML='  '+msg+' ';
                 iserror = true;
            } 
            else
            {
                 document.getElementById(elementId).innerHTML='';
                 iserror = false;
            }
        }
        
        setErrorStyle(field, iserror);
        return !iserror;    
    };    

    setFormFieldFocus(document.loginForm);
    
    // validate form
    var loginIsEmail = document.getElementById("loginIsEmail");
    var loginFieldValidation = (loginIsEmail && loginIsEmail.value == "true") ? emailValidation : validateRequiredText;

    
    if(isPreview == "true") {
        $CQ("#loginBtn-eventlogin").css("color", "#DEDEDE");
        return;
    }
    
    if ($CQ("#errorMsg").html() != ''){
        $CQ("#errorMsg").show();
    }
    
    $CQ("#loginBtn-eventlogin").click(function(e){
        if($CQ("#loading").is(":visible") != true) {
            loginBtnSubmitHandler(eventId);
        }
    });
    
    // active session join button
    $CQ("#submitActiveSessionLoginFormLink").click(function(e){       
        var redirectToContent = $CQ("#submitActiveSessionLoginFormLink").attr("href");
        window.location.href = redirectToContent;       
    });
    
    $CQ("#loginField").keypress(function(event) {
        checkSubmit(event, function(){
            if($CQ("#loading").is(":visible") != true) {
                loginBtnSubmitHandler(eventId);
            }
        });
    });
    $CQ("#passwordField").keypress(function(event) {
        checkSubmit(event, function(){
            if($CQ("#loading").is(":visible") != true) {
                loginBtnSubmitHandler(eventId);
            }
        });
    });
    
    $CQ("input[id='loginField']").change(
            function() {
                var valPassed = loginFieldValidation(this);    
                return valPassed;
            });
    
    $CQ("input[id='passwordField']").change(
            function() {
                var valPassed = validateRequiredText(this);
                return valPassed;
            });
    
    // handler for 'Forgot your password'
    $CQ("#eventForgotPwdLink").click(function() {
        // clear error messages on 'login' form
        setErrorStyle(document.getElementById('loginField'), false);
        $CQ("#loginField_errorMessage").html("");
        
        pwdField = document.getElementById('passwordField');
        if(pwdField != null){
            setErrorStyle(pwdField, false);
            $CQ("#passwordField_errorMessage").html("");
        }
        
        $CQ("#errorMsg").html("");
        
        
        if($CQ("#eventResetPwdContainer").html() == "") {
            // load 'forgot password' form only first time when is needed
            $CQ("#eventResetPwdContainer").load(componentPath + ".forgotpassword.html",
                    function() {
                        // attach handlers
                        $CQ("#forgotPwdSubmit").click(function() {
                            forgotPwdSubmitHandler();
                        });
                        
                        $CQ("#forgotPwdLogin").keypress(function(event) {
                            checkSubmit(event, function(){
                                forgotPwdSubmitHandler();
                            });
                        });
                        
                        $CQ("#forgotPwdCancel").click(function() {
                            forgotPwdCancel();
                        });
                        $CQ("#pwdResetBtn").click(function() {
                            pwdResetBtnHandler();
                        });
                
                        // hide 'login' form and show 'forgot password' form
                        $CQ("#eventLoginContainer").hide();
                        $CQ("#eventForgotPwdContainer").show();
            });
        } else {
            // 'forgot password' form has been already loaded - show it
            
            // hide 'login' form and show 'forgot password' form
            $CQ("#eventLoginContainer").hide();
            $CQ("#eventForgotPwdContainer").show();
        }
        
    });

    //handler for login form submit
    loginBtnSubmitHandler = function(eventId) {
        
        var loginField = document.getElementById("loginField");
        var pwdField = document.getElementById("passwordField");
        var isUserField = document.getElementById("isUserField");
           
        if((loginFieldValidation(loginField) != true) || (validateRequiredText(pwdField) != true)) {
            return false;
        }
		
		if(!redirectIDPServer()) // if sso user want to login
			return false;
        
        var isUser = 'false';
        if( isUserField )
        {
            isUser = 'true';
    
        }
        
        var loginReq = { login: $CQ("#loginField").val(), password: $CQ("#passwordField").val(),action: 'event-login', 'sco-id': eventId, 'is-user': isUser, "_charset_":"UTF-8"}
        
        $CQ("#errorMsg").hide();
        $CQ("#loginBtn-eventlogin").attr("style", "color: #DEDEDE");
        $CQ("#loading").fadeIn();
        
        $CQ.post(
                "/content/connect/connect-action", loginReq,
                function(xml){
                    $CQ("#loading").fadeOut('fast');
                    $CQ("#loginBtn-eventlogin").attr("style", " ");
                    xml = parseXML(xml);
                    var code = $CQ("status", xml).attr('code');
                    var msg1 = "", msg2 = "";
                    
                    //result handler
                    switch(code) {
                    case 'ok':
                        var eventURL = $CQ("session", xml).find("entry-url").text(); 
                        var sessionId = $CQ("session", xml).find("session").text();
                        window.location = eventURL + '?session=' + sessionId;
                        break;
                    case 'no-data':
						document.getElementById("passwordField").value = ''; 
                        msg1 = eventResBundle.getMessage('eventLoginNodata');
                        $CQ("#errorMsg").html(msg1).show();
                        break;
                    case 'invalid':
                        msg1 = eventResBundle.getMessage('eventLoginInvalid');
                        var subcode = $CQ("status", xml).find("invalid").attr("subcode");
                        if (subcode == null) {
                        	subcode = $CQ("status", xml).attr("subcode");
                        }
                        
                        if('missing' == subcode) {
                            field = $CQ("status", xml).find("invalid").attr("field");
                            msg2 = eventResBundle.getMessage('eventLoginMissing', [field]);
                        } else if('not-allowed' == subcode) {
                            var reason = $CQ("status", xml).find("invalid").attr("field");
                            if ( reason == "not-registered" ) {
                                msg1 = eventResBundle.getMessage('errMsgNotRegistered'); 
                                $CQ("#errorMsg").html(msg1).show();  
                            } else if ( reason == "denied" ) {
                                msg1 = eventResBundle.getMessage('errMsgRegistrationDenied'); 
                                $CQ("#errorMsg").html(msg1).show();  
                            } else {                                
								var newLocation = window.location.href;
								var login = $CQ("#loginField").val();
								var separator = (-1 == newLocation.indexOf("?")) ? "?" : "&";
								
								if (-1 == newLocation.indexOf("is-user=true")) {
								   newLocation = newLocation + separator + 'is-user=true';
								   separator = "&";
								}
								
								if (-1 == newLocation.indexOf("login=")) {
								   newLocation = newLocation + separator + 'login=' + encodeURIComponent(login);
								   separator = "&";
								}
								
								if (-1 == newLocation.indexOf("msg=")) {
									newLocation = newLocation + separator + 'msg=eventLoginNotAllowedForExistingUsers';
									separator = "&";
								}
								
								msg1 = "";
								msg2 = "";
								window.location =  newLocation;
                            }
                        } else if ('user-suspended' == subcode) {
                            var suspendValue = $CQ("param", xml).attr('value');
                            msg1 = makeDefaultMessage('eventLoginNodata');
                            msg2 = "";
                        } else {
                            msg2 = makeDefaultMessage('unknownErrorSubcode', subcode);
                        }                        
                        $CQ("#errorMsg").html(msg1 + '<br>' + msg2).show();
                        break;
                    case 'no-access':
                        var subcode = $CQ("status", xml).attr("subcode");
                        if ( 'denied' == subcode ) {
                            msg1 = eventResBundle.getMessage('errMsgRegistrationDenied');
                        } if ( 'sco-expired' == subcode ) {
                            //msg1 = eventResBundle.getMessage('errMsgEventEnded');
                            window.location.reload();
                        } else {
                            msg1 = makeDefaultMessage('unknownErrorSubcode', subcode);
                        }
                        $CQ("#errorMsg").html(msg1).show();                  
                        break;
                    default:
                        msg1 = makeDefaultMessage('unknownErrorCode', code);
                        $CQ("#errorMsg").html(msg1).show();
                    }
                }
        );
    };
    
    // handler for 'forgot password' form submit
    forgotPwdSubmitHandler = function(){
        
        // validate form        
        var loginFieldValidation = emailValidation;
        var loginField = document.getElementById("forgotPwdLogin");
                
        // validate form
        if(loginFieldValidation(loginField) != true) {
            return false;
        }
        
        $CQ("#forgotPwdErrorMsg").hide();
        $CQ("#forgotPwdSubmit").hide();
        $CQ("#forgotPwdCancel").hide();
        $CQ("#forgotPwdLoading").fadeIn();
        
        var loginEmail = $CQ("#forgotPwdLogin").val();
        
        $CQ.post(
                "/content/connect/connect-action", 
                { login: loginEmail, action: 'reset-password', "login-url": encodeURIComponent(curr_page_url), "account-id": accountId },
                function(xml){
                    $CQ("#forgotPwdLoading").fadeOut('fast');
                    $CQ("#forgotPwdSubmit").show();
                    $CQ("#forgotPwdCancel").show();
                    xml = parseXML(xml);
                    var code = $CQ("status", xml).attr('code');
                    var msg1, msg2;
    
                    //result handler
                    switch(code) {
                    case 'ok':
                        // hide 'forgot password' form and show confirmation message
                        $CQ("#eventForgotPwdContainer").hide();
                        $CQ("#loginEcho").html(loginEmail);
                        $CQ("#pwdResetConfirmContainer").show();
                        break;
                    case 'invalid':
                        msg1 = eventResBundle.getMessage('eventLoginPwdResetInvalid');
                        var subcode = $CQ("status", xml).find("invalid").attr("subcode");
                        if('missing' == subcode) {
                            field = $CQ("status", xml).find("invalid").attr("field");
                            msg2 = CQ.I18n.getMessage('eventLoginMissing', field);
                        } else if('range' == subcode) {
                            msg2 = eventResBundle.getMessage('eventRegistrationPasswordRange');
                        } else {
                            msg2 = makeDefaultMessage('unknownErrorSubcode', subcode);
                        }
                        $CQ("#forgotPwdErrorMsg").html(msg1 + '<br>' + msg2).show();
                        break;
                    default:
                        msg1 = makeDefaultMessage('unknownErrorCode', code);
                        $CQ("#forgotPwdErrorMsg").html(msg1).show();
                    }
                    
        });
    };
    
    // handler for Cancel button on 'forgot password' form      
    forgotPwdCancel = function() {
        // clear error messages on 'login' form
        setErrorStyle(document.getElementById('forgotPwdLogin'), false);
        $CQ("#forgotPwdLogin_errorMessage").html("");
        $CQ("#forgotPwdErrorMsg").html("");
        
        // hide 'forgot password' form and show 'login' form
        $CQ("#eventForgotPwdContainer").hide();
        $CQ("#eventLoginContainer").show();
    };
    
    // handler for Return To Login button on 'reset password conformation' form
    pwdResetBtnHandler = function(){
        // hide 'reset password confirmation' form and show 'login' form
        $CQ("#pwdResetConfirmContainer").hide();
        $CQ("#eventLoginContainer").show();
    };
    
    makeDefaultMessage = function(key, code) { 
          if(code == undefined || code == null) {
              return eventResBundle.getMessage(key, ["N/A"]);
          } else {
              return eventResBundle.getMessage(key, [code]);
          }
    }
};

//starting a login workflow
function loginAutomatically(joinButtonSelector) {
    // selecting the specified join button and automating a click  
    if ($CQ(joinButtonSelector).length > 0) {
        $CQ(joinButtonSelector).click();
    }
}
