<%@include file="/apps/connect/common.jsp" %>
<%@page import="com.adobe.connect.osgi.info.*" %>

<%
	//using body text, instead of input label style
	String bodyTextCSS = (String)request.getAttribute("registrationPageBodyTextCSS");
    EventField eventField = (EventField)request.getAttribute("eventField");
	String value = null;
	// find value from the request
	value = xssUtilService.getValidJSToken( slingRequest.getParameter(eventField.getInteractionId()) );
	if(value == null) {
		// if there is no value in the request, try to load it from the eventField object
		value = eventField.getValue() != null ? eventField.getValue() : "";
	}
    boolean isChecked = false;
    if (value.equals("")) { //select based on default setting
        if (eventField.getDefaultValue().equals("true")) {
            isChecked = true;
        }
    } else { //select based on value setting
        if (value.equals("true")) {
            isChecked = true;
        }
    }

%>
<div class="event_reg_checkbox_label" <%= bodyTextCSS %> >
    <input id="<%=eventField.getInteractionId()%>" class="event_reg_field_check" type="checkbox" name="<%=eventField.getInteractionId()%>" value="true" prechecked=<%= eventField.getDefaultValue().equals("true") %> <%= isChecked ? "checked" : "" %> onKeyPress="return checkSubmit(event, regFormSubmit)"/>
    <input id="<%=eventField.getInteractionId() + "_hidden"%>" type="hidden" name="<%= eventField.getInteractionId()%>" value="false" prechecked=<%= eventField.getDefaultValue().equals("true") %> <%= isChecked ? "disabled" : "" %> />
<%= ConnectUtil.escapeHtml(eventField.getDescription()) %>
<%
    if("true".equals(eventField.getIsRequired())) {
    %>
        <span class="mandatory">*</span>
<%  }
%>
</div>
<div class="error_msg_checkbox_registration">
    <span id="<%=eventField.getInteractionId()+"_errorMessage"%>" class="error_msg_registration"></span>
</div>

<script type="text/javascript">
$CQ(document).ready(function() {
    $CQ("input[id='<%=eventField.getInteractionId()%>']").change(
        function() {
            var isCheckedOnChange = document.getElementById(this.id).checked;
		    if (isCheckedOnChange==false) {
                //enable hidden input, so it can send "false" value when checkbox is not selected
                document.getElementById('<%=eventField.getInteractionId() + "_hidden"%>').disabled = false;
		    } else {
                //disable hidden input, when checkbox is selected
                document.getElementById('<%=eventField.getInteractionId() + "_hidden"%>').disabled = true;
            }
            //validation of required fields
			<% if("true".equals(eventField.getIsRequired())) { %>
                var valPassed = validateRequired(this);
                return valPassed;
			<% } %>
        });
});
</script>
